/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import org.jpedal.fonts.glyph.GlyphFactory;

class DecodeData {
    int nonSubrCommandCount;
    int dicEnd;
    int lastVal;
    byte[] glyphStream;
    boolean isFlex;
    int potentialWidth;
    private double ymin = 999999.0;
    private double ymax;
    double yy = 1000.0;

    DecodeData(byte[] glyphStream) {
        this.glyphStream = glyphStream;
        this.dicEnd = glyphStream.length;
    }

    void setMinY(GlyphFactory factory, double h) {
        if (this.yy > h) {
            this.ymin = this.yy - h;
        }
        if (this.ymax < this.yy) {
            this.ymin = 0.0;
        } else if (this.yy != this.ymax) {
            float dy = (float)(this.ymax - (this.yy - this.ymin));
            this.ymin = dy < 0.0f ? (this.yy - this.ymax <= (double)dy ? (double)dy : (this.ymin -= (double)dy)) : 0.0;
            if (this.ymin < 0.0) {
                this.ymin = 0.0;
            }
        }
        factory.setYMin((float)this.ymin);
    }

    public void resizeArray(int p, int lastNumberStart, byte[] newStream) {
        int newLength = newStream.length;
        int oldLength = this.glyphStream.length;
        int totalLength = newLength + oldLength - 2;
        this.dicEnd = this.dicEnd + newLength - 2;
        byte[] combinedStream = new byte[totalLength];
        System.arraycopy(this.glyphStream, 0, combinedStream, 0, lastNumberStart);
        System.arraycopy(newStream, 0, combinedStream, lastNumberStart, newLength);
        System.arraycopy(this.glyphStream, p, combinedStream, lastNumberStart + newLength, oldLength - p);
        this.glyphStream = combinedStream;
    }

    public void trackBounds(double y) {
        if (this.ymin > y) {
            this.ymin = y;
        }
        if (this.ymax < y) {
            this.ymax = y;
        }
    }

    public void increasePotentialWidth(int nominalWidthX) {
        this.potentialWidth = nominalWidthX + this.lastVal;
    }
}

