/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.glyph.objects.T1GlyphNumber;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.utils.FontLoader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class Type1C
extends Type1 {
    private static final boolean debugFont = false;
    private static final boolean debugDictionary = false;
    private int FDArray = -1;
    private int FDSelect = -1;
    private int top;
    private int charset;
    private int enc;
    private int charstrings;
    private int stringIdx;
    private int stringStart;
    private int stringOffSize;
    private boolean hasFontMatrix;
    private int[] privateDictOffset = new int[]{-1};
    private int[] privateDictLength = new int[]{-1};
    private int currentFD = -1;
    private int[] defaultWidthX = new int[]{0};
    private int[] nominalWidthX = new int[]{0};
    private int[] fdSelect;
    private static final int[] ExpertSubCharset = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    public static final String[] type1CStdStrings = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    private static final int[] ISOAdobeCharset = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final int[] ExpertCharset = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    private int[] subrs = new int[]{-1};

    Type1C() {
    }

    public Type1C(PdfObjectReader current_pdf_file, String substituteFont) {
        this.glyphs = new T1Glyphs(false);
        this.init(current_pdf_file);
        this.substituteFont = substituteFont;
    }

    void readEmbeddedFont(PdfObject pdfFontDescriptor) {
        if (this.substituteFont != null) {
            try {
                this.isFontSubstituted = true;
                this.readType1FontFile(FontLoader.getBytes(this.substituteFont, this.loader));
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF]Substitute font=" + this.substituteFont + "Type 1 exception=" + e);
            }
        } else if (pdfFontDescriptor != null) {
            PdfObject FontFile = pdfFontDescriptor.getDictionary(746093177);
            if (FontFile != null) {
                try {
                    byte[] stream = this.currentPdfFile.readStream(FontFile, true, true, false, false, false, FontFile.getCacheName(this.currentPdfFile.getObjectReader()));
                    if (stream != null) {
                        this.readType1FontFile(stream);
                    }
                }
                catch (Exception e) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            } else {
                byte[] stream;
                PdfObject FontFile3 = pdfFontDescriptor.getDictionary(2021292335);
                if (FontFile3 != null && (stream = this.currentPdfFile.readStream(FontFile3, true, true, false, false, false, FontFile3.getCacheName(this.currentPdfFile.getObjectReader()))) != null) {
                    this.readType1CFontFile(stream, null);
                }
            }
        }
    }

    @Override
    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage) {
        this.fontTypes = 1228944677;
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfFontDescriptor);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
        try {
            this.readEmbeddedFont(pdfFontDescriptor);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
        this.readWidths(pdfObject, true);
        if (renderPage) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    public Type1C(byte[] fontDataAsArray, PdfJavaGlyphs glyphs, boolean is1C) throws Exception {
        this.glyphs = glyphs;
        this.trackIndices = true;
        this.renderPage = true;
        if (is1C) {
            this.readType1CFontFile(fontDataAsArray, null);
        } else {
            this.readType1FontFile(fontDataAsArray);
        }
    }

    public Type1C(byte[] fontDataAsArray, FontData fontData, PdfJavaGlyphs glyphs) {
        this.glyphs = glyphs;
        this.isCID = glyphs.isCIDFont;
        this.readType1CFontFile(fontDataAsArray, fontData);
    }

    private void readType1CFontFile(byte[] fontDataAsArray, FontData fontDataAsObject) {
        LogWriter.writeLog("Embedded Type1C font used");
        this.glyphs.setis1C(true);
        boolean isByteArray = fontDataAsArray != null;
        int size = 2;
        Type1C.readHeader(fontDataAsArray, fontDataAsObject);
        this.top = isByteArray ? fontDataAsArray[2] : (int)fontDataAsObject.getByte(2);
        int count = Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top, 2);
        byte offsize = isByteArray ? fontDataAsArray[this.top + 2] : fontDataAsObject.getByte(this.top + 2);
        this.top += 3;
        int start = this.top + (count + 1) * offsize - 1;
        this.top = start + Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top + count * offsize, offsize);
        count = Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top, 2);
        offsize = isByteArray ? fontDataAsArray[this.top + 2] : fontDataAsObject.getByte(this.top + 2);
        this.top += 3;
        start = this.top + (count + 1) * offsize - 1;
        int dicStart = start + Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top, offsize);
        int dicEnd = start + Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top + offsize, offsize);
        String[] strings = this.readStringIndex(fontDataAsArray, fontDataAsObject, start, offsize, count);
        this.readGlobalSubRoutines(fontDataAsArray, fontDataAsObject);
        this.decodeDictionary(fontDataAsArray, fontDataAsObject, dicStart, dicEnd, strings);
        if (this.FDSelect != -1) {
            this.handleSubDictionaries(fontDataAsArray, fontDataAsObject, isByteArray, strings);
        }
        this.top = this.charstrings;
        int nGlyphs = Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top, 2);
        this.glyphs.setGlyphCount(nGlyphs);
        int[] names = this.readCharset(this.charset, nGlyphs, fontDataAsObject, fontDataAsArray);
        this.setEncoding(fontDataAsArray, fontDataAsObject, nGlyphs, names);
        this.top = this.charstrings;
        this.readGlyphs(fontDataAsArray, fontDataAsObject, nGlyphs, names);
        this.readPrivateDictionaries(fontDataAsArray, fontDataAsObject, isByteArray, strings);
        this.currentFD = -1;
        this.isFontEmbedded = true;
        this.glyphs.setFontEmbedded(true);
    }

    private void readPrivateDictionaries(byte[] fontDataAsArray, FontData fontDataAsObject, boolean isByteArray, String[] strings) {
        for (int i = 0; i < this.privateDictOffset.length; ++i) {
            this.currentFD = i;
            int dict = this.privateDictOffset[i];
            if (dict == -1) continue;
            int dictLength = this.privateDictLength[i];
            this.decodeDictionary(fontDataAsArray, fontDataAsObject, dict, dict + dictLength, strings);
            int fontLength = isByteArray ? fontDataAsArray.length : fontDataAsObject.length();
            if (this.subrs[this.currentFD] == -1 || this.subrs[this.currentFD] >= fontLength) continue;
            this.top = this.subrs[this.currentFD];
            int nSubrs = Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top, 2);
            if (nSubrs <= 0) continue;
            this.readSubrs(fontDataAsArray, fontDataAsObject, nSubrs);
        }
    }

    private static int getValue(byte[] fontDataAsArray, FontData fontDataAsObject, int top, int size) {
        if (fontDataAsArray != null) {
            return Type1C.getWord(fontDataAsArray, top, size);
        }
        return Type1C.getWord(fontDataAsObject, top, size);
    }

    private static void readHeader(byte[] fontDataAsArray, FontData fontDataAsObject) {
        byte minor;
        byte major;
        if (fontDataAsArray != null) {
            major = fontDataAsArray[0];
            minor = fontDataAsArray[1];
        } else {
            major = fontDataAsObject.getByte(0);
            minor = fontDataAsObject.getByte(1);
        }
        if (major != 1 || minor != 0) {
            LogWriter.writeLog("1C  format " + major + ':' + minor + " not fully supported");
        }
    }

    private void handleSubDictionaries(byte[] fontDataAsArray, FontData fontDataAsObject, boolean isByteArray, String[] strings) {
        byte offsize;
        int count;
        int i;
        int nextDic = this.FDSelect;
        int format = Type1C.getValue(fontDataAsArray, fontDataAsObject, nextDic, 1);
        int glyphCount = Type1C.getValue(fontDataAsArray, fontDataAsObject, this.charstrings, 2);
        this.fdSelect = new int[glyphCount];
        if (format == 0) {
            for (i = 0; i < glyphCount; ++i) {
                this.fdSelect[i] = isByteArray ? Type1C.getWord(fontDataAsArray, nextDic + 1 + i, 1) : Type1C.getWord(fontDataAsObject, nextDic + 1 + i, 1);
            }
        } else if (format == 3) {
            int i2;
            int nRanges = Type1C.getValue(fontDataAsArray, fontDataAsObject, nextDic + 1, 2);
            int[] rangeStarts = new int[nRanges + 1];
            int[] fDicts = new int[nRanges];
            for (i2 = 0; i2 < nRanges; ++i2) {
                if (isByteArray) {
                    rangeStarts[i2] = Type1C.getWord(fontDataAsArray, nextDic + 3 + 3 * i2, 2);
                    fDicts[i2] = Type1C.getWord(fontDataAsArray, nextDic + 5 + 3 * i2, 1);
                    continue;
                }
                rangeStarts[i2] = Type1C.getWord(fontDataAsObject, nextDic + 3 + 3 * i2, 2);
                fDicts[i2] = Type1C.getWord(fontDataAsObject, nextDic + 5 + 3 * i2, 1);
            }
            rangeStarts[rangeStarts.length - 1] = glyphCount;
            for (i2 = 0; i2 < nRanges; ++i2) {
                for (int j = rangeStarts[i2]; j < rangeStarts[i2 + 1]; ++j) {
                    this.fdSelect[j] = fDicts[i2];
                }
            }
        }
        ((T1Glyphs)this.glyphs).setFDSelect(this.fdSelect);
        nextDic = this.FDArray;
        if (isByteArray) {
            count = Type1C.getWord(fontDataAsArray, nextDic, 2);
            offsize = fontDataAsArray[nextDic + 2];
        } else {
            count = Type1C.getWord(fontDataAsObject, nextDic, 2);
            offsize = fontDataAsObject.getByte(nextDic + 2);
        }
        int start = (nextDic += 3) + (count + 1) * offsize - 1;
        this.privateDictOffset = new int[count];
        this.privateDictLength = new int[count];
        this.subrs = new int[count];
        this.defaultWidthX = new int[count];
        this.nominalWidthX = new int[count];
        for (i = 0; i < count; ++i) {
            int dicEnd;
            int dicStart;
            this.currentFD = i;
            this.privateDictOffset[i] = -1;
            this.privateDictLength[i] = -1;
            this.subrs[i] = -1;
            if (isByteArray) {
                dicStart = start + Type1C.getWord(fontDataAsArray, nextDic + i * offsize, (int)offsize);
                dicEnd = start + Type1C.getWord(fontDataAsArray, nextDic + (i + 1) * offsize, (int)offsize);
            } else {
                dicStart = start + Type1C.getWord(fontDataAsObject, nextDic + i * offsize, (int)offsize);
                dicEnd = start + Type1C.getWord(fontDataAsObject, nextDic + (i + 1) * offsize, (int)offsize);
            }
            this.decodeDictionary(fontDataAsArray, fontDataAsObject, dicStart, dicEnd, strings);
        }
        this.currentFD = -1;
    }

    private void setEncoding(byte[] fontDataAsArray, FontData fontDataAsObject, int nGlyphs, int[] names) {
        switch (this.enc) {
            case 0: {
                this.embeddedEnc = this.setEncodingToSTD(fontDataAsArray, fontDataAsObject, nGlyphs, names);
                if (this.fontEnc != -1) break;
                this.putFontEncoding(this.embeddedEnc);
                break;
            }
            case 1: {
                this.embeddedEnc = 3;
                if (this.fontEnc != -1) break;
                this.putFontEncoding(this.embeddedEnc);
                break;
            }
            default: {
                this.setEncodingToCustom(fontDataAsArray, fontDataAsObject, nGlyphs, names);
            }
        }
    }

    private void setEncodingToCustom(byte[] fontDataAsArray, FontData fontDataAsObject, int nGlyphs, int[] names) {
        String name;
        int c;
        int i;
        boolean isByteArray = fontDataAsArray != null;
        this.top = this.enc;
        int encFormat = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
        if ((encFormat & 0x7F) == 0) {
            int nCodes = isByteArray ? 1 + (fontDataAsArray[this.top++] & 0xFF) : 1 + (fontDataAsObject.getByte(this.top++) & 0xFF);
            if (nCodes > nGlyphs) {
                nCodes = nGlyphs;
            }
            for (i = 1; i < nCodes; ++i) {
                if (isByteArray) {
                    c = fontDataAsArray[this.top++] & 0xFF;
                    name = Type1C.getString(fontDataAsArray, names[i], this.stringIdx, this.stringStart, this.stringOffSize);
                } else {
                    c = fontDataAsObject.getByte(this.top++) & 0xFF;
                    name = Type1C.getString(fontDataAsObject, names[i], this.stringIdx, this.stringStart, this.stringOffSize);
                }
                this.putChar(c, name);
            }
        } else if ((encFormat & 0x7F) == 1) {
            int nRanges = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
            int nCodes = 1;
            for (int i2 = 0; i2 < nRanges; ++i2) {
                int nLeft;
                if (isByteArray) {
                    c = fontDataAsArray[this.top++] & 0xFF;
                    nLeft = fontDataAsArray[this.top++] & 0xFF;
                } else {
                    c = fontDataAsObject.getByte(this.top++) & 0xFF;
                    nLeft = fontDataAsObject.getByte(this.top++) & 0xFF;
                }
                for (int j = 0; j <= nLeft && nCodes < nGlyphs; ++j) {
                    name = isByteArray ? Type1C.getString(fontDataAsArray, names[nCodes], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontDataAsObject, names[nCodes], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putChar(c, name);
                    ++nCodes;
                    ++c;
                }
            }
        }
        if ((encFormat & 0x80) != 0) {
            int nSups = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
            for (i = 0; i < nSups; ++i) {
                c = isByteArray ? fontDataAsArray[this.top++] & 0xFF : fontDataAsObject.getByte(this.top++) & 0xFF;
                int sid = Type1C.getValue(fontDataAsArray, fontDataAsObject, this.top, 2);
                this.top += 2;
                name = isByteArray ? Type1C.getString(fontDataAsArray, sid, this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontDataAsObject, sid, this.stringIdx, this.stringStart, this.stringOffSize);
                this.putChar(c, name);
            }
        }
    }

    private int setEncodingToSTD(byte[] fontDataAsArray, FontData fontDataAsObject, int nGlyphs, int[] names) {
        boolean isByteArray;
        boolean embeddedEnc = true;
        boolean bl = isByteArray = fontDataAsArray != null;
        if (this.isCID) {
            try {
                int count = nGlyphs;
                if (count > names.length) {
                    count = names.length;
                }
                for (int i = 1; i < count; ++i) {
                    if (names[i] >= 391) continue;
                    String name = isByteArray ? Type1C.getString(fontDataAsArray, names[i], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontDataAsObject, names[i], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putMappedChar(names[i], StandardFonts.getUnicodeName(name));
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return 1;
    }

    private void readSubrs(byte[] fontDataAsArray, FontData fontDataAsObject, int nSubrs) {
        boolean isByteArray = fontDataAsArray != null;
        byte subrOffSize = isByteArray ? fontDataAsArray[this.top + 2] : fontDataAsObject.getByte(this.top + 2);
        this.top += 3;
        int subrIdx = this.top;
        int subrStart = this.top + (nSubrs + 1) * subrOffSize - 1;
        int nextTablePtr = this.top + nSubrs * subrOffSize;
        this.top = isByteArray ? (nextTablePtr < fontDataAsArray.length ? subrStart + Type1C.getWord(fontDataAsArray, nextTablePtr, (int)subrOffSize) : fontDataAsArray.length - 1) : fontDataAsObject.length() - 1;
        int[] subrOffset = new int[nSubrs + 2];
        int ii = subrIdx;
        for (int jj = 0; jj < nSubrs + 1; ++jj) {
            if (isByteArray) {
                if (ii + subrOffSize < fontDataAsArray.length) {
                    subrOffset[jj] = subrStart + Type1C.getWord(fontDataAsArray, ii, (int)subrOffSize);
                }
            } else if (ii + subrOffSize < fontDataAsObject.length()) {
                subrOffset[jj] = subrStart + Type1C.getWord(fontDataAsObject, ii, (int)subrOffSize);
            }
            ii += subrOffSize;
        }
        subrOffset[nSubrs + 1] = this.top;
        this.glyphs.setLocalBias(this.currentFD, Type1C.calculateSubroutineBias(nSubrs));
        int current = subrOffset[0];
        for (int jj = 1; jj < nSubrs + 1; ++jj) {
            if (current == 0 || isByteArray && subrOffset[jj] > fontDataAsArray.length || subrOffset[jj] < 0 || subrOffset[jj] == 0) continue;
            FastByteArrayOutputStream nextSubr = new FastByteArrayOutputStream();
            for (int c = current; c < subrOffset[jj]; ++c) {
                if (isByteArray || c >= fontDataAsObject.length()) continue;
                nextSubr.write(fontDataAsObject.getByte(c));
            }
            if (isByteArray) {
                int length = subrOffset[jj] - current;
                if (length > 0) {
                    byte[] nextSub = new byte[length];
                    System.arraycopy(fontDataAsArray, current, nextSub, 0, length);
                    this.glyphs.setCharString("subrs" + this.currentFD + '-' + (jj - 1), nextSub, jj);
                }
            } else {
                this.glyphs.setCharString("subrs" + this.currentFD + '-' + (jj - 1), nextSubr.toByteArray(), jj);
            }
            current = subrOffset[jj];
        }
    }

    private void readGlyphs(byte[] fontDataAsArray, FontData fontDataAsObject, int nGlyphs, int[] names) {
        boolean isByteArray = fontDataAsArray != null;
        byte glyphOffSize = isByteArray ? fontDataAsArray[this.top + 2] : fontDataAsObject.getByte(this.top + 2);
        this.top += 3;
        int glyphIdx = this.top;
        int glyphStart = this.top + (nGlyphs + 1) * glyphOffSize - 1;
        this.top = isByteArray ? glyphStart + Type1C.getWord(fontDataAsArray, this.top + nGlyphs * glyphOffSize, (int)glyphOffSize) : glyphStart + Type1C.getWord(fontDataAsObject, this.top + nGlyphs * glyphOffSize, (int)glyphOffSize);
        int[] glyphoffset = new int[nGlyphs + 2];
        int ii = glyphIdx;
        for (int jj = 0; jj < nGlyphs + 1; ++jj) {
            glyphoffset[jj] = isByteArray ? glyphStart + Type1C.getWord(fontDataAsArray, ii, (int)glyphOffSize) : glyphStart + Type1C.getWord(fontDataAsObject, ii, (int)glyphOffSize);
            ii += glyphOffSize;
        }
        glyphoffset[nGlyphs + 1] = this.top;
        int current = glyphoffset[0];
        for (int jj = 1; jj < nGlyphs + 1; ++jj) {
            byte[] nextGlyph = new byte[glyphoffset[jj] - current];
            for (int c = current; c < glyphoffset[jj]; ++c) {
                nextGlyph[c - current] = isByteArray ? fontDataAsArray[c] : fontDataAsObject.getByte(c);
            }
            String glyphName = this.isCID ? String.valueOf(names[jj - 1]) : (isByteArray ? Type1C.getString(fontDataAsArray, names[jj - 1], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontDataAsObject, names[jj - 1], this.stringIdx, this.stringStart, this.stringOffSize));
            this.glyphs.setCharString(glyphName, nextGlyph, jj);
            current = glyphoffset[jj];
            if (!this.trackIndices) continue;
            this.glyphs.setNameForGlyphIndex(jj, glyphName);
        }
    }

    private static int calculateSubroutineBias(int subroutineCount) {
        int bias = subroutineCount < 1240 ? 107 : (subroutineCount < 33900 ? 1131 : 32768);
        return bias;
    }

    private void readGlobalSubRoutines(byte[] fontDataAsArray, FontData fontDataAsObject) {
        int count;
        int subOffSize;
        boolean isByteArray;
        boolean bl = isByteArray = fontDataAsArray != null;
        if (isByteArray) {
            subOffSize = fontDataAsArray[this.top + 2] & 0xFF;
            count = Type1C.getWord(fontDataAsArray, this.top, 2);
        } else {
            subOffSize = fontDataAsObject.getByte(this.top + 2) & 0xFF;
            count = Type1C.getWord(fontDataAsObject, this.top, 2);
        }
        this.top += 3;
        if (count > 0) {
            int idx = this.top;
            int start = this.top + (count + 1) * subOffSize - 1;
            this.top = isByteArray ? start + Type1C.getWord(fontDataAsArray, this.top + count * subOffSize, subOffSize) : start + Type1C.getWord(fontDataAsObject, this.top + count * subOffSize, subOffSize);
            int[] offset = new int[count + 2];
            int ii = idx;
            for (int jj = 0; jj < count + 1; ++jj) {
                offset[jj] = isByteArray ? start + Type1C.getWord(fontDataAsArray, ii, subOffSize) : start + Type1C.getWord(fontDataAsObject, ii, subOffSize);
                ii += subOffSize;
            }
            offset[count + 1] = this.top;
            this.glyphs.setGlobalBias(Type1C.calculateSubroutineBias(count));
            int current = offset[0];
            for (int jj = 1; jj < count + 1; ++jj) {
                FastByteArrayOutputStream nextStream = new FastByteArrayOutputStream();
                for (int c = current; c < offset[jj]; ++c) {
                    if (isByteArray) {
                        nextStream.write(fontDataAsArray[c]);
                        continue;
                    }
                    nextStream.write(fontDataAsObject.getByte(c));
                }
                this.glyphs.setCharString("global" + (jj - 1), nextStream.toByteArray(), jj);
                current = offset[jj];
            }
        }
    }

    private void decodeDictionary(byte[] fontDataAsArray, FontData fontDataAsObject, int dicStart, int dicEnd, String[] strings) {
        boolean fdReset = false;
        boolean isByteArray = fontDataAsArray != null;
        int p = dicStart;
        int i = 0;
        double[] op = new double[48];
        while (p < dicEnd) {
            int nextVal = isByteArray ? fontDataAsArray[p] & 0xFF : fontDataAsObject.getByte(p) & 0xFF;
            if (nextVal <= 27 || nextVal == 31) {
                int key = nextVal;
                ++p;
                if (key == 12) {
                    key = isByteArray ? fontDataAsArray[p] & 0xFF : fontDataAsObject.getByte(p) & 0xFF;
                    ++p;
                    fdReset = this.handle2ByteOperand(strings, fdReset, key, op);
                } else {
                    this.handle1ByteOperand(dicStart, key, op);
                }
                i = 0;
                continue;
            }
            p = isByteArray ? T1GlyphNumber.getNumber(fontDataAsArray, p, op, i, this.is1C()) : T1GlyphNumber.getNumber(fontDataAsObject, p, op, i, this.is1C());
            ++i;
        }
        if (!fdReset) {
            this.FDSelect = -1;
        }
    }

    private void handle1ByteOperand(int dicStart, int key, double[] op) {
        switch (key) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                for (int ii = 0; ii < 4; ++ii) {
                    this.FontBBox[ii] = (float)op[ii];
                }
                break;
            }
            case 15: {
                this.charset = (int)op[0];
                break;
            }
            case 16: {
                this.enc = (int)op[0];
                break;
            }
            case 17: {
                this.charstrings = (int)op[0];
                break;
            }
            case 18: {
                if (!this.glyphs.is1C()) break;
                int dictNo = this.currentFD;
                if (dictNo == -1) {
                    dictNo = 0;
                }
                this.privateDictOffset[dictNo] = (int)op[1];
                this.privateDictLength[dictNo] = (int)op[0];
                break;
            }
            case 19: {
                int dictNo = this.currentFD;
                if (dictNo == -1) {
                    dictNo = 0;
                }
                this.subrs[dictNo] = dicStart + (int)op[0];
                break;
            }
            case 20: {
                int dictNo = this.currentFD;
                if (dictNo == -1) {
                    dictNo = 0;
                }
                this.defaultWidthX[dictNo] = (int)op[0];
                if (!(this.glyphs instanceof T1Glyphs)) break;
                ((T1Glyphs)this.glyphs).setWidthValues(this.defaultWidthX, this.nominalWidthX);
                break;
            }
            case 21: {
                int dictNo = this.currentFD;
                if (dictNo == -1) {
                    dictNo = 0;
                }
                this.nominalWidthX[dictNo] = (int)op[0];
                if (!(this.glyphs instanceof T1Glyphs)) break;
                ((T1Glyphs)this.glyphs).setWidthValues(this.defaultWidthX, this.nominalWidthX);
            }
        }
    }

    private boolean handle2ByteOperand(String[] strings, boolean fdReset, int key, double[] op) {
        if (key == 36 || key == 37 || key == 7 || this.FDSelect == -1) {
            switch (key) {
                case 0: {
                    int id = (int)op[0];
                    if (id > 390) {
                        id -= 390;
                    }
                    this.copyright = strings[id];
                    break;
                }
                case 2: {
                    break;
                }
                case 6: 
                case 9: {
                    if (!(op[0] > 0.0)) break;
                    int[] blueValues = new int[6];
                    for (int z = 0; z < blueValues.length; ++z) {
                        blueValues[z] = (int)op[z];
                    }
                    break;
                }
                case 7: {
                    if (!this.hasFontMatrix) {
                        System.arraycopy(op, 0, this.FontMatrix, 0, 6);
                    }
                    this.hasFontMatrix = true;
                    break;
                }
                case 8: {
                    int[] familyBlues = new int[6];
                    for (int z = 0; z < familyBlues.length; ++z) {
                        familyBlues[z] = (int)op[z];
                    }
                    break;
                }
                case 10: 
                case 11: {
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    break;
                }
                case 30: {
                    this.isCID = true;
                    this.isCIDROS = true;
                    break;
                }
                case 36: {
                    this.FDArray = (int)op[0];
                    break;
                }
                case 37: {
                    this.FDSelect = (int)op[0];
                    fdReset = true;
                    break;
                }
            }
        }
        return fdReset;
    }

    private String[] readStringIndex(byte[] fontDataAsArray, FontData fontDataAsObject, int start, int offsize, int count) {
        int nStrings;
        boolean isByteArray;
        boolean bl = isByteArray = fontDataAsArray != null;
        if (isByteArray) {
            this.top = start + Type1C.getWord(fontDataAsArray, this.top + count * offsize, offsize);
            nStrings = Type1C.getWord(fontDataAsArray, this.top, 2);
            this.stringOffSize = fontDataAsArray[this.top + 2];
        } else {
            this.top = start + Type1C.getWord(fontDataAsObject, this.top + count * offsize, offsize);
            nStrings = Type1C.getWord(fontDataAsObject, this.top, 2);
            this.stringOffSize = fontDataAsObject.getByte(this.top + 2);
        }
        this.top += 3;
        this.stringIdx = this.top;
        this.stringStart = this.top + (nStrings + 1) * this.stringOffSize - 1;
        this.top = isByteArray ? this.stringStart + Type1C.getWord(fontDataAsArray, this.top + nStrings * this.stringOffSize, this.stringOffSize) : this.stringStart + Type1C.getWord(fontDataAsObject, this.top + nStrings * this.stringOffSize, this.stringOffSize);
        int[] offsets = new int[nStrings + 2];
        String[] strings = new String[nStrings + 2];
        int ii = this.stringIdx;
        for (int jj = 0; jj < nStrings + 1; ++jj) {
            offsets[jj] = isByteArray ? Type1C.getWord(fontDataAsArray, ii, this.stringOffSize) : Type1C.getWord(fontDataAsObject, ii, this.stringOffSize);
            ii += this.stringOffSize;
        }
        offsets[nStrings + 1] = this.top - this.stringStart;
        int current = 0;
        for (int jj = 0; jj < nStrings + 1; ++jj) {
            StringBuilder nextString = new StringBuilder(offsets[jj] - current);
            for (int c = current; c < offsets[jj]; ++c) {
                if (isByteArray) {
                    nextString.append((char)fontDataAsArray[this.stringStart + c]);
                    continue;
                }
                nextString.append((char)fontDataAsObject.getByte(this.stringStart + c));
            }
            strings[jj] = nextString.toString();
            current = offsets[jj];
        }
        return strings;
    }

    private static String getString(FontData fontDataAsObject, int sid, int idx, int start, int offsize) {
        String result;
        if (sid < 391) {
            result = type1CStdStrings[sid];
        } else {
            int idx0 = start + Type1C.getWord(fontDataAsObject, idx + (sid -= 391) * offsize, offsize);
            int idxPtr1 = start + Type1C.getWord(fontDataAsObject, idx + (sid + 1) * offsize, offsize);
            int len = idxPtr1 - idx0;
            if (len > 255) {
                len = 255;
            }
            result = new String(fontDataAsObject.getBytes(idx0, len));
        }
        return result;
    }

    private static String getString(byte[] fontDataAsArray, int sid, int idx, int start, int offsize) {
        String result;
        if (sid < 391) {
            result = type1CStdStrings[sid];
        } else {
            int idx0 = start + Type1C.getWord(fontDataAsArray, idx + (sid -= 391) * offsize, offsize);
            int idxPtr1 = start + Type1C.getWord(fontDataAsArray, idx + (sid + 1) * offsize, offsize);
            int len = idxPtr1 - idx0;
            if (len > 255) {
                len = 255;
            }
            result = new String(fontDataAsArray, idx0, len);
        }
        return result;
    }

    private int[] readCharset(int charset, int nGlyphs, FontData fontDataAsObject, byte[] fontDataAsArray) {
        int[] glyphNames;
        boolean isByteArray;
        boolean bl = isByteArray = fontDataAsArray != null;
        if (this.isCID && !this.isCIDROS) {
            glyphNames = new int[nGlyphs];
            glyphNames[0] = 0;
            for (int i = 1; i < nGlyphs; ++i) {
                glyphNames[i] = i;
            }
        } else {
            glyphNames = charset == 0 ? ISOAdobeCharset : (charset == 1 ? ExpertCharset : (charset == 2 ? ExpertSubCharset : Type1C.readCustom(charset, nGlyphs, fontDataAsObject, fontDataAsArray, isByteArray)));
        }
        return glyphNames;
    }

    private static int[] readCustom(int charset, int nGlyphs, FontData fontDataAsObject, byte[] fontDataAsArray, boolean isByteArray) {
        int[] glyphNames = new int[nGlyphs + 1];
        glyphNames[0] = 0;
        int top = charset;
        int charsetFormat = isByteArray ? fontDataAsArray[top++] & 0xFF : fontDataAsObject.getByte(top++) & 0xFF;
        switch (charsetFormat) {
            case 0: {
                for (int i = 1; i < nGlyphs; ++i) {
                    glyphNames[i] = isByteArray ? Type1C.getWord(fontDataAsArray, top, 2) : Type1C.getWord(fontDataAsObject, top, 2);
                    top += 2;
                }
                break;
            }
            case 1: {
                int i = 1;
                while (i < nGlyphs) {
                    int c = isByteArray ? Type1C.getWord(fontDataAsArray, top, 2) : Type1C.getWord(fontDataAsObject, top, 2);
                    top += 2;
                    int nLeft = isByteArray ? fontDataAsArray[top++] & 0xFF : fontDataAsObject.getByte(top++) & 0xFF;
                    for (int j = 0; j <= nLeft; ++j) {
                        glyphNames[i++] = c++;
                    }
                }
                break;
            }
            case 2: {
                int i = 1;
                while (i < nGlyphs) {
                    int c = isByteArray ? Type1C.getWord(fontDataAsArray, top, 2) : Type1C.getWord(fontDataAsObject, top, 2);
                    int nLeft = isByteArray ? Type1C.getWord(fontDataAsArray, top, 2) : Type1C.getWord(fontDataAsObject, top += 2, 2);
                    top += 2;
                    for (int j = 0; j <= nLeft; ++j) {
                        glyphNames[i++] = c++;
                    }
                }
                break;
            }
        }
        return glyphNames;
    }

    private static int getWord(FontData fontDataAsObject, int index, int size) {
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (fontDataAsObject.getByte(index + i) & 0xFF);
        }
        return result;
    }

    private static int getWord(byte[] fontDataAsArray, int index, int size) {
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (fontDataAsArray[index + i] & 0xFF);
        }
        return result;
    }

    @Override
    public Rectangle getBoundingBox() {
        Rectangle BBox = this.isFontEmbedded ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        return BBox;
    }

    public int[] getFDSelect() {
        return this.fdSelect;
    }
}

