/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ExtractTextInRectangle
extends BaseTextExtraction {
    public static boolean isTest;
    private static String outputDirectory;

    public ExtractTextInRectangle(String fileName) {
        super(fileName);
        this.init();
    }

    public ExtractTextInRectangle(String fileName, boolean extractPlainText) {
        super(fileName, extractPlainText);
        this.init();
    }

    public ExtractTextInRectangle(byte[] byteArray) {
        super(byteArray);
        this.init();
    }

    @Override
    void decodeFile(String file_name) throws PdfException {
        this.fileName = file_name;
        if (this.openPDFFile()) {
            String name = "demo";
            int pointer = file_name.lastIndexOf(separator);
            if (pointer != -1) {
                name = file_name.substring(pointer + 1, file_name.length() - 4);
            }
            String outputDir = outputDirectory + name + separator;
            boolean start = true;
            int end = this.getPageCount();
            if (end > 10 && this.maxCount > 0 && end > this.maxCount) {
                end = this.maxCount;
            }
            try {
                for (int page = 1; page < end + 1; ++page) {
                    this.selectPage(page);
                    int x1 = this.currentPageData.getMediaBoxX(page);
                    int x2 = this.currentPageData.getMediaBoxWidth(page) + x1;
                    int y2 = this.currentPageData.getMediaBoxY(page);
                    int y1 = this.currentPageData.getMediaBoxHeight(page) + y2;
                    String text = this.getTextOnPage(page, x1, y1, x2, y2);
                    if (isTest && text != null) {
                        text = text + this.currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, true, true);
                    }
                    if (text != null) {
                        File page_path = new File(outputDir + separator);
                        if (!page_path.exists()) {
                            page_path.mkdirs();
                        }
                        String prefix = ".txt";
                        String encoding = System.getProperty("file.encoding");
                        if (isTest) {
                            prefix = ".xml";
                        }
                        try (OutputStreamWriter output_stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outputDir + page + prefix), encoding);){
                            if (isTest) {
                                output_stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                                output_stream.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                                output_stream.write("(x1,y1 is top left corner)\n");
                                output_stream.write("(x1,y1 is bottom right corner)\n");
                                output_stream.write("(origin is bottom left corner)  -->\n");
                                output_stream.write("\n\n<ARTICLE>\n");
                                output_stream.write("<LOCATION x1=\"" + x1 + "\" y1=\"" + y1 + "\" x2=\"" + x2 + "\" y2=\"" + y2 + "\" />\n");
                                output_stream.write("\n\n<TEXT>\n");
                                output_stream.write(text);
                                output_stream.write("\n\n</TEXT>\n");
                                output_stream.write("\n\n</ARTICLE>\n");
                            } else {
                                output_stream.write(text);
                            }
                        }
                        catch (IOException e) {
                            LogWriter.writeLog(e);
                        }
                    }
                    this.decode_pdf.flushObjectValues(false);
                }
            }
            catch (Exception e) {
                throw new PdfException(e.getMessage());
            }
        }
    }

    public String getTextOnPage(int page) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        int x1 = this.currentPageData.getMediaBoxX(page);
        int x2 = this.currentPageData.getMediaBoxWidth(page) + x1;
        int y2 = this.currentPageData.getMediaBoxY(page);
        int y1 = this.currentPageData.getMediaBoxHeight(page) + y2;
        return this.currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
    }

    public String getTextOnPage(int page, Rectangle rectangle) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        return this.currentGrouping.extractTextInRectangle(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, page, false, true);
    }

    public String getTextOnPage(int page, int x1, int y1, int x2, int y2) throws PdfException {
        this.checkFileOpened();
        this.selectPage(page);
        return this.currentGrouping.extractTextInRectangle(x1, y1, x2, y2, page, false, true);
    }

    public static void main(String[] args) {
        int len = args.length;
        switch (len) {
            case 0: {
                System.out.println("Example takes 2 parameters");
                System.out.println("Value 1 is the file name or directory of PDF files to process");
                System.out.println("Value 2 is Directory for writing the data as text files");
                System.exit(0);
            }
            case 2: {
                try {
                    ExtractTextInRectangle.writeAllTextToDir(args[0], args[1], -1);
                }
                catch (PdfException e) {
                    LogWriter.writeLog(e);
                }
                break;
            }
            default: {
                System.out.println("too many arguments entered - run with no values to see defaults");
                StringBuilder arguments = new StringBuilder();
                for (String arg : args) {
                    arguments.append(arg).append('\n');
                }
                System.out.println("you entered:\n" + arguments + "as the arguments");
                System.exit(0);
            }
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.TEXT_IN_RECTANGLE;
        super.init();
    }

    public static void writeAllTextToDir(String inputDir, String password, String outputDir, int maxPages) throws PdfException {
        outputDirectory = outputDir;
        ExtractTextInRectangle extract = new ExtractTextInRectangle(inputDir);
        if (password != null) {
            extract.setPassword(password);
        }
        extract.setup(outputDir, maxPages);
        extract.processFiles(inputDir);
        extract.closePDFfile();
    }

    public static void writeAllTextToDir(String inputDir, String outputDir, int maxPages) throws PdfException {
        ExtractTextInRectangle.writeAllTextToDir(inputDir, null, outputDir, maxPages);
    }

    private void setup(String outputDir, int maxCount) {
        if (!outputDir.endsWith(separator)) {
            outputDir = outputDir + separator;
        }
        this.output_dir = outputDir;
        this.maxCount = maxCount;
    }
}

