/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.acroform;

import org.jpedal.PdfDecoderInt;
import org.jpedal.PdfDecoderServer;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.acroforms.ReturnValues;

public class PdfFormUtilities {
    private byte[] byteArray;
    private PdfDecoderInt decode_pdf;
    private String password;
    private String fileName;

    public PdfFormUtilities(String fileName) {
        this.fileName = fileName;
        this.init();
    }

    public PdfFormUtilities(byte[] byteArray) {
        this.byteArray = byteArray;
        this.init();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void init() {
        FontMappings.setFontReplacements();
        this.decode_pdf = new PdfDecoderServer(false);
    }

    public int getPageCount() {
        return this.decode_pdf.getPageCount();
    }

    public boolean openPDFFile() throws PdfException {
        try {
            if (this.fileName != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfFile(this.fileName);
                } else {
                    this.decode_pdf.openPdfFile(this.fileName, this.password);
                }
            } else if (this.byteArray != null) {
                if (this.password == null) {
                    this.decode_pdf.openPdfArray(this.byteArray);
                } else {
                    this.decode_pdf.openPdfArray(this.byteArray, this.password);
                }
            } else {
                return false;
            }
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() || !this.decode_pdf.isExtractionAllowed()) {
                if (!this.decode_pdf.isExtractionAllowed()) {
                    throw new PdfException("Not permitted to extract from PDF");
                }
                if (this.password == null) {
                    throw new PdfException("Unable to open encrypted PDF file - call setPassword(passsword) ");
                }
                throw new PdfException("Unable to open encrypted PDF file with password " + this.password);
            }
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage());
        }
        return true;
    }

    public void closePDFfile() {
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.closePdfFile();
        }
    }

    public Object[] getFormComponentsFromDocument(String filter, ReturnValues value) throws PdfException {
        return this.getFormComponentsFromPage(filter, value, -1);
    }

    public Object[] getFormComponentsFromPage(String filter, ReturnValues value, int page) throws PdfException {
        if (this.decode_pdf == null) {
            throw new PdfException("Valid PDF file must be open");
        }
        return this.decode_pdf.getFormRenderer().getFormComponents(filter, value, page);
    }

    public byte[] getRawXFAData(int dataType) throws PdfException {
        boolean isXFA = this.decode_pdf.getFormRenderer().isXFA();
        byte[] a = null;
        if (isXFA) {
            switch (dataType) {
                case 1013350773: 
                case 1043741046: 
                case 1130793076: {
                    break;
                }
                default: {
                    throw new PdfException("Unknown value for dataType - use PdfDictionary.XFA_CONFIG, PdfDictionary.XFA_DATASET, PdfDictionary.XFA_TEMPLATE");
                }
            }
            a = this.decode_pdf.getFormRenderer().getXMLContentAsBytes(dataType);
        }
        return a;
    }
}

