/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Timer;
import org.jpedal.FileAccess;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.FontMappings;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfResources;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.DecoderResults;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.swing.PDFtoImageConvertorSwing;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.SwingDisplay;
import org.jpedal.text.TextLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class Parser {
    private String decodeStatus = "";
    private StatusBar statusBar;
    private String fontsInFile = "";
    private String imagesInFile = "";
    private float multiplyer = 1.0f;
    private PdfImageData pdfImages = new PdfImageData();
    private PdfImageData pdfBackgroundImages = new PdfImageData();
    private PdfData pdfData;
    private PdfData pdfBackgroundData;
    private int displayRotation;
    private float scaling = 1.0f;
    private boolean isBackgroundDecoding;
    private final ExternalHandlers externalHandlers;
    private int extractionMode = 7;
    private int renderMode = 7;
    private final DecoderOptions options;
    private final FileAccess fileAcces;
    private final PdfResources res;
    private final DecoderResults resultsFromDecode;
    private final TextLines textLines = new TextLines();
    private boolean generateGlyphOnRender;
    private int indent;
    private int specialMode;
    private boolean warnOnceOnForms;

    float getHiResUpscaleFactor() {
        return this.multiplyer;
    }

    void setParms(int displayRotation, float scaling, int indent, int specialMode) {
        this.displayRotation = displayRotation;
        this.scaling = scaling;
        this.indent = indent;
        this.specialMode = specialMode;
    }

    void resetOnOpen() {
        this.warnOnceOnForms = false;
    }

    TextLines getTextLines() {
        return this.textLines;
    }

    Parser(ExternalHandlers externalHandlers, DecoderOptions options, FileAccess fileAcces, PdfResources res, DecoderResults resultsFromDecode) {
        this.externalHandlers = externalHandlers;
        this.options = options;
        this.fileAcces = fileAcces;
        this.res = res;
        this.resultsFromDecode = resultsFromDecode;
        fileAcces.setDVR(new SwingDisplay(1, fileAcces.getObjectStore(), false));
    }

    public Parser createNewParser() {
        DynamicVectorRenderer dvr = this.fileAcces.getDynamicRenderer();
        Parser parser = new Parser(this.externalHandlers, this.options, this.fileAcces, this.res, this.resultsFromDecode);
        this.fileAcces.setDVR(dvr);
        int extractionMode = this.extractionMode;
        parser.setRenderMode(this.renderMode);
        parser.extractionMode = extractionMode;
        parser.generateGlyphOnRender = this.generateGlyphOnRender;
        parser.setParms(this.displayRotation, this.scaling, this.indent, this.specialMode);
        parser.statusBar = this.statusBar;
        return parser;
    }

    void setGenerateGlyphOnRender(boolean generateGlyphOnRender) {
        this.generateGlyphOnRender = generateGlyphOnRender;
    }

    void setExtractionMode(int mode, float newScaling) {
        boolean layersChanged;
        PdfPageData pageData = this.fileAcces.getPdfPageData();
        pageData.setScalingValue(newScaling);
        this.extractionMode = mode;
        PdfLayerList layers = this.res.getPdfLayerList();
        if (layers != null && (layersChanged = layers.setZoom(newScaling))) {
            this.decodePage(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodePageInBackground(int i) {
        if (this.fileAcces.isDecoding()) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in foreground");
            LogWriter.writeLog("[PDF]Multiple access not recommended - use  waitForDecodingToFinish() to check");
        } else if (this.isBackgroundDecoding) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already in background");
        } else {
            try {
                this.isBackgroundDecoding = true;
                if (i > this.fileAcces.getPageCount()) {
                    LogWriter.writeLog("Page out of bounds");
                } else {
                    String currentPageOffset = this.getIO().getReferenceforPage(i);
                    AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
                    if (currentPageOffset != null || formRenderer.isXFA() && formRenderer.useXFA()) {
                        if (this.getIO() == null) {
                            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
                        }
                        PageObject pdfObject = new PageObject(currentPageOffset);
                        this.getIO().readObject(pdfObject);
                        PdfObject Resources = ((PdfObject)pdfObject).getDictionary(2004251818);
                        pdfObject.setPageNumber(i);
                        ObjectStore backgroundObjectStoreRef = this.getIO().getObjectStore();
                        PdfStreamDecoder backgroundDecoder = formRenderer.getStreamDecoder(this.getIO(), this.res.getPdfLayerList(), false);
                        backgroundDecoder.setParameters(true, false, 0, this.extractionMode, false);
                        backgroundDecoder.setXMLExtraction(this.options.isXMLExtraction());
                        this.externalHandlers.addHandlers(backgroundDecoder);
                        backgroundDecoder.setObjectValue(-9, this.fileAcces.getFilename());
                        backgroundDecoder.setRenderer(new ImageDisplay(this.fileAcces.getPageNumber(), false, 5000, this.getIO().getObjectStore()));
                        backgroundDecoder.setObjectValue(-8, backgroundObjectStoreRef);
                        backgroundDecoder.setObjectValue(-18, this.fileAcces.getPdfPageData());
                        backgroundDecoder.setIntValue(-10, i);
                        this.res.setupResources(backgroundDecoder, false, Resources, this.fileAcces.getPageNumber(), this.getIO());
                        backgroundDecoder.decodePageContent(pdfObject);
                        this.pdfBackgroundData = (PdfData)backgroundDecoder.getObjectValue(-19);
                        this.pdfBackgroundImages = (PdfImageData)backgroundDecoder.getObjectValue(-20);
                    }
                }
            }
            catch (PdfException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            finally {
                this.isBackgroundDecoding = false;
            }
        }
    }

    BufferedImage getPageAsImage(int pageIndex, boolean imageIsTransparent) throws PdfException {
        BufferedImage image = null;
        if (pageIndex > this.fileAcces.getPageCount() || pageIndex < 1) {
            LogWriter.writeLog("Page " + pageIndex + " not in range");
        } else {
            if (this.getIO() == null) {
                throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
            }
            if (this.fileAcces.linearParser.linearizedBackgroundReaderer != null) {
                LogWriter.writeLog("[Warning] Linear mode used : images may not be generated if content not fully loaded");
            }
            String currentPageOffset = this.getIO().getReferenceforPage(pageIndex);
            PdfPageData pageData = this.fileAcces.getPdfPageData();
            if (currentPageOffset != null || this.externalHandlers.getFormRenderer().isXFA()) {
                PDFtoImageConvertorSwing pdfToImageConvertor = new PDFtoImageConvertorSwing(this.multiplyer, this.options);
                image = pdfToImageConvertor.convert(this.resultsFromDecode, this.res, this.externalHandlers, this.renderMode, pageData, this.externalHandlers.getFormRenderer(), this.scaling, this.getIO(), pageIndex, imageIsTransparent, currentPageOffset);
                this.multiplyer = pdfToImageConvertor.getMultiplyer();
            }
            if (!DecoderOptions.isRunningOnAIX && !imageIsTransparent && image != null) {
                image = ColorSpaceConvertor.convertToRGB(image);
            }
        }
        return image;
    }

    void setRenderMode(int mode) {
        this.renderMode = mode;
        this.extractionMode = mode;
    }

    void setExtractionMode(int mode) {
        this.extractionMode = mode;
    }

    void disposeObjects() {
        FontMappings.fontsInitialised = false;
        this.externalHandlers.dispose();
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
        this.pdfData = null;
        FontMappings.defaultFont = null;
        this.fileAcces.dispose();
    }

    Object getJPedalObject(int id) {
        switch (id) {
            case 826881374: {
                return this.res.getPdfLayerList();
            }
            case 2004845231: {
                return this.fileAcces.linearParser.getLinearObject(this.fileAcces.isOpen, this.getIO());
            }
            case -1276915978: {
                return this.fileAcces.linearParser.linearizedBackgroundReaderer;
            }
            case 0x6F6A6AAF: {
                return this.fileAcces;
            }
        }
        return null;
    }

    synchronized BufferedImage getPageAsHiRes(int pageIndex, boolean isTransparent) throws PdfException {
        this.multiplyer = this.options.getImageDimensions(pageIndex, this.fileAcces.getPdfPageData());
        return this.getPageAsImage(pageIndex, isTransparent);
    }

    synchronized boolean isPageAvailable(int rawPage) {
        return this.fileAcces.linearParser.isPageAvailable(rawPage, this.getIO());
    }

    PdfData getPdfBackgroundData() {
        return this.pdfBackgroundData;
    }

    PdfData getPdfData() throws PdfException {
        if ((this.extractionMode & 1) == 0) {
            throw new PdfException("[PDF] Page data object requested will be empty as text extraction disabled. Enable with PdfDecoder method setExtractionMode(PdfDecoderInt.TEXT | other values");
        }
        return this.pdfData;
    }

    PdfGroupingAlgorithms getGroupingObject() throws PdfException {
        return this.options.getGroupingObject(this.fileAcces.getLastPageDecoded(), this.getPdfData());
    }

    PdfGroupingAlgorithms getBackgroundGroupingObject() {
        return this.options.getBackgroundGroupingObject(this.pdfBackgroundData);
    }

    PdfImageData getPdfImageData() {
        return this.pdfImages;
    }

    PdfImageData getPdfBackgroundImageData() {
        return this.pdfBackgroundImages;
    }

    void flushObjectValues(boolean reinit) {
        if (this.pdfData != null && !reinit) {
            this.pdfData.flushTextList();
        }
        if (this.pdfImages != null && reinit) {
            this.pdfImages.clearImageData();
        }
    }

    String getPageDecodeReport() {
        return this.decodeStatus;
    }

    String getInfo(int type) {
        String returnValue;
        switch (type) {
            case 373243460: {
                if (this.fontsInFile == null) {
                    returnValue = "No fonts defined";
                    break;
                }
                returnValue = this.fontsInFile;
                break;
            }
            case 1026635598: {
                if (this.imagesInFile == null) {
                    returnValue = "No images defined as XObjects";
                    break;
                }
                returnValue = this.imagesInFile;
                break;
            }
            default: {
                returnValue = null;
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decodePage(int rawPage) {
        DynamicVectorRenderer currentDisplay;
        Object customErrorTracker = this.externalHandlers.getExternalHandler(31);
        if (customErrorTracker != null) {
            ((ErrorTracker)customErrorTracker).startedPageDecoding(rawPage);
        }
        DynamicVectorRenderer customDVR = (DynamicVectorRenderer)this.externalHandlers.getExternalHandler(20);
        PdfPageData pageData = this.fileAcces.getPdfPageData();
        if (customDVR != null) {
            currentDisplay = customDVR;
            if (customDVR.isHTMLorSVG()) {
                this.fileAcces.setDVR(currentDisplay);
            }
        } else {
            currentDisplay = this.fileAcces.getDynamicRenderer();
        }
        boolean isDuplicate = false;
        if (rawPage == -1) {
            rawPage = this.fileAcces.getLastPageDecoded();
            isDuplicate = true;
        }
        int page = rawPage;
        if (this.fileAcces.isDecoding()) {
            LogWriter.writeLog("[PDF]WARNING - this file is being decoded already - use  waitForDecodingToFinish() to check");
        } else {
            PdfObject pdfObject = this.fileAcces.linearParser.getLinearPageObject();
            AcroRenderer formRenderer = this.externalHandlers.getFormRenderer();
            this.fileAcces.setDecoding(true);
            try {
                this.fileAcces.setDecoding(true);
                this.fileAcces.setLastPageDecoded(page);
                this.decodeStatus = "";
                currentDisplay.writeCustom(43, null);
                if (page > this.fileAcces.getPageCount() || page < 1) {
                    LogWriter.writeLog("Page out of bounds");
                    this.fileAcces.setDecoding(false);
                } else {
                    this.decode(currentDisplay, pageData, isDuplicate, page, pdfObject, formRenderer);
                }
            }
            catch (PdfException ex) {
                LogWriter.writeLog(ex);
            }
            finally {
                this.fileAcces.setDecoding(false);
                if (this.statusBar != null) {
                    this.statusBar.percentageDone = 100.0f;
                }
            }
        }
        if (customErrorTracker != null) {
            ((ErrorTracker)customErrorTracker).finishedPageDecoding(rawPage);
        }
        this.fileAcces.getDynamicRenderer().writeCustom(19, null);
    }

    private void decode(DynamicVectorRenderer currentDisplay, PdfPageData pageData, boolean isDuplicate, int page, PdfObject pdfObject, AcroRenderer formRenderer) throws PdfException {
        Timer t = null;
        if (this.statusBar != null) {
            ProgressListener listener = new ProgressListener();
            t = new Timer(150, listener);
            t.start();
        }
        this.fileAcces.setPageNumber(page);
        if (this.getIO() == null) {
            throw new PdfException("File not open - did you call closePdfFile() inside a loop and not reopen");
        }
        pdfObject = this.getPdfObject(page, pdfObject);
        PdfStreamDecoder current = this.setupObjectsForDecode(currentDisplay, pageData, page, pdfObject, formRenderer);
        try {
            this.textLines.setLineAreas(null);
            current.decodePageContent(pdfObject);
        }
        catch (Error err) {
            this.decodeStatus = this.decodeStatus + "Error in decoding page " + err;
        }
        this.setResultsFromDecode(page, current, currentDisplay.isHTMLorSVG());
        if (t != null) {
            t.stop();
            this.statusBar.setProgress(100);
        }
        if (this.options.getRenderPage() && !isDuplicate && (this.renderMode & 0x20) != 32 && !formRenderer.ignoreForms()) {
            this.decodeAcroforms(currentDisplay, page, formRenderer, current);
        }
    }

    private void decodeAcroforms(DynamicVectorRenderer currentDisplay, int page, AcroRenderer formRenderer, PdfStreamDecoder current) throws PdfException {
        PageOffsets currentOffset = this.fileAcces.getOffset();
        if (currentOffset != null) {
            formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, this.indent, 0, 0, 1, currentOffset.getWidestPageNR(), currentOffset.getWidestPageR());
        }
        formRenderer.createDisplayComponentsForPage(page, current);
        formRenderer.getFormFactory().indexAllKids();
        if (!formRenderer.useXFA() && currentDisplay.isHTMLorSVG()) {
            List<FormObject>[] formsOrdered = formRenderer.getCompData().getFormList(true);
            for (FormObject nextVal : formsOrdered[page]) {
                if (nextVal == null) continue;
                formRenderer.getFormFlattener().drawFlattenedForm(current, nextVal, true, (PdfObject)formRenderer.getFormResources()[0]);
            }
        }
        if (this.specialMode != -1 && this.specialMode != 1 && page != this.fileAcces.getPageCount()) {
            formRenderer.createDisplayComponentsForPage(page + 1, current);
        }
    }

    private PdfObject getPdfObject(int page, PdfObject pdfObject) {
        if (pdfObject == null) {
            pdfObject = new PageObject(this.getIO().getReferenceforPage(page));
            this.getIO().readObject(pdfObject);
            this.getIO().checkParentForResources(pdfObject);
        }
        if (pdfObject.getPageNumber() == -1) {
            pdfObject.setPageNumber(page);
        }
        return pdfObject;
    }

    private PdfStreamDecoder setupObjectsForDecode(DynamicVectorRenderer currentDisplay, PdfPageData pageData, int page, PdfObject pdfObject, AcroRenderer formRenderer) {
        PdfStreamDecoder current;
        PdfObject Resources = pdfObject.getDictionary(2004251818);
        if (formRenderer.isXFA() && formRenderer.useXFA()) {
            current = formRenderer.getStreamDecoder(this.getIO(), this.res.getPdfLayerList(), false);
            Resources = (PdfObject)formRenderer.getFormResources()[0];
        } else {
            current = formRenderer.getStreamDecoder(this.getIO(), this.res.getPdfLayerList(), false);
            if (!this.warnOnceOnForms) {
                this.warnOnceOnForms = true;
            }
        }
        if (!this.warnOnceOnForms) {
            this.warnOnceOnForms = formRenderer.showFormWarningMessage(page);
        }
        current.setXMLExtraction(this.options.isXMLExtraction());
        currentDisplay.writeCustom(8, this.externalHandlers.getExternalHandler(19));
        current.setParameters(true, this.options.getRenderPage(), this.renderMode, this.extractionMode, false);
        this.externalHandlers.addHandlers(current);
        current.setBooleanValue(-11, this.generateGlyphOnRender);
        current.setObjectValue(-9, this.fileAcces.getFilename());
        current.setIntValue(-10, page);
        current.setRenderer(currentDisplay);
        current.setObjectValue(-8, this.fileAcces.getObjectStore());
        current.setObjectValue(-3, this.statusBar);
        current.setObjectValue(-18, pageData);
        this.res.setupResources(current, false, Resources, page, this.getIO());
        currentDisplay.init(pageData.getMediaBoxWidth(page), pageData.getMediaBoxHeight(page), this.options.getPageColor());
        RenderUtils.setDisplayOptions(currentDisplay, this.options);
        return current;
    }

    private void setResultsFromDecode(int page, PdfStreamDecoder current, boolean isHTML) {
        if (this.extractionMode > 0 && !isHTML) {
            Vector_Rectangle_Int vr = (Vector_Rectangle_Int)current.getObjectValue(-21);
            vr.trim();
            int[][] pageTextAreas = vr.get();
            Vector_Int vi = (Vector_Int)current.getObjectValue(22);
            vi.trim();
            int[] pageTextDirections = vi.get();
            for (int k = 0; k != pageTextAreas.length; ++k) {
                this.textLines.addToLineAreas(pageTextAreas[k], pageTextDirections[k], page);
            }
        }
        this.fontsInFile = (String)current.getObjectValue(373243460);
        this.imagesInFile = (String)current.getObjectValue(1026635598);
        this.pdfData = (PdfData)current.getObjectValue(-19);
        this.pdfImages = (PdfImageData)current.getObjectValue(-20);
        this.resultsFromDecode.update(current, true);
    }

    PdfObjectReader getIO() {
        return this.fileAcces.getIO();
    }

    void resetMultiplyer() {
        this.multiplyer = 1.0f;
    }

    void resetFontsInFile() {
        this.fontsInFile = "";
    }

    void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    class ProgressListener
    implements ActionListener {
        ProgressListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Parser.this.statusBar.setProgress((int)((Parser)Parser.this).statusBar.percentageDone);
        }
    }
}

