/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.utility;

import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;

public class PixGet13
implements PixGet {
    private final byte[] pix;
    private final int stripe;
    private final int[] argb = new int[256];
    private final IndexColorModel icm;

    public PixGet13(BufferedImage image) {
        this.icm = (IndexColorModel)image.getColorModel();
        this.icm.getRGBs(this.argb);
        this.pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        this.stripe = image.getWidth();
    }

    @Override
    public boolean hasAlpha() {
        return this.icm.hasAlpha();
    }

    @Override
    public int getRGB(int x, int y) {
        return this.argb[this.pix[y * this.stripe + x] & 0xFF];
    }

    @Override
    public int getARGB(int x, int y) {
        return this.argb[this.pix[y * this.stripe + x] & 0xFF];
    }
}

