/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Sps;
import java.util.List;

class Rps {
    final int[] DeltaPocS0 = new int[16];
    final int[] DeltaPocS1 = new int[16];
    final int[] UsedByCurrPicS0 = new int[16];
    final int[] UsedByCurrPicS1 = new int[16];
    int NumNegativePics;
    int NumPositivePics;
    int NumDeltaPocs;
    int NumPocTotalCurr_shortterm_only;

    Rps() {
    }

    void reset() {
        this.NumNegativePics = 0;
        this.NumPositivePics = 0;
        this.NumDeltaPocs = 0;
        this.NumPocTotalCurr_shortterm_only = 0;
        for (int i = 0; i < 16; ++i) {
            this.DeltaPocS0[i] = 0;
            this.DeltaPocS1[i] = 0;
            this.UsedByCurrPicS0[i] = 0;
            this.UsedByCurrPicS1[i] = 0;
        }
    }

    void compute_derived_values() {
        int i;
        this.NumPocTotalCurr_shortterm_only = 0;
        for (i = 0; i < this.NumNegativePics; ++i) {
            if (this.UsedByCurrPicS0[i] == 0) continue;
            ++this.NumPocTotalCurr_shortterm_only;
        }
        for (i = 0; i < this.NumPositivePics; ++i) {
            if (this.UsedByCurrPicS1[i] == 0) continue;
            ++this.NumPocTotalCurr_shortterm_only;
        }
        this.NumDeltaPocs = this.NumNegativePics + this.NumPositivePics;
    }

    static void read(Bitstream br, Sps sps, Rps out_set, int idxRps, List<Rps> sets, boolean sliceRefPicSet) {
        byte inter_ref_pic_set_prediction_flag = idxRps != 0 ? br.readBit() : (byte)0;
        if (inter_ref_pic_set_prediction_flag != 0) {
            int dPoc;
            int j;
            int delta_idx;
            int vlc;
            if (sliceRefPicSet) {
                delta_idx = vlc = br.ue();
                ++delta_idx;
            } else {
                delta_idx = 1;
            }
            int RIdx = idxRps - delta_idx;
            assert (RIdx >= 0);
            byte delta_rps_sign = br.readBit();
            int abs_delta_rps = vlc = br.ue();
            int DeltaRPS = delta_rps_sign != 0 ? -abs_delta_rps : ++abs_delta_rps;
            int nDeltaPocsRIdx = sets.get((int)RIdx).NumDeltaPocs;
            int[] used_by_curr_pic_flag = new int[nDeltaPocsRIdx + 1];
            int[] use_delta_flag = new int[nDeltaPocsRIdx + 1];
            for (int j2 = 0; j2 <= nDeltaPocsRIdx; ++j2) {
                used_by_curr_pic_flag[j2] = br.readBit();
                use_delta_flag[j2] = used_by_curr_pic_flag[j2] != 0 ? 1 : (int)br.readBit();
            }
            int nNegativeRIdx = sets.get((int)RIdx).NumNegativePics;
            int nPositiveRIdx = sets.get((int)RIdx).NumPositivePics;
            int i = 0;
            for (j = nPositiveRIdx - 1; j >= 0; --j) {
                dPoc = sets.get((int)RIdx).DeltaPocS1[j] + DeltaRPS;
                if (dPoc >= 0 || use_delta_flag[nNegativeRIdx + j] == 0) continue;
                out_set.DeltaPocS0[i] = dPoc;
                out_set.UsedByCurrPicS0[i] = used_by_curr_pic_flag[nNegativeRIdx + j];
                ++i;
            }
            if (DeltaRPS < 0 && use_delta_flag[nDeltaPocsRIdx] != 0) {
                out_set.DeltaPocS0[i] = DeltaRPS;
                out_set.UsedByCurrPicS0[i] = used_by_curr_pic_flag[nDeltaPocsRIdx];
                ++i;
            }
            for (j = 0; j < nNegativeRIdx; ++j) {
                dPoc = sets.get((int)RIdx).DeltaPocS0[j] + DeltaRPS;
                if (dPoc >= 0 || use_delta_flag[j] == 0) continue;
                out_set.DeltaPocS0[i] = dPoc;
                out_set.UsedByCurrPicS0[i] = used_by_curr_pic_flag[j];
                ++i;
            }
            out_set.NumNegativePics = i;
            i = 0;
            for (j = nNegativeRIdx - 1; j >= 0; --j) {
                dPoc = sets.get((int)RIdx).DeltaPocS0[j] + DeltaRPS;
                if (dPoc <= 0 || use_delta_flag[j] == 0) continue;
                out_set.DeltaPocS1[i] = dPoc;
                out_set.UsedByCurrPicS1[i] = used_by_curr_pic_flag[j];
                ++i;
            }
            if (DeltaRPS > 0 && use_delta_flag[nDeltaPocsRIdx] != 0) {
                out_set.DeltaPocS1[i] = DeltaRPS;
                out_set.UsedByCurrPicS1[i] = used_by_curr_pic_flag[nDeltaPocsRIdx];
                ++i;
            }
            for (j = 0; j < nPositiveRIdx; ++j) {
                dPoc = sets.get((int)RIdx).DeltaPocS1[j] + DeltaRPS;
                if (dPoc <= 0 || use_delta_flag[nNegativeRIdx + j] == 0) continue;
                out_set.DeltaPocS1[i] = dPoc;
                out_set.UsedByCurrPicS1[i] = used_by_curr_pic_flag[nNegativeRIdx + j];
                ++i;
            }
            out_set.NumPositivePics = i;
        } else {
            int i;
            int num_positive_pics;
            int num_negative_pics = br.ue();
            if (num_negative_pics + (num_positive_pics = br.ue()) > sps.sps_max_dec_pic_buffering[sps.max_sub_layers - 1]) {
                out_set.NumNegativePics = 0;
                out_set.NumPositivePics = 0;
                out_set.NumDeltaPocs = 0;
                out_set.NumPocTotalCurr_shortterm_only = 0;
                return;
            }
            out_set.NumNegativePics = num_negative_pics;
            out_set.NumPositivePics = num_positive_pics;
            int lastPocS = 0;
            for (i = 0; i < num_negative_pics; ++i) {
                int delta_poc_s0 = br.ue();
                byte used_by_curr_pic_s0_flag = br.readBit();
                out_set.DeltaPocS0[i] = lastPocS - ++delta_poc_s0;
                out_set.UsedByCurrPicS0[i] = used_by_curr_pic_s0_flag;
                lastPocS = out_set.DeltaPocS0[i];
            }
            lastPocS = 0;
            for (i = 0; i < num_positive_pics; ++i) {
                int delta_poc_s1 = br.ue();
                byte used_by_curr_pic_s1_flag = br.readBit();
                out_set.DeltaPocS1[i] = lastPocS + ++delta_poc_s1;
                out_set.UsedByCurrPicS1[i] = used_by_curr_pic_s1_flag;
                lastPocS = out_set.DeltaPocS1[i];
            }
        }
        out_set.compute_derived_values();
    }
}

