/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.CtxTbl;
import com.idrsolutions.image.heic.common.Model;
import com.idrsolutions.image.utility.ByteWriter;

class ECabac {
    private static final int[] RANGE_LPS = new int[]{128, 176, 208, 240, 128, 167, 197, 227, 128, 158, 187, 216, 123, 150, 178, 205, 116, 142, 169, 195, 111, 135, 160, 185, 105, 128, 152, 175, 100, 122, 144, 166, 95, 116, 137, 158, 90, 110, 130, 150, 85, 104, 123, 142, 81, 99, 117, 135, 77, 94, 111, 128, 73, 89, 105, 122, 69, 85, 100, 116, 66, 80, 95, 110, 62, 76, 90, 104, 59, 72, 86, 99, 56, 69, 81, 94, 53, 65, 77, 89, 51, 62, 73, 85, 48, 59, 69, 80, 46, 56, 66, 76, 43, 53, 63, 72, 41, 50, 59, 69, 39, 48, 56, 65, 37, 45, 54, 62, 35, 43, 51, 59, 33, 41, 48, 56, 32, 39, 46, 53, 30, 37, 43, 50, 29, 35, 41, 48, 27, 33, 39, 45, 26, 31, 37, 43, 24, 30, 35, 41, 23, 28, 33, 39, 22, 27, 32, 37, 21, 26, 30, 35, 20, 24, 29, 33, 19, 23, 27, 31, 18, 22, 26, 30, 17, 21, 25, 28, 16, 20, 23, 27, 15, 19, 22, 25, 14, 18, 21, 24, 14, 17, 20, 23, 13, 16, 19, 22, 12, 15, 18, 21, 12, 14, 17, 20, 11, 14, 16, 19, 11, 13, 15, 18, 10, 12, 15, 17, 10, 12, 14, 16, 9, 11, 13, 15, 9, 11, 12, 14, 8, 10, 12, 14, 8, 9, 11, 13, 7, 9, 11, 12, 7, 9, 10, 12, 7, 8, 10, 11, 6, 8, 9, 11, 6, 7, 9, 10, 6, 7, 8, 9, 2, 2, 2, 2};
    private static final int[] TRANS_LPS = new int[]{0, 0, 1, 2, 2, 4, 4, 5, 6, 7, 8, 9, 9, 11, 11, 12, 13, 13, 15, 15, 16, 16, 18, 18, 19, 19, 21, 21, 22, 22, 23, 24, 24, 25, 26, 26, 27, 27, 28, 29, 29, 30, 30, 30, 31, 32, 32, 33, 33, 33, 34, 34, 35, 35, 35, 36, 36, 36, 37, 37, 37, 38, 38, 63};
    private static final int[] TRANS_MPS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 62, 63};
    private int range = 510;
    private int offset;
    private int onesOutstanding;
    private boolean zeroBorrowed;
    private int outReg;
    private int bitsInOutReg;
    private ByteWriter out = new ByteWriter();
    private Model[] models;
    private int p1 = -1;
    private int p2 = -1;

    ECabac() {
    }

    void init_CABAC() {
        this.range = 510;
        this.offset = 0;
    }

    void writeUE(int value) {
        int nLeadingZeros = 0;
        int base = 0;
        int ran = 1;
        while (value >= base + ran) {
            base += ran;
            ran <<= 1;
            ++nLeadingZeros;
        }
        this.write_bits(1 << nLeadingZeros | value - base, 2 * nLeadingZeros + 1);
    }

    void writeSE(int value) {
        if (value == 0) {
            this.write_bits(1, 1);
        } else if (value > 0) {
            this.writeUE(2 * value - 1);
        } else {
            this.writeUE(-2 * value);
        }
    }

    final void add_trailing_bits() {
        this.write_bits(1, 1);
        if (this.bitsInOutReg != 0) {
            int nZeros = 8 - this.bitsInOutReg;
            this.write_bits(0, nZeros);
        }
    }

    void write_bit(int bit) {
        this.putBit(bit & 1);
    }

    void write_bits(int bits, int n) {
        while (n > 0) {
            this.putBit(bits >> --n & 1);
        }
    }

    void set_context_models(CtxTbl tbl) {
        this.models = tbl.models;
    }

    void write_CABAC_bit(int modelIdx, int bin) {
        Model model = this.models[modelIdx];
        int rangeLPS = RANGE_LPS[model.state * 4 + (this.range >> 6) - 4];
        this.range -= rangeLPS;
        if (bin != model.mps) {
            this.offset += this.range;
            this.range = rangeLPS;
            if (model.state == 0) {
                model.mps = 1 - model.mps;
            }
            model.state = TRANS_LPS[model.state];
        } else {
            model.state = TRANS_MPS[model.state];
        }
        this.renormalize();
    }

    void write_CABAC_bypass(int bin) {
        this.offset <<= 1;
        if (bin == 1) {
            this.offset += this.range;
        }
        if (this.offset >= 1024) {
            this.flushOutstanding(1);
            this.offset -= 1024;
        } else if (this.offset >= 512) {
            this.offset -= 512;
            ++this.onesOutstanding;
        } else {
            this.flushOutstanding(0);
        }
    }

    void write_CABAC_term_bit(int bin) {
        this.range -= 2;
        if (bin == 0) {
            this.renormalize();
        } else {
            this.offset += this.range;
            this.range = 2;
            this.renormalize();
            this.flushOutstanding(this.offset >> 9 & 1);
            this.write_bits(this.offset >> 7 & 3 | 1, 2);
        }
    }

    void finishEncoding() {
        this.flushOutstanding(this.offset >> 9 & 1);
        this.putBit(this.offset >> 8 & 1);
        this.stuffBits();
    }

    private void renormalize() {
        while (this.range < 256) {
            if (this.offset < 256) {
                this.flushOutstanding(0);
            } else if (this.offset < 512) {
                this.offset &= 0xFF;
                ++this.onesOutstanding;
            } else {
                this.offset &= 0x1FF;
                this.flushOutstanding(1);
            }
            this.range <<= 1;
            this.offset <<= 1;
        }
    }

    private void flushOutstanding(int hasCarry) {
        if (this.zeroBorrowed) {
            this.putBit(hasCarry);
        }
        int trailingBit = 1 - hasCarry;
        while (this.onesOutstanding > 0) {
            this.putBit(trailingBit);
            --this.onesOutstanding;
        }
        this.zeroBorrowed = true;
    }

    private void putBit(int bit) {
        this.outReg = this.outReg << 1 | bit;
        ++this.bitsInOutReg;
        if (this.bitsInOutReg == 8) {
            if (this.p1 == 0 && this.p2 == 0 && (this.outReg & 3) == this.outReg) {
                this.p2 = this.p1;
                this.p1 = 3;
                this.out.putByte((byte)3);
            }
            this.out.putByte((byte)this.outReg);
            this.p2 = this.p1;
            this.p1 = this.outReg;
            this.outReg = 0;
            this.bitsInOutReg = 0;
        }
    }

    private void stuffBits() {
        if (this.bitsInOutReg == 0) {
            this.out.putByte((byte)-128);
        } else {
            this.outReg = this.outReg << 1 | 1;
            this.outReg <<= 8 - (this.bitsInOutReg + 1);
            this.out.putByte((byte)this.outReg);
            this.outReg = 0;
            this.bitsInOutReg = 0;
        }
    }

    void write_CABAC_TU_bypass(int value, int cMax) {
        for (int i = 0; i < value; ++i) {
            this.write_CABAC_bypass(1);
        }
        if (value < cMax) {
            this.write_CABAC_bypass(0);
        }
    }

    void write_CABAC_FL_bypass(int value, int n) {
        while (n > 0) {
            this.write_CABAC_bypass(value >> --n & 1);
        }
    }

    void write_CABAC_EGk(int val, int k) {
        while (val >= 1 << k) {
            this.write_CABAC_bypass(1);
            val -= 1 << k;
            ++k;
        }
        this.write_CABAC_bypass(0);
        while (k != 0) {
            this.write_CABAC_bypass(val >> --k & 1);
        }
    }

    void skip_bits(int nBits) {
        while (nBits >= 8) {
            this.write_bits(0, 8);
            nBits -= 8;
        }
        if (nBits > 0) {
            this.write_bits(0, nBits);
        }
    }

    byte[] getEncodedData() {
        return this.out.toArray();
    }

    void reset() {
        this.out = new ByteWriter();
        this.init_CABAC();
    }
}

