/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.w3c.tools.codec.Base64Decoder;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.codec.Base64FormatException;

public class JRValueStringUtils {
    private static final Map serializers = JRValueStringUtils.getSerializers();
    private static final ValueSerializer defaultSerializer = new DefaultSerializer();

    public static String serialize(String valueClass, Object value) {
        String data;
        if (value == null) {
            data = null;
        } else {
            ValueSerializer serializer = JRValueStringUtils.getSerializer(valueClass);
            data = serializer.serialize(value);
        }
        return data;
    }

    public static Object deserialize(String valueClass, String data) {
        Object value;
        if (data == null) {
            value = null;
        } else {
            ValueSerializer serializer = JRValueStringUtils.getSerializer(valueClass);
            value = serializer.deserialize(data);
        }
        return value;
    }

    protected static ValueSerializer getSerializer(String valueClass) {
        ValueSerializer serializer = (ValueSerializer)serializers.get(valueClass);
        if (serializer == null) {
            serializer = defaultSerializer;
        }
        return serializer;
    }

    private static Map getSerializers() {
        HashMap<String, ValueSerializer> map = new HashMap<String, ValueSerializer>();
        map.put(String.class.getName(), new StringSerializer());
        map.put(Character.class.getName(), new CharacterSerializer());
        map.put(Boolean.class.getName(), new BooleanSerializer());
        map.put(Byte.class.getName(), new ByteSerializer());
        map.put(Short.class.getName(), new ShortSerializer());
        map.put(Integer.class.getName(), new IntegerSerializer());
        map.put(Long.class.getName(), new LongSerializer());
        map.put(Float.class.getName(), new FloatSerializer());
        map.put(Double.class.getName(), new DoubleSerializer());
        map.put(BigInteger.class.getName(), new BigIntegerSerializer());
        map.put(BigDecimal.class.getName(), new BigDecimalSerializer());
        map.put(Date.class.getName(), new DateSerializer());
        map.put(Timestamp.class.getName(), new TimestampSerializer());
        map.put(Time.class.getName(), new TimeSerializer());
        return map;
    }

    protected static interface ValueSerializer {
        public String serialize(Object var1);

        public Object deserialize(String var1);
    }

    protected static class StringSerializer
    implements ValueSerializer {
        protected StringSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            return data;
        }

        @Override
        public String serialize(Object value) {
            return (String)value;
        }
    }

    protected static class CharacterSerializer
    implements ValueSerializer {
        protected CharacterSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            if (data.length() != 1) {
                throw new JRRuntimeException("Character data \"" + data + "\" should be exactly one character long");
            }
            return new Character(data.charAt(0));
        }

        @Override
        public String serialize(Object value) {
            return String.valueOf(new char[]{((Character)value).charValue()});
        }
    }

    protected static class BooleanSerializer
    implements ValueSerializer {
        protected BooleanSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            if (data.equals("true")) {
                return Boolean.TRUE;
            }
            if (data.equals("false")) {
                return Boolean.FALSE;
            }
            throw new JRRuntimeException("Unkown boolean data \"" + data + "\"");
        }

        @Override
        public String serialize(Object value) {
            return (Boolean)value != false ? "true" : "false";
        }
    }

    protected static class ByteSerializer
    implements ValueSerializer {
        protected ByteSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Byte.valueOf(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Byte data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Byte)value).toString();
        }
    }

    protected static class ShortSerializer
    implements ValueSerializer {
        protected ShortSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Short.valueOf(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Short data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Short)value).toString();
        }
    }

    protected static class IntegerSerializer
    implements ValueSerializer {
        protected IntegerSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Integer.valueOf(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Integer data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Integer)value).toString();
        }
    }

    protected static class LongSerializer
    implements ValueSerializer {
        protected LongSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Long.valueOf(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Long data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Long)value).toString();
        }
    }

    protected static class FloatSerializer
    implements ValueSerializer {
        protected FloatSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Float.valueOf(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Float data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Float)value).toString();
        }
    }

    protected static class DoubleSerializer
    implements ValueSerializer {
        protected DoubleSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Double.valueOf(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Double data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Double)value).toString();
        }
    }

    protected static class BigIntegerSerializer
    implements ValueSerializer {
        protected BigIntegerSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return new BigInteger(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing BigInteger data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((BigInteger)value).toString();
        }
    }

    protected static class BigDecimalSerializer
    implements ValueSerializer {
        protected BigDecimalSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return new BigDecimal(data);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing BigDecimal data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((BigDecimal)value).toString();
        }
    }

    protected static class DateSerializer
    implements ValueSerializer {
        protected DateSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                long time = Long.parseLong(data);
                return new Date(time);
            }
            catch (NumberFormatException e) {
                throw new JRRuntimeException("Error parsing Date data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            return Long.toString(((Date)value).getTime());
        }
    }

    protected static class TimestampSerializer
    implements ValueSerializer {
        protected TimestampSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Timestamp.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                throw new JRRuntimeException("Error parsing Timestamp data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            Timestamp timestamp = (Timestamp)value;
            return timestamp.toString();
        }
    }

    protected static class TimeSerializer
    implements ValueSerializer {
        protected TimeSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Time.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                throw new JRRuntimeException("Error parsing Time data \"" + data + "\"", e);
            }
        }

        @Override
        public String serialize(Object value) {
            Time timestamp = (Time)value;
            return timestamp.toString();
        }
    }

    protected static class DefaultSerializer
    implements ValueSerializer {
        protected DefaultSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                ByteArrayInputStream dataIn = new ByteArrayInputStream(data.getBytes());
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                Base64Decoder dec = new Base64Decoder((InputStream)dataIn, (OutputStream)bytesOut);
                dec.process();
                ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
                ObjectInputStream objectIn = new ObjectInputStream(bytesIn);
                return objectIn.readObject();
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(e);
            }
            catch (Base64FormatException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public String serialize(Object value) {
            try {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
                objectOut.writeObject(value);
                objectOut.close();
                ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
                ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
                Base64Encoder enc = new Base64Encoder((InputStream)bytesIn, (OutputStream)dataOut);
                enc.process();
                return new String(dataOut.toByteArray(), "UTF-8");
            }
            catch (NotSerializableException e) {
                throw new JRRuntimeException("Value is not serializable", e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

