/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.report;

import coldfusion.document.DocumentInvalidEncryptionPermission;
import coldfusion.document.DocumentInvalidEncryptionStrength;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.ListFunc;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.report.CFHtmlExporterParameter;
import coldfusion.runtime.report.Report;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.report.OldReportTag;
import coldfusion.tagext.validation.MissingAttributeException;
import coldfusion.util.FastHashtable;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Permission;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;

public class ReportTag
extends OldReportTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfreport");
    private String Template = null;
    private boolean OverWrite = false;
    private String FileName = null;
    private String Style = null;
    private ResultSet Query;
    private Map Parameters = new FastHashtable();
    private String Format = null;
    private String Name = null;
    private int Permissionsbits = 0;
    private String Permissions = null;
    private String OwnerPassword = null;
    private String UserPassword = null;
    private String Encryption = null;
    private Integer ResourceTimespan = null;
    private HashMap exportParams = new HashMap();
    private Map subreportQueries = new FastHashtable();
    private Map subreportStyles = new FastHashtable();

    @Override
    protected Permission getPermission() {
        return tp;
    }

    @Override
    public void setReport(String report) {
        super.setReport(report);
    }

    public void setTemplate(String template) {
        this.Template = Utils.getFileFullPath((String)template, (PageContext)this.pageContext, (boolean)true);
    }

    public void setFileName(String filename) {
        this.FileName = Utils.getFileFullPath((String)filename, (PageContext)this.pageContext, (boolean)true);
    }

    public void setFormat(String format) {
        this.Format = format;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public void setOverWrite(boolean overwrite) {
        this.OverWrite = overwrite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setQuery(Object arg) {
        if (arg instanceof String) {
            String var = (String)arg;
            Object obj = this.pageContext.findAttribute(var);
            if (obj == null) {
                throw new ReportNotValidQueryException(var);
            }
            if (!(obj instanceof ResultSet)) throw new ReportNotValidQueryException(var);
            this.Query = (ResultSet)obj;
            return;
        } else {
            if (!(arg instanceof ResultSet)) throw new ReportNotValidQueryException(arg.getClass().getName());
            this.Query = (ResultSet)arg;
        }
    }

    public void setResourceTimespan(Object timespan) {
        if (timespan != null) {
            if (timespan instanceof Double) {
                int secs = (int)((Double)timespan * 86400.0);
                if (secs >= 0) {
                    this.ResourceTimespan = new Integer(secs);
                    return;
                }
            } else if (timespan instanceof String) {
                try {
                    int secs = Integer.parseInt((String)timespan);
                    if (secs == 0) {
                        this.ResourceTimespan = new Integer(secs);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new ReportAttributeValueException("timespan", timespan);
        }
    }

    public void setStyle(String s) {
        this.Style = s.trim();
    }

    public void setEncryption(String encryption) {
        this.Encryption = encryption.trim();
        if (!(this.Encryption.equalsIgnoreCase("128-bit") || this.Encryption.equalsIgnoreCase("40-bit") || this.Encryption.equalsIgnoreCase("none"))) {
            throw new DocumentInvalidEncryptionStrength(encryption);
        }
    }

    public void setOwnerpassword(String ownerpassword) {
        this.OwnerPassword = ownerpassword;
    }

    public void setUserpassword(String userpassword) {
        this.UserPassword = userpassword;
    }

    public String getPermissions() {
        return this.Permissions;
    }

    public void setPermissions(String permissions) {
        this.Permissionsbits = 0;
        this.Permissions = permissions;
        if (permissions != null && permissions.length() > 0) {
            Array a = ListFunc.ListToArray((String)permissions, (String)",");
            Iterator it = a.iterator();
            while (it.hasNext()) {
                String key = ((String)it.next()).trim();
                if (key.equalsIgnoreCase("AllowPrinting")) {
                    this.Permissionsbits |= 0x804;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowModifyContents")) {
                    this.Permissionsbits |= 8;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowCopy")) {
                    this.Permissionsbits |= 0x10;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowModifyAnnotations")) {
                    this.Permissionsbits |= 0x20;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowFillIn")) {
                    this.Permissionsbits |= 0x100;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowAssembly")) {
                    this.Permissionsbits |= 0x400;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowScreenReaders")) {
                    this.Permissionsbits |= 0x200;
                    continue;
                }
                if (key.equalsIgnoreCase("AllowDegradedPrinting")) {
                    this.Permissionsbits |= 4;
                    continue;
                }
                if (key.length() <= 0) continue;
                throw new DocumentInvalidEncryptionPermission(permissions);
            }
        }
    }

    public void setReportParam(String name, Object value) {
        this.Parameters.put(name, value);
    }

    public void setQueryParam(String name, Object value) {
        this.subreportQueries.put(name, value);
    }

    public void setStyleParam(String name, String s) {
        this.subreportStyles.put(name, s);
    }

    public void setChartParam(String chart, int series, ResultSet query) {
        Array chartQueries;
        Object value = this.subreportQueries.get(chart);
        if (value == null) {
            chartQueries = new Array(1, 10);
            this.subreportQueries.put(chart, chartQueries);
        } else {
            chartQueries = (Array)value;
        }
        CfJspPage._arrayset((Object)chartQueries, (Object)new Integer(series), (Object)query, (boolean)false);
    }

    @Override
    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.Template == null) {
            return super.doStartTag();
        }
        return 2;
    }

    private void exportReportToVariable(Report theReport) {
        if (this.Format.equalsIgnoreCase("html")) {
            throw new ReportAttributeNotValidException(this.Name, this.Format);
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            theReport.exportReport(os, this.Format);
            byte[] bytes = os.toByteArray();
            this.pageContext.setAttribute(this.Name, (Object)bytes);
        }
        catch (JRException e) {
            throw new Report.ReportFormatException(e);
        }
    }

    private void exportReportToFile(Report theReport) {
        File file = VFSFileFactory.getFileObject((String)this.FileName);
        if (!this.OverWrite && file.exists()) {
            throw new ReportFileOverWriteException(this.FileName);
        }
        if (this.OverWrite && file.exists() && !file.canWrite()) {
            throw new ReportFileReadOnlyException(this.FileName);
        }
        try {
            String directoryName;
            String fullName = file.getCanonicalPath();
            int index = fullName.lastIndexOf(File.separator);
            File directory = null;
            if (index > 0 && !(directory = VFSFileFactory.getFileObject((String)(directoryName = this.FileName.substring(0, index)))).isDirectory()) {
                throw new ReportInvalidFilePathException(directoryName);
            }
            if (this.Format.equalsIgnoreCase("html")) {
                Object prefix = VFSFileFactory.getFileObject((String)fullName).getName();
                int dotIndex = ((String)prefix).lastIndexOf(".");
                if (dotIndex >= 0) {
                    prefix = ((String)prefix).substring(0, ((String)prefix).lastIndexOf("."));
                }
                prefix = (String)prefix + "_files";
                File resourceDir = VFSFileFactory.getFileObject((File)directory, (String)prefix);
                if (!this.OverWrite && resourceDir.exists()) {
                    throw new ReportFileOverWriteException(resourceDir.getAbsolutePath());
                }
                if (this.OverWrite && resourceDir.exists() && !resourceDir.canWrite()) {
                    throw new ReportFileReadOnlyException(resourceDir.getAbsolutePath());
                }
                this.exportParams.put(CFHtmlExporterParameter.IMAGES_DIR, resourceDir);
            }
            OutputStream os = VFSFileFactory.getOutputStream((File)file);
            theReport.exportReport(os, this.Format);
            os.close();
            theReport.runFinalize();
        }
        catch (JRException e) {
            throw new Report.ReportFormatException(e);
        }
        catch (FileNotFoundException fe) {
            throw new ReportFileException(this.FileName, fe);
        }
        catch (IOException ie) {
            throw new Report.ReportFormatException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() throws JspException {
        if (this.Template == null) {
            return super.doEndTag();
        }
        String conttype = this.request.getHeader("User-Agent");
        if (conttype != null && conttype.equalsIgnoreCase("contype")) {
            Report.setContentType(this.Format, (ServletResponse)this.response);
            throw new AbortException();
        }
        try {
            if (this.Format != null) {
                boolean FormatAllowed = false;
                if (this.Format.equalsIgnoreCase("pdf") || this.Format.equalsIgnoreCase("flashpaper") || this.Format.equalsIgnoreCase("html") || this.Format.equalsIgnoreCase("excel") || this.Format.equalsIgnoreCase("rtf") || this.Format.equalsIgnoreCase("csv") || this.Format.equalsIgnoreCase("xml")) {
                    FormatAllowed = true;
                }
                if (!FormatAllowed) {
                    throw new Report.ReportUnSupportedFormatException(this.Format);
                }
            } else {
                throw new MissingAttributeException("format");
            }
            Report theReport = new Report(this.Template, (NeoPageContext)this.pageContext, this.Style);
            theReport.setSubreportQueries(this.subreportQueries);
            theReport.setSubreportStyles(this.subreportStyles);
            if (this.Format != null && this.Format.equalsIgnoreCase("pdf")) {
                if (this.OwnerPassword != null) {
                    this.exportParams.put(JRPdfExporterParameter.OWNER_PASSWORD, this.OwnerPassword);
                }
                if (this.UserPassword != null) {
                    this.exportParams.put(JRPdfExporterParameter.USER_PASSWORD, this.UserPassword);
                }
                if (this.Permissionsbits != 0) {
                    this.exportParams.put(JRPdfExporterParameter.PERMISSIONS, new Integer(this.Permissionsbits));
                }
                if (this.Encryption != null && !this.Encryption.equalsIgnoreCase("none")) {
                    this.exportParams.put(JRPdfExporterParameter.IS_ENCRYPTED, Boolean.TRUE);
                } else {
                    this.exportParams.put(JRPdfExporterParameter.IS_ENCRYPTED, Boolean.FALSE);
                }
                if (this.Encryption != null && this.Encryption.equalsIgnoreCase("128-bit")) {
                    this.exportParams.put(JRPdfExporterParameter.IS_128_BIT_KEY, Boolean.TRUE);
                } else {
                    this.exportParams.put(JRPdfExporterParameter.IS_128_BIT_KEY, Boolean.FALSE);
                }
            }
            theReport.setExportParams(this.exportParams);
            theReport.runReport(this.Query, this.Parameters);
            if (this.Name != null) {
                this.exportReportToVariable(theReport);
                int n = 6;
                return n;
            }
            if (this.FileName != null) {
                this.exportReportToFile(theReport);
            } else {
                if (this.Format != null && this.Format.equalsIgnoreCase("html") && this.ResourceTimespan != null) {
                    this.exportParams.put(CFHtmlExporterParameter.RESOURCE_TIMESPAN, this.ResourceTimespan);
                }
                theReport.exportReportToStream(this.Format);
            }
            this.onTagEnd();
            int n = 6;
            return n;
        }
        finally {
            this.Parameters.clear();
        }
    }

    @Override
    public void doInitBody() throws JspException {
        if (this.Template == null) {
            super.doInitBody();
        }
    }

    @Override
    public int doAfterBody() throws JspException {
        if (this.Template == null) {
            return super.doAfterBody();
        }
        return 0;
    }

    @Override
    public void release() {
        super.release();
        this.Template = null;
        this.OverWrite = false;
        this.FileName = null;
        this.Query = null;
        this.Parameters.clear();
        this.Format = null;
        this.Name = null;
        this.Permissionsbits = 0;
        this.Permissions = null;
        this.OwnerPassword = null;
        this.UserPassword = null;
        this.Encryption = null;
        this.subreportQueries.clear();
        this.subreportStyles.clear();
    }

    public static class ReportNotValidQueryException
    extends NeoException {
        public String msg;

        public ReportNotValidQueryException(String msg) {
            this.msg = msg;
        }
    }

    public static class ReportAttributeValueException
    extends NeoException {
        public String attribute;
        public Object value;

        public ReportAttributeValueException(String attribute, Object value) {
            this.attribute = attribute;
            this.value = value;
        }
    }

    public static class ReportAttributeNotValidException
    extends NeoException {
        public String attr;
        public String output;

        public ReportAttributeNotValidException(String attr, String output) {
            this.attr = attr;
            this.output = output;
        }
    }

    public static class ReportFileOverWriteException
    extends NeoException {
        public String msg;

        public ReportFileOverWriteException(String path) {
            this.msg = path;
        }
    }

    public static class ReportFileReadOnlyException
    extends NeoException {
        public String msg;

        public ReportFileReadOnlyException(String path) {
            this.msg = path;
        }
    }

    public static class ReportInvalidFilePathException
    extends NeoException {
        public String msg;

        public ReportInvalidFilePathException(String path) {
            this.msg = path;
        }
    }

    public static class ReportFileException
    extends NeoException {
        public String msg;
        public String file;

        public ReportFileException(String path, Exception e) {
            this.msg = e.getLocalizedMessage();
            this.file = path;
        }
    }

    public static class ReportDtdException
    extends NeoException {
        public String FileName;

        public ReportDtdException(String filename) {
            this.FileName = filename;
        }
    }

    public static class ReportValidationException
    extends NeoException {
        public String FileName;
        public String Errors;

        public ReportValidationException(String filename, String errors) {
            this.FileName = filename;
            this.Errors = errors;
        }
    }
}

