/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class ParseNodeFactoryRegistry
implements ParseNodeFactory {
    public static final ParseNodeFactoryRegistry defaultInstance = new ParseNodeFactoryRegistry();
    @Nonnull
    public final Map<String, ParseNodeFactory> contentTypeAssociatedFactories = new HashMap<String, ParseNodeFactory>();
    private static final Pattern contentTypeVendorCleanupPattern = Pattern.compile("[^/]+\\+", 2);

    @Override
    @Nonnull
    public String getValidContentType() {
        throw new UnsupportedOperationException("The registry supports multiple content types. Get the registered factory instead.");
    }

    @Override
    @Nonnull
    public ParseNode getParseNode(@Nonnull String contentType, @Nonnull InputStream rawResponse) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        Objects.requireNonNull(rawResponse, "parameter rawResponse cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        String vendorSpecificContentType = contentType.split(";")[0];
        if (this.contentTypeAssociatedFactories.containsKey(vendorSpecificContentType)) {
            return this.contentTypeAssociatedFactories.get(vendorSpecificContentType).getParseNode(vendorSpecificContentType, rawResponse);
        }
        String cleanedContentType = contentTypeVendorCleanupPattern.matcher(vendorSpecificContentType).replaceAll("");
        if (this.contentTypeAssociatedFactories.containsKey(cleanedContentType)) {
            return this.contentTypeAssociatedFactories.get(cleanedContentType).getParseNode(cleanedContentType, rawResponse);
        }
        throw new RuntimeException("Content type " + cleanedContentType + " does not have a factory to be parsed");
    }
}

