/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.DocValuesAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.FacetRequest;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.StrAggValueSource;
import org.apache.solr.search.facet.UniqueMultiDvSlotAcc;
import org.apache.solr.search.facet.UniqueMultivaluedSlotAcc;
import org.apache.solr.search.facet.UniqueSinglevaluedSlotAcc;

public class UniqueAgg
extends StrAggValueSource {
    public static final String UNIQUE = "unique";
    static final String VALS = "vals";

    public UniqueAgg(String field) {
        super(UNIQUE, field);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) throws IOException {
        SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(this.getArg());
        if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
            if (sf.getType().isPointField()) {
                return new SortedNumericAcc(fcontext, this.getArg(), numSlots);
            }
            if (sf.hasDocValues()) {
                return new UniqueMultiDvSlotAcc(fcontext, sf, numSlots, null);
            }
            return new UniqueMultivaluedSlotAcc(fcontext, sf, numSlots, null);
        }
        if (sf.getType().getNumberType() != null) {
            return new NumericAcc(fcontext, this.getArg(), numSlots);
        }
        return new UniqueSinglevaluedSlotAcc(fcontext, sf, numSlots, null);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    static class SortedNumericAcc
    extends BaseNumericAcc {
        SortedNumericDocValues values;

        public SortedNumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext, field, numSlots);
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            this.values = DocValues.getSortedNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected void collectValues(int doc, LongSet set) throws IOException {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                set.add(this.values.nextValue());
            }
        }
    }

    static class NumericAcc
    extends BaseNumericAcc {
        NumericDocValues values;

        public NumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext, field, numSlots);
        }

        @Override
        protected boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }

        @Override
        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            this.values = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.sf.getName());
        }

        @Override
        protected void collectValues(int doc, LongSet set) throws IOException {
            set.add(this.values.longValue());
        }
    }

    private static class Merger
    extends FacetModule.FacetSortableMerger {
        long answer = -1L;
        long sumUnique;
        Set<Object> values;
        long sumAdded;
        long shardsMissingSum;
        long shardsMissingMax;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            SimpleOrderedMap map = (SimpleOrderedMap)facetResult;
            long unique = ((Number)map.get(UniqueAgg.UNIQUE)).longValue();
            this.sumUnique += unique;
            int valsListed = 0;
            List vals = (List)map.get(UniqueAgg.VALS);
            if (vals != null) {
                if (this.values == null) {
                    this.values = CollectionUtil.newHashSet((int)(vals.size() * 4));
                }
                this.values.addAll(vals);
                valsListed = vals.size();
                this.sumAdded += (long)valsListed;
            }
            this.shardsMissingSum += unique - (long)valsListed;
            this.shardsMissingMax = Math.max(this.shardsMissingMax, unique - (long)valsListed);
        }

        private long getLong() {
            if (this.answer >= 0L) {
                return this.answer;
            }
            long l = this.answer = this.values == null ? 0L : (long)this.values.size();
            if (this.answer == 0L) {
                this.answer = this.shardsMissingSum;
                return this.answer;
            }
            double factor = (double)this.values.size() / (double)this.sumAdded;
            long estimate = (long)((double)this.shardsMissingSum * factor);
            this.answer = (long)this.values.size() + estimate;
            return this.answer;
        }

        @Override
        public Object getMergedResult() {
            return this.getLong();
        }

        @Override
        public int compareTo(FacetModule.FacetSortableMerger other, FacetRequest.SortDirection direction) {
            return Long.compare(this.getLong(), ((Merger)other).getLong());
        }
    }

    static abstract class BaseNumericAcc
    extends DocValuesAcc {
        LongSet[] sets;

        public BaseNumericAcc(FacetContext fcontext, String field, int numSlots) throws IOException {
            super(fcontext, fcontext.qcontext.searcher().getSchema().getField(field));
            this.sets = new LongSet[numSlots];
        }

        @Override
        public void reset() {
            this.sets = new LongSet[this.sets.length];
        }

        @Override
        public void resize(SlotAcc.Resizer resizer) {
            this.sets = resizer.resize(this.sets, null);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            LongSet set = this.sets[slot];
            if (set == null) {
                set = this.sets[slot] = new LongHashSet(16);
            }
            this.collectValues(doc, set);
        }

        protected abstract void collectValues(int var1, LongSet var2) throws IOException;

        @Override
        public Object getValue(int slot) throws IOException {
            if (this.fcontext.isShard()) {
                return this.getShardValue(slot);
            }
            return this.getNonShardValue(slot);
        }

        private long getNonShardValue(int slot) {
            return this.getCardinality(slot);
        }

        private int getCardinality(int slot) {
            LongSet set = this.sets[slot];
            return set == null ? 0 : set.size();
        }

        public Object getShardValue(int slot) throws IOException {
            LongSet set = this.sets[slot];
            int unique = this.getCardinality(slot);
            SimpleOrderedMap map = new SimpleOrderedMap();
            map.add(UniqueAgg.UNIQUE, (Object)unique);
            int maxExplicit = 100;
            if (unique <= maxExplicit) {
                ArrayList<Long> lst = new ArrayList<Long>(Math.min(unique, maxExplicit));
                if (set != null) {
                    for (LongCursor v : set) {
                        lst.add(v.value);
                    }
                }
                map.add(UniqueAgg.VALS, lst);
            }
            return map;
        }

        @Override
        public int compare(int slotA, int slotB) {
            return this.getCardinality(slotA) - this.getCardinality(slotB);
        }
    }
}

