/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.codahale.metrics.Gauge;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.index.SlowCompositeReaderWrapper;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.BitsFilteredPostingsEnum;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.CancellableCollector;
import org.apache.solr.search.CursorMark;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetUtil;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.EarlyTerminatingCollector;
import org.apache.solr.search.EarlyTerminatingCollectorException;
import org.apache.solr.search.EarlyTerminatingSortingCollector;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.MaxScoreCollector;
import org.apache.solr.search.MultiThreadedSearcher;
import org.apache.solr.search.MutableBitDocSet;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.QueryLimits;
import org.apache.solr.search.QueryLimitsExceededException;
import org.apache.solr.search.QueryResult;
import org.apache.solr.search.QueryResultKey;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrDocumentFetcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.SortedIntDocSet;
import org.apache.solr.search.WrappedQuery;
import org.apache.solr.search.facet.UnInvertedField;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.SolrIndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSearcher
extends IndexSearcher
implements Closeable,
SolrInfoBean {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String STATS_SOURCE = "org.apache.solr.stats_source";
    public static final String STATISTICS_KEY = "searcher";
    public static final AtomicLong numOpens = new AtomicLong();
    public static final AtomicLong numCloses = new AtomicLong();
    private static final Map<String, SolrCache<?, ?>> NO_GENERIC_CACHES = Collections.emptyMap();
    private static final SolrCache<?, ?>[] NO_CACHES = new SolrCache[0];
    private static final boolean useExitableDirectoryReader = Boolean.getBoolean("solr.useExitableDirectoryReader");
    private final SolrCore core;
    private final IndexSchema schema;
    private final SolrDocumentFetcher docFetcher;
    private final String name;
    private final Date openTime = new Date();
    private final long openNanoTime = System.nanoTime();
    private Date registerTime;
    private long warmupTime = 0L;
    private final DirectoryReader reader;
    private final boolean closeReader;
    private final int queryResultWindowSize;
    private final int queryResultMaxDocsCached;
    private final boolean useFilterForSortedQuery;
    private final boolean cachingEnabled;
    private final SolrCache<Query, DocSet> filterCache;
    private final SolrCache<QueryResultKey, DocList> queryResultCache;
    private final SolrCache<String, UnInvertedField> fieldValueCache;
    private final LongAdder fullSortCount = new LongAdder();
    private final LongAdder skipSortCount = new LongAdder();
    private final LongAdder liveDocsNaiveCacheHitCount = new LongAdder();
    private final LongAdder liveDocsInsertsCount = new LongAdder();
    private final LongAdder liveDocsHitCount = new LongAdder();
    private final Map<String, SolrCache<?, ?>> cacheMap;
    private final SolrCache[] cacheList;
    private DirectoryFactory directoryFactory;
    private final LeafReader leafReader;
    private final DirectoryReader rawReader;
    private final String path;
    private boolean releaseDirectory;
    private final StatsCache statsCache;
    private Set<String> metricNames = ConcurrentHashMap.newKeySet();
    private SolrMetricsContext solrMetricsContext;
    private static final MatchAllDocsQuery MATCH_ALL_DOCS_QUERY = new MatchAllDocsQuery();
    private final Object liveDocsCacheLock = new Object();
    private BitDocSet liveDocs;
    private static final BitDocSet EMPTY = new BitDocSet(new FixedBitSet(0), 0);
    private static Comparator<ExtendedQuery> sortByCost = Comparator.comparingInt(ExtendedQuery::getCost);
    public static final int NO_CHECK_QCACHE = Integer.MIN_VALUE;
    public static final int GET_DOCSET = 0x40000000;
    static final int NO_CHECK_FILTERCACHE = 0x20000000;
    static final int NO_SET_QCACHE = 0x10000000;
    static final int SEGMENT_TERMINATE_EARLY = 8;
    public static final int TERMINATE_EARLY = 4;
    public static final int GET_DOCLIST = 2;
    public static final int GET_SCORES = 1;

    private static DirectoryReader getReader(SolrCore core, SolrIndexConfig config, DirectoryFactory directoryFactory, String path) throws IOException {
        Directory dir = directoryFactory.get(path, DirectoryFactory.DirContext.DEFAULT, config.lockType);
        try {
            return core.getIndexReaderFactory().newReader(dir, core);
        }
        catch (Exception e) {
            directoryFactory.release(dir);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error opening Reader", (Throwable)e);
        }
    }

    private static DirectoryReader wrapReader(SolrCore core, DirectoryReader reader) throws IOException {
        assert (reader != null);
        reader = UninvertingReader.wrap(reader, core.getLatestSchema().getUninversionMapper());
        if (useExitableDirectoryReader) {
            reader = ExitableDirectoryReader.wrap((DirectoryReader)reader, (QueryTimeout)QueryLimits.getCurrentLimits());
        }
        return reader;
    }

    private Collector buildAndRunCollectorChain(QueryResult qr, Query query, Collector collector, QueryCommand cmd, DelegatingCollector postFilter) throws IOException {
        long timeAllowed;
        boolean terminateEarly;
        EarlyTerminatingSortingCollector earlyTerminatingSortingCollector = null;
        if (cmd.getSegmentTerminateEarly()) {
            Sort cmdSort = cmd.getSort();
            int cmdLen = cmd.getLen();
            Sort mergeSort = this.core.getSolrCoreState().getMergePolicySort();
            if (cmdSort == null || cmdLen <= 0 || mergeSort == null || !EarlyTerminatingSortingCollector.canEarlyTerminate(cmdSort, mergeSort)) {
                log.warn("unsupported combination: segmentTerminateEarly=true cmdSort={} cmdLen={} mergeSort={}", new Object[]{cmdSort, cmdLen, mergeSort});
            } else {
                earlyTerminatingSortingCollector = new EarlyTerminatingSortingCollector((Collector)collector, cmdSort, cmd.getLen());
                collector = earlyTerminatingSortingCollector;
            }
        }
        if (terminateEarly = cmd.getTerminateEarly()) {
            collector = new EarlyTerminatingCollector((Collector)collector, cmd.getLen());
        }
        if ((timeAllowed = cmd.getTimeAllowed()) > 0L) {
            collector = new TimeLimitingCollector(collector, TimeLimitingCollector.getGlobalCounter(), timeAllowed);
        }
        if (postFilter != null) {
            postFilter.setLastDelegate((Collector)collector);
            collector = postFilter;
        }
        if (cmd.isQueryCancellable()) {
            collector = new CancellableCollector((Collector)collector);
            this.core.getCancellableQueryTracker().addShardLevelActiveQuery(cmd.getQueryID(), (CancellableCollector)collector);
        }
        try {
            super.search(query, collector);
        }
        catch (ExitableDirectoryReader.ExitingReaderException | TimeLimitingCollector.TimeExceededException | CancellableCollector.QueryCancelledException x) {
            log.warn("Query: [{}]; ", (Object)query, (Object)x);
            qr.setPartialResults(true);
        }
        catch (EarlyTerminatingCollectorException etce) {
            if (collector instanceof DelegatingCollector) {
                ((DelegatingCollector)((Object)collector)).complete();
            }
            throw etce;
        }
        finally {
            if (earlyTerminatingSortingCollector != null) {
                qr.setSegmentTerminatedEarly(earlyTerminatingSortingCollector.terminatedEarly());
            }
            if (cmd.isQueryCancellable()) {
                this.core.getCancellableQueryTracker().removeCancellableQuery(cmd.getQueryID());
            }
        }
        if (collector instanceof DelegatingCollector) {
            ((DelegatingCollector)((Object)collector)).complete();
        }
        return collector;
    }

    public SolrIndexSearcher(SolrCore core, String path, IndexSchema schema, SolrIndexConfig config, String name, boolean enableCache, DirectoryFactory directoryFactory) throws IOException {
        this(core, path, schema, name, SolrIndexSearcher.getReader(core, config, directoryFactory, path), true, enableCache, false, directoryFactory);
        this.releaseDirectory = true;
    }

    public SolrIndexSearcher(SolrCore core, String path, IndexSchema schema, String name, DirectoryReader r, boolean closeReader, boolean enableCache, boolean reserveDirectory, DirectoryFactory directoryFactory) throws IOException {
        super((IndexReader)SolrIndexSearcher.wrapReader(core, r), core.getCoreContainer().getCollectorExecutor());
        this.path = path;
        this.directoryFactory = directoryFactory;
        this.reader = (DirectoryReader)this.readerContext.reader();
        this.rawReader = r;
        this.leafReader = SlowCompositeReaderWrapper.wrap((IndexReader)this.reader);
        this.core = core;
        this.statsCache = core.createStatsCache();
        this.schema = schema;
        this.name = "Searcher@" + Integer.toHexString(this.hashCode()) + "[" + core.getName() + "]" + (String)(name != null ? " " + name : "");
        log.debug("Opening [{}]", (Object)this.name);
        if (directoryFactory.searchersReserveCommitPoints()) {
            core.getDeletionPolicy().saveCommitPoint(this.reader.getIndexCommit().getGeneration());
        }
        if (reserveDirectory) {
            directoryFactory.incRef(this.getIndexReader().directory());
            this.releaseDirectory = true;
        }
        this.closeReader = closeReader;
        this.setSimilarity(schema.getSimilarity());
        SolrConfig solrConfig = core.getSolrConfig();
        this.queryResultWindowSize = solrConfig.queryResultWindowSize;
        this.queryResultMaxDocsCached = solrConfig.queryResultMaxDocsCached;
        this.useFilterForSortedQuery = solrConfig.useFilterForSortedQuery;
        this.docFetcher = new SolrDocumentFetcher(this, solrConfig, enableCache);
        this.cachingEnabled = enableCache;
        if (this.cachingEnabled) {
            SolrCache<Integer, Document> documentCache;
            ArrayList<SolrCache> clist = new ArrayList<SolrCache>();
            SolrCache<String, UnInvertedField> solrCache = this.fieldValueCache = solrConfig.fieldValueCacheConfig == null ? null : solrConfig.fieldValueCacheConfig.newInstance();
            if (this.fieldValueCache != null) {
                clist.add(this.fieldValueCache);
            }
            SolrCache<Query, DocSet> solrCache2 = this.filterCache = solrConfig.filterCacheConfig == null ? null : solrConfig.filterCacheConfig.newInstance();
            if (this.filterCache != null) {
                clist.add(this.filterCache);
            }
            SolrCache<QueryResultKey, DocList> solrCache3 = this.queryResultCache = solrConfig.queryResultCacheConfig == null ? null : solrConfig.queryResultCacheConfig.newInstance();
            if (this.queryResultCache != null) {
                clist.add(this.queryResultCache);
            }
            if ((documentCache = this.docFetcher.getDocumentCache()) != null) {
                clist.add(documentCache);
            }
            if (solrConfig.userCacheConfigs.isEmpty()) {
                this.cacheMap = NO_GENERIC_CACHES;
            } else {
                this.cacheMap = CollectionUtil.newHashMap((int)solrConfig.userCacheConfigs.size());
                for (Map.Entry<String, CacheConfig> e : solrConfig.userCacheConfigs.entrySet()) {
                    SolrCache cache = e.getValue().newInstance();
                    if (cache == null) continue;
                    this.cacheMap.put(cache.name(), cache);
                    clist.add(cache);
                }
            }
            this.cacheList = clist.toArray(new SolrCache[0]);
        } else {
            this.filterCache = null;
            this.queryResultCache = null;
            this.fieldValueCache = null;
            this.cacheMap = NO_GENERIC_CACHES;
            this.cacheList = NO_CACHES;
        }
        this.setQueryCache(null);
        numOpens.incrementAndGet();
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public SolrDocumentFetcher getDocFetcher() {
        return this.docFetcher.clone();
    }

    public <T> T interrogateDocFetcher(Function<SolrDocumentFetcher, T> func) {
        return func.apply(this.docFetcher);
    }

    public StatsCache getStatsCache() {
        return this.statsCache;
    }

    public FieldInfos getFieldInfos() {
        return this.leafReader.getFieldInfos();
    }

    public TermStatistics termStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        StatsSource statsSrc;
        SolrRequestInfo reqInfo = SolrRequestInfo.getRequestInfo();
        if (reqInfo != null && (statsSrc = (StatsSource)reqInfo.getReq().getContext().get(STATS_SOURCE)) != null) {
            return statsSrc.termStatistics(this, term, docFreq, totalTermFreq);
        }
        return this.localTermStatistics(term, docFreq, totalTermFreq);
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        StatsSource statsSrc;
        SolrRequestInfo reqInfo = SolrRequestInfo.getRequestInfo();
        if (reqInfo != null && (statsSrc = (StatsSource)reqInfo.getReq().getContext().get(STATS_SOURCE)) != null) {
            return statsSrc.collectionStatistics(this, field);
        }
        return this.localCollectionStatistics(field);
    }

    public TermStatistics localTermStatistics(Term term, int docFreq, long totalTermFreq) throws IOException {
        return super.termStatistics(term, docFreq, totalTermFreq);
    }

    public CollectionStatistics localCollectionStatistics(String field) throws IOException {
        return super.collectionStatistics(field);
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.name + "{" + this.reader + "}";
    }

    public SolrCore getCore() {
        return this.core;
    }

    public final int maxDoc() {
        return this.reader.maxDoc();
    }

    public final int numDocs() {
        return this.reader.numDocs();
    }

    public final int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public final LeafReader getSlowAtomicReader() {
        return this.leafReader;
    }

    public final DirectoryReader getRawReader() {
        return this.rawReader;
    }

    public final DirectoryReader getIndexReader() {
        assert (Objects.equals(this.reader, super.getIndexReader()));
        return this.reader;
    }

    public void register() {
        Map<String, SolrInfoBean> infoRegistry = this.core.getInfoRegistry();
        infoRegistry.put(STATISTICS_KEY, this);
        infoRegistry.put(this.name, this);
        for (SolrCache cache : this.cacheList) {
            cache.setState(SolrCache.State.LIVE);
            infoRegistry.put(cache.name(), cache);
        }
        this.solrMetricsContext = this.core.getSolrMetricsContext().getChildContext(this);
        for (SolrCache cache : this.cacheList) {
            cache.initializeMetrics(this.solrMetricsContext, SolrMetricManager.mkName(cache.name(), STATISTICS_KEY));
        }
        this.initializeMetrics(this.solrMetricsContext, STATISTICS_KEY);
        this.registerTime = new Date();
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            if (this.cachingEnabled) {
                StringBuilder sb = new StringBuilder();
                sb.append("Closing ").append(this.name);
                for (SolrCache cache : this.cacheList) {
                    sb.append("\n\t");
                    sb.append(cache);
                }
                log.debug("{}", (Object)sb);
            } else {
                log.debug("Closing [{}]", (Object)this.name);
            }
        }
        this.core.getInfoRegistry().remove(this.name);
        long cpg = this.reader.getIndexCommit().getGeneration();
        try {
            if (this.closeReader) {
                this.rawReader.decRef();
            }
        }
        catch (Exception e) {
            log.error("Problem dec ref'ing reader", (Throwable)e);
        }
        if (this.directoryFactory.searchersReserveCommitPoints()) {
            this.core.getDeletionPolicy().releaseCommitPoint(cpg);
        }
        for (SolrCache cache : this.cacheList) {
            try {
                cache.close();
            }
            catch (Exception e) {
                log.error("Exception closing cache {}", (Object)cache.name(), (Object)e);
            }
        }
        if (this.releaseDirectory) {
            this.directoryFactory.release(this.getIndexReader().directory());
        }
        try {
            SolrInfoBean.super.close();
        }
        catch (Exception e) {
            log.warn("Exception closing", (Throwable)e);
        }
        numCloses.incrementAndGet();
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public Iterable<String> getFieldNames() {
        return StreamSupport.stream(this.getFieldInfos().spliterator(), false).map(fieldInfo -> fieldInfo.name).collect(Collectors.toUnmodifiableList());
    }

    public SolrCache<Query, DocSet> getFilterCache() {
        return this.filterCache;
    }

    public static void initRegenerators(SolrConfig solrConfig) {
        if (solrConfig.fieldValueCacheConfig != null && solrConfig.fieldValueCacheConfig.getRegenerator() == null) {
            solrConfig.fieldValueCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public <K, V> boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache<K, V> newCache, SolrCache<K, V> oldCache, K oldKey, V oldVal) throws IOException {
                    if (oldVal instanceof UnInvertedField) {
                        UnInvertedField.getUnInvertedField((String)oldKey, newSearcher);
                    }
                    return true;
                }
            });
        }
        if (solrConfig.filterCacheConfig != null && solrConfig.filterCacheConfig.getRegenerator() == null) {
            solrConfig.filterCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public <K, V> boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache<K, V> newCache, SolrCache<K, V> oldCache, K oldKey, V oldVal) throws IOException {
                    newSearcher.cacheDocSet((Query)oldKey, null, false);
                    return true;
                }
            });
        }
        if (solrConfig.queryResultCacheConfig != null && solrConfig.queryResultCacheConfig.getRegenerator() == null) {
            final int queryResultWindowSize = solrConfig.queryResultWindowSize;
            solrConfig.queryResultCacheConfig.setRegenerator(new CacheRegenerator(){

                @Override
                public <K, V> boolean regenerateItem(SolrIndexSearcher newSearcher, SolrCache<K, V> newCache, SolrCache<K, V> oldCache, K oldKey, V oldVal) throws IOException {
                    QueryResultKey key = (QueryResultKey)oldKey;
                    int nDocs = 1;
                    if (queryResultWindowSize <= 1) {
                        DocList oldList = (DocList)oldVal;
                        int oldnDocs = oldList.offset() + oldList.size();
                        nDocs = Math.min(oldnDocs, 40);
                    }
                    int flags = Integer.MIN_VALUE | key.nc_flags;
                    QueryCommand qc = new QueryCommand();
                    qc.setQuery(key.query).setFilterList(key.filters).setSort(key.sort).setLen(nDocs).setSupersetMaxDoc(nDocs).setFlags(flags);
                    QueryResult qr = new QueryResult();
                    newSearcher.getDocListC(qr, qc);
                    return true;
                }
            });
        }
    }

    public QueryResult search(QueryCommand cmd) throws IOException {
        return this.search(new QueryResult(), cmd);
    }

    @Deprecated
    public QueryResult search(QueryResult qr, QueryCommand cmd) throws IOException {
        this.getDocListC(qr, cmd);
        return qr;
    }

    protected void search(final List<LeafReaderContext> leaves, final Weight weight, final Collector collector) throws IOException {
        final QueryLimits queryLimits = QueryLimits.getCurrentLimits();
        if (useExitableDirectoryReader || !queryLimits.isLimitsEnabled()) {
            super.search(leaves, weight, collector);
        } else {
            new IndexSearcher((IndexReader)this.reader){

                void searchWithTimeout() throws IOException {
                    this.setTimeout(queryLimits);
                    super.search(leaves, weight, collector);
                    if (this.timedOut()) {
                        throw new QueryLimitsExceededException("Limits exceeded! (search): " + queryLimits.limitStatusMessage());
                    }
                }
            }.searchWithTimeout();
        }
    }

    @Deprecated
    public Document doc(int docId) throws IOException {
        return this.doc(docId, (Set<String>)null);
    }

    @Deprecated
    public final void doc(int docId, StoredFieldVisitor visitor) throws IOException {
        this.getDocFetcher().doc(docId, visitor);
    }

    @Deprecated
    public final Document doc(int i, Set<String> fields) throws IOException {
        return this.getDocFetcher().doc(i, fields);
    }

    public SolrCache<String, UnInvertedField> getFieldValueCache() {
        return this.fieldValueCache;
    }

    public Sort weightSort(Sort sort) throws IOException {
        return sort != null ? sort.rewrite((IndexSearcher)this) : null;
    }

    public SortSpec weightSortSpec(SortSpec originalSortSpec, Sort nullEquivalent) throws IOException {
        return this.implWeightSortSpec(originalSortSpec.getSort(), originalSortSpec.getCount(), originalSortSpec.getOffset(), nullEquivalent);
    }

    private SortSpec implWeightSortSpec(Sort originalSort, int num, int offset, Sort nullEquivalent) throws IOException {
        Sort rewrittenSort = this.weightSort(originalSort);
        if (rewrittenSort == null) {
            rewrittenSort = nullEquivalent;
        }
        SortField[] rewrittenSortFields = rewrittenSort.getSort();
        SchemaField[] rewrittenSchemaFields = new SchemaField[rewrittenSortFields.length];
        for (int ii = 0; ii < rewrittenSortFields.length; ++ii) {
            String fieldName = rewrittenSortFields[ii].getField();
            rewrittenSchemaFields[ii] = fieldName == null ? null : this.schema.getFieldOrNull(fieldName);
        }
        return new SortSpec(rewrittenSort, rewrittenSchemaFields, num, offset);
    }

    public int getFirstMatch(Term t) throws IOException {
        long pair = this.lookupId(t.field(), t.bytes());
        if (pair == -1L) {
            return -1;
        }
        int segIndex = (int)(pair >> 32);
        int segDocId = (int)pair;
        return ((LeafReaderContext)this.leafContexts.get((int)segIndex)).docBase + segDocId;
    }

    public long lookupId(BytesRef idBytes) throws IOException {
        return this.lookupId(this.schema.getUniqueKeyField().getName(), idBytes);
    }

    private long lookupId(String field, BytesRef idBytes) throws IOException {
        int c = this.leafContexts.size();
        for (int i = 0; i < c; ++i) {
            TermsEnum te;
            LeafReaderContext leaf = (LeafReaderContext)this.leafContexts.get(i);
            LeafReader reader = leaf.reader();
            Terms terms = reader.terms(field);
            if (terms == null || !(te = terms.iterator()).seekExact(idBytes)) continue;
            PostingsEnum docs = te.postings(null, 0);
            int id = (docs = BitsFilteredPostingsEnum.wrap(docs, reader.getLiveDocs())).nextDoc();
            if (id == Integer.MAX_VALUE) continue;
            assert (docs.nextDoc() == Integer.MAX_VALUE);
            return (long)i << 32 | (long)id;
        }
        return -1L;
    }

    public void cacheDocSet(Query query, DocSet optionalAnswer, boolean mustCache) throws IOException {
        if (optionalAnswer != null) {
            if (this.filterCache != null) {
                this.filterCache.put(query, optionalAnswer);
            }
            return;
        }
        this.getDocSet(query);
    }

    private BitDocSet makeBitDocSet(DocSet answer) {
        if (answer instanceof BitDocSet) {
            return (BitDocSet)answer;
        }
        FixedBitSet bs = new FixedBitSet(this.maxDoc());
        DocIterator iter = answer.iterator();
        while (iter.hasNext()) {
            bs.set(iter.nextDoc());
        }
        return new BitDocSet(bs, answer.size());
    }

    public BitDocSet getDocSetBits(Query q) throws IOException {
        DocSet answer = this.getDocSet(q);
        BitDocSet answerBits = this.makeBitDocSet(answer);
        if (answerBits != answer && this.filterCache != null) {
            this.filterCache.put(q, answerBits);
        }
        return answerBits;
    }

    DocSet getPositiveDocSet(Query query) throws IOException {
        boolean doCache;
        boolean bl = doCache = this.filterCache != null;
        if (query instanceof ExtendedQuery) {
            if (!((ExtendedQuery)query).getCache()) {
                doCache = false;
            }
            if (query instanceof WrappedQuery) {
                query = ((WrappedQuery)query).getWrappedQuery();
            }
        }
        if (doCache) {
            return this.getAndCacheDocSet(query);
        }
        return this.getDocSetNC(query, null);
    }

    private DocSet getAndCacheDocSet(Query query) throws IOException {
        DocSet answer;
        assert (!(query instanceof WrappedQuery)) : "should have unwrapped";
        assert (this.filterCache != null) : "must check for caching before calling this method";
        if (query instanceof MatchAllDocsQuery) {
            return this.getLiveDocSet();
        }
        QueryLimits queryLimits = QueryLimits.getCurrentLimits();
        if (queryLimits.isLimitsEnabled()) {
            answer = this.filterCache.get(query);
            if (answer == null) {
                answer = this.getDocSetNC(query, null);
                this.filterCache.put(query, answer);
            }
        } else {
            answer = this.filterCache.computeIfAbsent(query, q -> this.getDocSetNC((Query)q, null));
        }
        assert (!(answer instanceof MutableBitDocSet)) : "should not be mutable";
        return answer;
    }

    private BitDocSet computeLiveDocs() {
        switch (this.leafContexts.size()) {
            case 0: {
                assert (this.numDocs() == 0);
                return EMPTY;
            }
            case 1: {
                FixedBitSet fbs;
                Bits onlySegLiveDocs = ((LeafReaderContext)this.leafContexts.get(0)).reader().getLiveDocs();
                if (onlySegLiveDocs == null) {
                    int onlySegMaxDoc = this.maxDoc();
                    fbs = new FixedBitSet(onlySegMaxDoc);
                    fbs.set(0, onlySegMaxDoc);
                } else {
                    fbs = FixedBitSet.copyOf((Bits)onlySegLiveDocs);
                }
                assert (fbs.cardinality() == this.numDocs());
                return new BitDocSet(fbs, this.numDocs());
            }
        }
        FixedBitSet bs = new FixedBitSet(this.maxDoc());
        for (LeafReaderContext ctx : this.leafContexts) {
            LeafReader r = ctx.reader();
            Bits segLiveDocs = r.getLiveDocs();
            int segDocBase = ctx.docBase;
            if (segLiveDocs == null) {
                bs.set(segDocBase, segDocBase + r.maxDoc());
                continue;
            }
            DocSetUtil.copyTo(segLiveDocs, 0, r.maxDoc(), bs, segDocBase);
        }
        assert (bs.cardinality() == this.numDocs());
        return new BitDocSet(bs, this.numDocs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitDocSet populateLiveDocs(Supplier<BitDocSet> liveDocsSupplier) {
        Object object = this.liveDocsCacheLock;
        synchronized (object) {
            if (this.liveDocs != null) {
                this.liveDocsHitCount.increment();
            } else {
                this.liveDocs = liveDocsSupplier.get();
                this.liveDocsInsertsCount.increment();
            }
        }
        return this.liveDocs;
    }

    public BitDocSet getLiveDocSet() throws IOException {
        BitDocSet docs = this.liveDocs;
        if (docs != null) {
            this.liveDocsNaiveCacheHitCount.increment();
        } else {
            docs = this.populateLiveDocs(this::computeLiveDocs);
        }
        assert (docs.size() == this.numDocs());
        return docs;
    }

    public Bits getLiveDocsBits() throws IOException {
        return this.getIndexReader().hasDeletions() ? this.getLiveDocSet().getBits() : null;
    }

    public BitDocSet offerLiveDocs(Supplier<DocSet> docSetSupplier, int suppliedSize) {
        assert (suppliedSize == this.numDocs());
        BitDocSet ret = this.liveDocs;
        if (ret != null) {
            this.liveDocsNaiveCacheHitCount.increment();
            return ret;
        }
        return this.populateLiveDocs(() -> this.makeBitDocSet((DocSet)docSetSupplier.get()));
    }

    public DocSet getDocSet(List<Query> queries) throws IOException {
        ProcessedFilter pf = this.getProcessedFilter(null, queries);
        if (pf.postFilter == null) {
            if (pf.answer != null) {
                return pf.answer;
            }
            if (pf.filter == null) {
                return this.getLiveDocSet();
            }
        }
        DocSetCollector setCollector = new DocSetCollector(this.maxDoc());
        SimpleCollector collector = setCollector;
        if (pf.postFilter != null) {
            pf.postFilter.setLastDelegate((Collector)collector);
            collector = pf.postFilter;
        }
        MatchAllDocsQuery query = pf.filter != null ? pf.filter : MATCH_ALL_DOCS_QUERY;
        this.search((Query)query, (Collector)collector);
        if (collector instanceof DelegatingCollector) {
            ((DelegatingCollector)collector).complete();
        }
        return DocSetUtil.getDocSet(setCollector, this);
    }

    public ProcessedFilter getProcessedFilter(DocSet setFilter, List<Query> queries) throws IOException {
        ProcessedFilter pf = new ProcessedFilter();
        if (queries == null || queries.size() == 0) {
            if (setFilter != null) {
                pf.answer = setFilter;
                pf.filter = setFilter.makeQuery();
            }
            return pf;
        }
        DocSet answer = null;
        boolean[] neg = new boolean[queries.size()];
        DocSet[] sets = new DocSet[queries.size()];
        ArrayList<ExtendedQuery> notCached = null;
        ArrayList<PostFilter> postFilters = null;
        int end = 0;
        if (setFilter != null) {
            answer = setFilter;
        }
        for (Query query : queries) {
            ExtendedQuery eq;
            if (query instanceof ExtendedQuery && !(eq = (ExtendedQuery)query).getCache()) {
                if (eq.getCost() >= 100 && eq instanceof PostFilter) {
                    if (postFilters == null) {
                        postFilters = new ArrayList<PostFilter>(sets.length - end);
                    }
                    postFilters.add((PostFilter)query);
                    continue;
                }
                if (notCached == null) {
                    notCached = new ArrayList(sets.length - end);
                }
                notCached.add((ExtendedQuery)query);
                continue;
            }
            if (this.filterCache == null) {
                if (notCached == null) {
                    notCached = new ArrayList<ExtendedQuery>(sets.length - end);
                }
                WrappedQuery uncached = new WrappedQuery(query);
                uncached.setCache(false);
                notCached.add(uncached);
                continue;
            }
            Query posQuery = QueryUtils.getAbs(query);
            DocSet docSet = this.getPositiveDocSet(posQuery);
            if (Objects.equals(query, posQuery)) {
                if (answer == null) {
                    answer = docSet;
                    continue;
                }
                if (docSet.size() < answer.size()) {
                    DocSet tmp = answer;
                    answer = docSet;
                    docSet = tmp;
                }
                neg[end] = false;
            } else {
                neg[end] = true;
            }
            sets[end++] = docSet;
        }
        if (end > 0) {
            int i;
            if (answer == null) {
                answer = this.getLiveDocSet();
            }
            if (end > 1 && answer instanceof BitDocSet) {
                answer = MutableBitDocSet.fromBitDocSet((BitDocSet)answer);
            }
            for (i = 0; i < end; ++i) {
                if (!neg[i]) continue;
                answer = answer.andNot(sets[i]);
            }
            for (i = 0; i < end; ++i) {
                if (neg[i]) continue;
                answer = answer.intersection(sets[i]);
            }
            answer = MutableBitDocSet.unwrapIfMutable(answer);
        }
        if (answer != null && answer.size() == this.numDocs()) {
            answer = null;
        }
        if (notCached == null && postFilters == null) {
            if (answer != null) {
                pf.answer = answer;
                pf.filter = answer.makeQuery();
            }
            return pf;
        }
        if (notCached == null) {
            if (answer != null) {
                pf.filter = answer.makeQuery();
            }
        } else {
            notCached.sort(sortByCost);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            if (answer != null) {
                builder.add(answer.makeQuery(), BooleanClause.Occur.FILTER);
            }
            for (ExtendedQuery eq : notCached) {
                Query q = eq.getCostAppliedQuery();
                builder.add(q, BooleanClause.Occur.FILTER);
            }
            pf.filter = builder.build();
        }
        if (postFilters != null) {
            postFilters.sort(sortByCost);
            for (int i = postFilters.size() - 1; i >= 0; --i) {
                DelegatingCollector delegatingCollector = pf.postFilter;
                pf.postFilter = ((PostFilter)postFilters.get(i)).getFilterCollector(this);
                if (delegatingCollector == null) continue;
                pf.postFilter.setDelegate((Collector)delegatingCollector);
            }
        }
        return pf;
    }

    public DocSet getDocSet(DocsEnumState deState) throws IOException {
        boolean useCache;
        int largestPossible = deState.termsEnum.docFreq();
        boolean bl = useCache = this.filterCache != null && largestPossible >= deState.minSetSizeCached;
        if (useCache) {
            TermQuery key = new TermQuery(new Term(deState.fieldName, deState.termsEnum.term()));
            return this.filterCache.computeIfAbsent((Query)key, k -> this.getResult(deState, largestPossible));
        }
        return this.getResult(deState, largestPossible);
    }

    private DocSet getResult(DocsEnumState deState, int largestPossible) throws IOException {
        DocSet result;
        int smallSetSize = DocSetUtil.smallSetSize(this.maxDoc());
        int scratchSize = Math.min(smallSetSize, largestPossible);
        if (deState.scratch == null || deState.scratch.length < scratchSize) {
            deState.scratch = new int[scratchSize];
        }
        int[] docs = deState.scratch;
        int upto = 0;
        int bitsSet = 0;
        FixedBitSet fbs = null;
        PostingsEnum postingsEnum = deState.termsEnum.postings(deState.postingsEnum, 0);
        postingsEnum = BitsFilteredPostingsEnum.wrap(postingsEnum, deState.liveDocs);
        if (deState.postingsEnum == null) {
            deState.postingsEnum = postingsEnum;
        }
        if (postingsEnum instanceof MultiPostingsEnum) {
            MultiPostingsEnum.EnumWithSlice[] subs = ((MultiPostingsEnum)postingsEnum).getSubs();
            int numSubs = ((MultiPostingsEnum)postingsEnum).getNumSubs();
            for (int subindex = 0; subindex < numSubs; ++subindex) {
                int docid;
                MultiPostingsEnum.EnumWithSlice sub = subs[subindex];
                if (sub.postingsEnum == null) continue;
                int base = sub.slice.start;
                if (largestPossible > docs.length) {
                    if (fbs == null) {
                        fbs = new FixedBitSet(this.maxDoc());
                    }
                    while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        fbs.set(docid + base);
                        ++bitsSet;
                    }
                    continue;
                }
                while ((docid = sub.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    docs[upto++] = docid + base;
                }
            }
        } else if (largestPossible > docs.length) {
            int docid;
            fbs = new FixedBitSet(this.maxDoc());
            while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                fbs.set(docid);
                ++bitsSet;
            }
        } else {
            int docid;
            while ((docid = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                docs[upto++] = docid;
            }
        }
        if (fbs != null) {
            for (int i = 0; i < upto; ++i) {
                fbs.set(docs[i]);
            }
            result = new BitDocSet(fbs, bitsSet += upto);
        } else {
            result = upto == 0 ? DocSet.empty() : new SortedIntDocSet(Arrays.copyOf(docs, upto));
        }
        return result;
    }

    protected DocSet getDocSetNC(Query query, DocSet filter) throws IOException {
        return DocSetUtil.createDocSet(this, query, filter);
    }

    public DocSet getDocSet(Query query) throws IOException {
        return this.getDocSet(query, null);
    }

    public DocSet getDocSet(Query query, DocSet filter) throws IOException {
        boolean doCache;
        boolean bl = doCache = this.filterCache != null;
        if (query instanceof ExtendedQuery) {
            if (!((ExtendedQuery)query).getCache()) {
                doCache = false;
            }
            if (query instanceof WrappedQuery) {
                query = ((WrappedQuery)query).getWrappedQuery();
            }
        }
        if (!doCache) {
            query = QueryUtils.makeQueryable(query);
            return this.getDocSetNC(query, filter);
        }
        Query absQ = QueryUtils.getAbs(query);
        boolean positive = Objects.equals(absQ, query);
        DocSet absAnswer = this.getAndCacheDocSet(absQ);
        if (filter == null) {
            return positive ? absAnswer : this.getLiveDocSet().andNot(absAnswer);
        }
        return positive ? absAnswer.intersection(filter) : filter.andNot(absAnswer);
    }

    @Deprecated
    public DocList getDocList(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        return new QueryCommand().setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).search(this).getDocList();
    }

    @Deprecated
    public DocList getDocList(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        return new QueryCommand().setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).search(this).getDocList();
    }

    private static boolean sortIncludesOtherThanScore(Sort sort) {
        if (sort == null) {
            return false;
        }
        SortField[] sortFields = sort.getSort();
        return sortFields.length > 1 || sortFields[0].getType() != SortField.Type.SCORE;
    }

    private boolean useFilterCacheForDynamicScoreQuery(boolean needSort, QueryCommand cmd) {
        if (!this.useFilterForSortedQuery) {
            return false;
        }
        if (!needSort) {
            return true;
        }
        Sort sort = cmd.getSort();
        if (sort == null) {
            return false;
        }
        return Arrays.stream(sort.getSort()).noneMatch(sf -> sf.getType() == SortField.Type.SCORE);
    }

    private QueryResult getDocListC(QueryResult qr, QueryCommand cmd) throws IOException {
        boolean useFilterCache;
        boolean needSort;
        ExtendedQuery eq;
        if (cmd.getSegmentTerminateEarly()) {
            qr.setSegmentTerminatedEarly(Boolean.FALSE);
        }
        DocListAndSet out = new DocListAndSet();
        qr.setDocListAndSet(out);
        QueryResultKey key = null;
        int maxDocRequested = cmd.getOffset() + cmd.getLen();
        if (maxDocRequested < 0 || maxDocRequested > this.maxDoc()) {
            maxDocRequested = this.maxDoc();
        }
        int supersetMaxDoc = maxDocRequested;
        DocList superset = null;
        int flags = cmd.getFlags();
        Query q = cmd.getQuery();
        if (q instanceof ExtendedQuery && !(eq = (ExtendedQuery)q).getCache()) {
            flags |= 0xB0000000;
        }
        if (this.queryResultCache != null && cmd.getFilter() == null && (flags & 0x90000000) != -1879048192) {
            key = new QueryResultKey(q, cmd.getFilterList(), cmd.getSort(), flags, cmd.getMinExactCount(), cmd.isDistribStatsDisabled());
            if ((flags & Integer.MIN_VALUE) == 0) {
                superset = this.queryResultCache.get(key);
                if (superset != null && ((flags & 1) == 0 || superset.hasScores())) {
                    out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
                }
                if (out.docList != null) {
                    if (out.docSet == null && (flags & 0x40000000) != 0) {
                        if (cmd.getFilterList() == null) {
                            out.docSet = this.getDocSet(cmd.getQuery());
                        } else {
                            ArrayList<Query> newList = new ArrayList<Query>(cmd.getFilterList().size() + 1);
                            newList.add(cmd.getQuery());
                            newList.addAll(cmd.getFilterList());
                            out.docSet = this.getDocSet(newList);
                        }
                    }
                    return qr;
                }
            }
            if ((flags & 0x10000000) == 0) {
                if (maxDocRequested < this.queryResultWindowSize) {
                    supersetMaxDoc = this.queryResultWindowSize;
                } else {
                    supersetMaxDoc = ((maxDocRequested - 1) / this.queryResultWindowSize + 1) * this.queryResultWindowSize;
                    if (supersetMaxDoc < 0) {
                        supersetMaxDoc = maxDocRequested;
                    }
                }
            } else {
                key = null;
            }
        }
        cmd.setSupersetMaxDoc(supersetMaxDoc);
        if ((flags & 0x20000001) != 0 || this.filterCache == null) {
            needSort = true;
            useFilterCache = false;
        } else if (q instanceof MatchAllDocsQuery || this.useFilterForSortedQuery && QueryUtils.isConstantScoreQuery(q)) {
            Sort sort = cmd.getSort();
            boolean bl = needSort = cmd.getLen() > 0 && SolrIndexSearcher.sortIncludesOtherThanScore(sort);
            useFilterCache = !needSort ? true : Arrays.stream(sort.getSort()).noneMatch(sf -> sf.getType() == SortField.Type.SCORE);
        } else {
            needSort = cmd.getLen() > 0;
            useFilterCache = this.useFilterCacheForDynamicScoreQuery(needSort, cmd);
        }
        if (useFilterCache) {
            if (out.docSet == null) {
                out.docSet = this.getDocSet(cmd.getQuery(), cmd.getFilter());
                List<Query> filterList = cmd.getFilterList();
                if (filterList != null && !filterList.isEmpty()) {
                    out.docSet = DocSetUtil.getDocSet(out.docSet.intersection(this.getDocSet(filterList)), this);
                }
            }
            if (needSort) {
                this.fullSortCount.increment();
                this.sortDocSet(qr, cmd);
            } else {
                this.skipSortCount.increment();
                out.docList = this.constantScoreDocList(cmd.getOffset(), cmd.getLen(), out.docSet);
                if (0 == cmd.getSupersetMaxDoc()) {
                    qr.setNextCursorMark(cmd.getCursorMark());
                } else assert (cmd.getCursorMark() == null);
            }
        } else {
            this.fullSortCount.increment();
            if ((flags & 0x40000000) != 0) {
                DocSet qDocSet = this.getDocListAndSetNC(qr, cmd);
                if (qDocSet != null && this.filterCache != null && !qr.isPartialResults()) {
                    this.filterCache.put(cmd.getQuery(), qDocSet);
                }
            } else {
                this.getDocListNC(qr, cmd);
            }
            assert (null != out.docList) : "docList is null";
        }
        if (null == cmd.getCursorMark()) {
            superset = out.docList;
            out.docList = superset.subset(cmd.getOffset(), cmd.getLen());
        } else {
            assert (null == superset) : "cursor: superset isn't null";
            assert (0 == cmd.getOffset()) : "cursor: command offset mismatch";
            assert (0 == out.docList.offset()) : "cursor: docList offset mismatch";
            assert (cmd.getLen() >= supersetMaxDoc) : "cursor: superset len mismatch: " + cmd.getLen() + " vs " + supersetMaxDoc;
        }
        if (key != null && superset.size() <= this.queryResultMaxDocsCached && !qr.isPartialResults()) {
            this.queryResultCache.put(key, superset);
        }
        return qr;
    }

    private TotalHits.Relation populateScoresIfNeeded(QueryCommand cmd, boolean needScores, TopDocs topDocs, Query query, ScoreMode scoreModeUsed) throws IOException {
        if (cmd.getSort() != null && !(cmd.getQuery() instanceof RankQuery) && needScores) {
            TopFieldCollector.populateScores((ScoreDoc[])topDocs.scoreDocs, (IndexSearcher)this, (Query)query);
        }
        if (scoreModeUsed == ScoreMode.COMPLETE || scoreModeUsed == ScoreMode.COMPLETE_NO_SCORES) {
            return TotalHits.Relation.EQUAL_TO;
        }
        return topDocs.totalHits.relation;
    }

    private void populateNextCursorMarkFromTopDocs(QueryResult qr, QueryCommand qc, TopDocs topDocs) {
        if (null == qc.getCursorMark()) {
            return;
        }
        CursorMark lastCursorMark = qc.getCursorMark();
        assert (topDocs instanceof TopFieldDocs) : "TopFieldDocs cursor constraint violated";
        TopFieldDocs topFieldDocs = (TopFieldDocs)topDocs;
        ScoreDoc[] scoreDocs = topFieldDocs.scoreDocs;
        if (0 == scoreDocs.length) {
            qr.setNextCursorMark(lastCursorMark);
        } else {
            ScoreDoc lastDoc = scoreDocs[scoreDocs.length - 1];
            assert (lastDoc instanceof FieldDoc) : "FieldDoc cursor constraint violated";
            List<Object> lastFields = Arrays.asList(((FieldDoc)lastDoc).fields);
            CursorMark nextCursorMark = lastCursorMark.createNext(lastFields);
            assert (null != nextCursorMark) : "null nextCursorMark";
            qr.setNextCursorMark(nextCursorMark);
        }
    }

    TopDocsCollector<? extends ScoreDoc> buildTopDocsCollector(int len, QueryCommand cmd) throws IOException {
        int minNumFound = cmd.getMinExactCount();
        Query q = cmd.getQuery();
        if (q instanceof RankQuery) {
            RankQuery rq = (RankQuery)q;
            return rq.getTopDocsCollector(len, cmd, this);
        }
        if (null == cmd.getSort()) {
            assert (null == cmd.getCursorMark()) : "have cursor but no sort";
            return TopScoreDocCollector.create((int)len, (int)minNumFound);
        }
        Sort weightedSort = this.weightSort(cmd.getSort());
        CursorMark cursor = cmd.getCursorMark();
        FieldDoc searchAfter = null != cursor ? cursor.getSearchAfterFieldDoc() : null;
        return TopFieldCollector.create((Sort)weightedSort, (int)len, (FieldDoc)searchAfter, (int)minNumFound);
    }

    private void getDocListNC(QueryResult qr, QueryCommand cmd) throws IOException {
        TotalHits.Relation hitsRelation;
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        int lastDocRequested = last;
        int nDocsReturned = 0;
        boolean needScores = (cmd.getFlags() & 1) != 0;
        ProcessedFilter pf = this.getProcessedFilter(cmd.getFilter(), cmd.getFilterList());
        Query query = QueryUtils.combineQueryAndFilter(QueryUtils.makeQueryable(cmd.getQuery()), pf.filter);
        if (lastDocRequested <= 0) {
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            final int[] numHits = new int[1];
            SimpleCollector collector = !needScores ? new SimpleCollector(){

                public void collect(int doc) {
                    numHits[0] = numHits[0] + 1;
                }

                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE_NO_SCORES;
                }
            } : new SimpleCollector(){
                Scorable scorer;

                public void setScorer(Scorable scorer) {
                    this.scorer = scorer;
                }

                public void collect(int doc) throws IOException {
                    numHits[0] = numHits[0] + 1;
                    float score = this.scorer.score();
                    if (score > topscore[0]) {
                        topscore[0] = score;
                    }
                }

                public ScoreMode scoreMode() {
                    return ScoreMode.COMPLETE;
                }
            };
            this.buildAndRunCollectorChain(qr, query, (Collector)collector, cmd, pf.postFilter);
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = numHits[0];
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
            qr.setNextCursorMark(cmd.getCursorMark());
            hitsRelation = TotalHits.Relation.EQUAL_TO;
        } else {
            TopDocs topDocs;
            ScoreMode scoreModeUsed;
            if (log.isDebugEnabled()) {
                log.debug("calling from 2, query: {}", query.getClass());
            }
            if (!MultiThreadedSearcher.allowMT(pf.postFilter, cmd)) {
                log.trace("SINGLE THREADED search, skipping collector manager in getDocListNC");
                Collector topCollector = this.buildTopDocsCollector(len, cmd);
                MaxScoreCollector maxScoreCollector = null;
                Collector collector = topCollector;
                if (needScores) {
                    maxScoreCollector = new MaxScoreCollector();
                    collector = MultiCollector.wrap((Collector[])new Collector[]{topCollector, maxScoreCollector});
                }
                scoreModeUsed = this.buildAndRunCollectorChain(qr, query, collector, cmd, pf.postFilter).scoreMode();
                totalHits = topCollector.getTotalHits();
                topDocs = topCollector.topDocs(0, len);
                maxScore = totalHits > 0 ? (maxScoreCollector == null ? Float.NaN : maxScoreCollector.getMaxScore()) : 0.0f;
            } else {
                log.trace("MULTI-THREADED search, using CollectorManager int getDocListNC");
                MultiThreadedSearcher.SearchResult searchResult = new MultiThreadedSearcher(this).searchCollectorManagers(len, cmd, query, true, needScores, false);
                scoreModeUsed = searchResult.scoreMode;
                MultiThreadedSearcher.TopDocsResult topDocsResult = searchResult.getTopDocsResult();
                totalHits = topDocsResult.totalHits;
                topDocs = topDocsResult.topDocs;
                maxScore = searchResult.getMaxScore(totalHits);
            }
            hitsRelation = this.populateScoresIfNeeded(cmd, needScores, topDocs, query, scoreModeUsed);
            this.populateNextCursorMarkFromTopDocs(qr, cmd, topDocs);
            nDocsReturned = topDocs.scoreDocs.length;
            ids = new int[nDocsReturned];
            scores = needScores ? new float[nDocsReturned] : null;
            for (int i = 0; i < nDocsReturned; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                ids[i] = scoreDoc.doc;
                if (scores == null) continue;
                scores[i] = scoreDoc.score;
            }
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore, hitsRelation));
    }

    private DocSet getDocListAndSetNC(QueryResult qr, QueryCommand cmd) throws IOException {
        float maxScore;
        int totalHits;
        float[] scores;
        int[] ids;
        int nDocsReturned;
        DocSet set;
        int len = cmd.getSupersetMaxDoc();
        int last = len;
        if (last < 0 || last > this.maxDoc()) {
            last = this.maxDoc();
        }
        int lastDocRequested = last;
        boolean needScores = (cmd.getFlags() & 1) != 0;
        int maxDoc = this.maxDoc();
        cmd.setMinExactCount(Integer.MAX_VALUE);
        ProcessedFilter pf = this.getProcessedFilter(cmd.getFilter(), cmd.getFilterList());
        Query query = QueryUtils.combineQueryAndFilter(QueryUtils.makeQueryable(cmd.getQuery()), pf.filter);
        if (lastDocRequested <= 0) {
            DocSetCollector collector;
            final float[] topscore = new float[]{Float.NEGATIVE_INFINITY};
            DocSetCollector setCollector = new DocSetCollector(maxDoc);
            if (!needScores) {
                collector = setCollector;
            } else {
                SimpleCollector topScoreCollector = new SimpleCollector(){
                    Scorable scorer;

                    public void setScorer(Scorable scorer) throws IOException {
                        this.scorer = scorer;
                    }

                    public void collect(int doc) throws IOException {
                        float score = this.scorer.score();
                        if (score > topscore[0]) {
                            topscore[0] = score;
                        }
                    }

                    public ScoreMode scoreMode() {
                        return ScoreMode.TOP_SCORES;
                    }
                };
                collector = MultiCollector.wrap((Collector[])new Collector[]{setCollector, topScoreCollector});
            }
            this.buildAndRunCollectorChain(qr, query, (Collector)collector, cmd, pf.postFilter);
            set = DocSetUtil.getDocSet(setCollector, this);
            nDocsReturned = 0;
            ids = new int[nDocsReturned];
            scores = new float[nDocsReturned];
            totalHits = set.size();
            maxScore = totalHits > 0 ? topscore[0] : 0.0f;
            qr.setNextCursorMark(cmd.getCursorMark());
        } else {
            TopDocs topDocs;
            if (!MultiThreadedSearcher.allowMT(pf.postFilter, cmd)) {
                log.trace("SINGLE THREADED search, skipping collector manager in getDocListAndSetNC");
                TopDocsCollector<? extends ScoreDoc> topCollector = this.buildTopDocsCollector(len, cmd);
                DocSetCollector setCollector = new DocSetCollector(maxDoc);
                MaxScoreCollector maxScoreCollector = null;
                ArrayList<Collector> collectors = new ArrayList<Collector>(Arrays.asList(new Collector[]{topCollector, setCollector}));
                if (needScores) {
                    maxScoreCollector = new MaxScoreCollector();
                    collectors.add((Collector)maxScoreCollector);
                }
                Collector collector = MultiCollector.wrap(collectors);
                this.buildAndRunCollectorChain(qr, query, collector, cmd, pf.postFilter);
                set = DocSetUtil.getDocSet(setCollector, this);
                totalHits = topCollector.getTotalHits();
                assert (totalHits == set.size() || qr.isPartialResults());
                topDocs = topCollector.topDocs(0, len);
                maxScore = totalHits > 0 ? (maxScoreCollector == null ? Float.NaN : maxScoreCollector.getMaxScore()) : 0.0f;
            } else {
                log.trace("MULTI-THREADED search, using CollectorManager in getDocListAndSetNC");
                boolean needMaxScore = needScores;
                MultiThreadedSearcher.SearchResult searchResult = new MultiThreadedSearcher(this).searchCollectorManagers(len, cmd, query, true, needMaxScore, true);
                MultiThreadedSearcher.TopDocsResult topDocsResult = searchResult.getTopDocsResult();
                totalHits = topDocsResult.totalHits;
                topDocs = topDocsResult.topDocs;
                maxScore = searchResult.getMaxScore(totalHits);
                set = new BitDocSet(searchResult.getFixedBitSet());
            }
            this.populateScoresIfNeeded(cmd, needScores, topDocs, query, ScoreMode.COMPLETE);
            this.populateNextCursorMarkFromTopDocs(qr, cmd, topDocs);
            nDocsReturned = topDocs.scoreDocs.length;
            ids = new int[nDocsReturned];
            scores = needScores ? new float[nDocsReturned] : null;
            for (int i = 0; i < nDocsReturned; ++i) {
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                ids[i] = scoreDoc.doc;
                if (scores == null) continue;
                scores[i] = scoreDoc.score;
            }
        }
        int sliceLen = Math.min(lastDocRequested, nDocsReturned);
        if (sliceLen < 0) {
            sliceLen = 0;
        }
        qr.setDocList(new DocSlice(0, sliceLen, ids, scores, totalHits, maxScore, TotalHits.Relation.EQUAL_TO));
        qr.setDocSet(set);
        return pf.filter == null && pf.postFilter == null ? qr.getDocSet() : null;
    }

    @Deprecated
    public DocList getDocList(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        return new QueryCommand().setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).search(this).getDocList();
    }

    @Deprecated
    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len) throws IOException {
        return new QueryCommand().setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true).search(this).getDocListAndSet();
    }

    @Deprecated
    public DocListAndSet getDocListAndSet(Query query, Query filter, Sort lsort, int offset, int len, int flags) throws IOException {
        return new QueryCommand().setQuery(query).setFilterList(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true).search(this).getDocListAndSet();
    }

    @Deprecated
    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len) throws IOException {
        return new QueryCommand().setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true).search(this).getDocListAndSet();
    }

    @Deprecated
    public DocListAndSet getDocListAndSet(Query query, List<Query> filterList, Sort lsort, int offset, int len, int flags) throws IOException {
        return new QueryCommand().setQuery(query).setFilterList(filterList).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true).search(this).getDocListAndSet();
    }

    @Deprecated
    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len) throws IOException {
        return new QueryCommand().setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setNeedDocSet(true).search(this).getDocListAndSet();
    }

    @Deprecated
    public DocListAndSet getDocListAndSet(Query query, DocSet filter, Sort lsort, int offset, int len, int flags) throws IOException {
        return new QueryCommand().setQuery(query).setFilter(filter).setSort(lsort).setOffset(offset).setLen(len).setFlags(flags).setNeedDocSet(true).search(this).getDocListAndSet();
    }

    private DocList constantScoreDocList(int offset, int length, DocSet docs) {
        int size = docs.size();
        int returnSize = Math.min(offset + length, size);
        int[] docIds = new int[returnSize];
        DocIterator iter = docs.iterator();
        for (int i = 0; i < returnSize; ++i) {
            docIds[i] = iter.nextDoc();
        }
        return new DocSlice(0, returnSize, docIds, null, size, 0.0f, TotalHits.Relation.EQUAL_TO);
    }

    protected void sortDocSet(QueryResult qr, QueryCommand cmd) throws IOException {
        DocSet set = qr.getDocListAndSet().docSet;
        int nDocs = cmd.getSupersetMaxDoc();
        if (nDocs == 0) {
            qr.getDocListAndSet().docList = new DocSlice(0, 0, new int[0], null, set.size(), 0.0f, TotalHits.Relation.EQUAL_TO);
            qr.setNextCursorMark(cmd.getCursorMark());
            return;
        }
        TopDocsCollector<? extends ScoreDoc> topCollector = this.buildTopDocsCollector(nDocs, cmd);
        DocIterator iter = set.iterator();
        int base = 0;
        int end = 0;
        int readerIndex = 0;
        LeafCollector leafCollector = null;
        while (iter.hasNext()) {
            int doc = iter.nextDoc();
            while (doc >= end) {
                LeafReaderContext leaf = (LeafReaderContext)this.leafContexts.get(readerIndex++);
                base = leaf.docBase;
                end = base + leaf.reader().maxDoc();
                leafCollector = topCollector.getLeafCollector(leaf);
            }
            leafCollector.collect(doc - base);
        }
        TopDocs topDocs = topCollector.topDocs(0, nDocs);
        int nDocsReturned = topDocs.scoreDocs.length;
        int[] ids = new int[nDocsReturned];
        for (int i = 0; i < nDocsReturned; ++i) {
            ScoreDoc scoreDoc = topDocs.scoreDocs[i];
            ids[i] = scoreDoc.doc;
        }
        assert (topDocs.totalHits.relation == TotalHits.Relation.EQUAL_TO);
        qr.getDocListAndSet().docList = new DocSlice(0, nDocsReturned, ids, null, topDocs.totalHits.value, 0.0f, topDocs.totalHits.relation);
        this.populateNextCursorMarkFromTopDocs(qr, cmd, topDocs);
    }

    public int numDocs(Query a, DocSet b) throws IOException {
        if (b.size() == 0) {
            return 0;
        }
        if (this.filterCache != null) {
            Query absQ = QueryUtils.getAbs(a);
            DocSet positiveA = this.getPositiveDocSet(absQ);
            return Objects.equals(a, absQ) ? b.intersectionSize(positiveA) : b.andNotSize(positiveA);
        }
        TotalHitCountCollector collector = new TotalHitCountCollector();
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(QueryUtils.makeQueryable(a), BooleanClause.Occur.MUST);
        bq.add(b.makeQuery(), BooleanClause.Occur.MUST);
        super.search((Query)bq.build(), (Collector)collector);
        return collector.getTotalHits();
    }

    public int numDocs(DocSet a, DocsEnumState deState) throws IOException {
        return a.intersectionSize(this.getDocSet(deState));
    }

    public int numDocs(Query a, Query b) throws IOException {
        Query absA = QueryUtils.getAbs(a);
        Query absB = QueryUtils.getAbs(b);
        DocSet positiveA = this.getPositiveDocSet(absA);
        DocSet positiveB = this.getPositiveDocSet(absB);
        if (Objects.equals(a, absA)) {
            if (Objects.equals(b, absB)) {
                return positiveA.intersectionSize(positiveB);
            }
            return positiveA.andNotSize(positiveB);
        }
        if (Objects.equals(b, absB)) {
            return positiveB.andNotSize(positiveA);
        }
        BitDocSet all = this.getLiveDocSet();
        return ((DocSet)all).andNotSize(positiveA.union(positiveB));
    }

    public boolean intersects(DocSet a, DocsEnumState deState) throws IOException {
        return a.intersects(this.getDocSet(deState));
    }

    public void bootstrapFirstSearcher() {
        for (SolrCache solrCache : this.cacheList) {
            solrCache.initialSearcher(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warm(SolrIndexSearcher old) {
        long warmingStartTime = System.nanoTime();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("warming", new String[]{"true"});
        for (int i = 0; i < this.cacheList.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug("autowarming [{}] from [{}]\n\t{}", new Object[]{this, old, old.cacheList[i]});
            }
            LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, (SolrParams)params){

                @Override
                public SolrIndexSearcher getSearcher() {
                    return SolrIndexSearcher.this;
                }

                @Override
                public void close() {
                }
            };
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            try {
                this.cacheList[i].warm(this, old.cacheList[i]);
            }
            finally {
                try {
                    req.close();
                }
                finally {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("autowarming result for [{}]\n\t{}", (Object)this, (Object)this.cacheList[i]);
        }
        this.warmupTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - warmingStartTime, TimeUnit.NANOSECONDS);
    }

    public SolrCache getCache(String cacheName) {
        return this.cacheMap.get(cacheName);
    }

    public Object cacheLookup(String cacheName, Object key) {
        SolrCache<?, ?> cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.get(key);
    }

    public Object cacheInsert(String cacheName, Object key, Object val) {
        SolrCache<?, ?> cache = this.cacheMap.get(cacheName);
        return cache == null ? null : cache.put(key, val);
    }

    public Date getOpenTimeStamp() {
        return this.openTime;
    }

    public long getOpenNanoTime() {
        return this.openNanoTime;
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return super.explain(QueryUtils.makeQueryable(query), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexFingerprint getIndexFingerprint(long maxVersion) throws IOException {
        SolrIndexSearcher searcher = this;
        AtomicReference exception = new AtomicReference();
        try {
            IndexFingerprint indexFingerprint = searcher.getTopReaderContext().leaves().stream().map(ctx -> {
                try {
                    return searcher.getCore().getIndexFingerprint(searcher, (LeafReaderContext)ctx, maxVersion);
                }
                catch (IOException e) {
                    exception.set(e);
                    return null;
                }
            }).filter(Objects::nonNull).reduce(new IndexFingerprint(maxVersion), IndexFingerprint::reduce);
            return indexFingerprint;
        }
        finally {
            if (exception.get() != null) {
                throw (IOException)exception.get();
            }
        }
    }

    @Override
    public String getName() {
        return SolrIndexSearcher.class.getName();
    }

    @Override
    public String getDescription() {
        return "index searcher";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.CORE;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        parentContext.gauge(() -> this.name, true, "searcherName", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(() -> this.cachingEnabled, true, "caching", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(() -> this.openTime, true, "openedAt", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(() -> this.warmupTime, true, "warmupTime", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(() -> this.registerTime, true, "registeredAt", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.fullSortCount::sum, true, "fullSortCount", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.skipSortCount::sum, true, "skipSortCount", SolrInfoBean.Category.SEARCHER.toString(), scope);
        MetricsMap liveDocsCacheMetrics = new MetricsMap(map -> {
            map.put((CharSequence)"inserts", this.liveDocsInsertsCount.sum());
            map.put((CharSequence)"hits", this.liveDocsHitCount.sum());
            map.put((CharSequence)"naiveHits", this.liveDocsNaiveCacheHitCount.sum());
        });
        parentContext.gauge(liveDocsCacheMetrics, true, "liveDocsCache", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.rgauge(parentContext.nullNumber(), () -> this.reader.numDocs()), true, "numDocs", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.rgauge(parentContext.nullNumber(), () -> this.reader.maxDoc()), true, "maxDoc", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.rgauge(parentContext.nullNumber(), () -> this.reader.maxDoc() - this.reader.numDocs()), true, "deletedDocs", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.rgauge(parentContext.nullString(), () -> this.reader.toString()), true, "reader", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.rgauge(parentContext.nullString(), () -> this.reader.directory().toString()), true, "readerDir", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(this.rgauge(parentContext.nullNumber(), () -> this.reader.getVersion()), true, "indexVersion", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(() -> {
            try {
                Collection files = this.reader.getIndexCommit().getFileNames();
                long total = 0L;
                for (String file : files) {
                    total += DirectoryFactory.sizeOf(this.reader.directory(), file);
                }
                return total;
            }
            catch (Exception e) {
                return parentContext.nullNumber();
            }
        }, true, "indexCommitSize", SolrInfoBean.Category.SEARCHER.toString(), scope);
        parentContext.gauge(new MetricsMap(map -> {
            this.statsCache.getCacheMetrics().getSnapshot((arg_0, arg_1) -> ((MapWriter.EntryWriter)map).putNoEx(arg_0, arg_1));
            map.put((CharSequence)"statsCacheImpl", (CharSequence)this.statsCache.getClass().getSimpleName());
        }), true, "statsCache", SolrInfoBean.Category.CACHE.toString(), scope);
    }

    private <T> Gauge<T> rgauge(T closedDefault, Gauge<T> g) {
        return () -> {
            try {
                return g.getValue();
            }
            catch (AlreadyClosedException ignore) {
                return closedDefault;
            }
        };
    }

    public long getWarmupTime() {
        return this.warmupTime;
    }

    public static class ProcessedFilter {
        public DocSet answer;
        public Query filter;
        public DelegatingCollector postFilter;
    }

    public static class DocsEnumState {
        public String fieldName;
        public TermsEnum termsEnum;
        public Bits liveDocs;
        public PostingsEnum postingsEnum;
        public int minSetSizeCached;
        public int[] scratch;
    }
}

