/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.util.List;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.handler.admin.ZookeeperReadAPI;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;

public class MediaTypeOverridingFilter
implements ContainerResponseFilter {
    private static final List<Class<? extends JerseyResource>> EXEMPTED_RESOURCES = List.of(ZookeeperReadAPI.class);
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (responseContext.getStatus() >= 400) {
            return;
        }
        if (this.resourceInfo.getResourceClass() == null || EXEMPTED_RESOURCES.contains(this.resourceInfo.getResourceClass())) {
            return;
        }
        SolrQueryRequest solrQueryRequest = (SolrQueryRequest)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        String mediaType = V2ApiUtils.getMediaTypeFromWtParam(solrQueryRequest.getParams(), "application/json");
        if (mediaType != null) {
            responseContext.getHeaders().putSingle((Object)"Content-Type", (Object)mediaType);
        }
    }
}

