/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.TimeZoneUtils;

@Path(value="/aliases")
public class CreateAliasAPI
extends AdminAPIBase {
    @Inject
    public CreateAliasAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createAlias(CreateAliasRequestBody requestBody) throws Exception {
        ZkNodeProps remoteMessage;
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        CreateAliasAPI.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request body is required but missing");
        }
        requestBody.validate();
        if (CollectionUtil.isNotEmpty(requestBody.collections)) {
            remoteMessage = CreateAliasAPI.createRemoteMessageForTraditionalAlias(requestBody);
        } else {
            assert (CollectionUtil.isNotEmpty(requestBody.routers));
            Aliases aliases = this.coreContainer.getAliases();
            if (aliases.hasAlias(requestBody.name) && !aliases.isRoutedAlias(requestBody.name)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot add routing parameters to existing non-routed Alias: " + requestBody.name);
            }
            remoteMessage = CreateAliasAPI.createRemoteMessageForRoutedAlias(requestBody);
        }
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(this.coreContainer, this.coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.CREATEALIAS, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (requestBody.async != null) {
            response.requestId = requestBody.async;
        }
        return response;
    }

    public static ZkNodeProps createRemoteMessageForTraditionalAlias(CreateAliasRequestBody requestBody) {
        HashMap<String, String> remoteMessage = new HashMap<String, String>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATEALIAS.toLower());
        remoteMessage.put("name", requestBody.name);
        remoteMessage.put("collections", String.join((CharSequence)",", requestBody.collections));
        remoteMessage.put("async", requestBody.async);
        return new ZkNodeProps(remoteMessage);
    }

    public static ZkNodeProps createRemoteMessageForRoutedAlias(CreateAliasRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATEALIAS.toLower());
        remoteMessage.put("name", requestBody.name);
        if (StrUtils.isNotBlank((String)requestBody.async)) {
            remoteMessage.put("async", requestBody.async);
        }
        if (requestBody.routers.size() > 1) {
            for (int i = 0; i < requestBody.routers.size(); ++i) {
                requestBody.routers.get(i).addRemoteMessageProperties(remoteMessage, "router." + i + ".");
            }
        } else if (requestBody.routers.size() == 1) {
            requestBody.routers.get(0).addRemoteMessageProperties(remoteMessage, "router.");
        }
        if (requestBody.collCreationParameters != null) {
            CreateCollection.addToRemoteMessageWithPrefix(requestBody.collCreationParameters, remoteMessage, "create-collection.");
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static CreateAliasRequestBody createFromSolrParams(SolrParams params) {
        CreateAliasRequestBody createBody = new CreateAliasRequestBody();
        createBody.name = params.required().get("name");
        String collections = params.get("collections");
        createBody.collections = StrUtils.isNullOrEmpty((String)collections) ? new ArrayList() : StrUtils.split((String)collections, (char)',');
        createBody.async = params.get("async");
        String typeStr = params.get("router.name");
        if (typeStr == null) {
            return createBody;
        }
        createBody.routers = new ArrayList<RoutedAliasProperties>();
        if (typeStr.startsWith("Dimensional[")) {
            String commaSeparatedDimensions = typeStr.substring("Dimensional[".length(), typeStr.length() - 1);
            String[] dimensions = commaSeparatedDimensions.split(",");
            if (dimensions.length > 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "More than 2 dimensions is not supported yet. Please monitor SOLR-13628 for progress");
            }
            for (int i = 0; i < dimensions.length; ++i) {
                createBody.routers.add(CreateAliasAPI.createFromSolrParams(dimensions[i], params, "router." + i + "."));
            }
        } else {
            createBody.routers.add(CreateAliasAPI.createFromSolrParams(typeStr, params, "router."));
        }
        SolrParams createCollectionParams = CreateAliasAPI.getHierarchicalParametersByPrefix(params, "create-collection.");
        createBody.collCreationParameters = CreateCollection.createRequestBodyFromV1Params(createCollectionParams, false);
        return createBody;
    }

    public static RoutedAliasProperties createFromSolrParams(String type, SolrParams params, String propertyPrefix) {
        String typeLower = type.toLowerCase(Locale.ROOT);
        if (typeLower.startsWith("time")) {
            return TimeRoutedAliasProperties.createFromSolrParams(params, propertyPrefix);
        }
        if (typeLower.startsWith("category")) {
            return CategoryRoutedAliasProperties.createFromSolrParams(params, propertyPrefix);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Router name: " + type + " is not in supported types, " + Arrays.asList(RoutedAliasTypes.values()));
    }

    public static SolrParams getHierarchicalParametersByPrefix(SolrParams paramSource, String prefix) {
        ModifiableSolrParams filteredParams = new ModifiableSolrParams();
        paramSource.stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).forEach(e -> filteredParams.add(((String)e.getKey()).substring(prefix.length()), (String[])e.getValue()));
        return filteredParams;
    }

    public static class CreateAliasRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(required=true)
        public String name;
        @JsonProperty(value="collections")
        public List<String> collections;
        @JsonProperty(value="async")
        public String async;
        @JsonProperty(value="routers")
        public List<RoutedAliasProperties> routers;
        @JsonProperty(value="create-collection")
        public CreateCollectionRequestBody collCreationParameters;

        public void validate() {
            SolrIdentifierValidator.validateAliasName((String)this.name);
            if (CollectionUtil.isEmpty(this.collections) && CollectionUtil.isEmpty(this.routers)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Alias creation requires either a list of either collections (for creating a traditional alias) or routers (for creating a routed alias)");
            }
            if (CollectionUtil.isNotEmpty(this.routers)) {
                this.routers.forEach(r -> r.validate());
                if (CollectionUtil.isNotEmpty(this.collections)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collections cannot be specified when creating a routed alias.");
                }
                CreateCollectionRequestBody createCollReqBody = this.collCreationParameters;
                if (createCollReqBody != null) {
                    if (createCollReqBody.name != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "routed aliases calculate names for their dependent collections, you cannot specify the name.");
                    }
                    if (createCollReqBody.config == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Routed alias creation requires a configset name to use for any collections created by the alias.");
                    }
                }
            }
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TimeRoutedAliasProperties.class, name="time"), @JsonSubTypes.Type(value=CategoryRoutedAliasProperties.class, name="category")})
    public static abstract class RoutedAliasProperties
    implements JacksonReflectMapWriter {
        @JsonProperty(required=true)
        public String field;

        public abstract void validate();

        public abstract void addRemoteMessageProperties(Map<String, Object> var1, String var2);

        protected void ensureRequiredFieldPresent(Object val, String name) {
            if (val == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + name);
            }
        }
    }

    public static class TimeRoutedAliasProperties
    extends RoutedAliasProperties {
        @JsonProperty(required=true)
        public String start;
        @JsonProperty(value="tz")
        public String tz;
        @JsonProperty(required=true)
        public String interval;
        @JsonProperty(value="maxFutureMs")
        public Long maxFutureMs;
        @JsonProperty(value="preemptiveCreateMath")
        public String preemptiveCreateMath;
        @JsonProperty(value="autoDeleteAge")
        public String autoDeleteAge;

        @Override
        public void validate() {
            this.ensureRequiredFieldPresent(this.field, "'field' on time routed alias");
            this.ensureRequiredFieldPresent(this.start, "'start' on time routed alias");
            this.ensureRequiredFieldPresent(this.interval, "'interval' on time routed alias");
            TimeRoutedAlias.parseStringAsInstant(this.start, TimeZoneUtils.parseTimezone(this.tz));
            if (this.maxFutureMs != null && this.maxFutureMs < 0L) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.maxFutureMs must be >= 0");
            }
        }

        @Override
        public void addRemoteMessageProperties(Map<String, Object> remoteMessage, String prefix) {
            remoteMessage.put(prefix + "name", "time");
            remoteMessage.put(prefix + "field", this.field);
            remoteMessage.put(prefix + "start", this.start);
            remoteMessage.put(prefix + "interval", this.interval);
            if (this.tz != null) {
                remoteMessage.put(prefix + "tz", this.tz);
            }
            if (this.maxFutureMs != null) {
                remoteMessage.put(prefix + "maxFutureMs", this.maxFutureMs);
            }
            if (this.preemptiveCreateMath != null) {
                remoteMessage.put(prefix + "preemptiveCreateMath", this.preemptiveCreateMath);
            }
            if (this.autoDeleteAge != null) {
                remoteMessage.put(prefix + "autoDeleteAge", this.autoDeleteAge);
            }
        }

        public static TimeRoutedAliasProperties createFromSolrParams(SolrParams params, String propertyPrefix) {
            TimeRoutedAliasProperties timeRoutedProperties = new TimeRoutedAliasProperties();
            timeRoutedProperties.field = params.required().get(propertyPrefix + "field");
            timeRoutedProperties.start = params.required().get(propertyPrefix + "start");
            timeRoutedProperties.interval = params.required().get(propertyPrefix + "interval");
            timeRoutedProperties.tz = params.get(propertyPrefix + "tz");
            timeRoutedProperties.maxFutureMs = params.getLong(propertyPrefix + "maxFutureMs");
            timeRoutedProperties.preemptiveCreateMath = params.get(propertyPrefix + "preemptiveCreateMath");
            timeRoutedProperties.autoDeleteAge = params.get(propertyPrefix + "autoDeleteAge");
            return timeRoutedProperties;
        }
    }

    public static class CategoryRoutedAliasProperties
    extends RoutedAliasProperties {
        @JsonProperty(value="maxCardinality")
        public Long maxCardinality;
        @JsonProperty(value="mustMatch")
        public String mustMatch;

        @Override
        public void validate() {
            this.ensureRequiredFieldPresent(this.field, "'field' on category routed alias");
        }

        @Override
        public void addRemoteMessageProperties(Map<String, Object> remoteMessage, String prefix) {
            remoteMessage.put(prefix + "name", "category");
            remoteMessage.put(prefix + "field", this.field);
            if (this.maxCardinality != null) {
                remoteMessage.put(prefix + "maxCardinality", this.maxCardinality);
            }
            if (StrUtils.isNotBlank((String)this.mustMatch)) {
                remoteMessage.put(prefix + "mustMatch", this.mustMatch);
            }
        }

        public static CategoryRoutedAliasProperties createFromSolrParams(SolrParams params, String propertyPrefix) {
            CategoryRoutedAliasProperties categoryRoutedProperties = new CategoryRoutedAliasProperties();
            categoryRoutedProperties.field = params.required().get(propertyPrefix + "field");
            categoryRoutedProperties.maxCardinality = params.getLong(propertyPrefix + "maxCardinality");
            categoryRoutedProperties.mustMatch = params.get(propertyPrefix + "mustMatch");
            return categoryRoutedProperties;
        }
    }
}

