/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.Checksum;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.ShardBackupMetadata;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.IndexFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCore
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCore core;
    private RestoreRepository repository;

    private RestoreCore(SolrCore core, RestoreRepository repository) {
        this.core = core;
        this.repository = repository;
    }

    public static RestoreCore create(BackupRepository backupRepo, SolrCore core, URI location, String backupname) {
        BasicRestoreRepository repository = new BasicRestoreRepository(backupRepo.resolveDirectory(location, backupname), backupRepo);
        return new RestoreCore(core, repository);
    }

    public static RestoreCore createWithMetaFile(BackupRepository repo, SolrCore core, URI location, ShardBackupId shardBackupId) throws IOException {
        BackupFilePaths incBackupFiles = new BackupFilePaths(repo, location);
        URI shardBackupMetadataDir = incBackupFiles.getShardBackupMetadataDir();
        ShardBackupIdRestoreRepository resolver = new ShardBackupIdRestoreRepository(location, incBackupFiles.getIndexDir(), repo, ShardBackupMetadata.from(repo, shardBackupMetadataDir, shardBackupId));
        return new RestoreCore(core, resolver);
    }

    @Override
    public Boolean call() throws Exception {
        return this.doRestore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doRestore() throws Exception {
        int n;
        Directory indexDir;
        block19: {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT);
            String restoreIndexName = "restore." + dateFormat.format(new Date());
            String restoreIndexPath = this.core.getDataDir() + restoreIndexName;
            String indexDirPath = this.core.getIndexDir();
            Directory restoreIndexDir = null;
            indexDir = null;
            try {
                boolean success;
                restoreIndexDir = this.core.getDirectoryFactory().get(restoreIndexPath, DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
                indexDir = this.core.getDirectoryFactory().get(indexDirPath, DirectoryFactory.DirContext.DEFAULT, this.core.getSolrConfig().indexConfig.lockType);
                HashSet<String> indexDirFiles = new HashSet<String>(Arrays.asList(indexDir.listAll()));
                for (String filename : this.repository.listAllFiles()) {
                    this.checkInterrupted();
                    try {
                        if (indexDirFiles.contains(filename)) {
                            IndexFetcher.CompareResult compareResult;
                            Checksum cs = this.repository.checksum(filename);
                            if (cs == null) {
                                compareResult = new IndexFetcher.CompareResult();
                                compareResult.equal = false;
                            } else {
                                compareResult = IndexFetcher.compareFile(indexDir, filename, cs.size, cs.checksum);
                            }
                            if (!compareResult.equal || IndexFetcher.filesToAlwaysDownloadIfNoChecksums(filename, cs.size, compareResult)) {
                                this.repository.repoCopy(filename, restoreIndexDir);
                                continue;
                            }
                            this.repository.localCopy(indexDir, filename, restoreIndexDir);
                            continue;
                        }
                        this.repository.repoCopy(filename, restoreIndexDir);
                    }
                    catch (Exception e) {
                        log.warn("Exception while restoring the backup index ", (Throwable)e);
                        throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Exception while restoring the backup index", (Throwable)e);
                    }
                }
                log.debug("Switching directories");
                this.core.modifyIndexProps(restoreIndexName);
                try {
                    this.core.getUpdateHandler().newIndexWriter(false);
                    this.openNewSearcher();
                    success = true;
                    log.info("Successfully restored to the backup index");
                }
                catch (Exception e) {
                    block18: {
                        log.warn("Could not switch to restored index. Rolling back to the current index", (Throwable)e);
                        Directory dir = null;
                        try {
                            dir = this.core.getDirectoryFactory().get(this.core.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.core.getSolrConfig().indexConfig.lockType);
                            dir.deleteFile("index.properties");
                            if (dir == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (dir != null) {
                                this.core.getDirectoryFactory().release(dir);
                            }
                            throw throwable;
                        }
                        this.core.getDirectoryFactory().release(dir);
                    }
                    this.core.getDirectoryFactory().doneWithDirectory(restoreIndexDir);
                    this.core.getDirectoryFactory().remove(restoreIndexDir);
                    this.core.getUpdateHandler().newIndexWriter(false);
                    this.openNewSearcher();
                    throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Exception while restoring the backup index", (Throwable)e);
                }
                if (success) {
                    this.core.getDirectoryFactory().doneWithDirectory(indexDir);
                    this.core.deleteNonSnapshotIndexFiles(indexDirPath);
                }
                n = 1;
                if (restoreIndexDir == null) break block19;
            }
            catch (Throwable throwable) {
                if (restoreIndexDir != null) {
                    this.core.getDirectoryFactory().release(restoreIndexDir);
                }
                if (indexDir != null) {
                    this.core.getDirectoryFactory().release(indexDir);
                }
                throw throwable;
            }
            this.core.getDirectoryFactory().release(restoreIndexDir);
        }
        if (indexDir != null) {
            this.core.getDirectoryFactory().release(indexDir);
        }
        return n != 0;
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Stopping restore process. Thread was interrupted.");
        }
    }

    private void openNewSearcher() throws Exception {
        Future[] waitSearcher = (Future[])Array.newInstance(Future.class, 1);
        this.core.getSearcher(true, false, waitSearcher, true);
        if (waitSearcher[0] != null) {
            waitSearcher[0].get();
        }
    }

    private static interface RestoreRepository {
        public String[] listAllFiles() throws IOException;

        public IndexInput openInput(String var1) throws IOException;

        public void repoCopy(String var1, Directory var2) throws IOException;

        public void localCopy(Directory var1, String var2, Directory var3) throws IOException;

        public Checksum checksum(String var1) throws IOException;
    }

    private static class BasicRestoreRepository
    implements RestoreRepository {
        protected final URI backupPath;
        protected final BackupRepository repository;

        public BasicRestoreRepository(URI backupPath, BackupRepository repository) {
            this.backupPath = backupPath;
            this.repository = repository;
        }

        @Override
        public String[] listAllFiles() throws IOException {
            return this.repository.listAll(this.backupPath);
        }

        @Override
        public IndexInput openInput(String filename) throws IOException {
            return this.repository.openInput(this.backupPath, filename, IOContext.READONCE);
        }

        @Override
        public void repoCopy(String filename, Directory dest) throws IOException {
            this.repository.copyFileTo(this.backupPath, filename, dest);
        }

        @Override
        public void localCopy(Directory src, String filename, Directory dest) throws IOException {
            dest.copyFrom(src, filename, filename, IOContext.READONCE);
        }

        @Override
        public Checksum checksum(String filename) throws IOException {
            try (IndexInput indexInput = this.repository.openInput(this.backupPath, filename, IOContext.READONCE);){
                long checksum = CodecUtil.retrieveChecksum((IndexInput)indexInput);
                long length = indexInput.length();
                Checksum checksum2 = new Checksum(checksum, length);
                return checksum2;
            }
            return null;
        }
    }

    private static class ShardBackupIdRestoreRepository
    implements RestoreRepository {
        private final ShardBackupMetadata shardBackupMetadata;
        private final URI indexURI;
        protected final URI backupPath;
        protected final BackupRepository repository;

        public ShardBackupIdRestoreRepository(URI backupPath, URI indexURI, BackupRepository repository, ShardBackupMetadata shardBackupMetadata) {
            this.shardBackupMetadata = shardBackupMetadata;
            this.indexURI = indexURI;
            this.backupPath = backupPath;
            this.repository = repository;
        }

        @Override
        public String[] listAllFiles() {
            return this.shardBackupMetadata.listOriginalFileNames().toArray(new String[0]);
        }

        @Override
        public IndexInput openInput(String filename) throws IOException {
            String storedFileName = this.getStoredFilename(filename);
            return this.repository.openInput(this.indexURI, storedFileName, IOContext.READONCE);
        }

        @Override
        public void repoCopy(String filename, Directory dest) throws IOException {
            String storedFileName = this.getStoredFilename(filename);
            this.repository.copyIndexFileTo(this.indexURI, storedFileName, dest, filename);
        }

        @Override
        public void localCopy(Directory src, String filename, Directory dest) throws IOException {
            dest.copyFrom(src, filename, filename, IOContext.READONCE);
        }

        @Override
        public Checksum checksum(String filename) {
            Optional<ShardBackupMetadata.BackedFile> backedFile = this.shardBackupMetadata.getFile(filename);
            return backedFile.map(bf -> bf.fileChecksum).orElse(null);
        }

        private String getStoredFilename(String filename) {
            return this.shardBackupMetadata.getFile((String)filename).get().uniqueFileName;
        }
    }
}

