/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.graph.Traversal;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.DefaultStreamFactory;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.StreamHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private StreamFactory streamFactory = new DefaultStreamFactory();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String coreName;
    private SolrClientCache solrClientCache;

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreContainer();
        this.coreName = core.getName();
        this.solrClientCache = coreContainer.getSolrClientCache();
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
        }
        StreamHandler.addExpressiblePlugins(this.streamFactory, core);
        Object functionMappingsObj = this.initArgs.get("streamFunctions");
        if (null != functionMappingsObj) {
            log.warn("solrconfig.xml: <streamFunctions> is deprecated for adding additional streaming functions to GraphHandler.");
            NamedList functionMappings = (NamedList)functionMappingsObj;
            for (Map.Entry functionMapping : functionMappings) {
                String key = (String)functionMapping.getKey();
                PluginInfo pluginInfo = new PluginInfo(key, Collections.singletonMap("class", functionMapping.getValue()));
                if (pluginInfo.pkgName == null) {
                    Class<Expressible> clazz = core.getResourceLoader().findClass((String)functionMapping.getValue(), Expressible.class);
                    this.streamFactory.withFunctionName(key, clazz);
                    continue;
                }
                StreamHandler.ExpressibleHolder holder = new StreamHandler.ExpressibleHolder(pluginInfo, core, SolrConfig.classVsSolrPluginInfo.get(Expressible.class.getName()));
                this.streamFactory.withFunctionName(key, (Supplier)holder);
            }
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        TupleStream tupleStream = null;
        try {
            tupleStream = this.streamFactory.constructStream(params.get("expr"));
        }
        catch (Exception e) {
            log.error("Exception constructing stream", (Throwable)e);
            Map<Object, Object> requestContext = req.getContext();
            requestContext.put("stream", (Object)new DummyErrorStream(e));
            return;
        }
        StreamContext context = new StreamContext();
        context.setSolrClientCache(this.solrClientCache);
        context.put("core", (Object)this.coreName);
        Traversal traversal = new Traversal();
        context.put("traversal", (Object)traversal);
        tupleStream.setStreamContext(context);
        Map<Object, Object> requestContext = req.getContext();
        requestContext.put("stream", (Object)new TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        requestContext.put("traversal", traversal);
    }

    @Override
    public String getDescription() {
        return "GraphHandler";
    }

    public String getSource() {
        return null;
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    public static class DummyErrorStream
    extends TupleStream {
        private Exception e;

        public DummyErrorStream(Exception e) {
            this.e = e;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public Exception getException() {
            return this.e;
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return null;
        }

        public Tuple read() {
            return Tuple.EXCEPTION((String)this.e.getMessage(), (boolean)true);
        }
    }

    public static class TimerStream
    extends TupleStream {
        private long begin;
        private TupleStream tupleStream;

        public TimerStream(TupleStream tupleStream) {
            this.tupleStream = tupleStream;
        }

        public StreamComparator getStreamSort() {
            return this.tupleStream.getStreamSort();
        }

        public void close() throws IOException {
            this.tupleStream.close();
        }

        public void open() throws IOException {
            this.begin = System.nanoTime();
            this.tupleStream.open();
        }

        public void setStreamContext(StreamContext context) {
            this.tupleStream.setStreamContext(context);
        }

        public List<TupleStream> children() {
            return this.tupleStream.children();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return null;
        }

        public Tuple read() throws IOException {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                long totalTime = (System.nanoTime() - this.begin) / 1000000L;
                tuple.put("RESPONSE_TIME", (Object)totalTime);
            }
            return tuple;
        }
    }
}

