/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientCloudManager;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerElectionContext;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.cloud.RecoveringCoreTermWatcher;
import org.apache.solr.cloud.ReplicateFromLeader;
import org.apache.solr.cloud.ShardLeaderElectionContext;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.ZkCollectionTerms;
import org.apache.solr.cloud.ZkDistributedQueue;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DefaultZkACLProvider;
import org.apache.solr.common.cloud.DefaultZkCredentialsInjector;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocCollectionWatcher;
import org.apache.solr.common.cloud.LiveNodesListener;
import org.apache.solr.common.cloud.NodesSysPropsCacher;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SecurityAwareZkACLProvider;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkCredentialsInjector;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.ZLibCompressor;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCoreInitializationException;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.AddressUtils;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkController
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int WAIT_DOWN_STATES_TIMEOUT_SECONDS = 60;
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final ZkDistributedQueue overseerJobQueue;
    private final OverseerTaskQueue overseerCollectionQueue;
    private final OverseerTaskQueue overseerConfigSetQueue;
    private final DistributedMap overseerRunningMap;
    private final DistributedMap overseerCompletedMap;
    private final DistributedMap overseerFailureMap;
    private final DistributedMap asyncIdsMap;
    public static final String COLLECTION_PARAM_PREFIX = "collection.";
    public static final String CONFIGNAME_PROP = "configName";
    public static final byte[] TOUCHED_ZNODE_DATA = "{}".getBytes(StandardCharsets.UTF_8);
    private final Map<ContextKey, ElectionContext> electionContexts = Collections.synchronizedMap(new HashMap());
    private final SolrZkClient zkClient;
    public final ZkStateReader zkStateReader;
    private SolrCloudManager cloudManager;
    private CloudLegacySolrClient cloudSolrClient;
    private final String zkServerAddress;
    private final int localHostPort;
    private final String hostName;
    private final String nodeName;
    private String baseURL;
    private final CloudConfig cloudConfig;
    private final NodesSysPropsCacher sysPropsCacher;
    private final DistributedClusterStateUpdater distributedClusterStateUpdater;
    private LeaderElector overseerElector;
    private Map<String, ReplicateFromLeader> replicateFromLeaders = new ConcurrentHashMap<String, ReplicateFromLeader>();
    private final Map<String, ZkCollectionTerms> collectionToTerms = new HashMap<String, ZkCollectionTerms>();
    private CoreContainer cc;
    protected volatile Overseer overseer;
    private int leaderVoteWait;
    private int leaderConflictResolveWait;
    private boolean genericCoreNodeNames;
    private volatile boolean isClosed;
    private final ConcurrentHashMap<String, Throwable> replicasMetTragicEvent = new ConcurrentHashMap();
    @Deprecated
    private final Map<String, String> replicasInLeaderInitiatedRecovery = new HashMap<String, String>();
    private boolean zkRunOnly = Boolean.getBoolean("zkRunOnly");
    private HashSet<OnReconnect> reconnectListeners = new HashSet();
    private final Map<String, Set<Runnable>> confDirectoryListeners = new HashMap<String, Set<Runnable>>();

    public ZkController(CoreContainer cc, String zkServerAddress, int zkClientConnectTimeout, CloudConfig cloudConfig, Supplier<List<CoreDescriptor>> descriptorsSupplier) throws InterruptedException, TimeoutException, IOException {
        if (cc == null) {
            throw new IllegalArgumentException("CoreContainer cannot be null.");
        }
        this.cc = cc;
        this.cloudConfig = cloudConfig;
        this.distributedClusterStateUpdater = new DistributedClusterStateUpdater(cloudConfig.getDistributedClusterStateUpdates());
        this.genericCoreNodeNames = cloudConfig.getGenericCoreNodeNames();
        String localHostContext = ZkController.trimLeadingAndTrailingSlashes(cloudConfig.getSolrHostContext());
        this.zkServerAddress = zkServerAddress;
        this.localHostPort = cloudConfig.getSolrHostPort();
        this.hostName = this.normalizeHostName(cloudConfig.getHost());
        this.nodeName = ZkController.generateNodeName(this.hostName, Integer.toString(this.localHostPort), localHostContext);
        MDCLoggingContext.setNode(this.nodeName);
        this.leaderVoteWait = cloudConfig.getLeaderVoteWait();
        this.leaderConflictResolveWait = cloudConfig.getLeaderConflictResolveWait();
        int clientTimeout = cloudConfig.getZkClientTimeout();
        String connectionStrategy = System.getProperty("solr.zookeeper.connectionStrategy");
        ZkClientConnectionStrategy strat = ZkClientConnectionStrategy.forName((String)connectionStrategy, (ZkClientConnectionStrategy)new DefaultConnectionStrategy());
        String zkCredentialsInjectorClass = cloudConfig.getZkCredentialsInjectorClass();
        DefaultZkCredentialsInjector zkCredentialsInjector = StrUtils.isNullOrEmpty((String)zkCredentialsInjectorClass) ? new DefaultZkCredentialsInjector() : cc.getResourceLoader().newInstance(zkCredentialsInjectorClass, ZkCredentialsInjector.class);
        String zkACLProviderClass = cloudConfig.getZkACLProviderClass();
        DefaultZkACLProvider zkACLProvider = StrUtils.isNullOrEmpty((String)zkACLProviderClass) ? new DefaultZkACLProvider() : cc.getResourceLoader().newInstance(zkACLProviderClass, ZkACLProvider.class);
        zkACLProvider.setZkCredentialsInjector((ZkCredentialsInjector)zkCredentialsInjector);
        String zkCredentialsProviderClass = cloudConfig.getZkCredentialsProviderClass();
        DefaultZkCredentialsProvider zkCredentialsProvider = StrUtils.isNullOrEmpty((String)zkCredentialsProviderClass) ? new DefaultZkCredentialsProvider() : cc.getResourceLoader().newInstance(zkCredentialsProviderClass, ZkCredentialsProvider.class);
        zkCredentialsProvider.setZkCredentialsInjector((ZkCredentialsInjector)zkCredentialsInjector);
        strat.setZkCredentialsToAddAutomatically((ZkCredentialsProvider)zkCredentialsProvider);
        this.addOnReconnectListener(this.getConfigDirListener());
        String stateCompressionProviderClass = cloudConfig.getStateCompressorClass();
        ZLibCompressor compressor = StrUtils.isNullOrEmpty((String)stateCompressionProviderClass) ? new ZLibCompressor() : cc.getResourceLoader().newInstance(stateCompressionProviderClass, Compressor.class);
        this.zkClient = new SolrZkClient.Builder().withUrl(zkServerAddress).withTimeout(clientTimeout, TimeUnit.MILLISECONDS).withConnTimeOut(zkClientConnectTimeout, TimeUnit.MILLISECONDS).withConnStrategy(strat).withReconnectListener(() -> this.onReconnect(descriptorsSupplier)).withBeforeConnect(() -> this.beforeReconnect(descriptorsSupplier)).withAclProvider((ZkACLProvider)zkACLProvider).withClosedCheck(cc::isShutDown).withCompressor((Compressor)compressor).build();
        this.checkNoOldClusterstate(this.zkClient);
        this.overseerRunningMap = Overseer.getRunningMap(this.zkClient);
        this.overseerCompletedMap = Overseer.getCompletedMap(this.zkClient);
        this.overseerFailureMap = Overseer.getFailureMap(this.zkClient);
        this.asyncIdsMap = Overseer.getAsyncIdsMap(this.zkClient);
        this.zkStateReader = new ZkStateReader(this.zkClient, () -> {
            if (cc != null) {
                cc.securityNodeChanged();
            }
        });
        this.init();
        this.overseerJobQueue = this.distributedClusterStateUpdater.isDistributedStateUpdate() ? null : this.overseer.getStateUpdateQueue();
        this.overseerCollectionQueue = this.overseer.getCollectionQueue(this.zkClient);
        this.overseerConfigSetQueue = this.overseer.getConfigSetQueue(this.zkClient);
        this.sysPropsCacher = new NodesSysPropsCacher(((HttpShardHandlerFactory)this.getCoreContainer().getShardHandlerFactory()).getClient(), this.zkStateReader);
        assert (ObjectReleaseTracker.track((Object)this));
    }

    private void beforeReconnect(Supplier<List<CoreDescriptor>> descriptorsSupplier) {
        try {
            this.overseer.close();
        }
        catch (Exception e) {
            log.error("Error trying to stop any Overseer threads", (Throwable)e);
        }
        this.closeOutstandingElections(descriptorsSupplier);
        this.markAllAsNotLeader(descriptorsSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReconnect(Supplier<List<CoreDescriptor>> descriptorsSupplier) throws KeeperException.SessionExpiredException {
        log.info("ZooKeeper session re-connected ... refreshing core states after session expiration.");
        this.clearZkCollectionTerms();
        try {
            HashSet<OnReconnect> clonedListeners;
            ExecutorService executorService;
            this.zkStateReader.createClusterStateWatchersAndUpdate();
            if (!this.zkRunOnly) {
                OverseerElectionContext context = new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName());
                ElectionContext prevContext = this.overseerElector.getContext();
                if (prevContext != null) {
                    prevContext.cancelElection();
                    prevContext.close();
                }
                this.overseerElector.setup(context);
                if (this.cc.nodeRoles.isOverseerAllowedOrPreferred()) {
                    this.overseerElector.joinElection(context, true);
                }
            }
            this.cc.cancelCoreRecoveries();
            try {
                this.registerAllCoresAsDown(descriptorsSupplier, false);
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn("Exception while trying to register all cores as DOWN", (Throwable)e);
            }
            this.createEphemeralLiveNode();
            List<CoreDescriptor> descriptors = descriptorsSupplier.get();
            ExecutorService executorService2 = executorService = this.cc != null ? this.cc.getCoreZkRegisterExecutorService() : null;
            if (descriptors != null) {
                for (CoreDescriptor descriptor : descriptors) {
                    try {
                        this.throwErrorIfReplicaReplaced(descriptor);
                        if (executorService != null) {
                            executorService.submit(new RegisterCoreAsync(descriptor, true, true));
                            continue;
                        }
                        this.register(descriptor.getName(), descriptor, true, true, false);
                    }
                    catch (Exception e) {
                        log.error("Error registering SolrCore", (Throwable)e);
                    }
                }
            }
            HashSet<OnReconnect> hashSet = this.reconnectListeners;
            synchronized (hashSet) {
                clonedListeners = new HashSet<OnReconnect>(this.reconnectListeners);
            }
            for (OnReconnect listener : clonedListeners) {
                try {
                    if (executorService != null) {
                        executorService.submit(new OnReconnectNotifyAsync(listener));
                        continue;
                    }
                    listener.command();
                }
                catch (Exception exc) {
                    log.warn("Error when notifying OnReconnect listener {} after session re-connected.", (Object)listener, (Object)exc);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException.SessionExpiredException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Exception during reconnect", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    private void checkNoOldClusterstate(SolrZkClient zkClient) throws InterruptedException {
        try {
            if (!zkClient.exists("/clusterstate.json", true).booleanValue()) {
                return;
            }
            byte[] data = zkClient.getData("/clusterstate.json", null, null, true);
            if (!Arrays.equals("{}".getBytes(StandardCharsets.UTF_8), data)) {
                String message = "/clusterstate.json no longer supported starting with Solr 9. It is present and not empty. Cannot start Solr. Please first migrate collections to stateFormat=2 using an older version of Solr or if you don't care about the data then delete the file from Zookeeper using a command line tool, for example: bin/solr zk rm /clusterstate.json -z host:port";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, message);
            }
            log.warn("{} no longer supported starting with Solr 9. Found empty file on Zookeeper, deleting it.", (Object)"/clusterstate.json");
            zkClient.delete("/clusterstate.json", -1, true);
        }
        catch (KeeperException.NoNodeException e) {
            log.debug("NoNodeException attempting to delete {}. Another instance must have deleted it already", (Object)"/clusterstate.json", (Object)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    public int getLeaderVoteWait() {
        return this.leaderVoteWait;
    }

    public int getLeaderConflictResolveWait() {
        return this.leaderConflictResolveWait;
    }

    private void registerAllCoresAsDown(Supplier<List<CoreDescriptor>> registerOnReconnect, boolean updateLastPublished) throws KeeperException.SessionExpiredException {
        List<CoreDescriptor> descriptors = registerOnReconnect.get();
        if (this.isClosed) {
            return;
        }
        if (descriptors != null) {
            this.publishNodeAsDown(this.getNodeName());
            for (CoreDescriptor descriptor : descriptors) {
                CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
                String collection = cloudDesc.getCollectionName();
                String slice = cloudDesc.getShardId();
                try {
                    int children = this.zkStateReader.getZkClient().getChildren("/collections/" + collection + "/leader_elect/" + slice + "/election", null, true).size();
                    if (children == 0) {
                        log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                        continue;
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException.SessionExpiredException e) {
                    throw e;
                }
                catch (KeeperException e) {
                    log.warn("", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                String coreZkNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
                try {
                    log.debug("calling waitForLeaderToSeeDownState for coreZkNodeName={} collection={} shard={}", new Object[]{coreZkNodeName, collection, slice});
                    this.waitForLeaderToSeeDownState(descriptor, coreZkNodeName);
                }
                catch (Exception e) {
                    log.warn("There was a problem while making a best effort to ensure the leader has seen us as down, this is not unexpected as Zookeeper has just reconnected after a session expiration", (Throwable)e);
                    if (!this.isClosed) continue;
                    return;
                }
            }
        }
    }

    public NodesSysPropsCacher getSysPropsCacher() {
        return this.sysPropsCacher;
    }

    private void closeOutstandingElections(Supplier<List<CoreDescriptor>> registerOnReconnect) {
        List<CoreDescriptor> descriptors = registerOnReconnect.get();
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                this.closeExistingElectionContext(descriptor);
            }
        }
    }

    private ContextKey closeExistingElectionContext(CoreDescriptor cd) {
        String coreNodeName;
        String collection = cd.getCloudDescriptor().getCollectionName();
        ContextKey contextKey = new ContextKey(collection, coreNodeName = cd.getCloudDescriptor().getCoreNodeName());
        ElectionContext prevContext = this.electionContexts.get(contextKey);
        if (prevContext != null) {
            prevContext.close();
            this.electionContexts.remove(contextKey);
        }
        return contextKey;
    }

    private void markAllAsNotLeader(Supplier<List<CoreDescriptor>> registerOnReconnect) {
        List<CoreDescriptor> descriptors = registerOnReconnect.get();
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                descriptor.getCloudDescriptor().setLeader(false);
                descriptor.getCloudDescriptor().setHasRegistered(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preClose() {
        this.isClosed = true;
        try {
            this.removeEphemeralLiveNode();
        }
        catch (AlreadyClosedException | KeeperException.ConnectionLossException | KeeperException.SessionExpiredException throwable) {
        }
        catch (Exception e) {
            log.warn("Error removing live node. Continuing to close CoreContainer", (Throwable)e);
        }
        try {
            if (this.getZkClient().getConnectionManager().isConnected()) {
                log.info("Publish this node as DOWN...");
                this.publishNodeAsDown(this.getNodeName());
            }
        }
        catch (Exception e) {
            log.warn("Error publishing nodes as down. Continuing to close CoreContainer", (Throwable)e);
        }
        ExecutorService customThreadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("preCloseThreadPool"));
        try {
            Map<String, ZkCollectionTerms> map = this.collectionToTerms;
            synchronized (map) {
                customThreadPool.submit(() -> this.collectionToTerms.values().parallelStream().forEach(ZkCollectionTerms::close));
            }
            customThreadPool.submit(() -> this.replicateFromLeaders.values().parallelStream().forEach(ReplicateFromLeader::stopReplication));
        }
        finally {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)customThreadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        if (!this.isClosed) {
            this.preClose();
        }
        ExecutorService customThreadPool = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrNamedThreadFactory("closeThreadPool"));
        customThreadPool.submit(() -> IOUtils.closeQuietly((Closeable)this.overseerElector.getContext()));
        customThreadPool.submit(() -> IOUtils.closeQuietly((Closeable)((Object)this.overseer)));
        try {
            customThreadPool.submit(() -> {
                Collection<ElectionContext> values = this.electionContexts.values();
                Map<ContextKey, ElectionContext> map = this.electionContexts;
                synchronized (map) {
                    values.forEach(IOUtils::closeQuietly);
                }
            });
        }
        finally {
            this.sysPropsCacher.close();
            customThreadPool.submit(() -> IOUtils.closeQuietly((Closeable)this.cloudSolrClient));
            customThreadPool.submit(() -> IOUtils.closeQuietly((Closeable)this.cloudManager));
            try {
                try {
                    this.zkStateReader.close();
                }
                catch (Exception e) {
                    log.error("Error closing zkStateReader", (Throwable)e);
                }
            }
            finally {
                try {
                    this.zkClient.close();
                }
                catch (Exception e) {
                    log.error("Error closing zkClient", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)((Object)this.overseer));
                    ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)customThreadPool);
                }
            }
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public void giveupLeadership(CoreDescriptor cd) {
        assert (cd != null);
        String collection = cd.getCollectionName();
        if (collection == null) {
            return;
        }
        DocCollection dc = this.getClusterState().getCollectionOrNull(collection);
        if (dc == null) {
            return;
        }
        Slice shard = dc.getSlice(cd.getCloudDescriptor().getShardId());
        if (shard == null) {
            return;
        }
        String leader = cd.getCloudDescriptor().getCoreNodeName();
        if (!Objects.equals(shard.getReplica(leader), shard.getLeader())) {
            return;
        }
        Set liveNodes = this.getClusterState().getLiveNodes();
        int numActiveReplicas = shard.getReplicas(rep -> rep.getState() == Replica.State.ACTIVE && rep.getType() != Replica.Type.PULL && liveNodes.contains(rep.getNodeName())).size();
        if (numActiveReplicas >= 2) {
            ContextKey key = new ContextKey(collection, leader);
            ElectionContext context = this.electionContexts.get(key);
            if (context instanceof ShardLeaderElectionContextBase) {
                LeaderElector elector = ((ShardLeaderElectionContextBase)context).getLeaderElector();
                try {
                    log.warn("Leader {} met tragic exception, give up its leadership", (Object)key);
                    elector.retryElection(context, false);
                }
                catch (IOException | InterruptedException | KeeperException e) {
                    SolrZkClient.checkInterrupted((Throwable)e);
                    log.error("Met exception on give up leadership for {}", (Object)key, (Object)e);
                }
            } else {
                log.warn("Could not get election context {} to give up leadership", (Object)key);
            }
        }
    }

    public ClusterState getClusterState() {
        return this.zkStateReader.getClusterState();
    }

    public DistributedClusterStateUpdater getDistributedClusterStateUpdater() {
        return this.distributedClusterStateUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCloudManager getSolrCloudManager() {
        if (this.cloudManager != null) {
            return this.cloudManager;
        }
        ZkController zkController = this;
        synchronized (zkController) {
            if (this.cloudManager != null) {
                return this.cloudManager;
            }
            this.cloudSolrClient = ((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)((CloudLegacySolrClient.Builder)new CloudLegacySolrClient.Builder((ClusterStateProvider)new ZkClientClusterStateProvider(this.zkStateReader)).withHttpClient(this.cc.getUpdateShardHandler().getDefaultHttpClient())).withConnectionTimeout(15000, TimeUnit.MILLISECONDS)).withSocketTimeout(30000, TimeUnit.MILLISECONDS)).build();
            this.cloudManager = new SolrClientCloudManager(this.cloudSolrClient, this.cc.getObjectCache());
            this.cloudManager.getClusterStateProvider().connect();
        }
        return this.cloudManager;
    }

    private String normalizeHostName(String host) {
        if (host == null || host.length() == 0) {
            host = AddressUtils.getHostToAdvertise();
        } else if (URLUtil.hasScheme((String)host)) {
            host = URLUtil.removeScheme((String)host);
        }
        return host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getHostPort() {
        return this.localHostPort;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public static void createClusterZkNodes(SolrZkClient zkClient) throws KeeperException, InterruptedException, IOException {
        ZkMaintenanceUtils.ensureExists((String)"/live_nodes", (SolrZkClient)zkClient);
        ZkMaintenanceUtils.ensureExists((String)"/node_roles", (SolrZkClient)zkClient);
        for (NodeRoles.Role role : NodeRoles.Role.values()) {
            ZkMaintenanceUtils.ensureExists((String)NodeRoles.getZNodeForRole(role), (SolrZkClient)zkClient);
            for (String mode : role.supportedModes()) {
                ZkMaintenanceUtils.ensureExists((String)NodeRoles.getZNodeForRoleMode(role, mode), (SolrZkClient)zkClient);
            }
        }
        ZkMaintenanceUtils.ensureExists((String)"/collections", (SolrZkClient)zkClient);
        ZkMaintenanceUtils.ensureExists((String)"/aliases.json", (SolrZkClient)zkClient);
        byte[] emptyJson = "{}".getBytes(StandardCharsets.UTF_8);
        ZkMaintenanceUtils.ensureExists((String)"/security.json", (byte[])emptyJson, (SolrZkClient)zkClient);
        ZkController.repairSecurityJson(zkClient);
    }

    private static void repairSecurityJson(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        HashSet nonSecureACL;
        List securityConfAcl = zkClient.getACL("/security.json", null, true);
        ZkACLProvider aclProvider = zkClient.getZkACLProvider();
        boolean tryUpdate = false;
        if (ZooDefs.Ids.OPEN_ACL_UNSAFE.equals(securityConfAcl)) {
            List aclToAdd = aclProvider.getACLsToAdd("/security.json");
            if (ZooDefs.Ids.OPEN_ACL_UNSAFE.equals(aclToAdd)) {
                log.warn("Contents of zookeeper /security.json are world-readable; consider setting up ACLs as described in https://solr.apache.org/guide/solr/latest/deployment-guide/zookeeper-access-control.html");
            } else {
                tryUpdate = true;
            }
        } else if (aclProvider instanceof SecurityAwareZkACLProvider && (nonSecureACL = new HashSet(aclProvider.getACLsToAdd(null))).equals(new HashSet(securityConfAcl))) {
            tryUpdate = true;
        }
        if (tryUpdate) {
            if (Boolean.getBoolean("solr.security.aclautorepair.disable")) {
                log.warn("Detected inconsistent ACLs for zookeeper /security.json, but self-repair is disabled.");
            } else {
                log.info("Detected inconsistent ACLs for zookeeper /security.json, attempting to repair.");
                zkClient.updateACLs("/security.json");
            }
        }
    }

    private void init() {
        try {
            Stat stat;
            ZkController.createClusterZkNodes(this.zkClient);
            this.zkStateReader.createClusterStateWatchersAndUpdate();
            String urlSchemeFromClusterProp = (String)this.zkStateReader.getClusterProperty("urlScheme", (Object)"http");
            this.baseURL = Utils.getBaseUrlForNodeName((String)this.nodeName, (String)urlSchemeFromClusterProp);
            this.checkForExistingEphemeralNode();
            this.registerLiveNodesListener();
            if (!this.zkRunOnly) {
                this.overseerElector = new LeaderElector(this.zkClient);
                this.overseer = new Overseer((HttpShardHandler)this.cc.getShardHandlerFactory().getShardHandler(), this.cc.getUpdateShardHandler(), "/admin/cores", this.zkStateReader, this, this.cloudConfig);
                OverseerElectionContext context = new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName());
                this.overseerElector.setup(context);
                if (this.cc.nodeRoles.isOverseerAllowedOrPreferred()) {
                    this.overseerElector.joinElection(context, false);
                }
            }
            if ((stat = this.zkClient.exists("/live_nodes", null, true)) != null && stat.getNumChildren() > 0) {
                this.publishAndWaitForDownStates();
            }
            this.createEphemeralLiveNode();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't create ZooKeeperController", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    private void checkForExistingEphemeralNode() throws KeeperException, InterruptedException {
        if (this.zkRunOnly) {
            return;
        }
        String nodeName = this.getNodeName();
        String nodePath = "/live_nodes/" + nodeName;
        if (!this.zkClient.exists(nodePath, true).booleanValue()) {
            return;
        }
        CountDownLatch deletedLatch = new CountDownLatch(1);
        Stat stat = this.zkClient.exists(nodePath, event -> {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (Watcher.Event.EventType.NodeDeleted.equals((Object)event.getType())) {
                deletedLatch.countDown();
            }
        }, true);
        if (stat == null) {
            return;
        }
        boolean deleted = deletedLatch.await((long)this.zkClient.getZooKeeper().getSessionTimeout() * 2L, TimeUnit.MILLISECONDS);
        if (!deleted) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A previous ephemeral live node still exists. Solr cannot continue. Please ensure that no other Solr process using the same port is running already.");
        }
    }

    private void registerLiveNodesListener() {
        LiveNodesListener listener = (oldNodes, newNodes) -> {
            String n;
            oldNodes.removeAll(newNodes);
            if (oldNodes.isEmpty()) {
                return false;
            }
            if (this.isClosed) {
                return true;
            }
            int i = 0;
            Iterator iterator = newNodes.iterator();
            while (iterator.hasNext() && !(n = (String)iterator.next()).equals(this.getNodeName())) {
                if (i > 2) {
                    return false;
                }
                ++i;
            }
            return false;
        };
        this.zkStateReader.registerLiveNodesListener(listener);
    }

    public void publishAndWaitForDownStates() throws KeeperException, InterruptedException {
        this.publishAndWaitForDownStates(60);
    }

    public void publishAndWaitForDownStates(int timeoutSeconds) throws InterruptedException {
        String nodeName = this.getNodeName();
        Collection<String> collectionsWithLocalReplica = this.publishNodeAsDown(nodeName);
        ConcurrentHashMap collectionsAlreadyVerified = new ConcurrentHashMap(collectionsWithLocalReplica.size());
        CountDownLatch latch = new CountDownLatch(collectionsWithLocalReplica.size());
        for (String collectionWithLocalReplica : collectionsWithLocalReplica) {
            this.zkStateReader.registerDocCollectionWatcher(collectionWithLocalReplica, collectionState -> {
                if (collectionState == null) {
                    return false;
                }
                boolean allStatesCorrect = Optional.ofNullable(collectionState.getReplicas(nodeName)).stream().flatMap(Collection::stream).allMatch(replica -> replica.getState() == Replica.State.DOWN);
                if (allStatesCorrect && collectionsAlreadyVerified.putIfAbsent(collectionWithLocalReplica, true) == null) {
                    latch.countDown();
                }
                return allStatesCorrect;
            });
        }
        boolean allPublishedDown = latch.await(timeoutSeconds, TimeUnit.SECONDS);
        if (!allPublishedDown) {
            log.warn("Timed out waiting to see all nodes published as DOWN in our cluster state.");
        }
    }

    public static boolean checkChrootPath(String zkHost, boolean create) throws KeeperException, InterruptedException {
        if (!SolrZkClient.containsChroot((String)zkHost)) {
            return true;
        }
        log.trace("zkHost includes chroot");
        String chrootPath = zkHost.substring(zkHost.indexOf(47), zkHost.length());
        SolrZkClient tmpClient = new SolrZkClient.Builder().withUrl(zkHost.substring(0, zkHost.indexOf(47))).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).withConnTimeOut(SolrZkClientTimeout.DEFAULT_ZK_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS).build();
        boolean exists = tmpClient.exists(chrootPath, true);
        if (!exists && create) {
            log.info("creating chroot {}", (Object)chrootPath);
            tmpClient.makePath(chrootPath, false, true);
            exists = true;
        }
        tmpClient.close();
        return exists;
    }

    public boolean isConnected() {
        return this.zkClient.isConnected();
    }

    private void createEphemeralLiveNode() throws KeeperException, InterruptedException {
        if (this.zkRunOnly) {
            return;
        }
        String nodeName = this.getNodeName();
        String nodePath = "/live_nodes/" + nodeName;
        log.info("Register node as live in ZooKeeper:{}", (Object)nodePath);
        Map<NodeRoles.Role, String> roles = this.cc.nodeRoles.getRoles();
        ArrayList<Op> ops = new ArrayList<Op>(roles.size() + 1);
        ops.add(Op.create((String)nodePath, null, (List)this.zkClient.getZkACLProvider().getACLsToAdd(nodePath), (CreateMode)CreateMode.EPHEMERAL));
        roles.forEach((role, mode) -> ops.add(Op.create((String)(NodeRoles.getZNodeForRoleMode(role, mode) + "/" + nodeName), null, (List)this.zkClient.getZkACLProvider().getACLsToAdd(nodePath), (CreateMode)CreateMode.EPHEMERAL)));
        this.zkClient.multi(ops, true);
    }

    public void removeEphemeralLiveNode() throws KeeperException, InterruptedException {
        if (this.zkRunOnly) {
            return;
        }
        String nodeName = this.getNodeName();
        String nodePath = "/live_nodes/" + nodeName;
        log.info("Remove node as live in ZooKeeper:{}", (Object)nodePath);
        List<Op> ops = List.of(Op.delete((String)nodePath, (int)-1));
        try {
            this.zkClient.multi(ops, true);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean pathExists(String path) throws KeeperException, InterruptedException {
        return this.zkClient.exists(path, true);
    }

    public String register(String coreName, CoreDescriptor desc, boolean skipRecovery) throws Exception {
        return this.register(coreName, desc, false, false, skipRecovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String register(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean afterExpiration, boolean skipRecovery) throws Exception {
        MDCLoggingContext.setCoreDescriptor(this.cc, desc);
        try {
            String baseUrl = this.getBaseUrl();
            CloudDescriptor cloudDesc = desc.getCloudDescriptor();
            String collection = cloudDesc.getCollectionName();
            String shardId = cloudDesc.getShardId();
            String coreZkNodeName = cloudDesc.getCoreNodeName();
            assert (coreZkNodeName != null) : "we should have a coreNodeName by now";
            try {
                this.zkStateReader.waitForState(collection, 100L, TimeUnit.MILLISECONDS, collectionState -> this.getReplicaOrNull((DocCollection)collectionState, shardId, coreZkNodeName) != null);
            }
            catch (TimeoutException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error registering SolrCore, timeout waiting for replica present in clusterstate");
            }
            Replica replica = this.getReplicaOrNull(this.zkStateReader.getClusterState().getCollectionOrNull(collection), shardId, coreZkNodeName);
            if (replica == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error registering SolrCore, replica is removed from clusterstate");
            }
            if (replica.getType() != Replica.Type.PULL) {
                this.getCollectionTerms(collection).register(cloudDesc.getShardId(), coreZkNodeName);
            }
            ZkShardTerms shardTerms = this.getShardTerms(collection, cloudDesc.getShardId());
            log.debug("Register replica - core:{} address:{} collection:{} shard:{}", new Object[]{coreName, baseUrl, collection, shardId});
            try {
                boolean joinAtHead = replica.getBool("property.preferredleader", false);
                if (replica.getType() != Replica.Type.PULL) {
                    this.joinElection(desc, afterExpiration, joinAtHead);
                } else if (replica.getType() == Replica.Type.PULL) {
                    if (joinAtHead) {
                        log.warn("Replica {} was designated as preferred leader but it's type is {}, It won't join election", (Object)coreZkNodeName, (Object)Replica.Type.PULL);
                    }
                    log.debug("Replica {} skipping election because it's type is {}", (Object)coreZkNodeName, (Object)Replica.Type.PULL);
                    this.startReplicationFromLeader(coreName, false);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (IOException | KeeperException e) {
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
            }
            String leaderUrl = this.getLeader(cloudDesc, this.leaderVoteWait + 600000);
            String ourUrl = ZkCoreNodeProps.getCoreUrl((String)baseUrl, (String)coreName);
            log.debug("We are {} and leader is {}", (Object)ourUrl, (Object)leaderUrl);
            boolean isLeader = leaderUrl.equals(ourUrl);
            assert (!isLeader || replica.getType() != Replica.Type.PULL) : "Pull replica became leader!";
            try (SolrCore core = this.cc.getCore(desc.getName());){
                boolean didRecovery;
                Slice slice;
                String commitVersion;
                boolean isTlogReplicaAndNotLeader;
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCore is no longer available to register");
                }
                UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
                boolean bl = isTlogReplicaAndNotLeader = replica.getType() == Replica.Type.TLOG && !isLeader;
                if (isTlogReplicaAndNotLeader && (commitVersion = ReplicateFromLeader.getCommitVersion(core)) != null) {
                    ulog.copyOverOldUpdates(Long.parseLong(commitVersion));
                }
                if (!(afterExpiration || core.isReloaded() || ulog == null || isTlogReplicaAndNotLeader || (slice = this.getClusterState().getCollection(collection).getSlice(shardId)).getState() == Slice.State.CONSTRUCTION && isLeader)) {
                    Future<UpdateLog.RecoveryInfo> recoveryFuture = core.getUpdateHandler().getUpdateLog().recoverFromLog();
                    if (recoveryFuture != null) {
                        log.info("Replaying tlog for {} during startup... NOTE: This can take a while.", (Object)ourUrl);
                        recoveryFuture.get();
                    } else if (log.isDebugEnabled()) {
                        log.debug("No LogReplay needed for core={} baseURL={}", (Object)core.getName(), (Object)baseUrl);
                    }
                }
                if (!(didRecovery = this.checkRecovery(recoverReloadedCores, isLeader, skipRecovery, collection, coreZkNodeName, shardId, core, this.cc, afterExpiration))) {
                    if (isTlogReplicaAndNotLeader) {
                        this.startReplicationFromLeader(coreName, true);
                    }
                    this.publish(desc, Replica.State.ACTIVE);
                }
                if (replica.getType() != Replica.Type.PULL) {
                    shardTerms.addListener(new RecoveringCoreTermWatcher(core.getCoreDescriptor(), this.getCoreContainer()));
                }
                core.getCoreDescriptor().getCloudDescriptor().setHasRegistered(true);
            }
            catch (Exception e) {
                this.unregister(coreName, desc, false);
                throw e;
            }
            this.zkStateReader.forceUpdateCollection(collection);
            this.zkStateReader.registerDocCollectionWatcher(cloudDesc.getCollectionName(), (DocCollectionWatcher)new UnloadCoreOnDeletedWatcher(coreZkNodeName, shardId, desc.getName()));
            String string = shardId;
            return string;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    private Replica getReplicaOrNull(DocCollection docCollection, String shard, String coreNodeName) {
        if (docCollection == null) {
            return null;
        }
        Slice slice = docCollection.getSlice(shard);
        if (slice == null) {
            return null;
        }
        Replica replica = slice.getReplica(coreNodeName);
        if (replica == null) {
            return null;
        }
        if (!this.getNodeName().equals(replica.getNodeName())) {
            return null;
        }
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplicationFromLeader(String coreName, boolean switchTransactionLog) {
        ReplicateFromLeader replicateFromLeader;
        log.info("{} starting background replication from leader", (Object)coreName);
        ReplicateFromLeader replicateFromLeader2 = replicateFromLeader = new ReplicateFromLeader(this.cc, coreName);
        synchronized (replicateFromLeader2) {
            if (this.replicateFromLeaders.putIfAbsent(coreName, replicateFromLeader) == null) {
                replicateFromLeader.startReplication(switchTransactionLog);
            } else {
                log.warn("A replicate from leader instance already exists for core {}", (Object)coreName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReplicationFromLeader(String coreName) {
        log.info("{} stopping background replication from leader", (Object)coreName);
        ReplicateFromLeader replicateFromLeader = this.replicateFromLeaders.remove(coreName);
        if (replicateFromLeader != null) {
            ReplicateFromLeader replicateFromLeader2 = replicateFromLeader;
            synchronized (replicateFromLeader2) {
                replicateFromLeader.stopReplication();
            }
        }
    }

    private String getLeader(CloudDescriptor cloudDesc, int timeoutms) {
        String leaderUrl;
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        try {
            leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            String clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms * 2);
            int tries = 0;
            int msInSec = 1000;
            int maxTries = this.leaderConflictResolveWait / 1000;
            while (!leaderUrl.equals(clusterStateLeaderUrl)) {
                if (this.cc.isShutDown()) {
                    throw new AlreadyClosedException();
                }
                if (tries > maxTries) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There is conflicting information about the leader of shard: " + cloudDesc.getShardId() + " our state says:" + clusterStateLeaderUrl + " but zookeeper says:" + leaderUrl);
                }
                if (++tries % 30 == 0) {
                    String warnMsg = String.format(Locale.ENGLISH, "Still seeing conflicting information about the leader of shard %s for collection %s after %d seconds; our state says %s, but ZooKeeper says %s", cloudDesc.getShardId(), collection, tries, clusterStateLeaderUrl, leaderUrl);
                    log.warn(warnMsg);
                }
                Thread.sleep(1000L);
                clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms);
                leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            }
        }
        catch (AlreadyClosedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error getting leader from zk", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting leader from zk for shard " + shardId, (Throwable)e);
        }
        return leaderUrl;
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms) throws InterruptedException, KeeperException.SessionExpiredException {
        return this.getLeaderProps(collection, slice, timeoutms, true);
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms, boolean failImmediatelyOnExpiration) throws InterruptedException, KeeperException.SessionExpiredException {
        int iterCount = timeoutms / 1000;
        Throwable exp = null;
        while (iterCount-- > 0) {
            try {
                byte[] data = this.zkClient.getData(ZkStateReader.getShardLeadersPath((String)collection, (String)slice), null, null, true);
                ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(ZkNodeProps.load((byte[])data));
                return leaderProps;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (KeeperException.SessionExpiredException e) {
                if (failImmediatelyOnExpiration) {
                    throw e;
                }
                exp = e;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                exp = e;
                Thread.sleep(1000L);
            }
            if (!this.cc.isShutDown()) continue;
            throw new AlreadyClosedException();
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Could not get leader props", exp);
    }

    private void joinElection(CoreDescriptor cd, boolean afterExpiration, boolean joinAtHead) throws InterruptedException, KeeperException, IOException {
        String coreNodeName;
        String collection = cd.getCloudDescriptor().getCollectionName();
        ContextKey contextKey = new ContextKey(collection, coreNodeName = cd.getCloudDescriptor().getCoreNodeName());
        ElectionContext prevContext = this.electionContexts.get(contextKey);
        if (prevContext != null) {
            prevContext.cancelElection();
        }
        String shardId = cd.getCloudDescriptor().getShardId();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("core", cd.getName());
        props.put("node_name", this.getNodeName());
        props.put("base_url", this.zkStateReader.getBaseUrlForNodeName(this.getNodeName()));
        props.put("core_node_name", coreNodeName);
        ZkNodeProps ourProps = new ZkNodeProps(props);
        LeaderElector leaderElector = new LeaderElector(this.zkClient, contextKey, this.electionContexts);
        ShardLeaderElectionContext context = new ShardLeaderElectionContext(leaderElector, shardId, collection, coreNodeName, ourProps, this, this.cc);
        leaderElector.setup(context);
        this.electionContexts.put(contextKey, context);
        leaderElector.joinElection(context, false, joinAtHead);
    }

    private boolean checkRecovery(boolean recoverReloadedCores, boolean isLeader, boolean skipRecovery, String collection, String coreZkNodeName, String shardId, SolrCore core, CoreContainer cc, boolean afterExpiration) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return false;
        }
        boolean doRecovery = true;
        if (!isLeader) {
            if (skipRecovery || !afterExpiration && core.isReloaded() && !recoverReloadedCores) {
                doRecovery = false;
            }
            if (doRecovery) {
                if (log.isInfoEnabled()) {
                    log.info("Core needs to recover:{}", (Object)core.getName());
                }
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
            ZkShardTerms zkShardTerms = this.getShardTerms(collection, shardId);
            if (zkShardTerms.registered(coreZkNodeName) && !zkShardTerms.canBecomeLeader(coreZkNodeName)) {
                if (log.isInfoEnabled()) {
                    log.info("Leader's term larger than core {}; starting recovery process", (Object)core.getName());
                }
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
        } else {
            log.info("I am the leader, no recovery necessary");
        }
        return false;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public void publish(CoreDescriptor cd, Replica.State state) throws KeeperException, InterruptedException {
        this.publish(cd, state, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(CoreDescriptor cd, Replica.State state, boolean updateLastState, boolean forcePublish) throws KeeperException, InterruptedException {
        if (!forcePublish) {
            try (SolrCore core = this.cc.getCore(cd.getName());){
                if (core == null || core.isClosed()) {
                    return;
                }
            }
        }
        MDCLoggingContext.setCoreDescriptor(this.cc, cd);
        try {
            MapWriter m;
            String coreNodeName;
            String shardId;
            String collection;
            block30: {
                collection = cd.getCloudDescriptor().getCollectionName();
                log.debug("publishing state={}", (Object)state);
                Integer numShards = cd.getCloudDescriptor().getNumShards();
                assert (collection != null && collection.length() > 0);
                shardId = cd.getCloudDescriptor().getShardId();
                coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
                m = props -> {
                    props.put((CharSequence)"operation", (CharSequence)OverseerAction.STATE.toLower());
                    props.put((CharSequence)"state", (CharSequence)state.toString());
                    props.put((CharSequence)"core", (CharSequence)cd.getName());
                    props.put((CharSequence)"roles", (CharSequence)cd.getCloudDescriptor().getRoles());
                    props.put((CharSequence)"node_name", (CharSequence)this.getNodeName());
                    props.put((CharSequence)"base_url", (CharSequence)this.zkStateReader.getBaseUrlForNodeName(this.getNodeName()));
                    props.put((CharSequence)"shard", (CharSequence)cd.getCloudDescriptor().getShardId());
                    props.put((CharSequence)"collection", (CharSequence)collection);
                    props.put((CharSequence)"type", (CharSequence)cd.getCloudDescriptor().getReplicaType().toString());
                    props.put((CharSequence)"force_set_state", (CharSequence)"false");
                    if (numShards != null) {
                        props.put((CharSequence)"numShards", (CharSequence)numShards.toString());
                    }
                    props.putIfNotNull((CharSequence)"core_node_name", (Object)coreNodeName);
                };
                try (SolrCore core = this.cc.getCore(cd.getName());){
                    if (core != null && state == Replica.State.ACTIVE) {
                        ZkController.ensureRegisteredSearcher(core);
                    }
                    if (core != null && core.getDirectoryFactory().isSharedStorage() && core.getDirectoryFactory().isSharedStorage()) {
                        m = m.append(props -> {
                            props.put((CharSequence)"shared_storage", (CharSequence)"true");
                            props.put((CharSequence)"dataDir", (CharSequence)core.getDataDir());
                            UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
                            if (ulog != null) {
                                props.put((CharSequence)"ulogDir", (CharSequence)ulog.getUlogDir());
                            }
                        });
                    }
                }
                catch (SolrCoreInitializationException ex) {
                    if (!log.isInfoEnabled()) break block30;
                    log.info("The core '{}' had failed to initialize before.", (Object)cd.getName());
                }
            }
            if (state == Replica.State.RECOVERING && cd.getCloudDescriptor().getReplicaType() != Replica.Type.PULL) {
                this.getShardTerms(collection, shardId).startRecovering(coreNodeName);
            }
            if (state == Replica.State.ACTIVE && cd.getCloudDescriptor().getReplicaType() != Replica.Type.PULL) {
                this.getShardTerms(collection, shardId).doneRecovering(coreNodeName);
            }
            if (updateLastState) {
                cd.getCloudDescriptor().setLastPublished(state);
            }
            DocCollection coll = this.zkStateReader.getCollection(collection);
            if (forcePublish || ZkController.updateStateDotJson(coll, coreNodeName)) {
                if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
                    this.distributedClusterStateUpdater.doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ReplicaSetState, new ZkNodeProps(m), this.getSolrCloudManager(), this.zkStateReader);
                } else {
                    this.overseerJobQueue.offer(m);
                }
            }
            if (coll != null && coll.isPerReplicaState() && coreNodeName != null) {
                PerReplicaStates perReplicaStates = PerReplicaStatesOps.fetch((String)coll.getZNode(), (SolrZkClient)this.zkClient, (PerReplicaStates)coll.getPerReplicaStates());
                PerReplicaStatesOps.flipState((String)coreNodeName, (Replica.State)state, (PerReplicaStates)perReplicaStates).persist(coll.getZNode(), this.zkClient);
            }
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    static boolean updateStateDotJson(DocCollection coll, String replicaName) {
        if (coll == null) {
            return true;
        }
        if (!coll.isPerReplicaState()) {
            return true;
        }
        Replica r = coll.getReplica(replicaName);
        if (r == null) {
            return true;
        }
        Slice shard = coll.getSlice(r.shard);
        if (shard == null) {
            return true;
        }
        if (shard.getParent() != null) {
            return true;
        }
        for (Slice slice : coll.getSlices()) {
            if (!Objects.equals(shard.getName(), slice.getParent())) continue;
            return true;
        }
        return false;
    }

    public ZkShardTerms getShardTerms(String collection, String shardId) {
        return this.getCollectionTerms(collection).getShard(shardId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZkCollectionTerms getCollectionTerms(String collection) {
        Map<String, ZkCollectionTerms> map = this.collectionToTerms;
        synchronized (map) {
            if (!this.collectionToTerms.containsKey(collection)) {
                this.collectionToTerms.put(collection, new ZkCollectionTerms(collection, this.zkClient));
            }
            return this.collectionToTerms.get(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearZkCollectionTerms() {
        Map<String, ZkCollectionTerms> map = this.collectionToTerms;
        synchronized (map) {
            this.collectionToTerms.values().forEach(ZkCollectionTerms::close);
            this.collectionToTerms.clear();
        }
    }

    public void unregister(String coreName, CoreDescriptor cd) throws Exception {
        this.unregister(coreName, cd, true);
    }

    public void unregister(String coreName, CoreDescriptor cd, boolean removeCoreFromZk) throws Exception {
        ElectionContext context;
        Replica replica;
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        String collection = cd.getCloudDescriptor().getCollectionName();
        this.getCollectionTerms(collection).remove(cd.getCloudDescriptor().getShardId(), cd);
        this.replicasMetTragicEvent.remove(collection + ":" + coreNodeName);
        if (StrUtils.isNullOrEmpty((String)collection)) {
            log.error("No collection was specified.");
            assert (false) : "No collection was specified [" + collection + "]";
            return;
        }
        DocCollection docCollection = this.zkStateReader.getClusterState().getCollectionOrNull(collection);
        Replica replica2 = replica = docCollection == null ? null : docCollection.getReplica(coreNodeName);
        if ((replica == null || replica.getType() != Replica.Type.PULL) && (context = this.electionContexts.remove(new ContextKey(collection, coreNodeName))) != null) {
            context.cancelElection();
        }
        CloudDescriptor cloudDescriptor = cd.getCloudDescriptor();
        if (removeCoreFromZk) {
            if (docCollection != null && docCollection.isPerReplicaState() && coreNodeName != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Unregistering core with coreNodeName {} of collection {} - deleting the PRS entries from ZK", (Object)coreNodeName, (Object)docCollection.getName());
                }
                PerReplicaStates perReplicaStates = PerReplicaStatesOps.fetch((String)docCollection.getZNode(), (SolrZkClient)this.zkClient, (PerReplicaStates)docCollection.getPerReplicaStates());
                PerReplicaStatesOps.deleteReplica((String)coreNodeName, (PerReplicaStates)perReplicaStates).persist(docCollection.getZNode(), this.zkClient);
            }
            MapWriter m = ew -> ew.put((CharSequence)"operation", (CharSequence)OverseerAction.DELETECORE.toLower()).put((CharSequence)"core", (CharSequence)coreName).put((CharSequence)"node_name", (CharSequence)this.getNodeName()).put((CharSequence)"base_url", (CharSequence)this.zkStateReader.getBaseUrlForNodeName(this.getNodeName())).put((CharSequence)"collection", (CharSequence)cloudDescriptor.getCollectionName()).put((CharSequence)"core_node_name", (CharSequence)coreNodeName);
            if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
                this.distributedClusterStateUpdater.doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.SliceRemoveReplica, new ZkNodeProps(m), this.getSolrCloudManager(), this.zkStateReader);
            } else {
                this.overseerJobQueue.offer(m);
            }
        }
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    private void doGetShardIdAndNodeNameProcess(CoreDescriptor cd) {
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName != null) {
            this.waitForShardId(cd);
        } else {
            this.waitForCoreNodeName(cd);
            this.waitForShardId(cd);
        }
    }

    private void waitForCoreNodeName(CoreDescriptor descriptor) {
        log.debug("waitForCoreNodeName >>> look for our core node name");
        try {
            DocCollection collection = this.zkStateReader.waitForState(descriptor.getCollectionName(), 320L, TimeUnit.SECONDS, c -> ClusterStateMutator.getAssignedCoreNodeName(c, this.getNodeName(), descriptor.getName()) != null);
            String name = ClusterStateMutator.getAssignedCoreNodeName(collection, this.getNodeName(), descriptor.getName());
            descriptor.getCloudDescriptor().setCoreNodeName(name);
        }
        catch (InterruptedException | TimeoutException e) {
            SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed waiting for collection state", (Throwable)e);
        }
        this.getCoreContainer().getCoresLocator().persist(this.getCoreContainer(), descriptor);
    }

    private void waitForShardId(CoreDescriptor cd) {
        if (log.isDebugEnabled()) {
            log.debug("waiting to find shard id in clusterstate for {}", (Object)cd.getName());
        }
        try {
            DocCollection collection = this.zkStateReader.waitForState(cd.getCollectionName(), 320L, TimeUnit.SECONDS, c -> c != null && c.getShardId(this.getNodeName(), cd.getName()) != null);
            cd.getCloudDescriptor().setShardId(collection.getShardId(this.getNodeName(), cd.getName()));
        }
        catch (InterruptedException | TimeoutException e) {
            SolrZkClient.checkInterrupted((Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed getting shard id for core: " + cd.getName(), (Throwable)e);
        }
    }

    public String getCoreNodeName(CoreDescriptor descriptor) {
        String coreNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName == null && !this.genericCoreNodeNames) {
            return this.getNodeName() + "_" + descriptor.getName();
        }
        return coreNodeName;
    }

    public void preRegister(CoreDescriptor cd, boolean publishState) {
        String coreNodeName = this.getCoreNodeName(cd);
        try {
            this.checkStateInZk(cd);
            CloudDescriptor cloudDesc = cd.getCloudDescriptor();
            if (cloudDesc.getCoreNodeName() == null) {
                cloudDesc.setCoreNodeName(coreNodeName);
            }
            if (publishState || this.isPublishAsDownOnStartup(cloudDesc)) {
                this.publish(cd, Replica.State.DOWN, false, true);
            }
            String collectionName = cd.getCloudDescriptor().getCollectionName();
            DocCollection collection = this.zkStateReader.getClusterState().getCollectionOrNull(collectionName);
            if (log.isDebugEnabled()) {
                log.debug(collection == null ? "Collection {} not visible yet, but flagging it so a watch is registered when it becomes visible" : "Registering watch for collection {}", (Object)collectionName);
            }
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (NotInClusterStateException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        this.doGetShardIdAndNodeNameProcess(cd);
    }

    private boolean isPublishAsDownOnStartup(CloudDescriptor cloudDesc) {
        Replica replica = this.zkStateReader.getClusterState().getCollection(cloudDesc.getCollectionName()).getSlice(cloudDesc.getShardId()).getReplica(cloudDesc.getCoreNodeName());
        return !replica.getNodeName().equals(this.getNodeName());
    }

    private void checkStateInZk(CoreDescriptor cd) throws InterruptedException, NotInClusterStateException {
        CloudDescriptor cloudDesc = cd.getCloudDescriptor();
        String nodeName = cloudDesc.getCoreNodeName();
        if (nodeName == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No coreNodeName for " + cd);
        }
        String coreNodeName = nodeName;
        if (cloudDesc.getShardId() == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No shard id for " + cd);
        }
        AtomicReference errorMessage = new AtomicReference();
        try {
            this.zkStateReader.waitForState(cd.getCollectionName(), 10L, TimeUnit.SECONDS, c -> {
                if (c == null) {
                    return false;
                }
                Slice slice = c.getSlice(cloudDesc.getShardId());
                if (slice == null) {
                    errorMessage.set("Invalid shard: " + cloudDesc.getShardId());
                    return false;
                }
                Replica replica = slice.getReplica(coreNodeName);
                if (replica == null) {
                    errorMessage.set("coreNodeName " + coreNodeName + " does not exist in shard " + cloudDesc.getShardId() + ", ignore the exception if the replica was deleted");
                    return false;
                }
                return true;
            });
        }
        catch (TimeoutException e) {
            Object error = (String)errorMessage.get();
            if (error == null) {
                error = "coreNodeName " + coreNodeName + " does not exist in shard " + cloudDesc.getShardId() + ", ignore the exception if the replica was deleted";
            }
            throw new NotInClusterStateException(SolrException.ErrorCode.SERVER_ERROR, (String)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCancelAllElections() {
        if (this.zkClient.isClosed()) {
            return;
        }
        Collection<ElectionContext> values = this.electionContexts.values();
        Map<ContextKey, ElectionContext> map = this.electionContexts;
        synchronized (map) {
            values.forEach(context -> {
                try {
                    context.cancelElection();
                    context.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    log.warn("Error on cancelling elections of {}", (Object)context.leaderPath, (Object)e);
                }
            });
        }
    }

    private ZkCoreNodeProps waitForLeaderToSeeDownState(CoreDescriptor descriptor, String coreZkNodeName) throws KeeperException.SessionExpiredException {
        CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shard = cloudDesc.getShardId();
        ZkCoreNodeProps leaderProps = null;
        int retries = 2;
        for (int i = 0; i < retries; ++i) {
            try {
                if (this.isClosed) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                }
                leaderProps = this.getLeaderProps(collection, shard, 5000);
                break;
            }
            catch (KeeperException.SessionExpiredException e) {
                throw e;
            }
            catch (Exception e) {
                log.info("Did not find the leader in Zookeeper", (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (i != retries - 1) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem finding the leader in zk");
            }
        }
        String leaderBaseUrl = leaderProps.getBaseUrl();
        String leaderCoreName = leaderProps.getCoreName();
        String myCoreNodeName = cloudDesc.getCoreNodeName();
        String myCoreName = descriptor.getName();
        String ourUrl = ZkCoreNodeProps.getCoreUrl((String)this.getBaseUrl(), (String)myCoreName);
        boolean isLeader = leaderProps.getCoreUrl().equals(ourUrl);
        if (!isLeader && !this.SKIP_AUTO_RECOVERY) {
            if (!this.getShardTerms(collection, shard).canBecomeLeader(myCoreNodeName)) {
                log.debug("Term of replica {} is already less than leader, so not waiting for leader to see down state.", (Object)myCoreNodeName);
            } else {
                if (log.isInfoEnabled()) {
                    log.info("replica={} is making a best effort attempt to wait for leader={} to see it's DOWN state.", (Object)myCoreNodeName, (Object)leaderProps.getCoreUrl());
                }
                try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(leaderBaseUrl).withConnectionTimeout(8000, TimeUnit.MILLISECONDS)).withSocketTimeout(30000, TimeUnit.MILLISECONDS)).build();){
                    CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
                    prepCmd.setCoreName(leaderCoreName);
                    prepCmd.setNodeName(this.getNodeName());
                    prepCmd.setCoreNodeName(coreZkNodeName);
                    prepCmd.setState(Replica.State.DOWN);
                    retries = 3;
                    for (int i = 0; i < retries; ++i) {
                        if (this.isClosed) {
                            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                        }
                        try {
                            client.request((SolrRequest)prepCmd);
                            break;
                        }
                        catch (Exception e) {
                            if (this.cc.isShutDown()) {
                                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Core container is shutdown.");
                            }
                            Throwable rootCause = SolrException.getRootCause((Throwable)e);
                            if (rootCause instanceof IOException && !this.zkStateReader.getClusterState().liveNodesContain(leaderProps.getNodeName())) {
                                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Node " + leaderProps.getNodeName() + " hosting leader for " + shard + " in " + collection + " is not live!");
                            }
                            log.error("There was a problem making a request to the leader", (Throwable)e);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                            }
                            if (i != retries - 1) continue;
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem making a request to the leader");
                        }
                    }
                }
                catch (IOException e) {
                    log.error("Error closing HttpSolrClient", (Throwable)e);
                }
            }
        }
        return leaderProps;
    }

    public static void linkConfSet(SolrZkClient zkClient, String collection, String confSetName) throws KeeperException, InterruptedException {
        byte[] data;
        String path = "/collections/" + collection;
        log.debug("Load collection config from:{}", (Object)path);
        try {
            data = zkClient.getData(path, null, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            ZkNodeProps props = new ZkNodeProps(new String[]{CONFIGNAME_PROP, confSetName});
            try {
                zkClient.makePath(path, Utils.toJSON((Object)props), CreateMode.PERSISTENT, null, true);
            }
            catch (KeeperException e2) {
                if (e2.code() != KeeperException.Code.NODEEXISTS) {
                    throw e;
                }
                zkClient.setData(path, Utils.toJSON((Object)props), true);
            }
            return;
        }
        ZkNodeProps props = null;
        if (data != null) {
            props = ZkNodeProps.load((byte[])data);
            HashMap<String, String> newProps = new HashMap<String, String>(props.getProperties());
            newProps.put(CONFIGNAME_PROP, confSetName);
            props = new ZkNodeProps(newProps);
        } else {
            props = new ZkNodeProps(new String[]{CONFIGNAME_PROP, confSetName});
        }
        zkClient.setData(path, Utils.toJSON((Object)props), true);
    }

    public ZkDistributedQueue getOverseerJobQueue() {
        if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
            throw new IllegalStateException("Cluster is configured with distributed state update, not expecting the queue to be retrieved");
        }
        return this.overseerJobQueue;
    }

    public OverseerTaskQueue getOverseerCollectionQueue() {
        return this.overseerCollectionQueue;
    }

    public OverseerTaskQueue getOverseerConfigSetQueue() {
        return this.overseerConfigSetQueue;
    }

    public DistributedMap getOverseerRunningMap() {
        return this.overseerRunningMap;
    }

    public DistributedMap getOverseerCompletedMap() {
        return this.overseerCompletedMap;
    }

    public DistributedMap getOverseerFailureMap() {
        return this.overseerFailureMap;
    }

    public boolean claimAsyncId(String asyncId) throws KeeperException {
        try {
            return this.asyncIdsMap.putIfAbsent(asyncId, new byte[0]);
        }
        catch (InterruptedException e) {
            log.error("Could not claim asyncId={}", (Object)asyncId, (Object)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public boolean clearAsyncId(String asyncId) throws KeeperException {
        try {
            return this.asyncIdsMap.remove(asyncId);
        }
        catch (InterruptedException e) {
            log.error("Could not release asyncId={}", (Object)asyncId, (Object)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public Overseer getOverseer() {
        return this.overseer;
    }

    public LeaderElector getOverseerElector() {
        return this.overseerElector;
    }

    static String generateNodeName(String hostName, String hostPort, String hostContext) {
        return hostName + ":" + hostPort + "_" + URLEncoder.encode(ZkController.trimLeadingAndTrailingSlashes(hostContext), StandardCharsets.UTF_8);
    }

    public static String trimLeadingAndTrailingSlashes(String in) {
        if (null == in) {
            return in;
        }
        String out = in;
        if (out.startsWith("/")) {
            out = out.substring(1);
        }
        if (out.endsWith("/")) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rejoinOverseerElection(String electionNode, boolean joinAtHead) {
        try {
            ElectionContext context = this.overseerElector.getContext();
            if (electionNode == null) {
                this.overseerElector.retryElection(context, joinAtHead);
                return;
            }
            if (context != null && context.leaderSeqPath != null && !context.leaderSeqPath.endsWith(electionNode)) {
                log.warn("Asked to rejoin with wrong election node : {}, current node is {}", (Object)electionNode, (Object)context.leaderSeqPath);
                if (!electionNode.startsWith(this.getNodeName())) return;
                try {
                    this.zkClient.delete("/overseer_elect/election/" + electionNode, -1, true);
                    return;
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    log.warn("Old election node exists , could not be removed ", (Throwable)e);
                    return;
                }
            }
            this.overseerElector.retryElection(new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName()), joinAtHead);
            return;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rejoin election", (Throwable)e);
        }
    }

    public void rejoinShardLeaderElection(SolrParams params) {
        String collectionName = params.get("collection");
        String shardId = params.get("shard");
        String coreNodeName = params.get("core_node_name");
        String coreName = params.get("core");
        String electionNode = params.get("election_node");
        try {
            MDCLoggingContext.setCoreDescriptor(this.cc, this.cc.getCoreDescriptor(coreName));
            log.info("Rejoin the shard leader election.");
            ContextKey contextKey = new ContextKey(collectionName, coreNodeName);
            ElectionContext prevContext = this.electionContexts.get(contextKey);
            if (prevContext != null) {
                prevContext.cancelElection();
            }
            String baseUrl = this.zkStateReader.getBaseUrlForNodeName(this.getNodeName());
            String ourUrl = ZkCoreNodeProps.getCoreUrl((String)baseUrl, (String)coreName);
            ZkNodeProps zkProps = new ZkNodeProps(new String[]{"core", coreName, "node_name", this.getNodeName(), "core_node_name", coreNodeName, "base_url", baseUrl});
            LeaderElector elect = ((ShardLeaderElectionContextBase)prevContext).getLeaderElector();
            ShardLeaderElectionContext context = new ShardLeaderElectionContext(elect, shardId, collectionName, coreNodeName, zkProps, this, this.getCoreContainer());
            context.leaderSeqPath = context.electionPath + "/election/" + electionNode;
            elect.setup(context);
            this.electionContexts.put(contextKey, context);
            elect.retryElection(context, params.getBool("rejoinAtHead", false));
            try (SolrCore core = this.cc.getCore(coreName);){
                String leaderUrl;
                Replica.Type replicaType = core.getCoreDescriptor().getCloudDescriptor().getReplicaType();
                if (replicaType == Replica.Type.TLOG && !(leaderUrl = this.getLeader(core.getCoreDescriptor().getCloudDescriptor(), this.cloudConfig.getLeaderVoteWait())).equals(ourUrl)) {
                    this.stopReplicationFromLeader(coreName);
                    this.startReplicationFromLeader(coreName, true);
                }
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rejoin election", (Throwable)e);
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public void checkOverseerDesignate() {
        try {
            byte[] data = this.zkClient.getData("/roles.json", null, new Stat(), true);
            if (data == null) {
                return;
            }
            Map roles = (Map)Utils.fromJSON((byte[])data);
            if (roles == null) {
                return;
            }
            List nodeList = (List)roles.get("overseer");
            if (nodeList == null) {
                return;
            }
            if (nodeList.contains(this.getNodeName())) {
                this.setPreferredOverseer();
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return;
        }
        catch (Exception e) {
            log.warn("could not read the overseer designate ", (Throwable)e);
        }
    }

    public void setPreferredOverseer() throws KeeperException, InterruptedException {
        MapWriter props = ew -> ew.put((CharSequence)"operation", (CharSequence)CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT)).put((CharSequence)this.getNodeName(), (CharSequence)this.getNodeName()).put((CharSequence)"role", (CharSequence)"overseer").put((CharSequence)"persist", (CharSequence)"false");
        log.warn("Going to add role {}. It is deprecated to use ADDROLE and consider using Node Roles instead.", (Object)props.jsonStr());
        this.getOverseerCollectionQueue().offer(props);
    }

    public CoreContainer getCoreContainer() {
        return this.cc;
    }

    public void throwErrorIfReplicaReplaced(CoreDescriptor desc) {
        DocCollection collection;
        ClusterState clusterState = this.getZkStateReader().getClusterState();
        if (clusterState != null && (collection = clusterState.getCollectionOrNull(desc.getCloudDescriptor().getCollectionName())) != null) {
            CloudUtil.checkSharedFSFailoverReplaced(this.cc, desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnReconnectListener(OnReconnect listener) {
        if (listener != null) {
            HashSet<OnReconnect> hashSet = this.reconnectListeners;
            synchronized (hashSet) {
                this.reconnectListeners.add(listener);
                log.debug("Added new OnReconnect listener {}", (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnReconnectListener(OnReconnect listener) {
        if (listener != null) {
            boolean wasRemoved;
            HashSet<OnReconnect> hashSet = this.reconnectListeners;
            synchronized (hashSet) {
                wasRemoved = this.reconnectListeners.remove(listener);
            }
            if (wasRemoved) {
                log.debug("Removed OnReconnect listener {}", (Object)listener);
            } else {
                log.warn("Was asked to remove OnReconnect listener {}, but remove operation did not find it in the list of registered listeners.", (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<OnReconnect> getCurrentOnReconnectListeners() {
        HashSet clonedListeners;
        HashSet<OnReconnect> hashSet = this.reconnectListeners;
        synchronized (hashSet) {
            clonedListeners = (HashSet)this.reconnectListeners.clone();
        }
        return clonedListeners;
    }

    public static int persistConfigResourceToZooKeeper(ZkSolrResourceLoader zkLoader, int znodeVersion, String resourceName, byte[] content, boolean createIfNotExists) {
        int latestVersion;
        block16: {
            latestVersion = znodeVersion;
            ZkController zkController = zkLoader.getZkController();
            SolrZkClient zkClient = zkController.getZkClient();
            String resourceLocation = zkLoader.getConfigSetZkPath() + "/" + resourceName;
            String errMsg = "Failed to persist resource at {0} - old {1}";
            try {
                try {
                    Stat stat = zkClient.setData(resourceLocation, content, znodeVersion, true);
                    latestVersion = stat.getVersion();
                    log.info("Persisted config data to node {} ", (Object)resourceLocation);
                    ZkController.touchConfDir(zkLoader);
                }
                catch (KeeperException.NoNodeException e) {
                    if (!createIfNotExists) break block16;
                    try {
                        zkClient.create(resourceLocation, content, CreateMode.PERSISTENT, true);
                        latestVersion = 0;
                        ZkController.touchConfDir(zkLoader);
                    }
                    catch (KeeperException.NodeExistsException nee) {
                        try {
                            Stat stat = zkClient.exists(resourceLocation, null, true);
                            if (log.isDebugEnabled()) {
                                log.debug("failed to set data version in zk is {} and expected version is {} ", (Object)stat.getVersion(), (Object)znodeVersion);
                            }
                        }
                        catch (Exception e1) {
                            log.warn("could not get stat");
                        }
                        if (log.isInfoEnabled()) {
                            log.info(StrUtils.formatString((String)errMsg, (Object[])new Object[]{resourceLocation, znodeVersion}));
                        }
                        throw new ResourceModifiedInZkException(SolrException.ErrorCode.CONFLICT, StrUtils.formatString((String)errMsg, (Object[])new Object[]{resourceLocation, znodeVersion}) + ", retry.");
                    }
                }
            }
            catch (KeeperException.BadVersionException bve) {
                try {
                    zkClient.exists(resourceLocation, null, true);
                }
                catch (Exception e) {
                    log.error("Exception during ZooKeeper node checking ", (Throwable)e);
                }
                if (log.isInfoEnabled()) {
                    log.info(StrUtils.formatString((String)"%s zkVersion= %d %s %d", (Object[])new Object[]{errMsg, resourceLocation, znodeVersion}));
                }
                throw new ResourceModifiedInZkException(SolrException.ErrorCode.CONFLICT, StrUtils.formatString((String)errMsg, (Object[])new Object[]{resourceLocation, znodeVersion}) + ", retry.");
            }
            catch (ResourceModifiedInZkException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                String msg = "Error persisting resource at " + resourceLocation;
                log.error(msg, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
            }
        }
        return latestVersion;
    }

    public static void touchConfDir(ZkSolrResourceLoader zkLoader) {
        SolrZkClient zkClient = zkLoader.getZkController().getZkClient();
        String configSetZkPath = zkLoader.getConfigSetZkPath();
        try {
            zkClient.atomicUpdate(configSetZkPath, bytes -> bytes == null ? TOUCHED_ZNODE_DATA : bytes);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String msg = "Error 'touching' conf location " + configSetZkPath;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterConfListener(String confDir, Runnable listener) {
        Map<String, Set<Runnable>> map = this.confDirectoryListeners;
        synchronized (map) {
            Set<Runnable> listeners = this.confDirectoryListeners.get(confDir);
            if (listeners == null) {
                log.warn("{} has no more registered listeners, but a live one attempted to unregister!", (Object)confDir);
                return;
            }
            if (listeners.remove(listener)) {
                log.debug("removed listener for config directory [{}]", (Object)confDir);
            }
            if (listeners.isEmpty()) {
                log.debug("No more listeners for config directory [{}]", (Object)confDir);
                this.confDirectoryListeners.remove(confDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfListenerForCore(final String confDir, SolrCore core, final Runnable listener) {
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        Map<String, Set<Runnable>> map = this.confDirectoryListeners;
        synchronized (map) {
            Set<Runnable> confDirListeners = this.getConfDirListeners(confDir);
            confDirListeners.add(listener);
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                    ZkController.this.unregisterConfListener(confDir, listener);
                }
            });
        }
    }

    private Set<Runnable> getConfDirListeners(String confDir) {
        assert (Thread.holdsLock(this.confDirectoryListeners)) : "confDirListeners lock not held by thread";
        Set<Runnable> confDirListeners = this.confDirectoryListeners.get(confDir);
        if (confDirListeners == null) {
            log.debug("watch zkdir {}", (Object)confDir);
            confDirListeners = new HashSet<Runnable>();
            this.confDirectoryListeners.put(confDir, confDirListeners);
            this.setConfWatcher(confDir, new WatcherImpl(confDir), null);
        }
        return confDirListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fireEventListeners(String zkDir) {
        if (this.isClosed || this.cc.isShutDown()) {
            return false;
        }
        Map<String, Set<Runnable>> map = this.confDirectoryListeners;
        synchronized (map) {
            if (!this.confDirectoryListeners.containsKey(zkDir)) {
                log.debug("Watcher on {} is removed ", (Object)zkDir);
                return false;
            }
            Set<Runnable> listeners = this.confDirectoryListeners.get(zkDir);
            if (listeners != null && !listeners.isEmpty()) {
                HashSet<Runnable> listenersCopy = new HashSet<Runnable>(listeners);
                Runnable work = () -> {
                    log.debug("Running listeners for {}", (Object)zkDir);
                    for (Runnable listener : listenersCopy) {
                        try {
                            listener.run();
                        }
                        catch (RuntimeException e) {
                            log.warn("listener throws error", (Throwable)e);
                        }
                    }
                };
                this.cc.getCoreZkRegisterExecutorService().submit(work);
            }
        }
        return true;
    }

    private void setConfWatcher(String zkDir, Watcher watcher, Stat stat) {
        try {
            Stat newStat = this.zkClient.exists(zkDir, watcher, true);
            if (stat != null && newStat.getVersion() > stat.getVersion()) {
                this.fireEventListeners(zkDir);
            }
        }
        catch (KeeperException e) {
            log.error("failed to set watcher for conf dir {} ", (Object)zkDir);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("failed to set watcher for conf dir {} ", (Object)zkDir);
        }
    }

    public OnReconnect getConfigDirListener() {
        return () -> {
            Map<String, Set<Runnable>> map = this.confDirectoryListeners;
            synchronized (map) {
                for (String s : this.confDirectoryListeners.keySet()) {
                    this.setConfWatcher(s, new WatcherImpl(s), null);
                    this.fireEventListeners(s);
                }
            }
        };
    }

    public boolean checkIfCoreNodeNameAlreadyExists(CoreDescriptor dcore) {
        DocCollection collection = this.zkStateReader.getClusterState().getCollectionOrNull(dcore.getCollectionName());
        if (collection != null) {
            Collection slices = collection.getSlices();
            for (Slice slice : slices) {
                Replica r = slice.getReplica(dcore.getCloudDescriptor().getCoreNodeName());
                if (r == null) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<String> publishNodeAsDown(String nodeName) {
        log.info("Publish node={} as DOWN", (Object)nodeName);
        ClusterState clusterState = this.getClusterState();
        Map replicasPerCollectionOnNode = clusterState.getReplicaNamesPerCollectionOnNode(nodeName);
        if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
            this.distributedClusterStateUpdater.executeNodeDownStateUpdate(nodeName, this.zkStateReader);
        } else {
            try {
                for (String collName : replicasPerCollectionOnNode.keySet()) {
                    DocCollection coll;
                    if (collName == null || (coll = this.zkStateReader.getCollection(collName)) == null || !coll.isPerReplicaState()) continue;
                    PerReplicaStatesOps.downReplicas(((List)replicasPerCollectionOnNode.get(collName)).stream().map(Replica::getName).collect(Collectors.toList()), (PerReplicaStates)PerReplicaStatesOps.fetch((String)coll.getZNode(), (SolrZkClient)this.zkClient, (PerReplicaStates)coll.getPerReplicaStates())).persist(coll.getZNode(), this.zkClient);
                }
                this.overseer.getStateUpdateQueue().offer(m -> m.put((CharSequence)"operation", (CharSequence)OverseerAction.DOWNNODE.toLower()).put((CharSequence)"node_name", (CharSequence)nodeName));
            }
            catch (AlreadyClosedException e) {
                log.info("Not publishing node as DOWN because a resource required to do so is already closed.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("Publish node as down was interrupted.");
            }
            catch (KeeperException e) {
                log.warn("Could not publish node as down: ", (Throwable)e);
            }
        }
        return replicasPerCollectionOnNode.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureRegisteredSearcher(SolrCore core) throws InterruptedException {
        if (!core.getSolrConfig().useColdSearcher) {
            RefCounted<SolrIndexSearcher> registeredSearcher = core.getRegisteredSearcher();
            if (registeredSearcher != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found a registered searcher: {} for core: {}", (Object)registeredSearcher.get(), (Object)core);
                }
                registeredSearcher.decref();
            } else {
                Future[] waitSearcher = (Future[])Array.newInstance(Future.class, 1);
                if (log.isInfoEnabled()) {
                    log.info("No registered searcher found for core: {}, waiting until a searcher is registered before publishing as active", (Object)core.getName());
                }
                RTimer timer = new RTimer();
                RefCounted<SolrIndexSearcher> searcher = null;
                try {
                    searcher = core.getSearcher(false, true, waitSearcher, true);
                    boolean success = true;
                    if (waitSearcher[0] != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Waiting for first searcher of core {}, id: {} to be registered", (Object)core.getName(), (Object)core);
                        }
                        try {
                            waitSearcher[0].get();
                        }
                        catch (ExecutionException e) {
                            log.warn("Wait for a searcher to be registered for core {}, id: {} failed due to: {}", new Object[]{core.getName(), core, e, e});
                            success = false;
                        }
                    }
                    if (success) {
                        if (searcher == null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Did not find a searcher even after the future callback for core: {}, id: {}!!!", (Object)core.getName(), (Object)core);
                            }
                        } else if (log.isInfoEnabled()) {
                            log.info("Found a registered searcher: {}, took: {} ms for core: {}, id: {}", new Object[]{searcher.get(), timer.getTime(), core.getName(), core});
                        }
                    }
                }
                finally {
                    if (searcher != null) {
                        searcher.decref();
                    }
                }
            }
            RefCounted<SolrIndexSearcher> newestSearcher = core.getNewestSearcher(false);
            if (newestSearcher != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found newest searcher: {} for core: {}, id: {}", new Object[]{newestSearcher.get(), core.getName(), core});
                }
                newestSearcher.decref();
            }
        }
    }

    private class RegisterCoreAsync
    implements Callable<Object> {
        CoreDescriptor descriptor;
        boolean recoverReloadedCores;
        boolean afterExpiration;

        RegisterCoreAsync(CoreDescriptor descriptor, boolean recoverReloadedCores, boolean afterExpiration) {
            this.descriptor = descriptor;
            this.recoverReloadedCores = recoverReloadedCores;
            this.afterExpiration = afterExpiration;
        }

        @Override
        public Object call() throws Exception {
            if (log.isInfoEnabled()) {
                log.info("Registering core {} afterExpiration? {}", (Object)this.descriptor.getName(), (Object)this.afterExpiration);
            }
            ZkController.this.register(this.descriptor.getName(), this.descriptor, this.recoverReloadedCores, this.afterExpiration, false);
            return this.descriptor;
        }
    }

    private static class OnReconnectNotifyAsync
    implements Callable<Object> {
        private final OnReconnect listener;

        OnReconnectNotifyAsync(OnReconnect listener) {
            this.listener = listener;
        }

        @Override
        public Object call() throws Exception {
            this.listener.command();
            return null;
        }
    }

    static class ContextKey {
        private String collection;
        private String coreNodeName;

        public ContextKey(String collection, String coreNodeName) {
            this.collection = collection;
            this.coreNodeName = coreNodeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.coreNodeName == null ? 0 : this.coreNodeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ContextKey)) {
                return false;
            }
            ContextKey other = (ContextKey)obj;
            return Objects.equals(this.collection, other.collection) && Objects.equals(this.coreNodeName, other.coreNodeName);
        }

        public String toString() {
            return this.collection + ":" + this.coreNodeName;
        }
    }

    class UnloadCoreOnDeletedWatcher
    implements DocCollectionWatcher {
        String coreNodeName;
        String shard;
        String coreName;

        public UnloadCoreOnDeletedWatcher(String coreNodeName, String shard, String coreName) {
            this.coreNodeName = coreNodeName;
            this.shard = shard;
            this.coreName = coreName;
        }

        public synchronized boolean onStateChanged(DocCollection collectionState) {
            boolean replicaRemoved;
            if (ZkController.this.getCoreContainer().getCoreDescriptor(this.coreName) == null) {
                return true;
            }
            boolean bl = replicaRemoved = ZkController.this.getReplicaOrNull(collectionState, this.shard, this.coreNodeName) == null;
            if (replicaRemoved) {
                try {
                    log.info("Replica {} removed from clusterstate, remove it.", (Object)this.coreName);
                    ZkController.this.getCoreContainer().unload(this.coreName, true, true, true);
                }
                catch (SolrException e) {
                    if (!e.getMessage().contains("Cannot unload non-existent core")) {
                        log.warn("Failed to unregister core:{}", (Object)this.coreName, (Object)e);
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to unregister core:{}", (Object)this.coreName, (Object)e);
                }
            }
            return replicaRemoved;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnloadCoreOnDeletedWatcher)) {
                return false;
            }
            UnloadCoreOnDeletedWatcher that = (UnloadCoreOnDeletedWatcher)o;
            return Objects.equals(this.coreNodeName, that.coreNodeName) && Objects.equals(this.shard, that.shard) && Objects.equals(this.coreName, that.coreName);
        }

        public int hashCode() {
            return Objects.hash(this.coreNodeName, this.shard, this.coreName);
        }
    }

    public static class NotInClusterStateException
    extends SolrException {
        public NotInClusterStateException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    public static class ResourceModifiedInZkException
    extends SolrException {
        public ResourceModifiedInZkException(SolrException.ErrorCode code, String msg) {
            super(code, msg);
        }
    }

    private class WatcherImpl
    implements Watcher {
        private final String zkDir;

        private WatcherImpl(String dir) {
            this.zkDir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            Stat stat = null;
            try {
                stat = ZkController.this.zkClient.exists(this.zkDir, null, true);
            }
            catch (KeeperException keeperException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            boolean resetWatcher = false;
            try {
                resetWatcher = ZkController.this.fireEventListeners(this.zkDir);
            }
            finally {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    log.debug("A node got unwatched for {}", (Object)this.zkDir);
                } else if (resetWatcher) {
                    ZkController.this.setConfWatcher(this.zkDir, this, stat);
                } else {
                    log.debug("A node got unwatched for {}", (Object)this.zkDir);
                }
            }
        }
    }
}

