/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.solr.cli.ApiTool;
import org.apache.solr.cli.AssertTool;
import org.apache.solr.cli.AuthTool;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.ClusterTool;
import org.apache.solr.cli.ConfigSetDownloadTool;
import org.apache.solr.cli.ConfigSetUploadTool;
import org.apache.solr.cli.ConfigTool;
import org.apache.solr.cli.CreateTool;
import org.apache.solr.cli.DeleteTool;
import org.apache.solr.cli.ExportTool;
import org.apache.solr.cli.HealthcheckTool;
import org.apache.solr.cli.LinkConfigTool;
import org.apache.solr.cli.PackageTool;
import org.apache.solr.cli.PostLogsTool;
import org.apache.solr.cli.PostTool;
import org.apache.solr.cli.RunExampleTool;
import org.apache.solr.cli.StatusTool;
import org.apache.solr.cli.Tool;
import org.apache.solr.cli.UpdateACLTool;
import org.apache.solr.cli.VersionTool;
import org.apache.solr.cli.ZkCpTool;
import org.apache.solr.cli.ZkLsTool;
import org.apache.solr.cli.ZkMkrootTool;
import org.apache.solr.cli.ZkMvTool;
import org.apache.solr.cli.ZkRmTool;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.StartupLoggingUtils;
import org.apache.solr.util.configuration.SSLConfigurationsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCLI
implements CLIO {
    public static String RED = "\u001b[31m";
    public static String GREEN = "\u001b[32m";
    public static String YELLOW = "\u001b[33m";
    private static final long MAX_WAIT_FOR_CORE_LOAD_NANOS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ZK_HOST = "localhost:9983";
    public static final Option OPTION_ZKHOST_DEPRECATED = Option.builder((String)"zkHost").longOpt("zkHost").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --zk-host instead").get()).argName("HOST").hasArg().required(false).desc("Zookeeper connection string; unnecessary if ZK_HOST is defined in solr.in.sh; otherwise, defaults to localhost:9983.").build();
    public static final Option OPTION_ZKHOST = Option.builder((String)"z").longOpt("zk-host").argName("HOST").hasArg().required(false).desc("Zookeeper connection string; unnecessary if ZK_HOST is defined in solr.in.sh; otherwise, defaults to localhost:9983.").build();
    public static final Option OPTION_SOLRURL_DEPRECATED = Option.builder((String)"solrUrl").longOpt("solrUrl").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --solr-url instead").get()).argName("HOST").hasArg().required(false).desc("Base Solr URL, which can be used to determine the zk-host if that's not known; defaults to: " + SolrCLI.getDefaultSolrUrl() + ".").build();
    public static final Option OPTION_SOLRURL = Option.builder((String)"url").longOpt("solr-url").argName("HOST").hasArg().required(false).desc("Base Solr URL, which can be used to determine the zk-host if that's not known; defaults to: " + SolrCLI.getDefaultSolrUrl() + ".").build();
    public static final Option OPTION_VERBOSE = Option.builder((String)"v").longOpt("verbose").required(false).desc("Enable verbose command output.").build();
    public static final Option OPTION_HELP = Option.builder((String)"h").longOpt("help").required(false).desc("Print this message.").build();
    public static final Option OPTION_RECURSE = Option.builder((String)"r").longOpt("recurse").argName("recurse").hasArg().required(false).desc("Recurse (true|false), default is false.").build();
    public static final Option OPTION_CREDENTIALS = Option.builder((String)"u").longOpt("credentials").argName("credentials").hasArg().required(false).desc("Credentials in the format username:password. Example: --credentials solr:SolrRocks").build();
    public static final Option OPTION_CREDENTIALS_DEPRECATED = Option.builder((String)"credentials").argName("credentials").hasArg().deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use -u or --credentials instead").get()).required(false).desc("Credentials in the format username:password. Example: --credentials solr:SolrRocks").build();
    private static final String JSON_CONTENT_TYPE = "application/json";
    public static final String DEFAULT_CONFIG_SET = "_default";
    private static final long MS_IN_MIN = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;

    public static void exit(int exitStatus) {
        block2: {
            try {
                System.exit(exitStatus);
            }
            catch (SecurityException secExc) {
                if (exitStatus == 0) break block2;
                throw new RuntimeException("SolrCLI failed to exit with status " + exitStatus);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        boolean isHelpCommand;
        boolean hasNoCommand = args == null || args.length == 0 || args[0] == null || args[0].trim().isEmpty();
        boolean bl = isHelpCommand = !hasNoCommand && Arrays.asList("-h", "--help", "/?").contains(args[0]);
        if (hasNoCommand || isHelpCommand) {
            SolrCLI.printHelp();
            SolrCLI.exit(1);
        }
        if (Arrays.asList("-v", "-version", "version").contains(args[0])) {
            args[0] = "version";
        }
        SSLConfigurationsFactory.current().init();
        Tool tool = null;
        try {
            tool = SolrCLI.findTool(args);
        }
        catch (IllegalArgumentException iae) {
            CLIO.err(iae.getMessage());
            System.exit(1);
        }
        CommandLine cli = SolrCLI.parseCmdLine(tool, args);
        System.exit(tool.runTool(cli));
    }

    public static Tool findTool(String[] args) throws Exception {
        String toolType = args[0].trim().toLowerCase(Locale.ROOT);
        return SolrCLI.newTool(toolType);
    }

    public static CommandLine parseCmdLine(Tool tool, String[] args) {
        ArrayList<String> toolArgList = new ArrayList<String>();
        ArrayList<String> dashDList = new ArrayList<String>();
        for (int a = 1; a < args.length; ++a) {
            String arg = args[a];
            if (arg.startsWith("-D")) {
                dashDList.add(arg);
                continue;
            }
            toolArgList.add(arg);
        }
        String[] toolArgs = toolArgList.toArray(new String[0]);
        CommandLine cli = SolrCLI.processCommandLineArgs(tool, toolArgs);
        List argList = cli.getArgList();
        argList.addAll(dashDList);
        String solrInstallDir = System.getProperty("solr.install.dir");
        if (solrInstallDir != null) {
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "keyStore");
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "trustStore");
        }
        return cli;
    }

    public static String getDefaultSolrUrl() {
        String scheme = EnvUtils.getProperty((String)"solr.url.scheme", (String)"http");
        String host = EnvUtils.getProperty((String)"solr.tool.host", (String)"localhost");
        String port = EnvUtils.getProperty((String)"jetty.port", (String)"8983");
        return String.format(Locale.ROOT, "%s://%s:%s", scheme.toLowerCase(Locale.ROOT), host, port);
    }

    protected static void checkSslStoreSysProp(String solrInstallDir, String key) {
        String sysProp = "javax.net.ssl." + key;
        String keyStore = System.getProperty(sysProp);
        if (keyStore == null) {
            return;
        }
        File keyStoreFile = new File(keyStore);
        if (keyStoreFile.isFile()) {
            return;
        }
        keyStoreFile = new File(solrInstallDir, "server/" + keyStore);
        if (keyStoreFile.isFile()) {
            System.setProperty(sysProp, keyStoreFile.getAbsolutePath());
        } else {
            CLIO.err("WARNING: " + sysProp + " file " + keyStore + " not found! https requests to Solr will likely fail; please update your " + sysProp + " setting to use an absolute path.");
        }
    }

    public static void raiseLogLevelUnlessVerbose(CommandLine cli) {
        if (!cli.hasOption(OPTION_VERBOSE.getOpt())) {
            StartupLoggingUtils.changeLogLevel("WARN");
        }
    }

    private static Tool newTool(String toolType) throws Exception {
        if ("healthcheck".equals(toolType)) {
            return new HealthcheckTool();
        }
        if ("status".equals(toolType)) {
            return new StatusTool();
        }
        if ("api".equals(toolType)) {
            return new ApiTool();
        }
        if ("create".equals(toolType)) {
            return new CreateTool();
        }
        if ("delete".equals(toolType)) {
            return new DeleteTool();
        }
        if ("config".equals(toolType)) {
            return new ConfigTool();
        }
        if ("run_example".equals(toolType)) {
            return new RunExampleTool();
        }
        if ("upconfig".equals(toolType)) {
            return new ConfigSetUploadTool();
        }
        if ("downconfig".equals(toolType)) {
            return new ConfigSetDownloadTool();
        }
        if ("rm".equals(toolType)) {
            return new ZkRmTool();
        }
        if ("mv".equals(toolType)) {
            return new ZkMvTool();
        }
        if ("cp".equals(toolType)) {
            return new ZkCpTool();
        }
        if ("ls".equals(toolType)) {
            return new ZkLsTool();
        }
        if ("cluster".equals(toolType)) {
            return new ClusterTool();
        }
        if ("updateacls".equals(toolType)) {
            return new UpdateACLTool();
        }
        if ("linkconfig".equals(toolType)) {
            return new LinkConfigTool();
        }
        if ("mkroot".equals(toolType)) {
            return new ZkMkrootTool();
        }
        if ("assert".equals(toolType)) {
            return new AssertTool();
        }
        if ("auth".equals(toolType)) {
            return new AuthTool();
        }
        if ("export".equals(toolType)) {
            return new ExportTool();
        }
        if ("package".equals(toolType)) {
            return new PackageTool();
        }
        if ("postlogs".equals(toolType)) {
            return new PostLogsTool();
        }
        if ("version".equals(toolType)) {
            return new VersionTool();
        }
        if ("post".equals(toolType)) {
            return new PostTool();
        }
        for (Class<? extends Tool> next : SolrCLI.findToolClassesInPackage("org.apache.solr.util")) {
            Tool tool = next.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!toolType.equals(tool.getName())) continue;
            return tool;
        }
        throw new IllegalArgumentException(toolType + " is not a valid command!");
    }

    public static Options getToolOptions(Tool tool) {
        Options options = new Options();
        options.addOption(OPTION_HELP);
        options.addOption(OPTION_VERBOSE);
        List<Option> toolOpts = tool.getOptions();
        for (Option toolOpt : toolOpts) {
            if (toolOpt.isDeprecated()) continue;
            options.addOption(toolOpt);
        }
        return options;
    }

    public static String getOptionWithDeprecatedAndDefault(CommandLine cli, String opt, String deprecated, String def) {
        String val = cli.getOptionValue(opt);
        if (val == null) {
            val = cli.getOptionValue(deprecated);
        }
        return val == null ? def : val;
    }

    private static void deprecatedHandlerStdErr(Option o) {
        if (o.isDeprecated()) {
            StringBuilder buf = new StringBuilder().append("Option '-").append(o.getOpt()).append('\'');
            if (o.getLongOpt() != null) {
                buf.append(",'--").append(o.getLongOpt()).append('\'');
            }
            buf.append(": ").append(o.getDeprecated());
            CLIO.err(buf.toString());
        }
    }

    public static CommandLine processCommandLineArgs(Tool tool, String[] args) {
        List<Option> customOptions = tool.getOptions();
        Options options = new Options();
        options.addOption(OPTION_HELP);
        options.addOption(OPTION_VERBOSE);
        if (customOptions != null) {
            for (Option customOption : customOptions) {
                options.addOption(customOption);
            }
        }
        CommandLine cli = null;
        try {
            cli = DefaultParser.builder().setDeprecatedHandler(SolrCLI::deprecatedHandlerStdErr).build().parse(options, args);
        }
        catch (ParseException exp) {
            boolean hasHelpArg = false;
            if (args != null) {
                for (String arg : args) {
                    if (!"-h".equals(arg) && !"--help".equals(arg) && !"-help".equals(arg)) continue;
                    hasHelpArg = true;
                    break;
                }
            }
            if (!hasHelpArg) {
                CLIO.err("Failed to parse command-line arguments due to: " + exp.getMessage() + "\n");
                SolrCLI.printToolHelp(tool);
                SolrCLI.exit(1);
            }
            SolrCLI.printToolHelp(tool);
            SolrCLI.exit(0);
        }
        if (cli.hasOption("help")) {
            SolrCLI.printToolHelp(tool);
            SolrCLI.exit(0);
        }
        return cli;
    }

    private static void printToolHelp(Tool tool) {
        HelpFormatter formatter = HelpFormatter.builder().get();
        formatter.setWidth(120);
        Options optionsNoDeprecated = new Options();
        tool.getOptions().stream().filter(option -> !option.isDeprecated()).forEach(arg_0 -> ((Options)optionsNoDeprecated).addOption(arg_0));
        Object usageString = tool.getUsage() == null ? "bin/solr " + tool.getName() : tool.getUsage();
        boolean autoGenerateUsage = tool.getUsage() == null;
        formatter.printHelp((String)usageString, tool.getHeader(), optionsNoDeprecated, tool.getFooter(), autoGenerateUsage);
    }

    private static List<Class<? extends Tool>> findToolClassesInPackage(String packageName) {
        ArrayList<Class<? extends Tool>> toolClasses = new ArrayList<Class<? extends Tool>>();
        try {
            ClassLoader classLoader = SolrCLI.class.getClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            TreeSet<String> classes = new TreeSet<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                classes.addAll(SolrCLI.findClasses(resource.getFile(), packageName));
            }
            for (String classInPackage : classes) {
                Class<?> theClass = Class.forName(classInPackage);
                if (!Tool.class.isAssignableFrom(theClass)) continue;
                toolClasses.add(theClass.asSubclass(Tool.class));
            }
        }
        catch (Exception e) {
            log.debug("Failed to find Tool impl classes in {}, due to: ", (Object)packageName, (Object)e);
        }
        return toolClasses;
    }

    private static Set<String> findClasses(String path, String packageName) throws Exception {
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    String className;
                    if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                    classes.add(className);
                }
            }
        }
        return classes;
    }

    public static boolean checkCommunicationError(Exception exc) {
        Throwable rootCause = SolrException.getRootCause((Throwable)exc);
        return rootCause instanceof SolrServerException || rootCause instanceof SocketException;
    }

    public static void checkCodeForAuthError(int code) {
        if (code == SolrException.ErrorCode.UNAUTHORIZED.code || code == SolrException.ErrorCode.FORBIDDEN.code) {
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)code), "Solr requires authentication for request. Please supply valid credentials. HTTP code=" + code);
        }
    }

    public static boolean exceptionIsAuthRelated(Exception exc) {
        return exc instanceof SolrException && Arrays.asList(SolrException.ErrorCode.UNAUTHORIZED.code, SolrException.ErrorCode.FORBIDDEN.code).contains(((SolrException)exc).code());
    }

    public static SolrClient getSolrClient(String solrUrl) {
        String hostContext = System.getProperty("hostContext", "/solr");
        if (hostContext.isBlank()) {
            log.warn("Invalid hostContext {} provided, setting to /solr", (Object)hostContext);
            hostContext = "/solr";
        }
        solrUrl = SolrCLI.normalizeSolrUrl((String)solrUrl, true, hostContext) + hostContext;
        Http2SolrClient.Builder builder = ((Http2SolrClient.Builder)new Http2SolrClient.Builder((String)solrUrl).withMaxConnectionsPerHost(32)).withKeyStoreReloadInterval(-1L, TimeUnit.SECONDS);
        return builder.build();
    }

    public static SolrClient getSolrClient(CommandLine cli) throws Exception {
        String solrUrl = SolrCLI.normalizeSolrUrl(cli);
        return SolrCLI.getSolrClient(solrUrl);
    }

    public static NamedList<Object> postJsonToSolr(SolrClient solrClient, String updatePath, String jsonBody) throws Exception {
        ContentStreamBase.StringStream contentStream = new ContentStreamBase.StringStream(jsonBody);
        contentStream.setContentType(JSON_CONTENT_TYPE);
        ContentStreamUpdateRequest req = new ContentStreamUpdateRequest(updatePath);
        req.addContentStream((ContentStream)contentStream);
        return solrClient.request((SolrRequest)req);
    }

    @VisibleForTesting
    public static String uptime(long uptimeMs) {
        if (uptimeMs <= 0L) {
            return "?";
        }
        long numDays = uptimeMs >= 86400000L ? uptimeMs / 86400000L : 0L;
        long rem = uptimeMs - numDays * 86400000L;
        long numHours = rem >= 3600000L ? rem / 3600000L : 0L;
        long numMinutes = (rem -= numHours * 3600000L) >= 60000L ? rem / 60000L : 0L;
        long numSeconds = Math.round((double)(rem -= numMinutes * 60000L) / 1000.0);
        return String.format(Locale.ROOT, "%d days, %d hours, %d minutes, %d seconds", numDays, numHours, numMinutes, numSeconds);
    }

    private static void printHelp() {
        SolrCLI.print("Usage: solr COMMAND OPTIONS");
        SolrCLI.print("       where COMMAND is one of: start, stop, restart, status, healthcheck, create, delete, version, zk, auth, assert, config, export, api, package, post");
        SolrCLI.print("");
        SolrCLI.print("  Standalone server example (start Solr running in the background on port 8984):");
        SolrCLI.print("");
        SolrCLI.printGreen("    ./solr start -p 8984");
        SolrCLI.print("");
        SolrCLI.print("  SolrCloud example (start Solr running in SolrCloud mode using localhost:2181 to connect to Zookeeper, with 1g max heap size and remote Java debug options enabled):");
        SolrCLI.print("");
        SolrCLI.printGreen("    ./solr start -c -m 1g -z localhost:2181 -a \"-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=1044\"");
        SolrCLI.print("");
        SolrCLI.print("  Omit '-z localhost:2181' from the above command if you have defined ZK_HOST in solr.in.sh.");
        SolrCLI.print("");
        SolrCLI.print("Pass --help or -h after any COMMAND to see command-specific usage information,");
        SolrCLI.print("such as:    ./solr start --help or ./solr stop -h");
    }

    public static String normalizeSolrUrl(String solrUrl, boolean logUrlFormatWarning) {
        return SolrCLI.normalizeSolrUrl(solrUrl, logUrlFormatWarning, "/solr");
    }

    public static String normalizeSolrUrl(String solrUrl, boolean logUrlFormatWarning, String hostContext) {
        if (solrUrl != null) {
            URI uri = URI.create(solrUrl);
            String urlPath = uri.getRawPath();
            if (hostContext != null && hostContext.endsWith("/")) {
                hostContext = hostContext.substring(0, hostContext.length() - 1);
            }
            if (urlPath.contains(hostContext)) {
                String newSolrUrl = uri.resolve(urlPath.substring(0, urlPath.indexOf(hostContext)) + "/").toString();
                if (logUrlFormatWarning) {
                    CLIO.err("WARNING: URLs provided to this tool needn't include Solr's context-root (e.g. \"/solr\"). Such URLs are deprecated and support for them will be removed in a future release. Correcting from [" + solrUrl + "] to [" + newSolrUrl + "].");
                }
                solrUrl = newSolrUrl;
            }
            if (solrUrl.endsWith("/")) {
                solrUrl = solrUrl.substring(0, solrUrl.length() - 1);
            }
        }
        return solrUrl;
    }

    public static String normalizeSolrUrl(CommandLine cli) throws Exception {
        String solrUrl;
        String string = solrUrl = cli.hasOption("solr-url") ? cli.getOptionValue("solr-url") : cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            String zkHost;
            String string2 = zkHost = cli.hasOption("zk-host") ? cli.getOptionValue("zk-host") : cli.getOptionValue("zkHost");
            if (zkHost == null) {
                solrUrl = SolrCLI.getDefaultSolrUrl();
                CLIO.err("Neither --zk-host or --solr-url parameters provided so assuming solr url is " + solrUrl + ".");
            } else {
                try (CloudHttp2SolrClient cloudSolrClient = SolrCLI.getCloudHttp2SolrClient(zkHost);){
                    cloudSolrClient.connect();
                    Set liveNodes = cloudSolrClient.getClusterState().getLiveNodes();
                    if (liveNodes.isEmpty()) {
                        throw new IllegalStateException("No live nodes found! Cannot determine 'solrUrl' from ZooKeeper: " + zkHost);
                    }
                    String firstLiveNode = (String)liveNodes.iterator().next();
                    solrUrl = ZkStateReader.from((CloudSolrClient)cloudSolrClient).getBaseUrlForNodeName(firstLiveNode);
                    solrUrl = SolrCLI.normalizeSolrUrl(solrUrl, false);
                }
            }
        }
        return solrUrl;
    }

    public static String getZkHost(CommandLine cli) throws Exception {
        String zkHost = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "zk-host", "zkHost", null);
        if (zkHost != null && !zkHost.isBlank()) {
            return zkHost;
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            NamedList systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
            StatusTool statusTool = new StatusTool();
            Map<String, Object> status = statusTool.reportStatus((NamedList<Object>)systemInfo, solrClient);
            Map cloud = (Map)status.get("cloud");
            if (cloud != null) {
                String zookeeper = (String)cloud.get("ZooKeeper");
                if (zookeeper.endsWith("(embedded)")) {
                    zookeeper = zookeeper.substring(0, zookeeper.length() - "(embedded)".length());
                }
                zkHost = zookeeper;
            }
        }
        return zkHost;
    }

    public static SolrZkClient getSolrZkClient(CommandLine cli, String zkHost) {
        if (zkHost == null) {
            throw new IllegalStateException("Solr at " + cli.getOptionValue("solrUrl") + " is running in standalone server mode, this command can only be used when running in SolrCloud mode.\n");
        }
        return new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();
    }

    public static CloudHttp2SolrClient getCloudHttp2SolrClient(String zkHost) {
        return SolrCLI.getCloudHttp2SolrClient(zkHost, null);
    }

    public static CloudHttp2SolrClient getCloudHttp2SolrClient(String zkHost, Http2SolrClient.Builder builder) {
        return new CloudHttp2SolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).withInternalClientBuilder(builder).build();
    }

    public static boolean safeCheckCollectionExists(String solrUrl, String collection) {
        boolean exists = false;
        try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
            NamedList existsCheckResult = solrClient.request((SolrRequest)new CollectionAdminRequest.List());
            List collections = (List)existsCheckResult.get("collections");
            exists = collections != null && collections.contains(collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static boolean safeCheckCoreExists(String solrUrl, String coreName) {
        boolean exists = false;
        try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
            boolean wait = false;
            long startWaitAt = System.nanoTime();
            do {
                if (wait) {
                    int clamPeriodForStatusPollMs = 1000;
                    Thread.sleep(1000L);
                }
                NamedList existsCheckResult = CoreAdminRequest.getStatus((String)coreName, (SolrClient)solrClient).getResponse();
                NamedList status = (NamedList)existsCheckResult.get("status");
                NamedList coreStatus = (NamedList)status.get(coreName);
                Map failureStatus = (Map)existsCheckResult.get("initFailures");
                String errorMsg = (String)failureStatus.get(coreName);
                boolean hasName = coreStatus != null && coreStatus.asMap().containsKey("name");
                exists = hasName || errorMsg != null;
                boolean bl = wait = hasName && errorMsg == null && "true".equals(coreStatus.get("isLoading"));
            } while (wait && System.nanoTime() - startWaitAt < MAX_WAIT_FOR_CORE_LOAD_NANOS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static boolean isCloudMode(SolrClient solrClient) throws SolrServerException, IOException {
        NamedList systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system"));
        return "solrcloud".equals(systemInfo.get("mode"));
    }

    public static Path getConfigSetsDir(Path solrInstallDir) {
        Path configSetsPath = Paths.get("server/solr/configsets/", new String[0]);
        return solrInstallDir.resolve(configSetsPath);
    }

    public static void print(Object message) {
        SolrCLI.print(null, message);
    }

    public static void printGreen(Object message) {
        SolrCLI.print(GREEN, message);
    }

    public static void printRed(Object message) {
        SolrCLI.print(RED, message);
    }

    public static void print(String color, Object message) {
        String RESET = "\u001b[0m";
        if (color != null) {
            CLIO.out(color + String.valueOf(message) + RESET);
        } else {
            CLIO.out(String.valueOf(message));
        }
    }

    public static class AssertionFailureException
    extends Exception {
        public AssertionFailureException(String message) {
            super(message);
        }
    }
}

