/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.SolrZkClient;

public class LinkConfigTool
extends ToolBase {
    public LinkConfigTool() {
        this(CLIO.getOutStream());
    }

    public LinkConfigTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "linkconfig";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of the collection to link.").build(), Option.builder((String)"n").longOpt("conf-name").argName("NAME").hasArg().required(true).desc("Configset name in ZooKeeper.").build(), SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        String collection = cli.getOptionValue("name");
        String confName = cli.getOptionValue("conf-name");
        String zkHost = SolrCLI.getZkHost(cli);
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();){
            ZkController.linkConfSet(zkClient, collection, confName);
        }
    }
}

