/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.im;

import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.im.IMGateway;
import coldfusion.eventgateway.im.XMPPGatewayHelper;
import coldfusion.eventgateway.impl.EventServiceImpl;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import com.zion.jbuddy.IClientFactory;
import com.zion.jbuddy.IGateway;
import com.zion.jbuddy.IJabberClient;
import java.io.IOException;

public class XMPPGateway
extends IMGateway {
    private XMPPGatewayHelper helper = null;
    private String protocol = null;
    private String stRequired = null;
    private boolean isRequired = false;

    public XMPPGateway(String id, String configPath) {
        super(id, configPath, "XMPP");
        this.loadSecurityConfig();
        this.helper = new XMPPGatewayHelper(this);
    }

    @Override
    public void start() {
        this.status = 1;
        this.logger.info(RB.getString((Object)this, (String)"IMGateway.connecting", (Object)"XMPP", (Object)this.gatewayID, (Object)this.userid));
        EventServiceImpl eventService = (EventServiceImpl)ServiceFactory.getEventProcessorService();
        eventService.initializeJBuddyIMGateway();
        this.bound = false;
        this.imclient = IClientFactory.factory((IGateway)this, (int)50, (String)this.userid, (String)this.password);
        if (this.imclient != null) {
            ((IJabberClient)this.imclient).setResourceName(this.resourceName);
        }
        if (this.protocol != null && this.imclient != null) {
            if (this.protocol.equalsIgnoreCase("TLS") || this.protocol.equalsIgnoreCase("TSL")) {
                this.logger.info(RB.getString((Object)this, (String)"IMGateway.secureconnecting", (Object)"XMPP", (Object)this.gatewayID, (Object)"TLS"));
                ((IJabberClient)this.imclient).setUseXMPP(true);
                ((IJabberClient)this.imclient).setSecure(true, this.isRequired);
            } else if (this.protocol.equalsIgnoreCase("SSL")) {
                this.logger.info(RB.getString((Object)this, (String)"IMGateway.secureconnecting", (Object)"XMPP", (Object)this.gatewayID, (Object)"SSL"));
                ((IJabberClient)this.imclient).setUseXMPP(false);
                ((IJabberClient)this.imclient).setSecure(true, this.isRequired);
            } else {
                throw new IMGatewayUnknownSecureProtocolException(this.userid, this.protocol);
            }
        }
        this.connect();
    }

    private void loadSecurityConfig() {
        try {
            this.protocol = this.properties.getProperty("secureprotocol");
            this.stRequired = this.properties.getProperty("securerequirement");
            if (this.stRequired != null) {
                this.isRequired = this.stRequired != null && this.stRequired.equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            throw new IMGateway.IMGatewayUnableInitializeGatewayException("XMPPGateway", e);
        }
    }

    public void sendConfigToServer() {
        try {
            ((IJabberClient)this.imclient).sendConfigToServer();
        }
        catch (IOException e) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"sendConfigToServer", (Object)e.getMessage()));
        }
    }

    @Override
    public GatewayHelper getHelper() {
        return this.helper;
    }

    public class IMGatewayUnknownSecureProtocolException
    extends ApplicationException {
        public String userid = null;
        public String protocol = null;

        public IMGatewayUnknownSecureProtocolException(String userid, String protocol) {
            this.userid = userid;
            this.protocol = protocol;
        }
    }
}

