/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.http;

import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptorChain;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@NotThreadSafe
@SdkProtectedApi
public final class ExecutionContext
implements ToCopyableBuilder<Builder, ExecutionContext> {
    private final Signer signer;
    private InterceptorContext interceptorContext;
    private final ExecutionInterceptorChain interceptorChain;
    private final ExecutionAttributes executionAttributes;

    private ExecutionContext(Builder builder) {
        this.signer = (Signer)Validate.paramNotNull((Object)builder.signer, (String)"signer");
        this.interceptorContext = (InterceptorContext)Validate.paramNotNull((Object)builder.interceptorContext, (String)"interceptorContext");
        this.interceptorChain = (ExecutionInterceptorChain)Validate.paramNotNull((Object)builder.interceptorChain, (String)"interceptorChain");
        this.executionAttributes = (ExecutionAttributes)Validate.paramNotNull((Object)builder.executionAttributes, (String)"executionAttributes");
    }

    public static Builder builder() {
        return new Builder();
    }

    public InterceptorContext interceptorContext() {
        return this.interceptorContext;
    }

    public ExecutionContext interceptorContext(InterceptorContext interceptorContext) {
        this.interceptorContext = interceptorContext;
        return this;
    }

    public ExecutionInterceptorChain interceptorChain() {
        return this.interceptorChain;
    }

    public ExecutionAttributes executionAttributes() {
        return this.executionAttributes;
    }

    public Signer signer() {
        return this.signer;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    implements CopyableBuilder<Builder, ExecutionContext> {
        private InterceptorContext interceptorContext;
        private ExecutionInterceptorChain interceptorChain;
        private ExecutionAttributes executionAttributes;
        private Signer signer;

        private Builder() {
        }

        public Builder(ExecutionContext executionContext) {
            this.signer = executionContext.signer;
            this.interceptorContext = executionContext.interceptorContext;
            this.interceptorChain = executionContext.interceptorChain;
            this.executionAttributes = executionContext.executionAttributes;
        }

        public Builder interceptorContext(InterceptorContext interceptorContext) {
            this.interceptorContext = interceptorContext;
            return this;
        }

        public Builder interceptorChain(ExecutionInterceptorChain interceptorChain) {
            this.interceptorChain = interceptorChain;
            return this;
        }

        public Builder executionAttributes(ExecutionAttributes executionAttributes) {
            this.executionAttributes = executionAttributes;
            return this;
        }

        public Builder signer(Signer signer) {
            this.signer = signer;
            return this;
        }

        public ExecutionContext build() {
            return new ExecutionContext(this);
        }
    }
}

