/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.endpointdiscovery;

import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryEndpoint;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class EndpointDiscoveryRefreshCache {
    private static final Logger log = Logger.loggerFor(EndpointDiscoveryRefreshCache.class);
    private final Map<String, EndpointDiscoveryEndpoint> cache = new ConcurrentHashMap<String, EndpointDiscoveryEndpoint>();
    private final EndpointDiscoveryCacheLoader client;

    private EndpointDiscoveryRefreshCache(EndpointDiscoveryCacheLoader client) {
        this.client = client;
    }

    public static EndpointDiscoveryRefreshCache create(EndpointDiscoveryCacheLoader client) {
        return new EndpointDiscoveryRefreshCache(client);
    }

    public URI get(String accessKey, EndpointDiscoveryRequest request) {
        EndpointDiscoveryEndpoint endpoint;
        String key = accessKey;
        if (request.cacheKey().isPresent()) {
            key = key + ":" + request.cacheKey().get();
        }
        if ((endpoint = this.cache.get(key)) == null) {
            if (request.required()) {
                return this.cache.computeIfAbsent(key, k -> this.discoverEndpoint(request).join()).endpoint();
            }
            EndpointDiscoveryEndpoint tempEndpoint = EndpointDiscoveryEndpoint.builder().endpoint(request.defaultEndpoint()).expirationTime(Instant.now().plusSeconds(60L)).build();
            return this.cache.computeIfAbsent(key, k -> tempEndpoint).endpoint();
        }
        if (endpoint.expirationTime().isBefore(Instant.now())) {
            this.cache.put(key, endpoint.toBuilder().expirationTime(Instant.now().plusSeconds(60L)).build());
            String finalKey = key;
            this.discoverEndpoint(request).thenApply(v -> this.cache.put(finalKey, (EndpointDiscoveryEndpoint)v));
        }
        return endpoint.endpoint();
    }

    public CompletableFuture<EndpointDiscoveryEndpoint> discoverEndpoint(EndpointDiscoveryRequest request) {
        return this.client.discoverEndpoint(request);
    }

    public void evict(String key) {
        this.cache.remove(key);
    }
}

