/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.client.builder;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.core.client.config.ClientAsyncConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkAsyncHttpClientBuilder;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkHttpClientBuilder;
import software.amazon.awssdk.core.internal.util.UserAgentUtils;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public abstract class SdkDefaultClientBuilder<B extends SdkClientBuilder<B, C>, C>
implements SdkClientBuilder<B, C> {
    private static final SdkHttpClient.Builder DEFAULT_HTTP_CLIENT_BUILDER = new DefaultSdkHttpClientBuilder();
    private static final SdkAsyncHttpClient.Builder DEFAULT_ASYNC_HTTP_CLIENT_BUILDER = new DefaultSdkAsyncHttpClientBuilder();
    protected final SdkClientConfiguration.Builder clientConfiguration = SdkClientConfiguration.builder();
    private final SdkHttpClient.Builder defaultHttpClientBuilder;
    private final SdkAsyncHttpClient.Builder defaultAsyncHttpClientBuilder;
    private SdkHttpClient.Builder httpClientBuilder;
    private SdkAsyncHttpClient.Builder asyncHttpClientBuilder;

    protected SdkDefaultClientBuilder() {
        this(DEFAULT_HTTP_CLIENT_BUILDER, DEFAULT_ASYNC_HTTP_CLIENT_BUILDER);
    }

    @SdkTestInternalApi
    protected SdkDefaultClientBuilder(SdkHttpClient.Builder defaultHttpClientBuilder, SdkAsyncHttpClient.Builder defaultAsyncHttpClientBuilder) {
        this.defaultHttpClientBuilder = defaultHttpClientBuilder;
        this.defaultAsyncHttpClientBuilder = defaultAsyncHttpClientBuilder;
    }

    public final C build() {
        return this.buildClient();
    }

    protected abstract C buildClient();

    protected final SdkClientConfiguration syncClientConfiguration() {
        SdkClientConfiguration configuration = this.clientConfiguration.build();
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeSyncConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        return configuration;
    }

    protected final SdkClientConfiguration asyncClientConfiguration() {
        SdkClientConfiguration configuration = this.clientConfiguration.build();
        configuration = this.mergeChildDefaults(configuration);
        configuration = this.mergeGlobalDefaults(configuration);
        configuration = this.finalizeChildConfiguration(configuration);
        configuration = this.finalizeAsyncConfiguration(configuration);
        configuration = this.finalizeConfiguration(configuration);
        return configuration;
    }

    protected SdkClientConfiguration mergeChildDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    private SdkClientConfiguration mergeGlobalDefaults(SdkClientConfiguration configuration) {
        return configuration.merge(c -> c.option(SdkClientOption.EXECUTION_INTERCEPTORS, new ArrayList()).option(SdkClientOption.ADDITIONAL_HTTP_HEADERS, new LinkedHashMap()).option(SdkClientOption.RETRY_POLICY, RetryPolicy.defaultRetryPolicy()).option(SdkAdvancedClientOption.USER_AGENT_PREFIX, UserAgentUtils.getUserAgent()).option(SdkAdvancedClientOption.USER_AGENT_SUFFIX, "").option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false));
    }

    protected SdkClientConfiguration finalizeChildConfiguration(SdkClientConfiguration configuration) {
        return configuration;
    }

    private SdkClientConfiguration finalizeSyncConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().option(SdkClientOption.SYNC_HTTP_CLIENT, this.resolveSyncHttpClient(config)).option(SdkClientOption.CLIENT_TYPE, ClientType.SYNC).build();
    }

    private SdkClientConfiguration finalizeAsyncConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, this.resolveAsyncFutureCompletionExecutor(config)).option(SdkClientOption.ASYNC_HTTP_CLIENT, this.resolveAsyncHttpClient(config)).option(SdkClientOption.CLIENT_TYPE, ClientType.ASYNC).build();
    }

    private SdkClientConfiguration finalizeConfiguration(SdkClientConfiguration config) {
        return config.toBuilder().option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE, this.resolveScheduledExecutorService()).option(SdkClientOption.EXECUTION_INTERCEPTORS, this.resolveExecutionInterceptors(config)).build();
    }

    private SdkHttpClient resolveSyncHttpClient(SdkClientConfiguration config) {
        Validate.isTrue((config.option(SdkClientOption.SYNC_HTTP_CLIENT) == null || this.httpClientBuilder == null ? 1 : 0) != 0, (String)"The httpClient and the httpClientBuilder can't both be configured.", (Object[])new Object[0]);
        return Either.fromNullable((Object)config.option(SdkClientOption.SYNC_HTTP_CLIENT), (Object)this.httpClientBuilder).map(e -> (SdkHttpClient)e.map(x$0 -> new NonManagedSdkHttpClient((SdkHttpClient)x$0), b -> b.buildWithDefaults(this.childHttpConfig()))).orElseGet(() -> this.defaultHttpClientBuilder.buildWithDefaults(this.childHttpConfig()));
    }

    private SdkAsyncHttpClient resolveAsyncHttpClient(SdkClientConfiguration config) {
        Validate.isTrue((config.option(SdkClientOption.ASYNC_HTTP_CLIENT) == null || this.asyncHttpClientBuilder == null ? 1 : 0) != 0, (String)"The asyncHttpClient and the asyncHttpClientBuilder can't both be configured.", (Object[])new Object[0]);
        return Either.fromNullable((Object)config.option(SdkClientOption.ASYNC_HTTP_CLIENT), (Object)this.asyncHttpClientBuilder).map(e -> (SdkAsyncHttpClient)e.map(NonManagedSdkAsyncHttpClient::new, b -> b.buildWithDefaults(this.childHttpConfig()))).orElseGet(() -> this.defaultAsyncHttpClientBuilder.buildWithDefaults(this.childHttpConfig()));
    }

    protected AttributeMap childHttpConfig() {
        return AttributeMap.empty();
    }

    private Executor resolveAsyncFutureCompletionExecutor(SdkClientConfiguration config) {
        Supplier<Executor> defaultExecutor = () -> {
            int processors = Runtime.getRuntime().availableProcessors();
            int corePoolSize = Math.max(8, processors);
            int maxPoolSize = Math.max(64, processors * 2);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("sdk-async-response").build());
            executor.allowCoreThreadTimeOut(true);
            return executor;
        };
        return Optional.ofNullable(config.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR)).orElseGet(defaultExecutor);
    }

    private ScheduledExecutorService resolveScheduledExecutorService() {
        return Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().threadNamePrefix("sdk-ScheduledExecutor").build());
    }

    private List<ExecutionInterceptor> resolveExecutionInterceptors(SdkClientConfiguration config) {
        List<ExecutionInterceptor> globalInterceptors = new ClasspathInterceptorChainFactory().getGlobalInterceptors();
        return CollectionUtils.mergeLists(globalInterceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
    }

    @Override
    public final B endpointOverride(URI endpointOverride) {
        Validate.paramNotNull((Object)endpointOverride, (String)"endpointOverride");
        Validate.paramNotNull((Object)endpointOverride.getScheme(), (String)"The URI scheme of endpointOverride");
        this.clientConfiguration.option(SdkClientOption.ENDPOINT, endpointOverride);
        return this.thisBuilder();
    }

    public final void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride(endpointOverride);
    }

    public final B asyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
        this.clientConfiguration.option(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, asyncConfiguration.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR));
        return this.thisBuilder();
    }

    public final void setAsyncConfiguration(ClientAsyncConfiguration asyncConfiguration) {
        this.asyncConfiguration(asyncConfiguration);
    }

    @Override
    public final B overrideConfiguration(ClientOverrideConfiguration overrideConfig) {
        this.clientConfiguration.option(SdkClientOption.EXECUTION_INTERCEPTORS, overrideConfig.executionInterceptors());
        this.clientConfiguration.option(SdkClientOption.RETRY_POLICY, overrideConfig.retryPolicy().orElse(null));
        this.clientConfiguration.option(SdkClientOption.ADDITIONAL_HTTP_HEADERS, overrideConfig.headers());
        this.clientConfiguration.option(SdkAdvancedClientOption.SIGNER, overrideConfig.advancedOption(SdkAdvancedClientOption.SIGNER).orElse(null));
        this.clientConfiguration.option(SdkAdvancedClientOption.USER_AGENT_SUFFIX, overrideConfig.advancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX).orElse(null));
        this.clientConfiguration.option(SdkAdvancedClientOption.USER_AGENT_PREFIX, overrideConfig.advancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX).orElse(null));
        this.clientConfiguration.option(SdkClientOption.API_CALL_TIMEOUT, overrideConfig.apiCallTimeout().orElse(null));
        this.clientConfiguration.option(SdkClientOption.API_CALL_ATTEMPT_TIMEOUT, overrideConfig.apiCallAttemptTimeout().orElse(null));
        this.clientConfiguration.option(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION, overrideConfig.advancedOption(SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION).orElse(null));
        return this.thisBuilder();
    }

    public final void setOverrideConfiguration(ClientOverrideConfiguration overrideConfiguration) {
        this.overrideConfiguration(overrideConfiguration);
    }

    public final B httpClient(SdkHttpClient httpClient) {
        this.clientConfiguration.option(SdkClientOption.SYNC_HTTP_CLIENT, httpClient);
        return this.thisBuilder();
    }

    public final B httpClientBuilder(SdkHttpClient.Builder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        return this.thisBuilder();
    }

    public final B httpClient(SdkAsyncHttpClient httpClient) {
        this.clientConfiguration.option(SdkClientOption.ASYNC_HTTP_CLIENT, httpClient);
        return this.thisBuilder();
    }

    public final B httpClientBuilder(SdkAsyncHttpClient.Builder httpClientBuilder) {
        this.asyncHttpClientBuilder = httpClientBuilder;
        return this.thisBuilder();
    }

    protected B thisBuilder() {
        return (B)this;
    }

    @SdkTestInternalApi
    public static final class NonManagedSdkAsyncHttpClient
    implements SdkAsyncHttpClient {
        private final SdkAsyncHttpClient delegate;

        NonManagedSdkAsyncHttpClient(SdkAsyncHttpClient delegate) {
            this.delegate = (SdkAsyncHttpClient)Validate.paramNotNull((Object)delegate, (String)"SdkAsyncHttpClient");
        }

        public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
            return this.delegate.execute(request);
        }

        public void close() {
        }
    }

    @SdkTestInternalApi
    public static final class NonManagedSdkHttpClient
    implements SdkHttpClient {
        private final SdkHttpClient delegate;

        private NonManagedSdkHttpClient(SdkHttpClient delegate) {
            this.delegate = (SdkHttpClient)Validate.paramNotNull((Object)delegate, (String)"SdkHttpClient");
        }

        public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
            return this.delegate.prepareRequest(request);
        }

        public void close() {
        }

        public String clientName() {
            return this.delegate.clientName();
        }
    }
}

