/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.FileOutputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkingWithPageSetup {
    public static void main(String[] args) throws Exception {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            Sheet sheet1 = wb.createSheet("new sheet");
            Sheet sheet2 = wb.createSheet("second sheet");
            Row row1 = sheet1.createRow(0);
            row1.createCell(0).setCellValue(1.0);
            row1.createCell(1).setCellValue(2.0);
            row1.createCell(2).setCellValue(3.0);
            Row row2 = sheet1.createRow(1);
            row2.createCell(1).setCellValue(4.0);
            row2.createCell(2).setCellValue(5.0);
            Row row3 = sheet2.createRow(1);
            row3.createCell(0).setCellValue(2.1);
            row3.createCell(4).setCellValue(2.2);
            row3.createCell(5).setCellValue(2.3);
            Row row4 = sheet2.createRow(2);
            row4.createCell(4).setCellValue(2.4);
            row4.createCell(5).setCellValue(2.5);
            sheet1.setRepeatingColumns(CellRangeAddress.valueOf("A:C"));
            CellRangeAddress cra = CellRangeAddress.valueOf("E2:F3");
            sheet2.setRepeatingColumns(cra);
            sheet2.setRepeatingRows(cra);
            wb.setPrintArea(0, 1, 2, 0, 3);
            try (FileOutputStream fileOut = new FileOutputStream("xssf-printsetup.xlsx");){
                wb.write(fileOut);
            }
        }
    }
}

