/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.streaming;

import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.DeferredSXSSFSheet;
import org.apache.poi.xssf.streaming.DeferredSXSSFWorkbook;
import org.apache.poi.xssf.streaming.SXSSFRow;

public class DeferredGeneration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try (DeferredSXSSFWorkbook wb = new DeferredSXSSFWorkbook();){
            DeferredSXSSFSheet sheet1 = wb.createSheet("new sheet");
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            sheet1.setRowGenerator(ssxSheet -> {
                for (int i = 0; i < 10; ++i) {
                    SXSSFRow row = ssxSheet.createRow(i);
                    Cell cell = row.createCell(1);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue("value " + i);
                }
            });
            try (FileOutputStream fileOut = new FileOutputStream("DeferredGeneration.xlsx");){
                wb.write(fileOut);
            }
            finally {
                wb.dispose();
            }
            System.out.println("wrote DeferredGeneration.xlsx");
        }
    }
}

