/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hssf.usermodel;

import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class CellComments {
    public static void main(String[] args) throws IOException {
        CellComments.createWorkbook(false, ".xls");
        CellComments.createWorkbook(true, ".xlsx");
    }

    private static void createWorkbook(boolean xssf, String extension) throws IOException {
        try (Workbook wb = WorkbookFactory.create(xssf);){
            Sheet sheet = wb.createSheet("Cell comments in POI " + extension);
            CreationHelper creationHelper = wb.getCreationHelper();
            Drawing<?> patr = sheet.createDrawingPatriarch();
            Cell cell1 = sheet.createRow(3).createCell(1);
            cell1.setCellValue(creationHelper.createRichTextString("Hello, World"));
            ClientAnchor clientAnchor = creationHelper.createClientAnchor();
            clientAnchor.setCol1(4);
            clientAnchor.setRow1(2);
            clientAnchor.setCol2(6);
            clientAnchor.setRow2(5);
            Comment comment1 = patr.createCellComment(clientAnchor);
            comment1.setString(creationHelper.createRichTextString("We can set comments in POI"));
            comment1.setAuthor("Apache Software Foundation");
            cell1.setCellComment(comment1);
            Cell cell2 = sheet.createRow(6).createCell(1);
            cell2.setCellValue(36.6);
            clientAnchor = creationHelper.createClientAnchor();
            clientAnchor.setCol1(4);
            clientAnchor.setRow1(8);
            clientAnchor.setCol2(6);
            clientAnchor.setRow2(11);
            Comment comment2 = patr.createCellComment(clientAnchor);
            if (wb instanceof HSSFWorkbook) {
                ((HSSFComment)comment2).setFillColor(204, 236, 255);
            }
            RichTextString string = creationHelper.createRichTextString("Normal body temperature");
            Font font = wb.createFont();
            font.setFontName("Arial");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            font.setColor(IndexedColors.RED.getIndex());
            string.applyFont(font);
            comment2.setString(string);
            comment2.setVisible(true);
            comment2.setAuthor("Bill Gates");
            comment2.setRow(6);
            comment2.setColumn(1);
            try (FileOutputStream out = new FileOutputStream("poi_comment" + extension);){
                wb.write(out);
            }
        }
    }
}

