/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.utils;

import coldfusion.cloud.gcp.model.PubSubMessageWrapper;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.TemplateProxy;
import coldfusion.util.RB;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PubSubMessageSerializer {
    private static final short STREAM_MAGIC = -21267;
    private static final short STREAM_VERSION = 5;

    public static ByteString serialize(Object messageData) {
        return PubSubMessageSerializer.serialize(messageData, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ByteString serialize(Object messageData, boolean serializeCFC) {
        if (messageData == null) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"MESSAGE_DATA_NULL_EMPTY"));
        }
        if (messageData instanceof String) {
            return ByteString.copyFromUtf8((String)((String)messageData));
        }
        if (messageData instanceof byte[]) {
            return ByteString.copyFrom((byte[])((byte[])messageData));
        }
        messageData = PubSubMessageSerializer.handleCFTypes(messageData, serializeCFC);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteString byteString;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(messageData);
                oos.flush();
                byteString = ByteString.copyFrom((byte[])bos.toByteArray());
            }
            return byteString;
        }
        catch (IOException e) {
            throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"MESSAGE_SERIALIZATION_ERROR"), e);
        }
    }

    private static Object handleCFTypes(Object messageData, boolean serializeCFC) {
        if (messageData instanceof TemplateProxy) {
            PubSubMessageWrapper wrapper = new PubSubMessageWrapper();
            wrapper.setType("TemplateProxy");
            String serializedCFC = JSONUtils.serializeJSON((Object)messageData, (Object)"struct", (boolean)false, (boolean)true, (boolean)serializeCFC);
            wrapper.setData(serializedCFC);
            messageData = wrapper;
        }
        return messageData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(ByteString msg) {
        Object outputObject = null;
        byte[] msgBytes = null;
        if (msg == null) return outputObject;
        msgBytes = msg.toByteArray();
        try (ByteArrayInputStream msgBytesInputStream = new ByteArrayInputStream(msgBytes);){
            if (msgBytes.length > 4 && PubSubMessageSerializer.validateStreamHeader(msgBytesInputStream)) {
                msgBytesInputStream.reset();
                try (ObjectInputStream input = new ObjectInputStream(msgBytesInputStream);){
                    outputObject = input.readObject();
                    return outputObject;
                }
                catch (ClassNotFoundException e) {
                    throw new PubSubException(e.getMessage(), e);
                }
            }
            String string = msg.toStringUtf8();
            return string;
        }
        catch (IOException e) {
            return msg.toStringUtf8();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean validateStreamHeader(InputStream inputStream) {
        try (DataInputStream dis = new DataInputStream(inputStream);){
            short streamHeader = dis.readShort();
            short streamVersion = dis.readShort();
            if (streamHeader == -21267) {
                if (streamVersion == 5) return true;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new PubSubException(e.getMessage(), e);
        }
    }
}

