/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.handlers;

import coldfusion.cloud.Executor;
import coldfusion.cloud.gcp.pubsub.exception.PubSubApiException;
import coldfusion.cloud.gcp.pubsub.exception.PubSubException;
import coldfusion.cloud.gcp.pubsub.impl.PubSubClientImpl;
import coldfusion.cloud.gcp.pubsub.model.BasicPubSubMessage;
import coldfusion.cloud.gcp.pubsub.utils.PubSubMessageSerializer;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Closure;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Scope;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.CallableUDFMethod;
import coldfusion.util.RB;
import com.google.api.core.ApiFunction;
import com.google.api.gax.rpc.ApiException;
import com.google.pubsub.v1.PubsubMessage;
import java.util.concurrent.Future;

public class MessageTransformerHandler {
    private NeoPageContext pageContext;
    private FusionContext fusionContext;
    private ApiFunction<PubsubMessage, PubsubMessage> apiFunction;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public MessageTransformerHandler(final Closure messageTransformer, FusionContext fcontext, final NeoPageContext pageContext, final RequestMonitorData rmd) {
        try {
            this.fusionContext = (FusionContext)fcontext.clone();
            this.fusionContext.hiddenScope = (Scope)fcontext.hiddenScope.clone();
            this.pageContext = (NeoPageContext)pageContext.clone();
            this.pageContext.setFusionContext(this.fusionContext);
        }
        catch (Exception e) {
            this.pageContext = pageContext;
            this.fusionContext = fcontext;
        }
        this.apiFunction = new ApiFunction<PubsubMessage, PubsubMessage>(){

            public PubsubMessage apply(PubsubMessage pubsubMessage) {
                try {
                    Object[] args = new Object[]{PubSubServiceUtils.deserialize(new BasicPubSubMessage(pubsubMessage))};
                    CallableUDFMethod callable = new CallableUDFMethod((UDFMethod)messageTransformer, args, MessageTransformerHandler.this.fusionContext, pageContext, rmd);
                    Future submit = Executor.getInstance().submit(callable);
                    Struct modifiedMsg = (Struct)submit.get();
                    PubsubMessage.Builder pubsubMessageBuilder = PubsubMessage.newBuilder();
                    pubsubMessageBuilder.setData(PubSubMessageSerializer.serialize(modifiedMsg.get((Object)"data")));
                    pubsubMessageBuilder.putAllAttributes(MessageTransformerHandler.this.cast.getStringStringMapFromStringObjectMapProperty(modifiedMsg.get((Object)"attributes")));
                    pubsubMessageBuilder.setOrderingKey((String)modifiedMsg.get((Object)"orderingKey"));
                    return pubsubMessageBuilder.build();
                }
                catch (ApiException apiException) {
                    throw new PubSubApiException(apiException.getMessage(), apiException);
                }
                catch (Throwable throwable) {
                    throw new PubSubException(RB.getString(PubSubClientImpl.class, (String)"MESSAGE_TRANSFORMER_HANDLER_ERROR"), throwable);
                }
            }
        };
    }

    public ApiFunction<PubsubMessage, PubsubMessage> getMessageHandler() {
        return this.apiFunction;
    }
}

