/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.pubsub.consumer;

import coldfusion.cloud.gcp.pubsub.consumer.ExecutorProviderRequestConsumer;
import coldfusion.cloud.gcp.pubsub.consumer.FlowControlSettingsRequestConsumer;
import coldfusion.cloud.gcp.pubsub.request.ExecutorProviderRequest;
import coldfusion.cloud.gcp.pubsub.request.FlowControlSettingsRequest;
import coldfusion.cloud.gcp.pubsub.request.SubscriberSettingsRequest;
import coldfusion.cloud.gcp.pubsub.utils.PubSubServiceUtils;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.CFPositiveIntegerValidator;
import coldfusion.cloud.validator.CFStructValidator;
import java.time.Duration;
import java.util.Collections;

public enum SubscriberSettingsRequestConsumer {
    INSTANCE;

    private static final long serialVersionUID = 1L;
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private ConsumerMap<SubscriberSettingsRequest> consumerMap = new ConsumerMap();

    private SubscriberSettingsRequestConsumer() {
        this.consumerMap.put((Object)"endpoint", new ConsumerValidator((subscriberSettingsRequest, value) -> subscriberSettingsRequest.setEndpoint(this.cast.getStringProperty(value)), Collections.emptyList()));
        this.consumerMap.put((Object)"executorProvider", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            ExecutorProviderRequest executorProvider = new ExecutorProviderRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)executorProvider, this.cast.getMapProperty(value, "executorProvider"), ExecutorProviderRequestConsumer.INSTANCE.getConsumerMap());
            subscriberSettingsRequest.setExecutorProvider(executorProvider);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"systemExecutorProvider", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            ExecutorProviderRequest systemExecutorProvider = new ExecutorProviderRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)systemExecutorProvider, this.cast.getMapProperty(value, "systemExecutorProvider"), ExecutorProviderRequestConsumer.INSTANCE.getConsumerMap());
            subscriberSettingsRequest.setSystemExecutorProvider(systemExecutorProvider);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"flowControlSettings", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            FlowControlSettingsRequest flowControlSettings = new FlowControlSettingsRequest();
            ValidatorFiller.INSTANCE.fillObject((Object)flowControlSettings, this.cast.getMapProperty(value, "flowControlSettings"), FlowControlSettingsRequestConsumer.INSTANCE.getConsumerMap());
            subscriberSettingsRequest.setFlowControlSettings(flowControlSettings);
        }, Collections.singletonList(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"maxAckExtensionPeriod", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                Duration duration = this.cast.getDurationProperty(value, "maxAckExtensionPeriod");
                subscriberSettingsRequest.setMaxAckExtensionPeriod(duration);
            }
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"minDurationPerAckExtensionPeriod", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                Duration duration = this.cast.getDurationProperty(value, "minDurationPerAckExtensionPeriod");
                subscriberSettingsRequest.setMinDurationPerAckExtensionPeriod(duration);
            }
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"maxDurationPerAckExtensionPeriod", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                Duration duration = this.cast.getDurationProperty(value, "maxDurationPerAckExtensionPeriod");
                subscriberSettingsRequest.setMaxDurationPerAckExtensionPeriod(duration);
            }
        }, Collections.emptyList()));
        this.consumerMap.put((Object)"parallelPullCount", new ConsumerValidator((subscriberSettingsRequest, value) -> {
            if (!PubSubServiceUtils.isNullOrEmpty(value)) {
                subscriberSettingsRequest.setParallelPullCount(this.cast.getIntegerProperty(value));
            }
        }, Collections.singletonList(new CFPositiveIntegerValidator("parallelPullCount"))));
        this.consumerMap.put((Object)"useLegacyFlowControl", new ConsumerValidator((subscriberSettingsRequest, value) -> subscriberSettingsRequest.setUseLegacyFlowControl(this.cast.getBooleanProperty(value)), Collections.singletonList(CFBooleanValidator.INSTANCE)));
    }

    public ConsumerMap<SubscriberSettingsRequest> getConsumerMap() {
        return this.consumerMap;
    }
}

