/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.fill.TextMeasurer;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.SAXException;

public class JRDesignViewer
extends JPanel {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_DESIGN = 3;
    private static final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    private JRReport report = null;
    private float zoom = 1.0f;
    private int screenResolution = 72;
    private float realZoom = 0.0f;
    private int offsetY = 0;
    private int upColumns = 0;
    private int downColumns = 0;
    private int downX = 0;
    private int downY = 0;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected TextRenderer textRenderer = new TextRenderer();
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final double ONE_POINT_CORNER_OFFSET = 0.5;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    private static final Stroke BORDER_STROKE_THIN = new BasicStroke(0.5f, 0, 0);
    private static final Stroke BORDER_STROKE_1_POINT = new BasicStroke(1.0f, 0, 0);
    private static final Stroke BORDER_STROKE_DOTTED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    protected JPanel tlbToolBar;
    private JPanel pnlInScroll;
    private JPanel jPanel4;
    private JPanel pnlPage;
    private JLabel jLabel1;
    private JScrollPane scrollPane;
    private JPanel pnlMain;
    private JPanel pnlSep02;
    private JButton btnReload;
    private JPanel jPanel5;
    private JButton btnZoomOut;
    private JLabel lblPage;
    private JPanel jPanel8;
    private JButton btnZoomIn;
    private JPanel jPanel7;
    private JPanel pnlSep01;
    private JPanel jPanel6;
    private JComboBox cmbZoom;
    private JPanel jPanel9;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(fileName, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(is, isXML);
        this.cmbZoom.setSelectedIndex(2);
    }

    public JRDesignViewer(JRReport report) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.setScreenDetails();
        this.initComponents();
        this.loadReport(report);
        this.cmbZoom.setSelectedIndex(2);
    }

    private void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        this.setZoom(1.0f);
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.pnlSep02 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<CallSite> model = new DefaultComboBoxModel<CallSite>();
        for (int i = 0; i < zooms.length; ++i) {
            model.addElement((CallSite)((Object)(zooms[i] + "%")));
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.setLayout(new BorderLayout());
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setText("Reload");
        this.btnReload.setToolTipText("Reload Document");
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(80, 23));
        this.btnReload.setMinimumSize(new Dimension(80, 23));
        this.btnReload.setPreferredSize(new Dimension(80, 23));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnReloadActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText("Zoom In");
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomInActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText("Zoom Out");
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.btnZoomOutActionPerformed();
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setToolTipText("Zoom Ratio");
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRDesignViewer.this.cmbZoomActionPerformed();
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        this.lblPage.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JRDesignViewer.this.lblPageMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseReleased();
            }
        });
        this.lblPage.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JRDesignViewer.this.lblPageMouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
    }

    void btnReloadActionPerformed() {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.refreshDesign();
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    void btnZoomInActionPerformed() {
        int index = this.cmbZoom.getSelectedIndex();
        if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.cmbZoom.setSelectedIndex(index + 1);
        }
    }

    void btnZoomOutActionPerformed() {
        int index = this.cmbZoom.getSelectedIndex();
        if (index > 0) {
            this.cmbZoom.setSelectedIndex(index - 1);
        }
    }

    void lblPageMousePressed(MouseEvent evt) {
        this.lblPage.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    void lblPageMouseReleased() {
        this.lblPage.setCursor(new Cursor(0));
    }

    void lblPageMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    void cmbZoomActionPerformed() {
        int index = this.cmbZoom.getSelectedIndex();
        this.setZoom((float)zooms[index] / 100.0f);
        this.btnZoomIn.setEnabled(index < this.cmbZoom.getModel().getSize() - 1);
        this.btnZoomOut.setEnabled(index > 0);
        this.refreshDesign();
    }

    private void setZoom(float zoom) {
        this.zoom = zoom;
        this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report definition not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
    }

    private void loadReport(String fileName, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(fileName));
        }
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
        this.setOffsetY();
        this.btnReload.setEnabled(true);
    }

    private void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(is));
        }
        this.type = 2;
        this.isXML = isXmlReport;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    private void loadReport(JRReport rep) throws JRException {
        this.setReport(rep);
        this.type = 3;
        this.isXML = false;
        this.setOffsetY();
        this.btnReload.setEnabled(false);
    }

    private void setReport(JRReport report) throws JRException {
        if (report instanceof JasperDesign) {
            this.verifyDesign((JasperDesign)report);
        }
        this.report = report;
    }

    public void setOffsetY() {
        int i;
        this.offsetY = this.report.getTopMargin();
        this.offsetY += this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0;
        this.offsetY += this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0;
        this.upColumns = this.offsetY;
        this.offsetY += this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0;
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                group = groups[i];
                this.offsetY += group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0;
        if (groups != null && groups.length > 0) {
            for (i = groups.length - 1; i >= 0; --i) {
                group = groups[i];
                this.offsetY += group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0;
            }
        }
        this.offsetY += this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0;
        this.downColumns = this.offsetY;
        this.offsetY += this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0;
        this.offsetY += this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0;
        this.offsetY += this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0;
        this.offsetY += this.report.getBottomMargin();
    }

    private void refreshDesign() {
        Image image = null;
        ImageIcon imageIcon = null;
        Dimension dim = new Dimension((int)((float)this.report.getPageWidth() * this.realZoom) + 8, (int)((float)this.offsetY * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        try {
            image = this.printDesignToImage();
            imageIcon = new ImageIcon(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lblPage.setIcon(imageIcon);
    }

    private Image printDesignToImage() {
        BufferedImage designImage = new BufferedImage((int)((float)this.report.getPageWidth() * this.realZoom) + 1, (int)((float)this.offsetY * this.realZoom) + 1, 1);
        Graphics2D grx = (Graphics2D)((Image)designImage).getGraphics();
        grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(this.realZoom, this.realZoom);
        grx.transform(atrans);
        this.printDesign(grx);
        grx.dispose();
        return designImage;
    }

    private void printDesign(Graphics2D grx) {
        int i;
        BasicStroke dashedStroke = new BasicStroke(1.0f / this.realZoom, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        Color dashedColor = new Color(170, 170, 255);
        grx.setColor(Color.white);
        grx.fillRect(0, 0, this.report.getPageWidth() + 1, this.offsetY + 1);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(this.report.getLeftMargin(), 0, this.report.getLeftMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getPageWidth() - this.report.getRightMargin(), 0, this.report.getPageWidth() - this.report.getRightMargin(), this.offsetY + 1);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth(), this.downColumns);
        grx.drawLine(this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.upColumns, this.report.getLeftMargin() + this.report.getColumnWidth() + this.report.getColumnSpacing(), this.downColumns);
        grx.translate(this.report.getLeftMargin(), this.report.getTopMargin());
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getTitle(), grx);
        grx.translate(0, this.report.getTitle() != null ? this.report.getTitle().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageHeader(), grx);
        grx.translate(0, this.report.getPageHeader() != null ? this.report.getPageHeader().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnHeader(), grx);
        grx.translate(0, this.report.getColumnHeader() != null ? this.report.getColumnHeader().getHeight() : 0);
        JRGroup group = null;
        JRGroup[] groups = this.report.getGroups();
        if (groups != null && groups.length > 0) {
            for (i = 0; i < groups.length; ++i) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupHeader(), grx);
                grx.translate(0, group.getGroupHeader() != null ? group.getGroupHeader().getHeight() : 0);
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getDetail(), grx);
        grx.translate(0, this.report.getDetail() != null ? this.report.getDetail().getHeight() : 0);
        if (groups != null && groups.length > 0) {
            for (i = groups.length - 1; i >= 0; --i) {
                group = groups[i];
                grx.setStroke(dashedStroke);
                grx.setColor(dashedColor);
                grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
                grx.setColor(Color.black);
                grx.setStroke(new BasicStroke(1.0f));
                this.printBand(group.getGroupFooter(), grx);
                grx.translate(0, group.getGroupFooter() != null ? group.getGroupFooter().getHeight() : 0);
            }
        }
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getColumnFooter(), grx);
        grx.translate(0, this.report.getColumnFooter() != null ? this.report.getColumnFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getPageFooter(), grx);
        grx.translate(0, this.report.getPageFooter() != null ? this.report.getPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getLastPageFooter(), grx);
        grx.translate(0, this.report.getLastPageFooter() != null ? this.report.getLastPageFooter().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
        grx.setColor(Color.black);
        grx.setStroke(new BasicStroke(1.0f));
        this.printBand(this.report.getSummary(), grx);
        grx.translate(0, this.report.getSummary() != null ? this.report.getSummary().getHeight() : 0);
        grx.setStroke(dashedStroke);
        grx.setColor(dashedColor);
        grx.drawLine(-this.report.getLeftMargin(), 0, this.report.getPageWidth() + 1, 0);
    }

    private void printBand(JRBand band, Graphics2D grx) {
        if (band != null) {
            this.printElements(band.getElements(), grx);
        }
    }

    protected void printElements(JRElement[] elements, Graphics2D grx) {
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element instanceof JRBreak) {
                    this.printBreak((JRBreak)element, grx);
                    continue;
                }
                if (element instanceof JRLine) {
                    this.printLine((JRLine)element, grx);
                    continue;
                }
                if (element instanceof JRRectangle) {
                    this.printRectangle((JRRectangle)element, grx);
                    continue;
                }
                if (element instanceof JREllipse) {
                    this.printEllipse((JREllipse)element, grx);
                    continue;
                }
                if (element instanceof JRImage) {
                    this.printImage((JRImage)element, grx);
                    continue;
                }
                if (element instanceof JRStaticText) {
                    this.printText((JRTextElement)element, grx);
                    continue;
                }
                if (element instanceof JRTextField) {
                    this.printText((JRTextElement)element, grx);
                    continue;
                }
                if (element instanceof JRSubreport) {
                    this.printSubreport((JRSubreport)element, grx);
                    continue;
                }
                if (element instanceof JRCrosstab) {
                    this.printCrosstab((JRCrosstab)element, grx);
                    continue;
                }
                if (!(element instanceof JRFrame)) continue;
                this.printFrame((JRFrame)element, grx);
            }
        }
    }

    private void printBreak(JRBreak breakElement, Graphics2D grx) {
        grx.setColor(breakElement.getForecolor());
        grx.setStroke(JRDesignViewer.getStroke((byte)4));
        grx.drawLine(0, breakElement.getY(), this.report.getColumnWidth(), breakElement.getY());
    }

    private void printLine(JRLine line, Graphics2D grx) {
        grx.setColor(line.getForecolor());
        Stroke stroke = JRDesignViewer.getStroke(line.getPen());
        if (stroke != null) {
            grx.setStroke(stroke);
            grx.translate(0.5, 0.5);
            if (line.getDirection() == 1) {
                grx.drawLine(line.getX(), line.getY(), line.getX() + line.getWidth() - 1, line.getY() + line.getHeight() - 1);
            } else {
                grx.drawLine(line.getX(), line.getY() + line.getHeight() - 1, line.getX() + line.getWidth() - 1, line.getY());
            }
            grx.translate(-0.5, -0.5);
        }
    }

    private void printRectangle(JRRectangle rectangle, Graphics2D grx) {
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            if (rectangle.getRadius() > 0) {
                grx.fillRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            }
        }
        grx.setColor(rectangle.getForecolor());
        byte pen = rectangle.getPen();
        Stroke stroke = JRDesignViewer.getStroke(pen);
        if (stroke != null) {
            double cornerOffset = JRDesignViewer.getBorderCornerOffset(pen);
            int sizeAdjust = JRDesignViewer.getRectangleSizeAdjust(pen);
            AffineTransform transform = grx.getTransform();
            grx.translate((double)rectangle.getX() + cornerOffset, (double)rectangle.getY() + cornerOffset);
            if (pen == 5) {
                grx.scale(((double)rectangle.getWidth() - 0.5) / (double)rectangle.getWidth(), ((double)rectangle.getHeight() - 0.5) / (double)rectangle.getHeight());
            }
            grx.setStroke(stroke);
            if (rectangle.getRadius() > 0) {
                grx.drawRoundRect(0, 0, rectangle.getWidth() - sizeAdjust, rectangle.getHeight() - sizeAdjust, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.drawRect(0, 0, rectangle.getWidth() - sizeAdjust, rectangle.getHeight() - sizeAdjust);
            }
            grx.setTransform(transform);
        }
    }

    private static double getBorderCornerOffset(byte pen) {
        switch (pen) {
            case 5: {
                return 0.25;
            }
            case 1: 
            case 4: {
                return 0.5;
            }
        }
        return 0.0;
    }

    private static int getRectangleSizeAdjust(byte pen) {
        switch (pen) {
            case 1: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private void printEllipse(JREllipse ellipse, Graphics2D grx) {
        if (ellipse.getMode() == 1) {
            grx.setColor(ellipse.getBackcolor());
            grx.fillOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
        grx.setColor(ellipse.getForecolor());
        byte pen = ellipse.getPen();
        Stroke stroke = JRDesignViewer.getStroke(pen);
        if (stroke != null) {
            double cornerOffset = JRDesignViewer.getBorderCornerOffset(pen);
            int sizeAdjust = JRDesignViewer.getRectangleSizeAdjust(pen);
            AffineTransform transform = grx.getTransform();
            grx.translate((double)ellipse.getX() + cornerOffset, (double)ellipse.getY() + cornerOffset);
            if (pen == 5) {
                grx.scale(((double)ellipse.getWidth() - 0.5) / (double)ellipse.getWidth(), ((double)ellipse.getHeight() - 0.5) / (double)ellipse.getHeight());
            }
            grx.setStroke(stroke);
            grx.drawOval(0, 0, ellipse.getWidth() - sizeAdjust, ellipse.getHeight() - sizeAdjust);
            grx.setTransform(transform);
        }
    }

    private void printImage(JRImage jrImage, Graphics2D grx) {
        if (jrImage.getMode() == 1) {
            grx.setColor(jrImage.getBackcolor());
            grx.fillRect(jrImage.getX(), jrImage.getY(), jrImage.getWidth(), jrImage.getHeight());
        }
        int topPadding = jrImage.getTopPadding();
        int leftPadding = jrImage.getLeftPadding();
        int bottomPadding = jrImage.getBottomPadding();
        int rightPadding = jrImage.getRightPadding();
        int availableImageWidth = jrImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = jrImage.getHeight() - topPadding - bottomPadding;
        int n = availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        if (availableImageWidth > 0 && availableImageHeight > 0) {
            String location;
            JRExpressionChunk firstChunk;
            Image awtImage = null;
            JRExpression jrExpression = jrImage.getExpression();
            if (jrExpression != null && jrExpression.getChunks().length == 1 && (firstChunk = jrExpression.getChunks()[0]).getType() == 1 && (location = firstChunk.getText().trim()).startsWith("\"") && location.endsWith("\"")) {
                location = location.substring(1, location.length() - 1);
                try {
                    awtImage = JRImageLoader.loadImage(JRImageLoader.loadImageDataFromLocation(location));
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
            }
            if (awtImage != null) {
                int awtWidth = awtImage.getWidth(null);
                int awtHeight = awtImage.getHeight(null);
                float xalignFactor = 0.0f;
                switch (jrImage.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (jrImage.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                switch (jrImage.getScaleImage()) {
                    case 1: {
                        int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                        int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                        Shape clip = grx.getClip();
                        grx.clipRect(jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight);
                        grx.drawImage(awtImage, jrImage.getX() + leftPadding + xoffset, jrImage.getY() + topPadding + yoffset, awtWidth, awtHeight, this);
                        grx.setClip(clip);
                        break;
                    }
                    case 2: {
                        grx.drawImage(awtImage, jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight, this);
                        break;
                    }
                    default: {
                        if (jrImage.getHeight() > 0) {
                            double ratio = (double)awtWidth / (double)awtHeight;
                            if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                                awtWidth = availableImageWidth;
                                awtHeight = (int)((double)availableImageWidth / ratio);
                            } else {
                                awtWidth = (int)((double)availableImageHeight * ratio);
                                awtHeight = availableImageHeight;
                            }
                            int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                            int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                            grx.drawImage(awtImage, jrImage.getX() + leftPadding + xoffset, jrImage.getY() + topPadding + yoffset, awtWidth, awtHeight, this);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                try {
                    awtImage = JRImageLoader.getImage((byte)1);
                }
                catch (JRException e) {
                    e.printStackTrace();
                }
                Shape clip = grx.getClip();
                grx.clipRect(jrImage.getX() + leftPadding, jrImage.getY() + topPadding, availableImageWidth, availableImageHeight);
                grx.drawImage(awtImage, jrImage.getX() + leftPadding + 2, jrImage.getY() + topPadding + 2, awtImage.getWidth(null), awtImage.getHeight(null), this);
                grx.setClip(clip);
            }
        }
        if (jrImage.getTopBorder() == 0 && jrImage.getLeftBorder() == 0 && jrImage.getBottomBorder() == 0 && jrImage.getRightBorder() == 0) {
            if (jrImage.getPen() != 0) {
                JRBaseBox box = new JRBaseBox(jrImage.getPen(), jrImage.getForecolor());
                this.printBox(box, jrImage, grx);
            }
        } else {
            this.printBox(jrImage, jrImage, grx);
        }
    }

    private JRStyledText getStyledText(JRTextElement textElement) {
        JRExpression textExpression;
        JRStyledText styledText = null;
        String text = null;
        if (textElement instanceof JRStaticText) {
            text = ((JRStaticText)textElement).getText();
        } else if (textElement instanceof JRTextField && (textExpression = ((JRTextField)textElement).getExpression()) != null) {
            text = textExpression.getText();
        }
        if (text == null) {
            text = "";
        }
        HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
        JRFontUtil.setAttributes(attributes, textElement);
        attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
        if (textElement instanceof JRStaticText && textElement.isStyledText()) {
            try {
                styledText = this.styledTextParser.parse(attributes, text, true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
        if (styledText == null) {
            styledText = new JRStyledText();
            styledText.append(text);
            styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
        }
        return styledText;
    }

    private void printText(JRTextElement text, Graphics2D grx) {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        String allText = styledText.getText();
        int x = text.getX();
        int y = text.getY();
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = text.getTopPadding();
        int leftPadding = text.getLeftPadding();
        int bottomPadding = text.getBottomPadding();
        int rightPadding = text.getRightPadding();
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + text.getHeight();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + text.getWidth();
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
        }
        grx.rotate(angle, x, y);
        if (text.getMode() == 1) {
            grx.setColor(text.getBackcolor());
            grx.fillRect(x, y, width, height);
        }
        grx.setColor(text.getForecolor());
        TextMeasurer textMeasurer = new TextMeasurer(text);
        textMeasurer.measure(styledText, allText, 0, 0);
        this.textRenderer.render(grx, x, y, width, height, topPadding, leftPadding, bottomPadding, rightPadding, textMeasurer.getTextHeight(), text.getHorizontalAlignment(), text.getVerticalAlignment(), textMeasurer.getLineSpacingFactor(), textMeasurer.getLeadingOffset(), text.getFontSize(), text.isStyledText(), styledText, allText);
        grx.rotate(-angle, x, y);
        this.printBox(text, text, grx);
    }

    private void printBox(JRBox box, Color defaultBorderColor, int x, int y, int width, int height, Graphics2D grx) {
        double cornerOffset;
        Stroke topStroke = null;
        Stroke leftStroke = null;
        Stroke bottomStroke = null;
        Stroke rightStroke = null;
        if (box != null) {
            topStroke = JRDesignViewer.getBorderStroke(box.getTopBorder());
            leftStroke = JRDesignViewer.getBorderStroke(box.getLeftBorder());
            bottomStroke = JRDesignViewer.getBorderStroke(box.getBottomBorder());
            rightStroke = JRDesignViewer.getBorderStroke(box.getRightBorder());
        }
        if (topStroke != null) {
            cornerOffset = JRDesignViewer.getBorderCornerOffset(box.getTopBorder());
            grx.setStroke(topStroke);
            grx.setColor(box.getTopBorderColor() == null ? defaultBorderColor : box.getTopBorderColor());
            grx.translate(0.0, cornerOffset);
            grx.drawLine(x, y, x + width, y);
            grx.translate(0.0, -cornerOffset);
        }
        if (leftStroke != null) {
            cornerOffset = JRDesignViewer.getBorderCornerOffset(box.getLeftBorder());
            grx.setStroke(leftStroke);
            grx.setColor(box.getLeftBorderColor() == null ? defaultBorderColor : box.getLeftBorderColor());
            grx.translate(cornerOffset, 0.0);
            grx.drawLine(x, y, x, y + height);
            grx.translate(-cornerOffset, 0.0);
        }
        if (bottomStroke != null) {
            cornerOffset = JRDesignViewer.getBorderCornerOffset(box.getBottomBorder());
            grx.setStroke(bottomStroke);
            grx.setColor(box.getBottomBorderColor() == null ? defaultBorderColor : box.getBottomBorderColor());
            grx.translate(0.0, -cornerOffset);
            grx.drawLine(x, y + height, x + width, y + height);
            grx.translate(0.0, cornerOffset);
        }
        if (rightStroke != null) {
            cornerOffset = JRDesignViewer.getBorderCornerOffset(box.getRightBorder());
            grx.setStroke(rightStroke);
            grx.setColor(box.getRightBorderColor() == null ? defaultBorderColor : box.getRightBorderColor());
            grx.translate(-cornerOffset, 0.0);
            grx.drawLine(x + width, y, x + width, y + height);
            grx.translate(cornerOffset, 0.0);
        }
        if (topStroke == null && leftStroke == null && bottomStroke == null && rightStroke == null) {
            grx.setColor(defaultBorderColor);
            grx.setStroke(new BasicStroke(1.0f / this.realZoom));
            grx.drawRect(x, y, width, height);
        }
    }

    private static Stroke getBorderStroke(byte pen) {
        switch (pen) {
            case 4: {
                return BORDER_STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return BORDER_STROKE_THIN;
            }
        }
        return BORDER_STROKE_1_POINT;
    }

    private void printBox(JRBox box, JRElement element, Graphics2D grx) {
        this.printBox(box, element.getForecolor(), element.getX(), element.getY(), element.getWidth(), element.getHeight(), grx);
    }

    private void printSubreport(JRSubreport subreport, Graphics2D grx) {
        if (subreport.getMode() == 1) {
            grx.setColor(subreport.getBackcolor());
            grx.fillRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        }
        Image image = null;
        try {
            image = JRImageLoader.getImage((byte)2);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        Shape clip = grx.getClip();
        grx.clipRect(subreport.getX(), subreport.getY(), subreport.getWidth(), subreport.getHeight());
        grx.drawImage(image, subreport.getX() + 2, subreport.getY() + 2, image.getWidth(null), image.getHeight(null), this);
        grx.setClip(clip);
        grx.setColor(subreport.getForecolor());
        grx.setStroke(new BasicStroke(1.0f / this.realZoom));
        grx.drawRect(subreport.getX(), subreport.getY(), subreport.getWidth() - 1, subreport.getHeight() - 1);
    }

    private void printCrosstab(JRCrosstab crosstab, Graphics2D grx) {
        grx.setClip(crosstab.getX(), crosstab.getY(), crosstab.getWidth(), crosstab.getHeight());
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        int rowHeadersXOffset = 0;
        for (int i = 0; i < rowGroups.length; ++i) {
            rowHeadersXOffset += rowGroups[i].getWidth();
        }
        JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
        int colHeadersYOffset = 0;
        for (int i = 0; i < columnGroups.length; ++i) {
            colHeadersYOffset += columnGroups[i].getHeight();
        }
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            grx.translate(crosstab.getX(), crosstab.getY());
            this.printCellContents(headerCell, grx, 0, 0, false, false);
            grx.translate(-crosstab.getX(), -crosstab.getY());
        }
        grx.translate(crosstab.getX() + rowHeadersXOffset, crosstab.getY());
        this.printCrosstabColumnHeaders(crosstab, grx);
        grx.translate(-(crosstab.getX() + rowHeadersXOffset), -crosstab.getY());
        grx.translate(crosstab.getX(), crosstab.getY() + colHeadersYOffset);
        this.printCrosstabRows(crosstab, grx, rowHeadersXOffset);
        grx.translate(-crosstab.getX(), -(crosstab.getY() + colHeadersYOffset));
        grx.setClip(-this.report.getLeftMargin(), 0, this.report.getPageWidth(), this.report.getPageHeight());
    }

    private void printCrosstabColumnHeaders(JRCrosstab crosstab, Graphics2D grx) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCrosstabColumnGroup group = groups[i];
            if (group.getTotalPosition() == 1) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x, y, x == 0 && crosstab.getHeaderCell() == null, false);
                x += totalHeader.getWidth();
            }
            JRCellContents header = group.getHeader();
            this.printCellContents(header, grx, x, y, x == 0 && crosstab.getHeaderCell() == null, false);
            if (group.getTotalPosition() == 2) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x + header.getWidth(), y, false, false);
            }
            y += group.getHeight();
        }
    }

    private void printCrosstabRows(JRCrosstab crosstab, Graphics2D grx, int rowHeadersXOffset) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        int x = 0;
        int y = 0;
        for (int i = 0; i < groups.length; ++i) {
            JRCrosstabRowGroup group = groups[i];
            if (group.getTotalPosition() == 1) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x, y, false, y == 0 && crosstab.getHeaderCell() == null);
                this.printCrosstabDataCellsRow(crosstab, grx, rowHeadersXOffset, y, i);
                y += totalHeader.getHeight();
            }
            JRCellContents header = group.getHeader();
            this.printCellContents(header, grx, x, y, false, y == 0 && crosstab.getHeaderCell() == null);
            if (i == groups.length - 1) {
                this.printCrosstabDataCellsRow(crosstab, grx, rowHeadersXOffset, y, groups.length);
            }
            if (group.getTotalPosition() == 2) {
                JRCellContents totalHeader = group.getTotalHeader();
                this.printCellContents(totalHeader, grx, x, y + header.getHeight(), false, false);
                this.printCrosstabDataCellsRow(crosstab, grx, rowHeadersXOffset, y + header.getHeight(), i);
            }
            x += group.getWidth();
        }
    }

    private void printCrosstabDataCellsRow(JRCrosstab crosstab, Graphics2D grx, int rowOffsetX, int rowOffsetY, int rowIndex) {
        grx.translate(rowOffsetX, rowOffsetY);
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        JRCrosstabCell[][] cells = crosstab.getCells();
        int x = 0;
        for (int i = 0; i < colGroups.length; ++i) {
            JRCrosstabColumnGroup group = colGroups[i];
            if (group.getTotalPosition() == 1) {
                this.printCellContents(cells[rowIndex][i].getContents(), grx, x, 0, false, false);
                x += cells[rowIndex][i].getContents().getWidth();
            }
            if (i == colGroups.length - 1) {
                this.printCellContents(cells[rowIndex][colGroups.length].getContents(), grx, x, 0, false, false);
            }
            if (group.getTotalPosition() != 2) continue;
            this.printCellContents(cells[rowIndex][i].getContents(), grx, x + group.getHeader().getWidth(), 0, false, false);
        }
        grx.translate(-rowOffsetX, -rowOffsetY);
    }

    private void printCellContents(JRCellContents cell, Graphics2D grx, int x, int y, boolean left, boolean top) {
        if (cell.getWidth() == 0 || cell.getHeight() == 0) {
            return;
        }
        JRDesignFrame frame = this.createCrosstabCellFrame(cell, x, y, left, top);
        this.printFrame(frame, grx);
    }

    private JRDesignFrame createCrosstabCellFrame(JRCellContents cell, int x, int y, boolean left, boolean top) {
        List children;
        JRDesignFrame frame = new JRDesignFrame(cell.getDefaultStyleProvider());
        frame.setX(x);
        frame.setY(y);
        frame.setWidth(cell.getWidth());
        frame.setHeight(cell.getHeight());
        frame.setMode(cell.getMode());
        frame.setBackcolor(cell.getBackcolor());
        frame.setStyle(cell.getStyle());
        JRBox box = cell.getBox();
        if (box != null) {
            boolean copyTop;
            frame.setBox(box);
            boolean copyLeft = left && box.getLeftBorder() == 0 && box.getRightBorder() != 0;
            boolean bl = copyTop = top && box.getTopBorder() == 0 && box.getBottomBorder() != 0;
            if (copyLeft) {
                frame.setLeftBorder(box.getRightBorder());
                frame.setLeftBorderColor(box.getRightBorderColor());
            }
            if (copyTop) {
                frame.setTopBorder(box.getBottomBorder());
                frame.setTopBorderColor(box.getBottomBorderColor());
            }
        }
        if ((children = cell.getChildren()) != null) {
            for (JRChild child : children) {
                if (child instanceof JRElement) {
                    frame.addElement((JRElement)child);
                    continue;
                }
                if (!(child instanceof JRElementGroup)) continue;
                frame.addElementGroup((JRElementGroup)child);
            }
        }
        return frame;
    }

    private void printFrame(JRFrame frame, Graphics2D grx) {
        if (frame.getMode() == 1) {
            grx.setColor(frame.getBackcolor());
            grx.fillRect(frame.getX(), frame.getY(), frame.getWidth(), frame.getHeight());
        }
        int topPadding = frame.getTopPadding();
        int leftPadding = frame.getLeftPadding();
        grx.translate(frame.getX() + leftPadding, frame.getY() + topPadding);
        this.printElements(frame.getElements(), grx);
        grx.translate(-(frame.getX() + leftPadding), -(frame.getY() + topPadding));
        this.printBox(frame, frame, grx);
    }

    private static Stroke getStroke(byte pen) {
        switch (pen) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }
}

