/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.IOException;

public class ByteArrayReader
extends RandomAccessReader {
    @NotNull
    private final byte[] _buffer;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public ByteArrayReader(@NotNull byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this._buffer = byArray;
    }

    public long getLength() {
        return this._buffer.length;
    }

    protected byte getByte(int n) throws IOException {
        return this._buffer[n];
    }

    protected void validateIndex(int n, int n2) throws IOException {
        if (!this.isValidIndex(n, n2)) {
            throw new BufferBoundsException(n, n2, this._buffer.length);
        }
    }

    protected boolean isValidIndex(int n, int n2) throws IOException {
        return n2 >= 0 && n >= 0 && (long)n + (long)n2 - 1L < (long)this._buffer.length;
    }

    @NotNull
    public byte[] getBytes(int n, int n2) throws IOException {
        this.validateIndex(n, n2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buffer, n, byArray, 0, n2);
        return byArray;
    }
}

