/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut.trace;

import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.trace.GlobalTraceStore;
import com.adobe.xfa.ut.trace.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;

public final class TraceHandler {
    private static volatile boolean gbTimingTraceEnabled;
    private static final AtomicLongArray mTimingData;
    private static volatile BufferedWriter gScriptLog;
    private static BufferedWriter gTimingLog;
    private static boolean gbTimingLogNonZeroOnly;
    private static final AtomicInteger mnThreadIdPool;
    private static final ThreadLocal<TraceHandler> mTraceHandlerTLS;
    private final int mnThreadId;
    private int mnLastCheckState = 0;
    private String msLastCheckName = "";
    private int mnMaxTraceNameLen;
    private final Map<String, Integer> mTraceLevels = new HashMap<String, Integer>();
    private final Map<String, Trace> mTraces = new HashMap<String, Trace>();
    private Formatter mFormatter;
    private Object mUserData = null;
    private AmendMsgCallback mAmendMsgCallback = null;

    public static void timingTraceEnabled(boolean bEnabled) {
        gbTimingTraceEnabled = bEnabled;
    }

    public static boolean timingTraceEnabled() {
        return gbTimingTraceEnabled;
    }

    public static boolean scriptLoggingEnabled() {
        return gScriptLog != null;
    }

    public static void setAmendMsgCallback(AmendMsgCallback callback, Object userData) {
        TraceHandler traceHandler = TraceHandler.getTraceHandler();
        if (traceHandler != null) {
            traceHandler.mAmendMsgCallback = callback;
            traceHandler.mUserData = userData;
        }
    }

    public static void resetTiming() {
        for (int i = 0; i < mTimingData.length(); ++i) {
            mTimingData.set(i, 0L);
        }
    }

    public static void resetTiming(TimingType eType) {
        mTimingData.set(eType.ordinal(), 0L);
    }

    public static void initializeTiming() {
        TraceHandler.resetTiming();
        TraceHandler.parseTraceControlFile();
    }

    public static synchronized void reportScriptInfo(String sMsg) {
        TraceHandler.parseTraceControlFile();
        if (gScriptLog == null) {
            return;
        }
        try {
            gScriptLog.write(sMsg);
            gScriptLog.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void outputTime(String prefix, TimingType eType) throws IOException {
        long milliseconds = TraceHandler.getTimerMilliseconds(eType);
        if (milliseconds == 0L && gbTimingLogNonZeroOnly) {
            return;
        }
        gTimingLog.write(prefix);
        gTimingLog.write(Long.toString(milliseconds));
        gTimingLog.write(10);
    }

    public static synchronized void reportTimingResults(boolean bClearStoppedTimers) {
        TraceHandler.parseTraceControlFile();
        if (gTimingLog == null) {
            return;
        }
        try {
            gTimingLog.write("Timing results (ms):\n");
            TraceHandler.outputTime("XFAPA_MERGE_TIMING:       ", TimingType.XFAPA_MERGE_TIMING);
            TraceHandler.outputTime("XFAPA_LAYOUT_TIMING:      ", TimingType.XFAPA_LAYOUT_TIMING);
            TraceHandler.outputTime("XFAPA_RENDER_TIMING:      ", TimingType.XFAPA_RENDER_TIMING);
            TraceHandler.outputTime("XFAPA_MERGE_CALC_TIMING:  ", TimingType.XFAPA_MERGE_CALC_TIMING);
            TraceHandler.outputTime("XFAPA_LAYOUT_CALC_TIMING: ", TimingType.XFAPA_LAYOUT_CALC_TIMING);
            TraceHandler.outputTime("XFA_MERGE_ONLY_TIMING:    ", TimingType.XFA_MERGE_ONLY_TIMING);
            TraceHandler.outputTime("XFA_LAYOUT_ONLY_TIMING:   ", TimingType.XFA_LAYOUT_ONLY_TIMING);
            TraceHandler.outputTime("XFA_SCRIPTS_ONLY_TIMING:  ", TimingType.XFA_SCRIPTS_ONLY_TIMING);
            TraceHandler.outputTime("XFA_OPEN_TIMING:          ", TimingType.XFA_OPEN_TIMING);
            gTimingLog.write("Timing results complete.\n\n");
            gTimingLog.flush();
            if (bClearStoppedTimers) {
                TraceHandler.resetTiming();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long getTimerMilliseconds(TimingType eType) {
        return mTimingData.get(eType.ordinal()) / 1000000L;
    }

    static void addTimerNanos(TimingType eType, long nanos) {
        mTimingData.addAndGet(eType.ordinal(), nanos);
    }

    public TraceHandler(int nThreadId) {
        this.mnThreadId = nThreadId;
        this.mnMaxTraceNameLen = 0;
    }

    public static TraceHandler getTraceHandler() {
        return mTraceHandlerTLS.get();
    }

    public static void registerTraceHandler(TraceHandler traceHandler) {
        if (traceHandler != null) {
            mTraceHandlerTLS.set(traceHandler);
        }
    }

    public static void unregisterTraceHandler() {
        mTraceHandlerTLS.set(null);
    }

    public void activate(Trace trace, int nLevel) {
        if (trace == null) {
            return;
        }
        this.activate(trace.getName(), nLevel);
    }

    public void activate(String sName, int nLevel) {
        if (sName.equals("timing")) {
            TraceHandler.timingTraceEnabled(nLevel > 0);
            TraceHandler.resetTiming();
        }
        this.msLastCheckName = sName;
        this.mnLastCheckState = 0;
        if (!this.mTraceLevels.containsKey(this.msLastCheckName)) {
            GlobalTraceStore globalTraceStore = GlobalTraceStore.getStore();
            globalTraceStore.ensureTraceExists(this.msLastCheckName);
            for (Trace t : globalTraceStore.getTraceSections()) {
                this.addTrace(t);
            }
        }
        this.mTraceLevels.put(this.msLastCheckName, nLevel);
        this.mnLastCheckState = nLevel;
        Trace trace = this.mTraces.get(this.msLastCheckName);
        GlobalTraceStore.getStore().enable();
        if (trace != null) {
            trace.enable();
        }
    }

    public void activate(String sNamesAndLevels) {
        StringTokenizer tokenizer = new StringTokenizer(sNamesAndLevels);
        while (tokenizer.hasMoreTokens()) {
            String sName;
            String token = tokenizer.nextToken();
            int colon = token.indexOf(58);
            int nLevel = 0;
            if (colon == -1) {
                sName = token.trim();
            } else {
                sName = token.substring(0, colon).trim();
                String sLevel = token.substring(colon + 1);
                try {
                    nLevel = Integer.parseInt(sLevel);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.activate(sName, nLevel);
        }
    }

    public void deactivate(String sName) {
        this.msLastCheckName = sName;
        this.mnLastCheckState = 0;
        if (this.mTraceLevels.containsKey(sName)) {
            this.mTraceLevels.put(sName, 0);
        }
    }

    String dumpAvailable(boolean bIncludeHelp) {
        StringBuilder sRetValue = new StringBuilder();
        for (Trace trace : this.mTraces.values()) {
            if (sRetValue.length() > 0) {
                sRetValue.append('\n');
            }
            if (bIncludeHelp) {
                sRetValue.append('\t');
            }
            sRetValue.append(trace.getName());
            if (!bIncludeHelp) continue;
            sRetValue.append(" - ");
            sRetValue.append(trace.getHelpId());
        }
        return sRetValue.toString();
    }

    boolean isActive(String sName, int nLevel) {
        if (!this.msLastCheckName.equals(sName)) {
            this.msLastCheckName = sName;
            Integer value = this.mTraceLevels.get(this.msLastCheckName);
            int n = this.mnLastCheckState = value == null ? 0 : value;
        }
        return this.mnLastCheckState != 0 && this.mnLastCheckState >= nLevel;
    }

    void trace(Trace oTrace, int nLevel, int nId, String sMsg) {
        if (oTrace != null && oTrace.isEnabled(nLevel)) {
            this.printTrace(oTrace.getName(), nId, sMsg);
        }
    }

    void trace(String sName, int nLevel, int nId, String sMsg) {
        if (this.isActive(sName, nLevel)) {
            this.printTrace(sName, nId, sMsg);
        }
    }

    void trace(String sName, int nLevel, MsgFormatPos oMsg) {
        if (this.isActive(sName, nLevel)) {
            this.printTrace(sName, oMsg.resId(), oMsg.toString());
        }
    }

    void trace(Trace oTrace, int nLevel, MsgFormatPos oMsg) {
        if (oTrace != null && oTrace.isEnabled(nLevel)) {
            this.printTrace(oTrace.getName(), oMsg.resId(), oMsg.toString());
        }
    }

    public int getThreadId() {
        return this.mnThreadId;
    }

    private void addTrace(Trace trace) {
        if (trace.getName().length() > this.mnMaxTraceNameLen) {
            this.mnMaxTraceNameLen = trace.getName().length();
        }
        this.mTraceLevels.put(trace.getName(), 0);
        this.mTraces.put(trace.getName(), trace);
    }

    private String amendMsg(int nAmendId) {
        if (this.mAmendMsgCallback != null) {
            return this.mAmendMsgCallback.amendMessage(nAmendId, this.mUserData);
        }
        return "";
    }

    private void printTrace(String sName, int nId, String sMsg) {
        if (this.mFormatter == null) {
            this.mFormatter = new Formatter(System.out, Locale.US);
        }
        this.mFormatter.format("%-" + this.mnMaxTraceNameLen + "s trace: mid=%-3u tid=%-3u msg: %s\n", this.mnMaxTraceNameLen, sName, nId, this.mnThreadId, sMsg);
        int nAmendId = nId;
        String sAmendId = this.amendMsg(nAmendId);
        if (!StringUtils.isEmpty(sAmendId)) {
            this.mFormatter.format("   trace: mid=%-3u tid=%-3u msg: %s\n", nAmendId, this.mnThreadId, sAmendId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void parseTraceControlFile() {
        block27: {
            String sTraceControlFileName = ResourceLoader.loadProperty("xtg.trace.control.file");
            if (sTraceControlFileName.length() == 0) {
                return;
            }
            gbTimingTraceEnabled = true;
            if (gTimingLog != null) {
                try {
                    gTimingLog.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gTimingLog = null;
            }
            if (gScriptLog != null) {
                try {
                    gScriptLog.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gScriptLog = null;
            }
            gbTimingLogNonZeroOnly = false;
            try {
                BufferedReader reader = new BufferedReader(new FileReader(sTraceControlFileName));
                block19: while (true) {
                    while (true) {
                        String line;
                        try {
                            line = reader.readLine();
                        }
                        catch (IOException ex) {
                            break block27;
                        }
                        if (line == null) {
                            break block27;
                        }
                        int index = line.indexOf("timinglog=");
                        if (index != -1) {
                            String timingLog = line.substring(index + "timinglog=".length());
                            if (gTimingLog != null) continue;
                            try {
                                gTimingLog = new BufferedWriter(new FileWriter(timingLog, true));
                                continue block19;
                            }
                            catch (IOException iOException) {
                                continue;
                            }
                        }
                        index = line.indexOf("nonZeroOnly=");
                        if (index != -1) {
                            String timingLogNonZeroOnly = line.substring(index + "nonZeroOnly=".length());
                            gbTimingLogNonZeroOnly = Integer.parseInt(timingLogNonZeroOnly) == 1;
                            continue;
                        }
                        index = line.indexOf("scriptlog=");
                        if (index == -1) continue;
                        String scriptLog = line.substring(index + "scriptlog=".length());
                        if (gScriptLog != null) continue;
                        try {
                            gScriptLog = new BufferedWriter(new FileWriter(scriptLog, true));
                            continue block19;
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public boolean isTimerActive(TimingType eType) {
        return mTimingData.get(eType.ordinal()) != 0L;
    }

    static {
        mTimingData = new AtomicLongArray(TimingType.values().length);
        mnThreadIdPool = new AtomicInteger();
        mTraceHandlerTLS = new ThreadLocal<TraceHandler>(){

            @Override
            protected TraceHandler initialValue() {
                return new TraceHandler(mnThreadIdPool.getAndIncrement());
            }
        };
    }

    public static interface AmendMsgCallback {
        public String amendMessage(int var1, Object var2);
    }

    public static enum TimingType {
        XFAPA_MERGE_TIMING,
        XFAPA_LAYOUT_TIMING,
        XFAPA_RENDER_TIMING,
        XFAPA_MERGE_CALC_TIMING,
        XFAPA_LAYOUT_CALC_TIMING,
        XFAPA_LAYOUT_FONTSERVICE_TIMING,
        XMLFORM_INIT_TIMING,
        XMLFORM_INIT_BATCH_TIMING,
        XMLFORM_RENDER_TIMING,
        XMLFORM_IMPORT_TIMING,
        XMLFORM_POSTPROCESS_TIMING,
        CORETECH_INIT_TIMING,
        XFA_MERGE_ONLY_TIMING,
        XFA_LAYOUT_ONLY_TIMING,
        XFA_SCRIPTS_ONLY_TIMING,
        UT_TESTCASE,
        APP_TOTALTIME,
        XFA_OPEN_TIMING,
        USER1_TIMING,
        USER2_TIMING;

    }
}

