/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text.markup;

import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBaselineShift;
import com.adobe.xfa.text.TextField;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextPosn;
import com.adobe.xfa.text.TextResolver;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.TextTab;
import com.adobe.xfa.text.TextTabList;
import com.adobe.xfa.text.markup.MarkupAttr;
import com.adobe.xfa.text.markup.MarkupEngineIn;
import com.adobe.xfa.text.markup.MarkupXHTMLAttr;
import com.adobe.xfa.text.markup.XMLParserBase;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UniCharIterator;
import com.adobe.xfa.ut.UnitSpan;
import org.xml.sax.Attributes;

public class MarkupXHTMLIn
extends MarkupEngineIn {
    static final int SPACE_SUPPRESS_BREAK = 0;
    static final int SPACE_SUPPRESS = 1;
    static final int SPACE_NORMAL = 2;
    static final int SPACE_XML = 3;
    static final int SPACE_RUN = 4;
    static final int SPACE_FORCED = 5;
    private static final int PENDING_DEFAULT = 0;
    private static final int PENDING_NONE = 1;
    private static final int PENDING_DIV = 2;
    private static final int PENDING_SPACE = 3;
    private static final int PENDING_BREAK = 4;
    private static final String gsXHTMLNS = "http://www.w3.org/1999/xhtml`";
    private static final String gsDefaultTypefaceDefault = "Arial";
    private static final String gsNewLine = "\n";
    private static final String gsAPIVersion = "xfa:APIVersion";
    private static final String gsRGBStart = "rgb(";
    private static final String gsRGBEnd = ")";
    private static final String gsNumeric = "-0123456789.";
    private static final int[] gnVersion_1_0_0_0 = new int[]{1, 0, 0, 0};
    private static final int[] gnVersion_2_5_6129_0 = new int[]{2, 5, 6129, 0};
    private XHTMLParser mpoParser;
    private final Stack moStack = new Stack();
    private boolean mbVersionDetermined;
    private boolean mbTextAccumulated;
    private boolean mbParaStarted;
    private boolean mbAmbientSupplied;
    private int mePending;
    private final TextAttr moPendingAttr = new TextAttr();
    private final TextAttr moPrevParaAttr = new TextAttr();
    private final TextResolver mpoResolver;
    private UniCharIterator mIterator;
    private LeaderInfo mpoLeaderInfo;
    private int mnTabCount;

    public MarkupXHTMLIn(String oMarkupSource, MarkupAttr pMarkupAttr, TextAttr poAmbientAttr, TextResolver poResolver) {
        super(oMarkupSource, pMarkupAttr == null ? MarkupXHTMLAttr.getDefault() : pMarkupAttr);
        this.mpoResolver = poResolver;
        this.initialize(poAmbientAttr);
    }

    void commit() {
        if (this.mpoLeaderInfo != null) {
            this.mpoLeaderInfo.mpoIn.commitTabs(this.mpoLeaderInfo);
        }
    }

    @Override
    public void translate() {
        this.mbVersionDetermined = false;
        this.moCurrentAttr.setDefault(true);
        this.moCurrentAttr.typefaceEnable(false);
        this.moCurrentAttr.sizeEnable(false);
        if (this.mbAmbientSupplied) {
            this.moCurrentAttr.override(this.moAmbientAttr);
        }
        this.moCurrentAttr.colourBgEnable(false);
        this.moCurrentAttr.transparentEnable(false);
        if (!this.moCurrentAttr.specialEnable()) {
            this.moCurrentAttr.special(TextMeasurement.zero());
        }
        if (!this.moCurrentAttr.justifyVEnable()) {
            this.moCurrentAttr.justifyV(1);
        }
        if (!this.moCurrentAttr.justifyHEnable()) {
            this.moCurrentAttr.justifyH(5);
        }
        if (!this.moCurrentAttr.tabsEnable()) {
            this.moCurrentAttr.tabs(new TextTabList());
        }
        if (!this.moCurrentAttr.spacingEnable()) {
            this.moCurrentAttr.spacing(TextMeasurement.zero());
        }
        this.attr(this.moCurrentAttr);
        this.moAttrList.add(this.moCurrentAttr);
        this.moStack.add(new Frame(47, 2));
        if (this.mpoParser == null) {
            XHTMLParser oParser;
            this.mpoParser = oParser = new XHTMLParser(this);
            oParser.processText(this.sourceText());
            this.mpoParser = null;
            this.commit();
        }
    }

    public static void tabDefault(String sAttrValue, TextAttr oAttr, MarkupAttr pMarkupAttr) {
        TextTab oTab = MarkupXHTMLIn.extractTab(pMarkupAttr, sAttrValue, 4);
        TextTabList oTabList = MarkupXHTMLIn.getTabList(oAttr);
        if (oTab.value() <= 0) {
            oTabList.noUniform(true);
        } else {
            oTabList.uniform(oTab);
        }
        oAttr.tabs(oTabList);
    }

    public static void tabSet(String sAttrValue, TextAttr oAttr, MarkupAttr pMarkupAttr) {
        TextTabList oTabList = MarkupXHTMLIn.getTabList(oAttr);
        int nOffset = 0;
        int nFoundAt = sAttrValue.indexOf(32);
        while (nFoundAt >= nOffset) {
            String sAlign = sAttrValue.substring(nOffset, nFoundAt);
            nOffset = nFoundAt + 1;
            if ((nFoundAt = sAttrValue.indexOf(32, nOffset)) < 0) {
                nFoundAt = sAttrValue.length();
            }
            String sValue = sAttrValue.substring(nOffset, nFoundAt);
            UnitSpan oValue = new UnitSpan(sValue);
            TextTab oTab = new TextTab(oValue, MarkupXHTMLIn.stringToAlign(pMarkupAttr, sAlign));
            oTabList.set(oTab);
            nOffset = nFoundAt + 1;
            nFoundAt = sAttrValue.indexOf(32, nOffset);
        }
        oAttr.tabs(oTabList);
    }

    @Override
    public String defaultTypeface() {
        return gsDefaultTypefaceDefault;
    }

    @Override
    public boolean skipThisCommand(int eTag) {
        return false;
    }

    MarkupXHTMLIn onStartTag(String pcName, Attributes attributes) {
        String sTagName = pcName;
        int nPos = sTagName.indexOf(gsXHTMLNS);
        if (nPos > 0) {
            StringBuilder noNS = new StringBuilder();
            noNS.append(pcName, 0, nPos);
            noNS.append(pcName, nPos + gsXHTMLNS.length(), pcName.length());
            sTagName = noNS.toString();
        }
        this.mnTabCount = 0;
        String sAttr = null;
        if (this.inUnknownElement()) {
            this.moStack.push(new Frame(0, this.moStack.top().meSpace));
        } else {
            int eTag = this.markupAttr().lookup(sTagName);
            this.moStack.push(new Frame(eTag, this.moStack.top().meSpace));
            this.updateSpaceStatus(eTag);
            switch (eTag) {
                case 22: {
                    this.onCommand(22, "");
                    break;
                }
                case 77: {
                    this.onCommand(77, "");
                    break;
                }
                case 79: {
                    this.onCommand(79, "");
                    break;
                }
                case 46: {
                    String sVersion;
                    if (!this.mbVersionDetermined && (sVersion = this.getAttr(attributes, gsAPIVersion)) != null) {
                        this.mbVersionDetermined = true;
                        int[] nVersion = new int[4];
                        if (MarkupXHTMLIn.extractHTMLVersion(sVersion, nVersion)) {
                            if (MarkupXHTMLIn.compareHTMLVersions(nVersion, gnVersion_1_0_0_0) == 0) {
                                this.switchToFF99Mode();
                            } else if (MarkupXHTMLIn.compareHTMLVersions(nVersion, gnVersion_2_5_6129_0) >= 0) {
                                this.setLegacyBlankLineMode(false);
                                for (int i = 0; i < this.moStack.size(); ++i) {
                                    if (this.moStack.frameAt((int)i).meSpace != 0) continue;
                                    this.moStack.frameAt((int)i).meSpace = 1;
                                }
                            }
                        }
                    }
                    this.pushAttr();
                    this.handleStylingAttributes(attributes, true);
                    this.onCommand(46, "");
                    break;
                }
                case 47: {
                    this.pushAttr();
                    this.handleStylingAttributes(attributes, true);
                    this.onCommand(47, "");
                    break;
                }
                case 18: 
                case 154: {
                    if (this.legacyBlankLineMode() && eTag == 18 || !this.mbParaStarted) {
                        if (this.legacyPositioning()) {
                            this.para();
                        } else {
                            this.pushAttr();
                            this.attr(this.moPrevParaAttr);
                            this.para();
                            this.popAttr();
                        }
                    }
                    this.pushAttr();
                    if (!this.handleStylingAttributes(attributes, eTag == 18)) {
                        TextAttr oParaAttrs = new TextAttr(this.textAttr());
                        oParaAttrs.isolatePara(true, this.posn().legacyPositioning());
                        this.attr(oParaAttrs);
                    }
                    this.onCommand(eTag, "");
                    break;
                }
                case 113: {
                    this.onCommand(113, "");
                    break;
                }
                case 115: {
                    this.onCommand(115, "");
                    break;
                }
                case 38: 
                case 40: {
                    this.flushPendingText(3);
                    this.openScopedBlock();
                    this.pushAttr();
                    if (this.handleStylingAttributes(attributes)) {
                        if (this.mnTabCount != 0) {
                            if (this.moCurrentAttr.leaderPatternEnable() && this.moCurrentAttr.leaderPattern() == 3) {
                                LeaderInfo poLeaderInfo = new LeaderInfo(this);
                                MarkupXHTMLIn poReturn = new MarkupXHTMLIn(poLeaderInfo);
                                return poReturn;
                            }
                            this.commitTabs(null);
                        }
                    } else {
                        String sExpression = this.getAttr(attributes, 42);
                        if (sExpression != null) {
                            this.flushPendingText(3);
                            int eEmbedType = 0;
                            int eEmbedMode = 1;
                            sAttr = this.getAttr(attributes, 44);
                            if (sAttr != null) {
                                if (sAttr.equals("uri")) {
                                    eEmbedType = 1;
                                } else if (sAttr.equals("som")) {
                                    eEmbedType = 0;
                                }
                            }
                            if ((sAttr = this.getAttr(attributes, 43)) != null) {
                                if (sAttr.equals("raw")) {
                                    eEmbedMode = 0;
                                } else if (sAttr.equals("formatted")) {
                                    eEmbedMode = 1;
                                }
                            }
                            this.embed(sExpression, eEmbedType, eEmbedMode);
                            if (!this.legacyBlankLineMode()) {
                                this.mbParaStarted = false;
                            }
                        }
                    }
                    this.onCommand(38, "");
                    break;
                }
                case 92: {
                    this.onCommand(92, "");
                }
            }
        }
        return null;
    }

    void onEndTag(String pcTag) {
        int eTag = this.moStack.top().meTag;
        this.moStack.removeLast();
        if (this.moStack.top().meSpace < 2) {
            this.moStack.top().meSpace = 2;
        }
        switch (eTag) {
            case 18: {
                this.onCommand(19, "");
                break;
            }
            case 154: {
                this.onCommand(155, "");
                break;
            }
            case 77: {
                this.onCommand(78, "");
                break;
            }
            case 92: {
                this.onCommand(90, "");
                break;
            }
            case 79: {
                this.onCommand(80, "");
                break;
            }
            case 115: {
                this.onCommand(116, "");
                break;
            }
            case 113: {
                this.onCommand(114, "");
                break;
            }
            case 46: {
                this.onCommand(48, "");
                break;
            }
            case 47: {
                this.onCommand(49, "");
                break;
            }
            case 38: 
            case 40: {
                this.onCommand(39, "");
            }
        }
        this.updateSpaceStatus(eTag, true);
    }

    void onHandleText(String sText) {
        if (this.inUnknownElement()) {
            return;
        }
        StringBuilder sAccumulate = new StringBuilder();
        int eSpace = this.moStack.top().meSpace;
        if (this.mIterator == null) {
            this.mIterator = new UniCharIterator();
        }
        this.mIterator.attach(sText);
        int c = this.mIterator.next();
        while (c != 0) {
            switch (eSpace) {
                case 1: {
                    if (this.legacyBlankLineMode()) {
                        this.flushPendingText(4);
                    }
                    if (MarkupXHTMLIn.isXHTMLSpace(c)) break;
                    if (!this.legacyBlankLineMode()) {
                        this.flushPendingText(4);
                    }
                    UniCharIterator.append(sAccumulate, c);
                    eSpace = 2;
                    this.moStack.top().meSpace = 2;
                    break;
                }
                case 0: {
                    if (!this.legacyBlankLineMode()) break;
                    this.flushPendingText(4);
                    if (MarkupXHTMLIn.isXHTMLSpace(c)) break;
                    UniCharIterator.append(sAccumulate, c);
                    eSpace = 2;
                    this.moStack.top().meSpace = 2;
                    break;
                }
                case 2: {
                    if (MarkupXHTMLIn.isXHTMLSpace(c)) {
                        if (this.mePending == 1) {
                            this.mePending = 3;
                        }
                    } else {
                        switch (this.mePending) {
                            case 3: {
                                sAccumulate.append(' ');
                                break;
                            }
                            case 2: {
                                if (!this.legacyBlankLineMode() || !this.mbTextAccumulated) break;
                                sAccumulate.append('\n');
                                break;
                            }
                            case 4: {
                                sAccumulate.append('\n');
                            }
                        }
                        this.mePending = 1;
                        UniCharIterator.append(sAccumulate, c);
                    }
                    if (this.mePending != 3) break;
                    this.moPendingAttr.copyFrom(this.textAttr());
                    break;
                }
                case 4: {
                    if (this.legacyBlankLineMode()) {
                        this.flushPendingText(1);
                    }
                    if (c == 160) {
                        c = 32;
                    }
                    if (MarkupXHTMLIn.isXHTMLSpace(c) && c != 32) break;
                    if (!this.legacyBlankLineMode()) {
                        this.flushPendingText(1);
                    }
                    UniCharIterator.append(sAccumulate, c);
                    break;
                }
                case 3: {
                    this.flushPendingText(1);
                    UniCharIterator.append(sAccumulate, c);
                    break;
                }
                case 5: {
                    if (this.legacyBlankLineMode() && this.mePending == 2 || this.mePending == 4) {
                        if (this.mbTextAccumulated || this.mePending == 4) {
                            sAccumulate.append('\n');
                        }
                        this.mePending = 1;
                    }
                    if (c == 10) {
                        this.mePending = 4;
                        break;
                    }
                    UniCharIterator.append(sAccumulate, c);
                }
            }
            c = this.mIterator.next();
        }
        if (sAccumulate.length() > 0) {
            this.text(sAccumulate.toString());
        }
    }

    private MarkupXHTMLIn(LeaderInfo poLeaderInfo) {
        super("", poLeaderInfo.mpoIn.markupAttr());
        this.mpoParser = poLeaderInfo.mpoIn.mpoParser;
        this.mpoResolver = poLeaderInfo.mpoIn.mpoResolver;
        this.mpoLeaderInfo = poLeaderInfo;
        this.initialize(poLeaderInfo.mpoIn.moCurrentAttr);
        this.setup(poLeaderInfo.moPosn, null);
        this.moStack.add(new Frame(38, 2));
        this.updateSpaceStatus(38);
    }

    public String getAttr(Attributes attrlist, int eTag) {
        return this.getAttr(attrlist, this.markupAttr().lookup(eTag));
    }

    public String getAttr(Attributes attrlist, String sName) {
        if (attrlist == null) {
            return null;
        }
        String result = attrlist.getValue(sName);
        if (result != null && result.length() == 0) {
            result = null;
        }
        return result;
    }

    @Override
    public void text(String sText) {
        super.text(sText);
        this.mbTextAccumulated = true;
        this.mbParaStarted = false;
        this.moPrevParaAttr.setDefault(false);
    }

    @Override
    protected boolean onCommand(int eTag, String sParameter) {
        TextMeasurement oMeasure = null;
        boolean bCommandHandled = false;
        block0 : switch (eTag) {
            case 18: 
            case 154: {
                this.mbTextAccumulated = false;
                this.mbParaStarted = true;
                break;
            }
            case 22: {
                if (this.legacyBlankLineMode()) {
                    if (this.moStack.top().meSpace == 0) break;
                    this.flushPendingText(4);
                    this.mePending = 4;
                    this.moPendingAttr.setDefault(false);
                    this.mbTextAccumulated = false;
                    break;
                }
                this.flushPendingText(4);
                this.mePending = 4;
                this.moPendingAttr.setDefault(false);
                this.mbTextAccumulated = false;
                this.mbParaStarted = false;
                break;
            }
            case 38: 
            case 46: 
            case 47: {
                this.mbTextAccumulated = false;
                break;
            }
            case 48: 
            case 49: {
                this.popAttr();
                this.mbTextAccumulated = false;
                break;
            }
            case 39: {
                if (this.legacyBlankLineMode()) {
                    this.flushPendingText(4);
                }
                this.moPrevParaAttr.copyFrom(this.moCurrentAttr);
                this.closeScopedBlock();
                this.popAttr();
                break;
            }
            case 50: {
                switch (this.markupAttr().lookup(sParameter)) {
                    case 51: {
                        this.moStack.top().meSpace = 4;
                        break;
                    }
                    case 52: {
                        this.moStack.top().meSpace = this.moStack.frameAt((int)(this.moStack.size() - 2)).meSpace;
                    }
                }
                break;
            }
            case 57: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.special(oMeasure);
                break;
            }
            case 58: {
                if (sParameter.length() == 0) {
                    this.flushAttr();
                    break;
                }
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.marginL(oMeasure);
                break;
            }
            case 59: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.marginR(oMeasure);
                break;
            }
            case 61: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.spaceBefore(oMeasure);
                break;
            }
            case 62: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.spaceAfter(oMeasure);
                break;
            }
            case 64: {
                StringBuilder sCmd = new StringBuilder(sParameter);
                StringUtils.trimStart(sCmd);
                int nCount = 0;
                int nFoundAt = sCmd.indexOf(" ");
                int nOffset = 0;
                while (nFoundAt >= 0 && nCount < 4) {
                    String sSize = sCmd.substring(nOffset, nFoundAt);
                    oMeasure = TextMeasurement.fromString(sSize, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sSize));
                    if (++nCount == 1) {
                        this.moCurrentAttr.marginL(oMeasure);
                        this.moCurrentAttr.marginR(oMeasure);
                        this.moCurrentAttr.spaceBefore(oMeasure);
                        this.moCurrentAttr.spaceAfter(oMeasure);
                    } else if (nCount == 2) {
                        this.moCurrentAttr.marginL(oMeasure);
                        this.moCurrentAttr.marginR(oMeasure);
                    } else if (nCount == 3) {
                        this.moCurrentAttr.spaceAfter(oMeasure);
                    } else if (nCount == 4) {
                        this.moCurrentAttr.marginL(oMeasure);
                    }
                    nOffset = nFoundAt + 1;
                    nFoundAt = sCmd.indexOf(" ", nOffset);
                }
                break;
            }
            case 53: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.spacing(oMeasure);
                break;
            }
            case 65: {
                this.moCurrentAttr.typeface(sParameter);
                break;
            }
            case 66: {
                UnitSpan size = new UnitSpan(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter), false);
                this.moCurrentAttr.size(size);
                break;
            }
            case 67: {
                this.updateWeight(sParameter);
                break;
            }
            case 68: {
                this.updateItalic(sParameter);
                break;
            }
            case 69: {
                this.updateFont(sParameter);
                break;
            }
            case 72: {
                double dScale = TextAttr.parsePercent(sParameter, true);
                if (Double.isNaN(dScale)) break;
                this.moCurrentAttr.horizontalScale(dScale);
                break;
            }
            case 73: {
                double dScale = TextAttr.parsePercent(sParameter, true);
                if (Double.isNaN(dScale)) break;
                this.moCurrentAttr.verticalScale(dScale);
                break;
            }
            case 75: {
                int lR = 0;
                int lG = 0;
                int lB = 0;
                if (sParameter.charAt(0) == '#') {
                    lR = Integer.parseInt(sParameter.substring(1, 3), 16);
                    lG = Integer.parseInt(sParameter.substring(3, 5), 16);
                    lB = Integer.parseInt(sParameter.substring(5, 7), 16);
                } else if (sParameter.substring(0, 4).equalsIgnoreCase(gsRGBStart) && sParameter.substring(sParameter.length() - 1).equals(gsRGBEnd)) {
                    int nOffset = 4;
                    int nFound = sParameter.indexOf(44, nOffset);
                    lR = Integer.parseInt(sParameter.substring(nOffset, nFound));
                    nOffset = nFound + 1;
                    nFound = sParameter.indexOf(44, nOffset);
                    lG = Integer.parseInt(sParameter.substring(nOffset, nFound));
                    nOffset = nFound + 1;
                    nFound = sParameter.indexOf(44, nOffset);
                    lB = Integer.parseInt(sParameter.substring(nOffset, nFound));
                }
                GFXColour oColour = new GFXColour(lR, lG, lB, 255);
                this.moCurrentAttr.colour(oColour);
                break;
            }
            case 110: {
                int eStrikeCode = 1;
                if (this.findAttr(sParameter, 81)) {
                    eStrikeCode = 18;
                }
                this.moCurrentAttr.strikeout(eStrikeCode);
                int nUnderType = 1;
                int nUnderCount = 0;
                if (this.findAttr(sParameter, 85)) {
                    nUnderType = 2;
                    nUnderCount = 16;
                }
                if (this.findAttr(sParameter, 86)) {
                    nUnderType = 2;
                    nUnderCount = 32;
                }
                if (this.findAttr(sParameter, 87)) {
                    nUnderType = 3;
                    if (nUnderCount == 0) {
                        nUnderCount = 16;
                    }
                }
                this.moCurrentAttr.underline(nUnderType | nUnderCount);
                break;
            }
            case 169: {
                switch (this.markupAttr().lookup(sParameter)) {
                    case 4: {
                        this.moCurrentAttr.kerning(false);
                        break;
                    }
                    case 170: {
                        this.moCurrentAttr.kerning(true);
                    }
                }
                break;
            }
            case 77: {
                this.pushAttr();
                this.moCurrentAttr.weight(700);
                this.flushPendingText(0);
                this.attr(this.moCurrentAttr);
                break;
            }
            case 79: {
                this.pushAttr();
                this.moCurrentAttr.italic(true);
                this.flushPendingText(0);
                this.attr(this.moCurrentAttr);
                break;
            }
            case 92: {
                this.pushAttr();
                this.moCurrentAttr.underline(18);
                this.flushPendingText(0);
                this.attr(this.moCurrentAttr);
                break;
            }
            case 90: {
                this.moPrevParaAttr.copyFrom(this.moCurrentAttr);
                this.popAttr();
                break;
            }
            case 119: {
                switch (this.markupAttr().lookup(sParameter)) {
                    case 120: {
                        this.moCurrentAttr.justifyH(8);
                        break;
                    }
                    case 121: {
                        this.moCurrentAttr.justifyH(9);
                        break;
                    }
                    case 156: {
                        this.moCurrentAttr.justifyH(5);
                        break;
                    }
                    case 157: {
                        this.moCurrentAttr.justifyH(6);
                        break;
                    }
                    case 158: {
                        this.moCurrentAttr.justifyH(7);
                        break;
                    }
                    case 125: {
                        this.moCurrentAttr.justifyH(11);
                        break;
                    }
                    case 126: {
                        this.moCurrentAttr.justifyH(12);
                        break;
                    }
                    case 127: {
                        this.moCurrentAttr.justifyH(13);
                    }
                }
                break;
            }
            case 128: 
            case 132: {
                switch (this.markupAttr().lookup(sParameter)) {
                    case 129: {
                        this.moCurrentAttr.justifyV(1);
                        break block0;
                    }
                    case 130: {
                        this.moCurrentAttr.justifyV(2);
                        break block0;
                    }
                    case 131: {
                        this.moCurrentAttr.justifyV(3);
                        break block0;
                    }
                }
                boolean bSuppressInversion = this.moStack.size() > 0 && this.moStack.frameAt((int)0).meSpace == 5;
                TextBaselineShift oShift = new TextBaselineShift(sParameter, bSuppressInversion);
                this.moCurrentAttr.baselineShift(oShift);
                break;
            }
            case 113: {
                this.pushAttr();
                UnitSpan oShift = this.textAttr().size();
                oShift = oShift.multiply(-0.31);
                if (this.moCurrentAttr.baselineShiftEnable()) {
                    UnitSpan oBase = new UnitSpan(this.moCurrentAttr.baselineShift().getString(false));
                    oShift = oShift.add(oBase);
                }
                this.moCurrentAttr.baselineShift(new TextBaselineShift(oShift));
                this.moCurrentAttr.size(this.moCurrentAttr.size().multiply(0.66));
                this.flushPendingText(0);
                this.attr(this.moCurrentAttr);
                break;
            }
            case 78: 
            case 80: 
            case 114: 
            case 116: {
                this.flushPendingText(4);
                this.moPrevParaAttr.copyFrom(this.moCurrentAttr);
                this.popAttr();
                break;
            }
            case 19: 
            case 155: {
                this.moPrevParaAttr.copyFrom(this.moCurrentAttr);
                this.popAttr();
                this.mbTextAccumulated = false;
                break;
            }
            case 115: {
                this.pushAttr();
                UnitSpan oShift = this.moCurrentAttr.size();
                oShift = oShift.multiply(0.15);
                if (this.moCurrentAttr.baselineShiftEnable()) {
                    UnitSpan oBase = new UnitSpan(this.moCurrentAttr.baselineShift().getString(false));
                    oShift = oShift.add(oBase);
                }
                this.moCurrentAttr.baselineShift(new TextBaselineShift(oShift));
                this.moCurrentAttr.size(this.moCurrentAttr.size().multiply(0.66));
                this.flushPendingText(0);
                this.attr(this.moCurrentAttr);
                break;
            }
            case 137: {
                MarkupXHTMLIn.tabDefault(sParameter, this.moCurrentAttr, this.markupAttr());
                break;
            }
            case 136: {
                break;
            }
            case 138: {
                MarkupXHTMLIn.tabSet(sParameter, this.moCurrentAttr, this.markupAttr());
                break;
            }
            case 156: {
                this.pendingTab(0);
                break;
            }
            case 157: {
                this.pendingTab(1);
                break;
            }
            case 158: {
                this.pendingTab(2);
                break;
            }
            case 142: {
                this.pendingTab(3);
                break;
            }
            case 143: {
                int tabs;
                Integer count = StringUtils.number(sParameter);
                if (count == null || (tabs = count.intValue()) <= 0) break;
                this.mnTabCount += tabs;
                break;
            }
            case 159: {
                int eParm = this.markupAttr().lookup(sParameter);
                int eDigits = 0;
                switch (eParm) {
                    case 161: {
                        eDigits = 1;
                        break;
                    }
                    case 162: {
                        eDigits = 2;
                    }
                }
                this.moCurrentAttr.digits(eDigits);
                break;
            }
            case 167: {
                int eLigature;
                int eParm = this.markupAttr().lookup(sParameter);
                switch (eParm) {
                    case 169: {
                        eLigature = 1;
                        break;
                    }
                    default: {
                        eLigature = 0;
                    }
                }
                this.moCurrentAttr.ligature(eLigature);
                break;
            }
            case 54: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.charSpacing(oMeasure);
                break;
            }
            case 55: {
                oMeasure = TextMeasurement.fromString(sParameter, MarkupXHTMLIn.stringToUnit(this.markupAttr(), sParameter));
                this.moCurrentAttr.wordSpacing(oMeasure);
                break;
            }
            case 171: {
                int eParm = this.markupAttr().lookup(sParameter);
                if (eParm == 3) {
                    if (!this.moCurrentAttr.hyphLevelEnable() || this.moCurrentAttr.hyphLevel() != 0) break;
                    this.moCurrentAttr.hyphLevel(2);
                    break;
                }
                this.moCurrentAttr.hyphLevel(0);
                break;
            }
            case 172: {
                int eParm = this.markupAttr().lookup(sParameter);
                int eLevel = 0;
                switch (eParm) {
                    case 173: {
                        eLevel = 1;
                        break;
                    }
                    case 5: {
                        eLevel = 2;
                        break;
                    }
                    case 2: {
                        eLevel = 3;
                    }
                }
                if (eLevel == 0) break;
                this.moCurrentAttr.hyphLevel(eLevel);
                break;
            }
            case 174: {
                int result;
                Integer convert;
                String sToken;
                int nValues;
                StringBuilder sTokens = new StringBuilder(sParameter);
                int[] nMin = new int[3];
                for (nValues = 0; nValues < 3 && (sToken = StringUtils.parseToken(sTokens)) != null && (convert = StringUtils.number(sToken)) != null && (result = convert.intValue()) >= 0; ++nValues) {
                    nMin[nValues] = result;
                }
                if (nValues <= 0) break;
                this.moCurrentAttr.hyphMinWord(nMin[0]);
                if (nValues <= 1) break;
                this.moCurrentAttr.hyphMinPrefix(nMin[1]);
                if (nValues <= 2) break;
                this.moCurrentAttr.hyphMinSuffix(nMin[2]);
                break;
            }
            case 175: {
                boolean bAcronyms = this.markupAttr().lookup(sParameter) == 3;
                this.moCurrentAttr.hyphSuppressAcronyms(!bAcronyms);
                break;
            }
            case 176: {
                boolean bNames = this.markupAttr().lookup(sParameter) == 3;
                this.moCurrentAttr.hyphSuppressNames(!bNames);
                break;
            }
            case 177: {
                int eAlign = 0;
                if (this.markupAttr().lookup(sParameter) == 178) {
                    eAlign = 1;
                }
                this.moCurrentAttr.leaderAlign(eAlign);
                break;
            }
            case 179: {
                int ePattern = 0;
                switch (this.markupAttr().lookup(sParameter)) {
                    case 181: {
                        ePattern = 1;
                        break;
                    }
                    case 182: {
                        ePattern = 2;
                        break;
                    }
                    case 183: 
                    case 184: {
                        ePattern = 3;
                    }
                }
                this.moCurrentAttr.leaderPattern(ePattern);
                break;
            }
            case 185: {
                oMeasure = TextMeasurement.fromString(sParameter);
                this.moCurrentAttr.leaderPatternWidth(oMeasure);
                break;
            }
            case 186: {
                int eStyle = 1;
                switch (this.markupAttr().lookup(sParameter)) {
                    case 4: {
                        eStyle = 0;
                        break;
                    }
                    case 187: {
                        eStyle = 2;
                        break;
                    }
                    case 188: {
                        eStyle = 3;
                    }
                }
                this.moCurrentAttr.ruleStyle(eStyle);
                break;
            }
            case 189: {
                oMeasure = TextMeasurement.fromString(sParameter);
                this.moCurrentAttr.ruleThickness(oMeasure);
                break;
            }
            default: {
                bCommandHandled = false;
            }
        }
        return bCommandHandled;
    }

    private boolean handleStylingAttributes(Attributes attributes, boolean bIsPara) {
        boolean bHasStyle = false;
        String sAttr = this.getAttr(attributes, 41);
        if (sAttr != null) {
            this.parseStyleAttr(sAttr, false);
            bHasStyle = true;
        }
        if ((sAttr = this.getAttr(attributes, 163)) != null) {
            int eParm = this.markupAttr().lookup(sAttr);
            int eDirection = 0;
            switch (eParm) {
                case 165: {
                    eDirection = 1;
                    break;
                }
                case 166: {
                    eDirection = 2;
                }
            }
            if (bIsPara) {
                this.moCurrentAttr.paraDirection(eDirection);
            } else {
                this.moCurrentAttr.direction(eDirection);
            }
            this.attr(this.moCurrentAttr);
            bHasStyle = true;
        }
        return bHasStyle;
    }

    private void initialize(TextAttr poAmbientAttr) {
        this.mbVersionDetermined = false;
        this.mbTextAccumulated = false;
        this.mbParaStarted = true;
        this.mePending = 1;
        this.mnTabCount = 0;
        this.mbAmbientSupplied = false;
        if (poAmbientAttr != null) {
            this.moAmbientAttr = poAmbientAttr;
            this.mbAmbientSupplied = true;
        }
    }

    private boolean handleStylingAttributes(Attributes attributes) {
        return this.handleStylingAttributes(attributes, false);
    }

    private void parseStyleAttr(String sAttr, boolean bIsInlineTag) {
        boolean BIT_INDENT_LEFT = true;
        int BIT_SPACE_BEFORE = 2;
        int BIT_INDENT_RIGHT = 4;
        int BIT_SPACE_AFTER = 8;
        int BIT_INDENT_FIRST_LINE = 16;
        int BIT_LINE_HEIGHT = 32;
        int BIT_JUSTIFY_VERT = 64;
        int BIT_JUSTIFY = 128;
        int BIT_TAB_DEFAULT = 256;
        int BIT_ALL_PARA = 511;
        int nBits = 0;
        String sName = null;
        int nItalic = -1;
        int nWeight = 0;
        UnitSpan oSize = null;
        StyleInfo info = new StyleInfo(sAttr);
        while (this.extractStyleElement(info)) {
            String value = info.parameter.toString();
            switch (info.commandEnum) {
                case 65: {
                    sName = value;
                    break;
                }
                case 67: {
                    if (this.findAttr(value, 70)) {
                        nWeight = 700;
                        break;
                    }
                    if (!this.findAttr(value, 5)) break;
                    nWeight = 400;
                    break;
                }
                case 68: {
                    if (this.findAttr(value, 71)) {
                        nItalic = 1;
                        break;
                    }
                    if (!this.findAttr(value, 5)) break;
                    nItalic = 0;
                    break;
                }
                case 66: {
                    oSize = new UnitSpan(value, MarkupXHTMLIn.stringToUnit(this.markupAttr(), value), false);
                }
            }
        }
        if (sName != null || nWeight != 0 || nItalic != -1 || oSize != null) {
            this.moCurrentAttr.typeface(sName, oSize, nWeight, nItalic);
        }
        info.offset = 0;
        while (this.extractStyleElement(info)) {
            if (info.commandEnum != 65 && info.commandEnum != 67 && info.commandEnum != 68 && info.commandEnum != 66) {
                this.onCommand(info.commandEnum, info.parameter.toString());
            }
            switch (info.commandEnum) {
                case 58: {
                    nBits |= 1;
                    break;
                }
                case 61: {
                    nBits |= 2;
                    break;
                }
                case 59: {
                    nBits |= 4;
                    break;
                }
                case 62: {
                    nBits |= 8;
                    break;
                }
                case 57: {
                    nBits |= 0x10;
                    break;
                }
                case 53: {
                    nBits |= 0x20;
                    break;
                }
                case 132: {
                    nBits |= 0x40;
                    break;
                }
                case 119: {
                    nBits |= 0x80;
                    break;
                }
                case 137: {
                    nBits |= 0x100;
                }
            }
        }
        if (!this.mbVersionDetermined) {
            this.mbVersionDetermined = true;
            if (nBits == 511) {
                this.switchToFF99Mode();
            }
        }
        this.flushPendingText(bIsInlineTag ? 0 : 4);
        this.attr(this.moCurrentAttr);
    }

    private static int stringToUnit(MarkupAttr pMarkupAttr, String sString) {
        int lStart = StringUtils.skipOver(sString, gsNumeric, 0);
        String sUnit = sString.substring(lStart);
        if (sUnit.equals(pMarkupAttr.lookup(144))) {
            return 1;
        }
        if (sUnit.equals(pMarkupAttr.lookup(145))) {
            return 19;
        }
        if (sUnit.equals(pMarkupAttr.lookup(146))) {
            return 3;
        }
        if (sUnit.equals(pMarkupAttr.lookup(147))) {
            return 17;
        }
        return 255;
    }

    private static int stringToAlign(MarkupAttr pMarkupAttr, String sString) {
        if (sString.equals(pMarkupAttr.lookup(156))) {
            return 0;
        }
        if (sString.equals(pMarkupAttr.lookup(158))) {
            return 2;
        }
        if (sString.equals(pMarkupAttr.lookup(157))) {
            return 1;
        }
        if (sString.equals(pMarkupAttr.lookup(142))) {
            return 3;
        }
        return 0;
    }

    private void updateWeight(String sString) {
        if (this.findAttr(sString, 70)) {
            this.moCurrentAttr.weight(700);
        } else if (this.findAttr(sString, 5)) {
            this.moCurrentAttr.weight(400);
        }
    }

    private void updateItalic(String sString) {
        if (this.findAttr(sString, 71)) {
            this.moCurrentAttr.italic(true);
        } else if (this.findAttr(sString, 5)) {
            this.moCurrentAttr.italic(false);
        }
    }

    private void updateFont(String sString) {
        this.updateWeight(sString);
        this.updateItalic(sString);
        int nFoundAt = sString.indexOf(32);
        int nOffset = 0;
        while (nFoundAt >= nOffset) {
            String sCmd = sString.substring(nOffset, nFoundAt);
            int eCmd = this.markupAttr().lookup(sCmd);
            if (eCmd != 70 && eCmd != 5 && eCmd != 71) {
                char c;
                char c2 = c = sCmd.length() == 0 ? (char)'\u0000' : sCmd.charAt(0);
                if (c >= '0' && c <= '9') {
                    int nFoundLH = sCmd.indexOf(47);
                    if (nFoundLH >= 0) {
                        String sLineHeight = sCmd.substring(nFoundLH + 1);
                        this.onCommand(53, sLineHeight);
                        sCmd = sCmd.substring(nFoundLH);
                    }
                    this.onCommand(66, sCmd);
                } else {
                    if (c == '\'' || c == '\"') {
                        nFoundAt = sString.indexOf(c, nFoundAt + 1);
                        sCmd = sString.substring(nOffset, nFoundAt);
                    }
                    this.onCommand(65, sCmd);
                }
            }
            nOffset = nFoundAt + 1;
            nFoundAt = sString.indexOf(32, nOffset);
        }
    }

    private boolean findAttr(String sCommand, int eTag) {
        return sCommand.contains(this.markupAttr().lookup(eTag));
    }

    private void embed(String sExpression, int eEmbedType, int eEmbedMode) {
        TextField oTextField = new TextField(eEmbedType, eEmbedMode, sExpression);
        oTextField.fontService(this.fontService());
        if (this.mpoResolver != null) {
            this.mpoResolver.embedContent(oTextField);
        }
        this.field(oTextField);
    }

    private void switchToFF99Mode() {
        for (int i = 0; i < this.moStack.size(); ++i) {
            if (this.moStack.frameAt((int)i).meSpace > 2) continue;
            this.moStack.frameAt((int)i).meSpace = 5;
        }
    }

    private boolean extractStyleElement(StyleInfo info) {
        int nCommandInitialAlloc = 32;
        int nParameterInitialAlloc = 128;
        if (this.mIterator == null) {
            this.mIterator = new UniCharIterator();
        }
        this.mIterator.attach(info.attrValue, info.offset);
        info.commandEnum = 0;
        while (info.commandEnum == 0 && this.mIterator.getIndex() < info.attrValue.length()) {
            info.command.delete(0, info.command.length());
            info.parameter.delete(0, info.parameter.length());
            int nAlloc = info.attrValue.length() - info.offset;
            if (nAlloc < 32) {
                nAlloc = 32;
            }
            info.command.ensureCapacity(nAlloc);
            int cQuote = 0;
            int nQuoteStart = 0;
            boolean STATE_PRE_COMMAND = false;
            boolean STATE_COMMAND = true;
            int STATE_POST_COMMAND = 2;
            int STATE_PRE_PARAMETER = 3;
            int STATE_PARAMETER = 4;
            int STATE_DONE = 5;
            int eState = 0;
            while (this.mIterator.getIndex() < info.attrValue.length() && eState != 5) {
                int nPrevOffset = this.mIterator.getIndex();
                int c = this.mIterator.next();
                if (cQuote != 0) {
                    if (c != cQuote) continue;
                    cQuote = 0;
                    switch (eState) {
                        case 3: 
                        case 4: {
                            info.parameter.append(info.attrValue, nQuoteStart, nPrevOffset);
                        }
                    }
                    continue;
                }
                if (c == 34 || c == 39) {
                    nQuoteStart = nPrevOffset + 1;
                    cQuote = c;
                    continue;
                }
                block3 : switch (eState) {
                    case 0: {
                        switch (c) {
                            case 32: 
                            case 58: 
                            case 59: {
                                break block3;
                            }
                        }
                        UniCharIterator.append(info.command, c);
                        eState = 1;
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case 32: {
                                eState = 2;
                                break block3;
                            }
                            case 59: {
                                eState = 5;
                                break block3;
                            }
                            case 58: {
                                eState = 3;
                                break block3;
                            }
                        }
                        UniCharIterator.append(info.command, c);
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case 59: {
                                eState = 5;
                                break block3;
                            }
                            case 58: {
                                eState = 3;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (c) {
                            case 59: {
                                eState = 5;
                                break block3;
                            }
                            case 32: {
                                break block3;
                            }
                        }
                        nAlloc = info.attrValue.length() - this.mIterator.getIndex();
                        if (nAlloc < 128) {
                            nAlloc = 128;
                        }
                        info.parameter.ensureCapacity(nAlloc);
                        UniCharIterator.append(info.parameter, c);
                        eState = 4;
                        break;
                    }
                    case 4: {
                        switch (c) {
                            case 59: {
                                eState = 5;
                                break block3;
                            }
                        }
                        UniCharIterator.append(info.parameter, c);
                    }
                }
            }
            if (eState == 0) continue;
            info.command.append(':');
            String cmd = info.command.toString();
            info.commandEnum = this.markupAttr().lookup(cmd);
            int nLength = info.parameter.length();
            while (nLength > 0) {
                if (MarkupXHTMLIn.isXHTMLSpace(info.parameter.charAt(--nLength))) continue;
                ++nLength;
                break;
            }
            info.parameter.delete(nLength, info.parameter.length());
        }
        info.offset = this.mIterator.getIndex();
        return info.commandEnum != 0;
    }

    private boolean inUnknownElement() {
        return this.moStack.top().meTag == 0;
    }

    private static boolean isXHTMLSpace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9 || c == 12;
    }

    private void updateSpaceStatus(int eTag, boolean bEnd) {
        int eSpace = this.moStack.top().meSpace;
        if (eTag == 18 || eTag == 46 || eTag == 154 || eTag == 47) {
            if (!bEnd || eTag == 46) {
                if (eSpace == 2 || eSpace == 1) {
                    this.moStack.top().meSpace = this.legacyBlankLineMode() ? 0 : 1;
                }
                this.mePending = 1;
            } else if (this.mePending == 3) {
                this.flushPendingText(0);
            }
        } else if (eTag == 22) {
            if (eSpace == 2) {
                this.moStack.top().meSpace = 1;
            }
        } else if (eSpace < 2) {
            this.moStack.top().meSpace = 2;
        }
    }

    private void updateSpaceStatus(int eTag) {
        this.updateSpaceStatus(eTag, false);
    }

    private void flushPendingText(int ePending) {
        if (ePending == 0) {
            int n = ePending = this.legacyBlankLineMode() ? 2 : 1;
        }
        if (this.mePending >= ePending || this.legacyBlankLineMode() && ePending == 1) {
            String psText = null;
            switch (this.mePending) {
                case 2: {
                    if (!this.legacyBlankLineMode() || !this.mbTextAccumulated) break;
                    psText = gsNewLine;
                    break;
                }
                case 4: {
                    psText = gsNewLine;
                    break;
                }
                case 3: {
                    if (this.legacyBlankLineMode() && ePending == 1) break;
                    psText = " ";
                }
            }
            if (psText != null) {
                this.pushAttr();
                this.attr(this.moPendingAttr);
                this.text(psText);
                if (this.moStack.top().meSpace == 2) {
                    this.moStack.top().meSpace = 1;
                }
                this.popAttr();
                this.mePending = 1;
            }
        }
    }

    private static boolean extractHTMLVersion(String sVersion, int[] nVersion) {
        int nVersionIndex;
        if (sVersion.length() == 0) {
            return false;
        }
        for (nVersionIndex = 0; nVersionIndex < 4; ++nVersionIndex) {
            nVersion[nVersionIndex] = 0;
        }
        int nChar = 0;
        int nStartChar = 0;
        nVersionIndex = 0;
        while (nChar < sVersion.length()) {
            int nEndChar = nChar;
            char c = sVersion.charAt(nChar);
            ++nChar;
            if (c != '.') continue;
            if (nEndChar >= nStartChar) {
                String sComponent = sVersion.substring(nStartChar, nEndChar);
                Integer value = StringUtils.number(sComponent);
                if (value == null) {
                    return false;
                }
                nVersion[nVersionIndex] = value;
            }
            if (++nVersionIndex >= 4) {
                return true;
            }
            nStartChar = nChar;
        }
        return true;
    }

    private static int compareHTMLVersions(int[] nVersion1, int[] nVersion2) {
        for (int i = 0; i < 4; ++i) {
            if (nVersion1[i] < nVersion2[i]) {
                return -1;
            }
            if (nVersion1[i] <= nVersion2[i]) continue;
            return 1;
        }
        return 0;
    }

    private static TextTab extractTab(MarkupAttr markupAttr, String measurement, int tabType) {
        UnitSpan oValue = new UnitSpan(measurement, MarkupXHTMLIn.stringToUnit(markupAttr, measurement), false);
        return new TextTab(oValue, tabType);
    }

    private static TextTabList getTabList(TextAttr attr) {
        return attr == null || !attr.tabsEnable() ? new TextTabList() : new TextTabList(attr.tabs());
    }

    private void commitTabs(LeaderInfo poLeaderInfo) {
        if (poLeaderInfo != null) {
            this.moCurrentAttr.leaderContent(poLeaderInfo.moContent);
            this.attr(this.moCurrentAttr);
        }
        StringBuilder sTabs = new StringBuilder();
        sTabs.ensureCapacity(this.mnTabCount);
        for (int i = 0; i < this.mnTabCount; ++i) {
            sTabs.append('\t');
        }
        this.text(sTabs.toString());
        this.mnTabCount = 0;
        this.closeScopedBlock();
        this.popAttr();
        this.moStack.top().meTag = 0;
    }

    private static class XHTMLParser
    extends XMLParserBase {
        private MarkupXHTMLIn mpoCurrent;
        private final Storage<StackData> moStack = new Storage();
        private int mnDepth;
        private int mnPopDepth;

        XHTMLParser(MarkupXHTMLIn poXHTMLIn) {
            this.mpoCurrent = poXHTMLIn;
            this.push(poXHTMLIn);
        }

        void cleanup() {
            while (this.moStack.size() > 0) {
                this.pop();
            }
        }

        @Override
        public void onStartTag(String name, Attributes attributes) {
            ++this.mnDepth;
            MarkupXHTMLIn poProcessor = this.mpoCurrent.onStartTag(name, attributes);
            if (poProcessor != null) {
                this.push(poProcessor);
            }
        }

        @Override
        public void onEndTag(String name) {
            if (this.mnDepth == this.mnPopDepth) {
                this.pop();
            }
            this.mpoCurrent.onEndTag(name);
            assert (this.mnDepth > 0);
            --this.mnDepth;
        }

        @Override
        public void onContent(String content) {
            this.mpoCurrent.onHandleText(content);
        }

        private void push(MarkupXHTMLIn poProcessor) {
            StackData oStackData = new StackData(poProcessor, this.mnDepth);
            this.moStack.add(oStackData);
            this.mpoCurrent = poProcessor;
            this.mnPopDepth = this.mnDepth;
        }

        private void pop() {
            assert (this.moStack.size() > 0);
            if (this.mnPopDepth > 0) {
                this.mpoCurrent.commit();
            }
            this.moStack.removeLast();
            if (this.moStack.size() > 0) {
                StackData oStackData = this.moStack.last();
                this.mpoCurrent = oStackData.mpoProcessor;
                this.mnPopDepth = oStackData.mnPopDepth;
            }
        }

        private static class StackData {
            final MarkupXHTMLIn mpoProcessor;
            final int mnPopDepth;

            StackData(MarkupXHTMLIn processor, int popDepth) {
                this.mpoProcessor = processor;
                this.mnPopDepth = popDepth;
            }
        }
    }

    private static class StyleInfo {
        final String attrValue;
        int offset;
        int commandEnum;
        final StringBuilder command = new StringBuilder();
        final StringBuilder parameter = new StringBuilder();

        StyleInfo(String attrValue) {
            this.attrValue = attrValue;
        }
    }

    private static class LeaderInfo {
        final MarkupXHTMLIn mpoIn;
        final TextStream moContent;
        final TextPosn moPosn;

        public LeaderInfo(MarkupXHTMLIn poIn) {
            this.mpoIn = poIn;
            this.moContent = new TextStream();
            this.moPosn = new TextPosn(this.moContent);
        }
    }

    private static class Stack
    extends Storage<Frame> {
        static final long serialVersionUID = 1010338834063169704L;

        Stack() {
        }

        final Frame frameAt(int index) {
            return (Frame)this.get(index);
        }

        final Frame top() {
            return this.frameAt(this.size() - 1);
        }

        final void push(Frame frame) {
            this.add(frame);
        }

        final void pop() {
            this.removeLast();
        }
    }

    private static class Frame {
        int meTag;
        int meSpace;

        Frame() {
            this.meTag = 0;
            this.meSpace = 2;
        }

        Frame(int eTag, int eSpace) {
            this.meTag = eTag;
            this.meSpace = eSpace;
        }
    }
}

