/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextIntArray;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.UniCharIterator;

public class TextGlyphRun {
    private TextAttr mpoAttr;
    private CoordPair moShift;
    private CoordPair moPosition;
    private final TextIntArray moGlyphs = new TextIntArray();
    private boolean mbIsCharRun;
    private boolean mbIsRTL;
    private int meGlyphOrientation = 0;

    public TextGlyphRun() {
    }

    public TextGlyphRun(TextGlyphRun oSource) {
        this.copyFrom(oSource);
    }

    public void setAttr(TextAttr oAttr) {
        this.mpoAttr = new TextAttr(oAttr);
    }

    public void setAttrRef(TextAttr poAttr) {
        this.mpoAttr = poAttr;
    }

    public TextAttr getAttr() {
        return this.mpoAttr;
    }

    public void setShift(CoordPair oShift) {
        this.moShift = oShift;
    }

    public CoordPair getShift() {
        return this.moShift == null ? CoordPair.zeroZero() : this.moShift;
    }

    public boolean isShifted() {
        return this.moShift != null && (this.moShift.x().value() != 0 || this.moShift.y().value() != 0);
    }

    public CoordPair getPosition() {
        return this.moPosition == null ? CoordPair.zeroZero() : this.moPosition;
    }

    public void addGlyph(int nAdd) {
        this.moGlyphs.add(nAdd);
    }

    public void addCharGlyphs(String sCharGlyphs) {
        UniCharIterator iter = new UniCharIterator(sCharGlyphs);
        int c = iter.next();
        while (c != 0) {
            this.addGlyph(c);
            c = iter.next();
        }
    }

    public int getGlyphCount() {
        return this.moGlyphs.getSize();
    }

    public int getGlyph(int nIndex) {
        return this.moGlyphs.get(nIndex);
    }

    public void setCharRun(boolean bCharRun) {
        this.mbIsCharRun = bCharRun;
    }

    public boolean isCharRun() {
        return this.mbIsCharRun;
    }

    public void setRTL(boolean bRTL) {
        this.mbIsRTL = bRTL;
    }

    public boolean isRTL() {
        return this.mbIsRTL;
    }

    public void setGlyphOrientation(int eGlyphOrientation) {
        this.meGlyphOrientation = eGlyphOrientation;
    }

    public int getGlyphOrientation() {
        return this.meGlyphOrientation;
    }

    public void copyFrom(TextGlyphRun oSource) {
        if (this != oSource) {
            this.moShift = oSource.moShift;
            this.moPosition = oSource.moPosition;
            this.moGlyphs.copyFrom(oSource.moGlyphs);
            this.mbIsCharRun = oSource.mbIsCharRun;
            this.mbIsRTL = oSource.mbIsRTL;
            this.meGlyphOrientation = oSource.meGlyphOrientation;
            this.mpoAttr = oSource.mpoAttr;
        }
    }

    void setPosition(CoordPair oPosition) {
        this.moPosition = oPosition;
    }
}

