/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRange;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.Rect;

public class TextEditor {
    public static final boolean LOGICAL_DEFAULT = true;
    private TextRange moRange = new TextRange();
    private GFXEnv mpoGfxEnv;
    private boolean mbUpdateDisplay;
    private Rect moPrevExtent;

    public TextEditor() {
        this.mbUpdateDisplay = true;
    }

    public TextEditor(TextEditor oSource) {
        this.moRange.copyFrom(oSource.moRange);
        this.mpoGfxEnv = oSource.mpoGfxEnv;
        this.mbUpdateDisplay = oSource.mbUpdateDisplay;
    }

    public TextEditor(GFXEnv poGfxEnv) {
        this.mpoGfxEnv = poGfxEnv;
        this.mbUpdateDisplay = true;
    }

    public TextEditor(TextStream poStream, GFXEnv poGfxEnv, boolean bSelectAll) {
        this.mpoGfxEnv = poGfxEnv;
        this.mbUpdateDisplay = true;
        this.associate(poStream, bSelectAll);
    }

    public TextEditor(TextRange oRange, GFXEnv poGfxEnv) {
        this.mpoGfxEnv = poGfxEnv;
        this.mbUpdateDisplay = true;
        this.associate(oRange);
    }

    public TextEditor(TextPosnBase oPosn, GFXEnv poGfxEnv) {
        this.mpoGfxEnv = poGfxEnv;
        this.mbUpdateDisplay = true;
        this.associate(oPosn);
    }

    public void associate(TextStream poStream, boolean bSelectAll) {
        TextRange oNewRange = new TextRange();
        if (bSelectAll) {
            oNewRange.associate(poStream);
        } else {
            oNewRange.associate(poStream, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        this.moveComplete(oNewRange);
    }

    public void associate(TextRange oRange) {
        TextRange oNewRange = new TextRange(oRange);
        this.moveComplete(oNewRange);
    }

    public void associate(TextPosnBase oPosn) {
        TextRange oNewRange = new TextRange(oPosn.stream(), oPosn.index(), oPosn.index());
        this.moveComplete(oNewRange);
    }

    public void associate(int nIndexStart, int nIndexEnd) {
        TextRange oNewRange = new TextRange(this.moRange.stream(), nIndexStart, nIndexEnd);
        this.moveComplete(oNewRange);
    }

    public void userAssociate(TextStream poStream, int nIndexStart, int nIndexEnd) {
        TextRange oNewRange = new TextRange(poStream, TextEditor.userIndexToStreamIndex(poStream, nIndexStart), TextEditor.userIndexToStreamIndex(poStream, nIndexEnd));
        this.moveComplete(oNewRange);
    }

    public void getUserPosition(IntegerHolder nIndexStart, IntegerHolder nIndexEnd) {
        nIndexStart.value = TextEditor.streamIndexToUserIndex(this.moRange.stream(), this.moRange.start().index());
        nIndexEnd.value = TextEditor.streamIndexToUserIndex(this.moRange.stream(), this.moRange.end().index());
    }

    public TextRange range() {
        return this.moRange;
    }

    public void range(TextRange oNewRange) {
        this.associate(oNewRange);
    }

    public GFXEnv gfxEnv() {
        return this.mpoGfxEnv;
    }

    public void gfxEnv(GFXEnv poNewGfxEnv) {
        this.mpoGfxEnv = poNewGfxEnv;
    }

    public boolean updateDisplay() {
        return this.mbUpdateDisplay;
    }

    public void updateDisplay(boolean bNewUpdateDisplay) {
        this.mbUpdateDisplay = bNewUpdateDisplay;
    }

    public boolean moveChar(boolean bForward, boolean bSelect, boolean bLogical) {
        TextPosnBase oPosn = new TextPosnBase(this.moRange.loose());
        boolean bMoved = bForward ? oPosn.nextUserPosn(!bLogical) : oPosn.prevUserPosn(!bLogical);
        this.moveComplete(oPosn, bSelect);
        return bMoved;
    }

    public boolean moveChar(boolean bForward, boolean bSelect) {
        return this.moveChar(bForward, bSelect, true);
    }

    public boolean moveWord(boolean bForward, boolean bSelect, boolean bLogical, int eWordMode) {
        TextPosnBase oPosn = new TextPosnBase(this.moRange.loose());
        boolean bMoved = bForward ? oPosn.nextWord(!bLogical, eWordMode) : oPosn.prevWord(!bLogical, eWordMode);
        this.moveComplete(oPosn, bSelect);
        return bMoved;
    }

    public boolean moveWord(boolean bForward, boolean bSelect, int eWordMode) {
        return this.moveWord(bForward, bSelect, true, eWordMode);
    }

    public boolean moveLine(boolean bForward, boolean bSelect) {
        TextPosnBase oPosn = new TextPosnBase(this.moRange.loose());
        boolean bMoved = false;
        if (bForward) {
            bMoved = oPosn.down();
            if (!bMoved && bSelect) {
                bMoved = oPosn.end();
            }
        } else {
            bMoved = oPosn.up();
            if (!bMoved && bSelect) {
                bMoved = oPosn.start();
            }
        }
        this.moveComplete(oPosn, bSelect);
        return bMoved;
    }

    public boolean movePara(boolean bForward, boolean bSelect) {
        TextPosnBase oPosn = new TextPosnBase(this.moRange.loose());
        boolean bMoved = bForward ? oPosn.nextPara() : oPosn.prevPara();
        this.moveComplete(oPosn, bSelect);
        return bMoved;
    }

    public boolean moveAll(boolean bAbsolute, boolean bForward, boolean bSelect, boolean bLogical) {
        TextPosnBase oPosn = new TextPosnBase(this.moRange.loose());
        boolean bMoved = false;
        if (bAbsolute) {
            if (bForward) {
                oPosn.last(!bLogical);
            } else {
                oPosn.first(!bLogical);
            }
            bMoved = true;
        } else {
            bMoved = bForward ? oPosn.end(!bLogical) : oPosn.start(!bLogical);
        }
        this.moveComplete(oPosn, bSelect);
        return bMoved;
    }

    public boolean moveAll(boolean bAbsolute, boolean bForward, boolean bSelect) {
        return this.moveAll(bAbsolute, bForward, bSelect, true);
    }

    public void grabWord(int eWordMode) {
        TextRange oNewRange = new TextRange(this.moRange);
        oNewRange.grabWord();
        this.moveComplete(oNewRange);
    }

    public void grabWord() {
        this.grabWord(0);
    }

    public void grabLine() {
        TextRange oNewRange = new TextRange(this.moRange);
        oNewRange.grabLine();
        this.moveComplete(oNewRange);
    }

    public void grabPara() {
        TextRange oNewRange = new TextRange(this.moRange);
        oNewRange.grabPara();
        this.moveComplete(oNewRange);
    }

    public void grabAll() {
        TextRange oNewRange = new TextRange(this.moRange.stream());
        this.moveComplete(oNewRange);
    }

    public int selectCount() {
        return this.moRange.countText();
    }

    public String selectText() {
        return this.moRange.text();
    }

    public void selectText(TextStream oSelect) {
        this.moRange.text(oSelect);
    }

    public TextAttr attributeGet() {
        return this.moRange.attribute();
    }

    public void attributeSet(TextAttr oNewAttr) {
        this.editStart();
        this.moRange.attribute(oNewAttr);
        this.editComplete(true);
    }

    public void replace(char cInsert, boolean bKeepRange) {
        this.editStart();
        this.moRange.replace(cInsert);
        this.editComplete(bKeepRange);
    }

    public void replace(String sInsert, boolean bKeepRange) {
        this.editStart();
        this.moRange.replace(sInsert);
        this.editComplete(bKeepRange);
    }

    public void replace(TextStream oInsert, boolean bKeepRange) {
        this.editStart();
        this.moRange.replace(oInsert);
        this.editComplete(bKeepRange);
    }

    public void replacePara() {
        this.editStart();
        this.moRange.delete();
        TextPosnBase oPosn = new TextPosnBase(this.moRange.anchor());
        oPosn.insertPara();
        this.editComplete();
    }

    public void deleteChar(boolean bForward) {
        this.editStart();
        TextPosnBase oPosn = new TextPosnBase(this.moRange.loose());
        if (bForward) {
            oPosn.deleteAhead();
        } else {
            oPosn.deleteBack();
        }
        this.editComplete();
    }

    public void deleteWord(boolean bForward, int eWordMode) {
        this.grabWord();
        this.deleteSelect();
    }

    public void deleteWord(boolean bForward) {
        this.deleteWord(bForward, 0);
    }

    public void deleteLine(boolean bForward) {
        this.grabLine();
        this.deleteSelect();
    }

    public void deletePara(boolean bForward) {
        this.grabPara();
        this.deleteSelect();
    }

    public void deleteAll(boolean bForward) {
        this.grabAll();
        this.deleteSelect();
    }

    public void deleteSelect() {
        this.editStart();
        this.moRange.delete();
        this.editComplete();
    }

    public TextEditor cloneEditor() {
        return new TextEditor(this);
    }

    public void onTextChanged(boolean bExtentChanged) {
    }

    public CoordPair relToAbs(GFXEnv poGfxEnv, CoordPair oPoint) {
        return oPoint;
    }

    public CoordPair absToRel(GFXEnv poGfxEnv, CoordPair oPoint) {
        return oPoint;
    }

    public void showCaret() {
    }

    public void complete() {
        this.moRange.start(this.moRange.end());
    }

    private void moveComplete(TextPosnBase oPosn, boolean bSelect, TextStream poDescendantStream) {
        TextRange oNewRange = new TextRange(this.moRange);
        oNewRange.loose(oPosn.index());
        if (!bSelect) {
            TextPosnBase oStart = new TextPosnBase(oPosn);
            if (poDescendantStream != null && poDescendantStream != this.moRange.stream()) {
                oStart.prev();
            }
            oNewRange.anchor(oStart.index());
        }
        this.moveComplete(oNewRange);
    }

    private void moveComplete(TextPosnBase oPosn, boolean bSelect) {
        this.moveComplete(oPosn, bSelect, null);
    }

    private void moveComplete(TextRange oNewRange) {
        TextDisplay poDisplay;
        oNewRange.tighten();
        if (!this.mbUpdateDisplay || this.mpoGfxEnv == null || (poDisplay = this.display()) != null) {
            // empty if block
        }
        this.moRange = oNewRange;
        this.showCaret();
    }

    private void editStart() {
        this.moRange.tighten();
        Rect poExtent = this.extent();
        if (poExtent != null) {
            this.moPrevExtent = poExtent;
        }
    }

    private void editComplete(boolean bKeepRange) {
        if (!bKeepRange) {
            this.moRange.start(this.moRange.end());
        }
        boolean bExtentChange = false;
        Rect poExtent = this.extent();
        if (poExtent != null && poExtent != this.moPrevExtent) {
            bExtentChange = true;
        }
        this.onTextChanged(bExtentChange);
        this.showCaret();
    }

    private void editComplete() {
        this.editComplete(false);
    }

    private Rect extent() {
        return null;
    }

    private TextDisplay display() {
        TextStream poStream = this.moRange.stream();
        if (poStream == null) {
            return null;
        }
        return poStream.display();
    }

    private static int userIndexToStreamIndex(TextStream poStream, int nUserIndex) {
        TextPosnBase oPosn = new TextPosnBase(poStream);
        if (nUserIndex > poStream.posnCount()) {
            nUserIndex = poStream.posnCount();
        }
        while (nUserIndex-- > 0) {
            oPosn.nextUserPosn();
        }
        return oPosn.index();
    }

    private static int streamIndexToUserIndex(TextStream poStream, int nStreamIndex) {
        TextPosnBase oPosn = new TextPosnBase(poStream, nStreamIndex);
        int nUserIndex = 0;
        while (oPosn.prevUserPosnType() != 0) {
            ++nUserIndex;
        }
        return nUserIndex;
    }
}

