/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.text.DispLine;
import com.adobe.xfa.text.DispLineWrapped;
import com.adobe.xfa.text.DispPosn;
import com.adobe.xfa.text.DrawParm;
import com.adobe.xfa.text.LeaderFill;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextDisplay;
import com.adobe.xfa.text.TextDrawInfo;
import com.adobe.xfa.text.TextFrame;
import com.adobe.xfa.text.TextPosnBase;
import com.adobe.xfa.text.TextRegion;
import com.adobe.xfa.text.TextSelection;
import com.adobe.xfa.text.Units;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

class LeaderContent
extends LeaderFill {
    private final TextDrawInfo moDrawInfo;
    private final int mnCharIndex;
    private TextRegion mpoLeaderRegion;
    private TextDisplay mpoLeaderDisplay;
    private DispLineWrapped mpoLeaderContentLine;
    private DrawParm mpoLeaderParm;
    private TextSelection mpoPrimary;
    private TextSelection mpoSecondary;
    private UnitSpan moOffsetY;

    LeaderContent(DrawParm oDrawParm, int nCharIndex) {
        super(oDrawParm);
        this.moDrawInfo = new TextDrawInfo(oDrawParm.env());
        this.mnCharIndex = nCharIndex;
    }

    @Override
    int alignment() {
        TextPosnBase oPosn;
        TextAttr poAttr;
        if (this.mpoLeaderRegion != null && (poAttr = (oPosn = new TextPosnBase(this.mpoLeaderRegion)).attributePtr()) != null && poAttr.justifyHEnable()) {
            return poAttr.justifyH();
        }
        return super.alignment();
    }

    @Override
    boolean onSetup() {
        assert (this.attr().leaderPattern() == 2 || this.attr().leaderPattern() == 3);
        this.mpoLeaderRegion = this.dispTab().getFillRegion();
        if (this.mpoLeaderRegion == null) {
            return false;
        }
        this.mpoLeaderDisplay = this.mpoLeaderRegion.display();
        if (this.mpoLeaderDisplay == null) {
            return false;
        }
        this.setBasePatternWidth(this.mpoLeaderDisplay.runtimeExtent(true).right());
        if (this.basePatternWidth().value() <= 0) {
            return false;
        }
        TextFrame poFrame = this.mpoLeaderRegion.getFrame(0);
        assert (poFrame != null);
        assert (poFrame.getLineCount() == 1);
        this.mpoLeaderContentLine = poFrame.getLine(0);
        this.mpoPrimary = this.resolveTabSelection(this.mpoLeaderRegion, this.mnCharIndex, this.drawParm().primary());
        this.mpoSecondary = this.resolveTabSelection(this.mpoLeaderRegion, this.mnCharIndex, this.drawParm().secondary());
        this.moDrawInfo.setPrimary(this.mpoPrimary);
        this.moDrawInfo.setSecondary(this.mpoSecondary);
        this.moDrawInfo.setPage(this.drawParm().page());
        assert (this.mpoLeaderParm == null);
        this.mpoLeaderParm = new DrawParm(this.moDrawInfo);
        this.mpoLeaderParm.setDriver(this.drawParm().driver());
        this.mpoLeaderParm.setCharIndex(this.mnCharIndex);
        this.moOffsetY = this.line().getBMin().add(this.textOffset());
        UnitSpan delta = Units.toUnitSpan(this.mpoLeaderContentLine.dispHeight().textOffset(0));
        this.moOffsetY = this.moOffsetY.subtract(delta);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onRender(UnitSpan oOffsetX) {
        CoordPair oOffset = new CoordPair(oOffsetX, this.moOffsetY);
        this.driver().pushOffset(true, oOffset);
        try {
            Rect oFillInvalid = this.drawParm().invalid().subtract(oOffset);
            this.mpoLeaderParm.setInvalid(oFillInvalid);
            this.mpoLeaderContentLine.gfxDraw(this.mpoLeaderParm);
        }
        finally {
            this.driver().popOffset();
        }
    }

    private TextSelection resolveTabSelection(TextRegion poLeaderRegion, int nCharIndex, TextSelection poSourceSelection) {
        if (poSourceSelection == null) {
            return null;
        }
        DispPosn oPosn = this.line().getMappedPosition(nCharIndex);
        if (oPosn.pp().stream() != poSourceSelection.stream()) {
            return null;
        }
        int nStreamIndex = DispLine.charToStreamIndex(oPosn, nCharIndex, 0);
        if (nStreamIndex < poSourceSelection.start().index() || nStreamIndex >= poSourceSelection.end().index()) {
            return null;
        }
        return new TextSelection(poSourceSelection.colour(), poSourceSelection.colourBg(), poLeaderRegion);
    }
}

