/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.TagnameFilter;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ContentArea;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.List;

public final class PageArea
extends Container {
    Measurement mZeroDefaultUnit = null;

    public PageArea(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "pageArea", "pageArea", null, XFA.PAGEAREATAG, "pageArea");
    }

    @Override
    public Attribute defaultAttribute(int eTag) {
        if (eTag == XFA.WTAG || eTag == XFA.HTAG) {
            if (this.mZeroDefaultUnit == null) {
                this.mZeroDefaultUnit = new Measurement("", "0");
            }
            return this.mZeroDefaultUnit;
        }
        return super.defaultAttribute(eTag);
    }

    public int getContentAreaCount() {
        int nCount = 0;
        NodeList oChildren = this.getNodes();
        for (int i = 0; i < oChildren.length(); ++i) {
            if (!(oChildren.item(i) instanceof ContentArea)) continue;
            ++nCount;
        }
        return nCount;
    }

    public UnitSpan getContentAreaHeight(int nCA) {
        ContentArea oCA = this.getContentAreaNode(nCA);
        if (oCA != null) {
            return oCA.getHeight();
        }
        return UnitSpan.ZERO;
    }

    public ContentArea getContentAreaNode(int nCA) {
        int nCount = 0;
        NodeList oChildren = this.getNodes();
        for (int i = 0; i < oChildren.length(); ++i) {
            if (!(oChildren.item(i) instanceof ContentArea)) continue;
            if (nCount == nCA) {
                return (ContentArea)oChildren.item(i);
            }
            ++nCount;
        }
        return null;
    }

    public List<Node> getContentAreaNodes() {
        TagnameFilter filter = new TagnameFilter(XFA.CONTENTAREATAG);
        List<Node> list = filter.filterNodes(this, 1);
        return list;
    }

    public UnitSpan getContentAreaWidth(int nCA) {
        ContentArea oCA = this.getContentAreaNode(nCA);
        if (oCA != null) {
            return oCA.getWidth();
        }
        return UnitSpan.ZERO;
    }

    public UnitSpan getHeight() {
        Element poMedium = this.getMedium();
        if (poMedium != null) {
            int eOrientation = ((EnumValue)poMedium.getAttribute(XFA.ORIENTATIONTAG)).getInt();
            Measurement oMeas = eOrientation == 2490369 ? (Measurement)poMedium.getAttribute(XFA.SHORTTAG) : (Measurement)poMedium.getAttribute(XFA.LONGTAG);
            return oMeas.getUnitSpan();
        }
        return UnitSpan.ZERO;
    }

    Element getMedium() {
        return this.getElement(XFA.MEDIUMTAG, true, 0, false, false);
    }

    public ContentArea getNextContentAreaNode(ContentArea oCA) {
        boolean bNext = false;
        NodeList oChildren = this.getNodes();
        for (int i = 0; i < oChildren.length(); ++i) {
            if (bNext && oChildren.item(i) instanceof ContentArea) {
                return (ContentArea)oChildren.item(i);
            }
            if (oCA != oChildren.item(i)) continue;
            bNext = true;
        }
        return null;
    }

    public EnumAttr getOrientation() {
        int eOrientation = 0x260000;
        Element poMedium = this.getMedium();
        if (poMedium != null) {
            eOrientation = ((EnumValue)poMedium.getAttribute(XFA.ORIENTATIONTAG)).getInt();
        }
        return EnumAttr.getEnum(eOrientation);
    }

    public List<Node> getPageContentNodes() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        TagnameFilter filter = new TagnameFilter();
        filter.setTagname(XFA.AREATAG);
        filter.filterNodes(this, 1, nodeList);
        filter.setTagname(XFA.DRAWTAG);
        filter.filterNodes(this, 1, nodeList);
        filter.setTagname(XFA.FIELDTAG);
        filter.filterNodes(this, 1, nodeList);
        filter.setTagname(XFA.SUBFORMTAG);
        filter.filterNodes(this, 1, nodeList);
        filter.setTagname(XFA.EXCLGROUPTAG);
        filter.filterNodes(this, 1, nodeList);
        return nodeList;
    }

    public UnitSpan getWidth() {
        Element poMedium = this.getMedium();
        if (poMedium != null) {
            int eOrientation = ((EnumValue)poMedium.getAttribute(XFA.ORIENTATIONTAG)).getInt();
            Measurement oMeas = eOrientation == 2490369 ? (Measurement)poMedium.getAttribute(XFA.LONGTAG) : (Measurement)poMedium.getAttribute(XFA.SHORTTAG);
            return oMeas.getUnitSpan();
        }
        return UnitSpan.ZERO;
    }

    boolean hasCompatibleMedium(PageArea pPageArea) {
        if (null != pPageArea) {
            String s2;
            String s1;
            Element poMedium1 = this.getMedium();
            Element poMedium2 = pPageArea.getMedium();
            if (null != poMedium1 && null != poMedium2 && (s1 = poMedium1.getAttribute(XFA.STOCKTAG).toString()).equals(s2 = poMedium2.getAttribute(XFA.STOCKTAG).toString())) {
                Measurement oM1 = (Measurement)poMedium1.getAttribute(XFA.SHORTTAG);
                Measurement oM2 = (Measurement)poMedium2.getAttribute(XFA.SHORTTAG);
                if (oM1.getUnitSpan() == oM2.getUnitSpan()) {
                    oM1 = (Measurement)poMedium1.getAttribute(XFA.LONGTAG);
                    oM2 = (Measurement)poMedium2.getAttribute(XFA.LONGTAG);
                    if (oM1.getUnitSpan() == oM2.getUnitSpan()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean hasPageContent() {
        return 0 < this.getPageContentNodes().size();
    }

    @Override
    public boolean isHeightGrowSupported() {
        return false;
    }

    @Override
    public boolean isWidthGrowSupported() {
        return false;
    }
}

