/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Int;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Obj;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.BooleanValue;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.DateTimeValue;
import com.adobe.xfa.content.DateValue;
import com.adobe.xfa.content.DecimalValue;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.FloatValue;
import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.content.IntegerValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.content.TimeValue;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.FieldScript;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.formatting.Picture;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.PictureFmt;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;

public class Field
extends Container {
    public Field(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "field", "field", null, XFA.FIELDTAG, "field");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearItems() {
        Items boundItems;
        block6: {
            boolean bSaveMute = this.isMute();
            boundItems = null;
            try {
                if (!bSaveMute) {
                    this.mute();
                }
                ItemPair items = new ItemPair();
                this.getItemLists(false, items, false);
                boundItems = items.mSaveItems;
                Items textItems = items.mDisplayItems;
                if (boundItems != null) {
                    boundItems.clearItems(false);
                }
                if (textItems != null) {
                    textItems.clearItems(false);
                }
                if (bSaveMute) break block6;
            }
            catch (Throwable throwable) {
                if (!bSaveMute) {
                    this.unMute();
                }
                this.notifyPeers(5, "items", boundItems);
                throw throwable;
            }
            this.unMute();
        }
        this.notifyPeers(5, "items", boundItems);
    }

    @Override
    protected Node defaultElementImpl(int eTag, int nOccurrence, boolean bAppend) {
        if (eTag == XFA.ITEMSTAG && nOccurrence == 1) {
            Element list1 = super.getElementLocal(XFA.ITEMSTAG, true, 0, false, false);
            if (list1 == null) {
                list1 = (Element)this.defaultElementImpl(XFA.ITEMSTAG, 0, false);
            }
            if (list1 != null) {
                Element list2 = this.getModel().createElement(bAppend ? this : null, this.getLastXMLChild(), null, "items");
                for (Node child = list1.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    child.clone(list2);
                }
                int eSave = list1.getEnum(XFA.SAVETAG);
                int ePresence = list1.getEnum(XFA.PRESENCETAG);
                if (eSave == 0x40040001) {
                    list2.setAttribute(0x40040000, XFA.SAVETAG);
                } else {
                    list2.setAttribute(0x40040001, XFA.SAVETAG);
                }
                if (ePresence == 1076494338 || ePresence == 1076494339) {
                    list2.setAttribute(1076494336, XFA.PRESENCETAG);
                } else {
                    list2.setAttribute(1076494338, XFA.PRESENCETAG);
                }
                return list2;
            }
        }
        return super.defaultElementImpl(eTag, nOccurrence, bAppend);
    }

    public boolean deleteItem(int nIndex) {
        boolean bRet = false;
        ItemPair items = new ItemPair();
        this.getItemLists(false, items, false);
        Items boundItems = items.mSaveItems;
        Items textItems = items.mDisplayItems;
        if (boundItems != null && nIndex < boundItems.getXFAChildCount()) {
            this.setItemState(nIndex, false);
            boundItems.removeItem(nIndex, false);
            if (boundItems != textItems) {
                textItems.removeItem(nIndex, false);
            }
            bRet = true;
        }
        return bRet;
    }

    public void execEvent(String sActivity) {
    }

    public boolean execValidate() {
        return true;
    }

    String getAccessKey() {
        Attribute oAttr;
        if (this.isValidAttr(XFA.ACCESSKEYTAG, false, null) && this.isPropertySpecified(XFA.ACCESSKEYTAG, true, 0) && (oAttr = this.getAttribute(XFA.ACCESSKEYTAG, true, false)) != null && !oAttr.isEmpty()) {
            String sAccessKey = oAttr.toString();
            return sAccessKey;
        }
        return "";
    }

    @Override
    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        String oValue;
        Attribute oProperty = super.getAttribute(eTag, bPeek, bValidate);
        if (eTag == XFA.LOCALETAG && !bPeek) {
            if (oProperty != null && !oProperty.isEmpty()) {
                return oProperty;
            }
            String sLocale = this.getInstalledLocale();
            return this.newAttribute(eTag, sLocale);
        }
        if (oProperty != null && eTag == XFA.LAYOUTTAG && !(oValue = oProperty.toString()).equals("lr-tb") && !oValue.equals("delegate")) {
            this.foundBadAttribute(eTag, oValue);
            return this.defaultAttribute(eTag);
        }
        return oProperty;
    }

    String getBackColor() {
        Element pColorNode;
        Element pFillNode;
        String sRet = "";
        Element pBorderNode = this.getElement(XFA.BORDERTAG, true, 0, true, false);
        if (pBorderNode != null && (pFillNode = pBorderNode.getElement(XFA.FILLTAG, true, 0, true, false)) != null && (pColorNode = pFillNode.getElement(XFA.COLORTAG, true, 0, true, false)) != null) {
            sRet = pColorNode.getAttribute(XFA.VALUETAG).toString();
        }
        return sRet;
    }

    String getBorderColor() {
        Element pColorNode;
        Element pEdgeNode;
        String sRet = "";
        Element pBorderNode = this.getElement(XFA.BORDERTAG, true, 0, true, false);
        if (pBorderNode != null && (pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, true, 0, true, false)) != null && (pColorNode = pEdgeNode.getElement(XFA.COLORTAG, true, 0, true, false)) != null) {
            sRet = pColorNode.getAttribute(XFA.VALUETAG).toString();
        }
        return sRet;
    }

    String getBorderWidth() {
        Element pEdgeNode;
        String sRet = "";
        Element pBorderNode = this.getElement(XFA.BORDERTAG, true, 0, true, false);
        if (pBorderNode != null && (pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, true, 0, true, false)) != null) {
            sRet = pEdgeNode.getAttribute(XFA.THICKNESSTAG).toString();
        }
        return sRet;
    }

    String getBoundItem(String sDisplayText) {
        ItemPair items = new ItemPair();
        this.getItemLists(true, items, false);
        Items oBoundItems = items.mSaveItems;
        Items oTextItems = items.mDisplayItems;
        if (oTextItems == null || oBoundItems == null) {
            return "";
        }
        boolean bFound = false;
        int nFoundAt = 0;
        TextValue child = (TextValue)oTextItems.getFirstXFAChild();
        while (child != null) {
            if (child.getValue().equals(sDisplayText)) {
                bFound = true;
                break;
            }
            child = (TextValue)child.getNextXFASibling();
            ++nFoundAt;
        }
        if (bFound) {
            int nIndex = 0;
            TextValue child2 = (TextValue)oBoundItems.getFirstXFAChild();
            while (child2 != null) {
                if (nIndex == nFoundAt) {
                    return child2.getValue();
                }
                child2 = (TextValue)child2.getNextXFASibling();
                ++nIndex;
            }
        }
        return "";
    }

    String getBoundItem(int nIndex) {
        ItemPair items = new ItemPair();
        this.getItemLists(true, items, false);
        Items oBoundItems = items.mSaveItems;
        if (oBoundItems == null) {
            return "";
        }
        int nCurrentIndex = 0;
        TextValue oBoundText = (TextValue)oBoundItems.getFirstXFAChild();
        while (oBoundText != null) {
            if (nCurrentIndex == nIndex) {
                return oBoundText.getValue();
            }
            oBoundText = (TextValue)oBoundText.getNextXFASibling();
            ++nCurrentIndex;
        }
        return "";
    }

    public DataNode getDataNode() {
        return null;
    }

    String getDisplayItem(int nIndex) {
        ItemPair items = new ItemPair();
        this.getItemLists(true, items, false);
        Items oTextItems = items.mDisplayItems;
        if (oTextItems == null) {
            return "";
        }
        int nCurrentIndex = 0;
        Content oDisplayText = (Content)oTextItems.getFirstXFAChild();
        while (oDisplayText != null) {
            if (nCurrentIndex == nIndex) {
                return oDisplayText.toString();
            }
            oDisplayText = (Content)oDisplayText.getNextXFASibling();
            ++nCurrentIndex;
        }
        return "";
    }

    String getDisplayItem(String sBoundText) {
        ItemPair items = new ItemPair();
        this.getItemLists(true, items, false);
        Items boundItems = items.mSaveItems;
        Items textItems = items.mDisplayItems;
        if (textItems == null || boundItems == null) {
            return "";
        }
        boolean bFound = false;
        int nFoundAt = 0;
        for (Node child = boundItems.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.toString().equals(sBoundText)) {
                bFound = true;
                break;
            }
            ++nFoundAt;
        }
        if (bFound) {
            int nCurrentIndex = 0;
            Node oDisplayText = textItems.getFirstXFAChild();
            while (oDisplayText != null) {
                if (nCurrentIndex == nFoundAt) {
                    Node poCurrentUI;
                    String sDisplay = oDisplayText.toString();
                    Element pUI = this.getElement(XFA.UITAG, 0);
                    if (pUI != null && (poCurrentUI = pUI.getOneOfChild(true, false)) != null && pUI.isSameClass(XFA.CHOICELISTTAG)) {
                        TemplateModel oTemplateModel;
                        boolean bLegacyRender = false;
                        AppModel oAppModel = this.getAppModel();
                        if (oAppModel != null && (oTemplateModel = TemplateModel.getTemplateModel(oAppModel, false)) != null && oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_RENDERING)) {
                            bLegacyRender = true;
                        }
                        if (!bLegacyRender && (sDisplay == null || sDisplay.equals(""))) {
                            return new String(" ");
                        }
                    }
                    return sDisplay;
                }
                oDisplayText = oDisplayText.getNextXFASibling();
                ++nCurrentIndex;
            }
        }
        return "";
    }

    String getEditValue() {
        String sRawValue;
        try {
            sRawValue = this.getRawValue();
        }
        catch (ExFull oErr) {
            Content pContent;
            this.getModel().addErrorList(oErr, 3, this);
            Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, true, false);
            if (pValueNode != null && (pContent = (Content)pValueNode.getOneOfChild(false, true)) != null) {
                return pContent.getStrValue();
            }
            return "";
        }
        String sDisplay = this.getDisplayItem(sRawValue);
        if (!StringUtils.isEmpty(sDisplay)) {
            return sDisplay;
        }
        Element poUI = this.getElement(XFA.UITAG, true, 0, false, false);
        Picture poEditPicture = null;
        if (poUI != null) {
            poEditPicture = (Picture)poUI.getElement(XFA.PICTURETAG, true, 0, false, false);
        }
        if (poEditPicture != null) {
            StringBuilder sFormatted = new StringBuilder();
            String sLocale = this.getInstalledLocale();
            boolean bSuccess = poEditPicture.formatString(sRawValue, sLocale, sFormatted);
            if (bSuccess) {
                return sFormatted.toString();
            }
        } else if (!StringUtils.isEmpty(sRawValue)) {
            Element poValueNode = this.getElement(XFA.VALUETAG, true, 0, true, false);
            Element poContentNode = null;
            if (poValueNode != null) {
                poContentNode = (Element)poValueNode.getOneOfChild(false, true);
            }
            if (poContentNode != null) {
                StringBuilder sFormatted = new StringBuilder();
                if (poContentNode.isSameClass(XFA.DATETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getDateFormat(1);
                    PictureFmt.formatDate(sRawValue, sPict, sLocale, sFormatted, true);
                } else if (poContentNode.isSameClass(XFA.TIMETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getTimeFormat(1);
                    PictureFmt.formatTime(sRawValue, sPict, sLocale, sFormatted, true);
                } else if (poContentNode.isSameClass(XFA.DATETIMETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getDateTimeFormat(1, 1);
                    String sDatePict = oData.getDateFormat(1);
                    String sTimePict = oData.getTimeFormat(1);
                    PictureFmt.formatDateTime(sRawValue, sPict, sDatePict, sTimePict, sLocale, sFormatted, true);
                } else if (poContentNode.isSameClass(XFA.INTEGERTAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    int nOptn = 0;
                    String sPict = oData.getNumberFormat(0, nOptn);
                    PictureFmt.formatNumeric(sRawValue, sPict, sLocale, sFormatted);
                } else if (poContentNode.isSameClass(XFA.FLOATTAG)) {
                    String sLocale = this.getInstalledLocale();
                    int nOptn = 0;
                    LcData oData = new LcData("en_US");
                    int nPrec = oData.getNumberPrecision(sRawValue);
                    nOptn |= LcData.withPrecision(nPrec);
                    int nWidth = sRawValue.length();
                    if (nWidth > 0) {
                        nOptn |= LcData.withWidth(nWidth);
                    }
                    if (sLocale != "en_US") {
                        oData = new LcData(sLocale);
                    }
                    String sPict = oData.getNumberFormat(1, nOptn);
                    PictureFmt.formatNumeric(sRawValue, sPict, sLocale, sFormatted);
                } else if (poContentNode.isSameClass(XFA.DECIMALTAG)) {
                    Int oFrac = (Int)poContentNode.getAttribute(XFA.FRACDIGITSTAG);
                    String sLocale = this.getInstalledLocale();
                    int nOptn = 0;
                    if (oFrac.getValue() == -1) {
                        nOptn |= 2;
                    }
                    LcData oData = new LcData("en_US");
                    int nPrec = oData.getNumberPrecision(sRawValue);
                    nOptn |= LcData.withPrecision(nPrec);
                    int nWidth = sRawValue.length();
                    if (nWidth > 0) {
                        nOptn |= LcData.withWidth(nWidth);
                    }
                    if (sLocale != "en_US") {
                        oData = new LcData(sLocale);
                    }
                    String sPict = oData.getNumberFormat(1, nOptn);
                    PictureFmt.formatNumeric(sRawValue, sPict, sLocale, sFormatted);
                }
                if (!StringUtils.isEmpty(sFormatted)) {
                    return sFormatted.toString();
                }
            }
        }
        return sRawValue;
    }

    String getForeColor() {
        Element pColorNode;
        Element pFillNode;
        String sRet = "";
        Element pFontNode = this.getElement(XFA.FONTTAG, true, 0, true, false);
        if (pFontNode != null && (pFillNode = pFontNode.getElement(XFA.FILLTAG, true, 0, true, false)) != null && (pColorNode = pFillNode.getElement(XFA.COLORTAG, true, 0, true, false)) != null) {
            sRet = pColorNode.getAttribute(XFA.VALUETAG).toString();
        }
        return sRet;
    }

    public String getFormattedValue() {
        String sLocale;
        Picture poPictureNode;
        String sValue = this.getRawValue();
        String sDisplay = this.getDisplayItem(sValue);
        if (!StringUtils.isEmpty(sDisplay)) {
            return sDisplay;
        }
        Element pContentNode = null;
        Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, true, false);
        if (pValueNode != null) {
            pContentNode = (Element)pValueNode.getOneOfChild(false, true);
        }
        boolean bNumericField = pContentNode instanceof DecimalValue || pContentNode instanceof IntegerValue || pContentNode instanceof FloatValue;
        Element poFormatNode = this.getElement(XFA.FORMATTAG, true, 0, false, false);
        if (sValue != null && poFormatNode != null && (poPictureNode = (Picture)poFormatNode.getElement(XFA.PICTURETAG, true, 0, false, false)) != null && !StringUtils.isEmpty(poPictureNode.getValue())) {
            sLocale = this.getInstalledLocale();
            StringBuilder sFormatted = new StringBuilder();
            boolean bPictureSucceed = poPictureNode.formatString(sValue, sLocale, sFormatted);
            double dVal = 0.0;
            if (bPictureSucceed) {
                return sFormatted.toString();
            }
            if (bNumericField) {
                boolean bValidDouble = true;
                try {
                    dVal = Double.parseDouble(sValue);
                }
                catch (NumberFormatException e) {
                    bValidDouble = false;
                }
                if (bValidDouble && dVal == 0.0) {
                    LcData oData = new LcData(sLocale);
                    return oData.getZeroSymbol();
                }
            }
        }
        if (StringUtils.isEmpty(sValue)) {
            return null;
        }
        if (pContentNode != null) {
            int nOptn;
            LcData oData;
            StringBuilder sFormatted = new StringBuilder();
            if (pContentNode.isSameClass(XFA.DATETAG)) {
                sLocale = this.getInstalledLocale();
                oData = new LcData(sLocale);
                String sPict = oData.getDateFormat(2);
                PictureFmt.formatDate(sValue, sPict, sLocale, sFormatted, true);
            } else if (pContentNode.isSameClass(XFA.TIMETAG)) {
                sLocale = this.getInstalledLocale();
                oData = new LcData(sLocale);
                String sPict = oData.getTimeFormat(2);
                PictureFmt.formatTime(sValue, sPict, sLocale, sFormatted, true);
            } else if (pContentNode.isSameClass(XFA.DATETIMETAG)) {
                sLocale = this.getInstalledLocale();
                oData = new LcData(sLocale);
                String sPict = oData.getDateTimeFormat(2, 1);
                String sDatePict = oData.getDateFormat(2);
                String sTimePict = oData.getTimeFormat(2);
                PictureFmt.formatDateTime(sValue, sPict, sDatePict, sTimePict, sLocale, sFormatted, true);
            } else if (pContentNode.isSameClass(XFA.INTEGERTAG)) {
                sLocale = this.getInstalledLocale();
                oData = new LcData(sLocale);
                nOptn = 1;
                String sPict = oData.getNumberFormat(0, nOptn);
                PictureFmt.formatNumeric(sValue, sPict, sLocale, sFormatted);
            } else if (pContentNode.isSameClass(XFA.FLOATTAG)) {
                sLocale = this.getInstalledLocale();
                int nOptn2 = 1;
                LcData oData2 = new LcData("en_US");
                int nPrec = oData2.getNumberPrecision(sValue);
                nOptn2 |= LcData.withPrecision(nPrec);
                int nWidth = sValue.length();
                if (nWidth > 0) {
                    nOptn2 |= LcData.withWidth(nWidth);
                }
                if (sLocale != "en_US") {
                    oData2 = new LcData(sLocale);
                }
                String sPict = oData2.getNumberFormat(1, nOptn2);
                PictureFmt.formatNumeric(sValue, sPict, sLocale, sFormatted);
            } else if (pContentNode.isSameClass(XFA.DECIMALTAG)) {
                Int oFrac = (Int)pContentNode.getAttribute(XFA.FRACDIGITSTAG);
                String sLocale2 = this.getInstalledLocale();
                nOptn = 1;
                if (oFrac.getValue() == -1) {
                    nOptn |= 2;
                }
                LcData oData3 = new LcData("en_US");
                int nPrec = oData3.getNumberPrecision(sValue);
                nOptn |= LcData.withPrecision(nPrec);
                int nWidth = sValue.length();
                if (nWidth > 0) {
                    nOptn |= LcData.withWidth(nWidth);
                }
                if (sLocale2 != "en_US") {
                    oData3 = new LcData(sLocale2);
                }
                String sPict = oData3.getNumberFormat(1, nOptn);
                PictureFmt.formatNumeric(sValue, sPict, sLocale2, sFormatted);
            }
            if (!StringUtils.isEmpty(sFormatted)) {
                return sFormatted.toString();
            }
        }
        return sValue;
    }

    public void getItemLists(boolean bPeek, ItemPair items, boolean bEnforceMultiColumn) {
        Items saveList = null;
        Items displayList = null;
        Items list1 = (Items)this.getElement(XFA.ITEMSTAG, bPeek, 0, false, false);
        Items list2 = (Items)this.getElement(XFA.ITEMSTAG, true, 1, false, false);
        if (!bPeek) {
            if (list2 != null && list2.getXFAParent() != this) {
                list2 = (Items)list2.createProto(this, false);
            }
            if (list2 == null && bEnforceMultiColumn) {
                list2 = (Items)this.defaultElementImpl(XFA.ITEMSTAG, 1, true);
            }
        }
        if (list1 == null) {
            return;
        }
        if (list2 != null) {
            int ePresence1 = list1.getEnum(XFA.PRESENCETAG);
            int eSave1 = list1.getEnum(XFA.SAVETAG);
            int ePresence2 = list2.getEnum(XFA.PRESENCETAG);
            int eSave2 = list2.getEnum(XFA.SAVETAG);
            if (ePresence1 == ePresence2 && eSave1 == eSave2) {
                displayList = list1;
                saveList = list1;
                bEnforceMultiColumn = true;
            } else if (ePresence1 == ePresence2) {
                if (eSave1 == 0x40040001) {
                    saveList = list1;
                    displayList = list2;
                } else {
                    saveList = list2;
                    displayList = list1;
                }
                if (!bPeek) {
                    displayList.setAttribute(1076494336, XFA.PRESENCETAG);
                    saveList.setAttribute(1076494338, XFA.PRESENCETAG);
                }
            } else if (eSave1 == eSave2) {
                if (ePresence1 != 1076494338 && ePresence1 != 1076494339) {
                    displayList = list1;
                    saveList = list2;
                } else {
                    displayList = list2;
                    saveList = list1;
                }
                if (!bPeek) {
                    saveList.setAttribute(0x40040001, XFA.SAVETAG);
                    displayList.setAttribute(0x40040000, XFA.SAVETAG);
                }
            } else {
                displayList = ePresence1 != 1076494338 && ePresence1 != 1076494339 ? list1 : list2;
                if (displayList == (saveList = eSave1 == 0x40040001 ? list1 : list2)) {
                    bEnforceMultiColumn = true;
                }
            }
        } else {
            displayList = list1;
            saveList = list1;
        }
        if (!bPeek && bEnforceMultiColumn) {
            if (displayList == saveList) {
                saveList = displayList == list1 && list2 != null ? list2 : list1;
                saveList.setAttribute(0x40040001, XFA.SAVETAG);
                saveList.setAttribute(1076494338, XFA.PRESENCETAG);
                displayList.setAttribute(0x40040000, XFA.SAVETAG);
                displayList.setAttribute(1076494336, XFA.PRESENCETAG);
            }
            int nSaveCount = saveList.getXFAChildCount();
            int nDisplayCount = displayList.getXFAChildCount();
            if (nDisplayCount != nSaveCount) {
                saveList.clearItems(false);
                for (Node child = displayList.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    child.clone(saveList);
                }
            }
        }
        items.mSaveItems = saveList;
        items.mDisplayItems = displayList;
    }

    boolean getItemState(String sValue, boolean bDisplay) {
        ItemPair items = new ItemPair();
        this.getItemLists(true, items, false);
        Items boundItems = items.mSaveItems;
        Items oDisplayItems = items.mDisplayItems;
        Items oSearch = bDisplay ? oDisplayItems : boundItems;
        int i = 0;
        TextValue oText = (TextValue)oSearch.getFirstXFAChild();
        while (oText != null) {
            String sItemValue = oText.getValue();
            if (sValue.equals(sItemValue)) {
                return this.getItemState(i);
            }
            oText = (TextValue)oText.getNextXFASibling();
            ++i;
        }
        return false;
    }

    boolean getItemState(int nIndex) {
        String sBoundItem = this.getBoundItem(nIndex);
        if (StringUtils.isEmpty(sBoundItem)) {
            return false;
        }
        Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
        if (pValueNode != null) {
            Content pContentNode = (Content)pValueNode.getOneOfChild(true, false);
            if (pContentNode == null || pContentNode.getIsNull()) {
                return false;
            }
            if (pContentNode.isSameClass(XFA.TEXTTAG)) {
                String sValue = ((TextValue)pContentNode).getValue();
                if (sBoundItem.equals(sValue)) {
                    return true;
                }
            } else if (pContentNode.isSameClass(XFA.EXDATATAG)) {
                ArrayList<String> oValues = new ArrayList<String>();
                ExDataValue oExData = (ExDataValue)pContentNode;
                oExData.getValues(oValues);
                for (int i = 0; i < oValues.size(); ++i) {
                    if (!sBoundItem.equals(oValues.get(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    String getItemValue(int nItemsIndex, int nItemIndex) {
        Element pItems = this.getElement(XFA.ITEMSTAG, true, nItemsIndex, false, false);
        if (pItems != null) {
            int nItemCount = 0;
            for (Node pText = pItems.getFirstXFAChild(); pText != null; pText = pText.getNextXFASibling()) {
                if (!pText.isSameClass(XFA.TEXTTAG) && !pText.isSameClass(XFA.INTEGERTAG)) continue;
                if (nItemCount == nItemIndex) {
                    return pText.toString();
                }
                if (++nItemCount <= nItemIndex) continue;
                return null;
            }
        }
        return null;
    }

    int getItemsLength() {
        ItemPair items = new ItemPair();
        this.getItemLists(true, items, false);
        Items oBoundItems = items.mSaveItems;
        if (oBoundItems != null) {
            return oBoundItems.getXFAChildCount();
        }
        return 0;
    }

    String getMandatory() {
        String sRet = "";
        Element pValidateNode = this.getElement(XFA.VALIDATETAG, true, 0, true, false);
        if (pValidateNode != null) {
            sRet = pValidateNode.getAttribute(XFA.NULLTESTTAG).toString();
        }
        return sRet;
    }

    String getMessage(String aType) {
        String sRet = "";
        Element pValidateNode = this.getElement(XFA.VALIDATETAG, true, 0, false, false);
        if (pValidateNode != null) {
            sRet = TemplateModel.getValidationMessage(pValidateNode, aType);
        }
        return sRet;
    }

    public String getNeutralValue() {
        Node oCurrentUI;
        Element oUI = this.getElement(XFA.UITAG, true, 0, false, false);
        if (oUI != null && (oCurrentUI = oUI.getOneOfChild()) != null && oCurrentUI.isSameClass(XFA.CHECKBUTTONTAG)) {
            return this.getItemValue(0, 2);
        }
        return null;
    }

    @Override
    public NodeList getNodes() {
        Model oModel = this.getModel();
        assert (oModel != null);
        if (oModel != null && !oModel.isLoading()) {
            this.lazyResolveItemsArrays(false);
        }
        return super.getNodes();
    }

    @Override
    public NodeList resolveAndEnumerateChildren(boolean bAllProperties, boolean bFirstDefaultOnly) {
        if (bAllProperties) {
            this.lazyResolveItemsArrays(bAllProperties);
        }
        return super.resolveAndEnumerateChildren(bAllProperties, bFirstDefaultOnly);
    }

    public String getOffValue() {
        Node oCurrentUI;
        Element oUI = this.getElement(XFA.UITAG, true, 0, false, false);
        if (oUI != null && (oCurrentUI = oUI.getOneOfChild()) != null && oCurrentUI.isSameClass(XFA.CHECKBUTTONTAG)) {
            return this.getItemValue(0, 1);
        }
        return null;
    }

    public String getOnValue() {
        Node oCurrentUI;
        Element oUI = this.getElement(XFA.UITAG, true, 0, false, false);
        if (oUI != null && (oCurrentUI = oUI.getOneOfChild()) != null && oCurrentUI.isSameClass(XFA.CHECKBUTTONTAG)) {
            return this.getItemValue(0, 0);
        }
        return null;
    }

    Subform getParentSubform() {
        for (Element pParent = this.getXFAParent(); pParent != null; pParent = pParent.getXFAParent()) {
            EnumValue eScope;
            if (!pParent.isSameClass(XFA.SUBFORMTAG) || (eScope = (EnumValue)pParent.getAttribute(XFA.SCOPETAG)).getInt() != 5963777) continue;
            return (Subform)pParent;
        }
        return null;
    }

    public String getRawValue() {
        Arg oRawValue = new Arg();
        this.getTypedRawValue(oRawValue);
        if (oRawValue.getArgType() != 2) {
            return oRawValue.getAsString(false);
        }
        return null;
    }

    @Override
    public ScriptTable getScriptTable() {
        return FieldScript.getScriptTable();
    }

    int getSelectedIndex() {
        block6: {
            Node pContentNode;
            Items oBoundItems;
            block7: {
                ItemPair items = new ItemPair();
                this.getItemLists(true, items, false);
                oBoundItems = items.mSaveItems;
                if (oBoundItems == null) {
                    return -1;
                }
                Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
                if (pValueNode == null) break block6;
                pContentNode = pValueNode.getOneOfChild(true, false);
                if (pContentNode == null || ((Content)pContentNode).getIsNull()) {
                    return -1;
                }
                if (!pContentNode.isSameClass(XFA.TEXTTAG)) break block7;
                String sDataValue = ((TextValue)pContentNode).getValue();
                int nFoundAt = 0;
                TextValue oText = (TextValue)oBoundItems.getFirstXFAChild();
                while (oText != null) {
                    String sItemValue = oText.getValue();
                    if (sItemValue.equals(sDataValue)) {
                        return nFoundAt;
                    }
                    oText = (TextValue)oText.getNextXFASibling();
                    ++nFoundAt;
                }
                break block6;
            }
            if (!pContentNode.isSameClass(XFA.EXDATATAG)) break block6;
            ArrayList<String> oValues = new ArrayList<String>();
            ExDataValue oExData = (ExDataValue)pContentNode;
            oExData.getValues(oValues);
            int nFoundAt = 0;
            TextValue oText = (TextValue)oBoundItems.getFirstXFAChild();
            while (oText != null) {
                String sItemValue = oText.getValue();
                for (int i = 0; i < oValues.size(); ++i) {
                    if (!sItemValue.equals(oValues.get(i))) continue;
                    return nFoundAt;
                }
                oText = (TextValue)oText.getNextXFASibling();
                ++nFoundAt;
            }
        }
        return -1;
    }

    void getTypedRawValue(Arg oValue) {
        Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
        if (pValueNode != null) {
            Content pContentNode = (Content)pValueNode.getOneOfChild(true, false);
            if (pContentNode == null || pContentNode instanceof Content && pContentNode.getIsNull()) {
                oValue.setNull();
                return;
            }
            if (pContentNode.isSameClass(XFA.TEXTTAG)) {
                oValue.setString(((TextValue)pContentNode).getValue());
            } else if (pContentNode.isSameClass(XFA.EXDATATAG)) {
                boolean bLegacy = this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V27_XHTMLVERSIONPROCESSING);
                oValue.setString(((ExDataValue)pContentNode).getValue(false, false, bLegacy));
            } else if (pContentNode.isSameClass(XFA.BOOLEANTAG)) {
                if (((BooleanValue)pContentNode).valueHasTypeMismatch()) {
                    if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
                        oValue.setBool(false);
                    } else {
                        oValue.setString(pContentNode.getStrValue());
                    }
                } else {
                    oValue.setBool(((BooleanValue)pContentNode).getValue());
                }
            } else if (pContentNode.isSameClass(XFA.DATETAG)) {
                oValue.setString(((DateValue)pContentNode).getValue());
            } else if (pContentNode.isSameClass(XFA.DATETIMETAG)) {
                oValue.setString(((DateTimeValue)pContentNode).getValue());
            } else if (pContentNode.isSameClass(XFA.TIMETAG)) {
                oValue.setString(((TimeValue)pContentNode).getValue());
            } else if (pContentNode.isSameClass(XFA.INTEGERTAG)) {
                String sValue = pContentNode.getStrValue();
                if (StringUtils.isEmpty(sValue)) {
                    oValue.setNull();
                } else if (((IntegerValue)pContentNode).valueHasTypeMismatch()) {
                    if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
                        oValue.setInteger(((IntegerValue)pContentNode).getValue());
                    } else {
                        oValue.setString(sValue);
                    }
                } else {
                    oValue.setInteger(((IntegerValue)pContentNode).getValue());
                }
            } else if (pContentNode.isSameClass(XFA.FLOATTAG)) {
                String sValue = pContentNode.getStrValue();
                if (StringUtils.isEmpty(sValue)) {
                    oValue.setNull();
                } else if (((FloatValue)pContentNode).valueHasTypeMismatch()) {
                    if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
                        oValue.setDouble(((FloatValue)pContentNode).getValue());
                    } else {
                        oValue.setString(sValue);
                    }
                } else {
                    oValue.setDouble(((FloatValue)pContentNode).getValue());
                }
            } else if (pContentNode.isSameClass(XFA.DECIMALTAG)) {
                String sValue = pContentNode.getStrValue();
                if (StringUtils.isEmpty(sValue)) {
                    oValue.setNull();
                } else if (((DecimalValue)pContentNode).valueHasTypeMismatch()) {
                    if (this.getAppModel().getLegacySetting(AppModel.XFA_LEGACY_V29_SCRIPTING)) {
                        Int oFracInt = (Int)pContentNode.getAttribute(XFA.FRACDIGITSTAG);
                        if (oFracInt.getValue() == -1) {
                            oValue.setString(sValue);
                        } else {
                            oValue.setDouble(((DecimalValue)pContentNode).getValue());
                        }
                    } else {
                        oValue.setString(sValue);
                    }
                } else {
                    Int oFracInt = (Int)pContentNode.getAttribute(XFA.FRACDIGITSTAG);
                    if (oFracInt.getValue() == -1) {
                        oValue.setString(sValue);
                    } else {
                        oValue.setDouble(((DecimalValue)pContentNode).getValue());
                    }
                }
            } else if (pContentNode.isSameClass(XFA.IMAGETAG)) {
                oValue.setString(((ImageValue)pContentNode).getValue());
            }
        } else {
            oValue.setNull();
        }
    }

    public boolean hasValidFormattedValue() {
        Picture poPictureNode;
        Element poFormatNode;
        String sValue = this.getRawValue();
        if (this.isPropertySpecified(XFA.VALIDATETAG, true, 0) && (poFormatNode = this.getElement(XFA.VALIDATETAG, true, 0, false, false)) != null && (poPictureNode = (Picture)poFormatNode.getElement(XFA.PICTURETAG, true, 0, false, false)) != null) {
            String sLocale = this.getInstalledLocale();
            StringBuilder s = new StringBuilder();
            return poPictureNode.formatString(sValue, sLocale, s);
        }
        return true;
    }

    @Override
    public boolean isConnectSupported() {
        return true;
    }

    @Override
    public boolean isHeightGrowSupported() {
        return this.isWidthGrowSupported();
    }

    boolean isOn() {
        boolean bRet = false;
        String sTemp = this.getOnValue();
        if (sTemp != null) {
            String sValue = this.getFormattedValue();
            if (sTemp.equals(sValue)) {
                bRet = true;
            }
        } else if (!this.getIsNull()) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public boolean isWidthGrowSupported() {
        Element poContentNode = null;
        UI poUI = (UI)this.getElement(XFA.UITAG, true, 0, false, false);
        if (poUI != null) {
            poContentNode = poUI.getUIElement(true);
        }
        if (poContentNode != null && (poContentNode.isSameClass(XFA.CHOICELISTTAG) || poContentNode.isSameClass(XFA.EXOBJECTTAG) || poContentNode.isSameClass(XFA.BARCODETAG))) {
            return false;
        }
        Element poValue = this.getElement(XFA.VALUETAG, true, 0, false, false);
        return poValue == null || (poContentNode = (Element)poValue.getOneOfChild(true, false)) == null || !poContentNode.isSameClass(XFA.RECTANGLETAG) && !poContentNode.isSameClass(XFA.ARCTAG);
    }

    @Override
    protected boolean notifyParent() {
        Element pParent = this.getXFAParent();
        return pParent instanceof ExclGroup;
    }

    void setBackColor(String sString) {
        Element pBorderNode = this.getElement(XFA.BORDERTAG, false, 0, false, false);
        Element pFillNode = pBorderNode.getElement(XFA.FILLTAG, false, 0, false, false);
        Element pColorNode = pFillNode.getElement(XFA.COLORTAG, false, 0, false, false);
        pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
    }

    void setBorderColor(String sString) {
        Element pColorNode;
        int i;
        Element pBorderNode = this.getElement(XFA.BORDERTAG, false, 0, false, false);
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.EDGETAG, true, i); ++i) {
            Element pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, false, i, false, false);
            pColorNode = pEdgeNode.getElement(XFA.COLORTAG, false, 0, false, false);
            pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
        }
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.CORNERTAG, true, i); ++i) {
            Element pCornerNode = pBorderNode.getElement(XFA.CORNERTAG, false, i, false, false);
            pColorNode = pCornerNode.getElement(XFA.COLORTAG, false, 0, false, false);
            pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
        }
    }

    void setBorderWidth(String sString) {
        int i;
        Element pBorderNode = this.getElement(XFA.BORDERTAG, false, 0, false, false);
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.EDGETAG, true, i); ++i) {
            Element pEdgeNode = pBorderNode.getElement(XFA.EDGETAG, false, i, false, false);
            pEdgeNode.setAttribute(new StringAttr("thickness", sString), XFA.THICKNESSTAG);
        }
        for (i = 0; i < 4 && pBorderNode.isPropertySpecified(XFA.CORNERTAG, true, i); ++i) {
            Element pCornerNode = pBorderNode.getElement(XFA.CORNERTAG, false, i, false, false);
            pCornerNode.setAttribute(new StringAttr("thickness", sString), XFA.THICKNESSTAG);
        }
    }

    void setEditValue(String sValue) {
        StringHolder sCanonical = new StringHolder();
        Element poUI = this.getElement(XFA.UITAG, true, 0, false, false);
        Picture poEditPicture = null;
        if (poUI != null) {
            poEditPicture = (Picture)poUI.getElement(XFA.PICTURETAG, true, 0, false, false);
        }
        if (poEditPicture != null) {
            String sLocale = this.getInstalledLocale();
            sCanonical.value = poEditPicture.unformatString(sValue, sLocale, null);
        } else if (!StringUtils.isEmpty(sValue)) {
            Element poValueNode = this.getElement(XFA.VALUETAG, true, 0, true, false);
            Obj poContentNode = null;
            if (poValueNode != null) {
                poContentNode = (Element)poValueNode.getOneOfChild(false, true);
            }
            if (poContentNode != null) {
                if (poContentNode.isSameClass(XFA.DATETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getDateFormat(1);
                    PictureFmt.parseDate(sValue, sPict, sLocale, sCanonical, true);
                } else if (poContentNode.isSameClass(XFA.TIMETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getTimeFormat(1);
                    PictureFmt.parseTime(sValue, sPict, sLocale, sCanonical, true);
                } else if (poContentNode.isSameClass(XFA.DATETIMETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getDateTimeFormat(1, 0);
                    String sDatePict = oData.getDateFormat(1);
                    String sTimePict = oData.getTimeFormat(1);
                    PictureFmt.parseDateTime(sValue, sPict, sDatePict, sTimePict, sLocale, sCanonical, true);
                } else if (poContentNode.isSameClass(XFA.INTEGERTAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    int nOptn = 0;
                    String sPict = oData.getNumberFormat(0, nOptn);
                    PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanonical);
                } else if (poContentNode.isSameClass(XFA.FLOATTAG)) {
                    String sLocale = this.getInstalledLocale();
                    int nOptn = 0;
                    LcData oData = new LcData(sLocale);
                    int nPrec = oData.getNumberPrecision(sValue);
                    if (nPrec == 0 && sValue.contains(oData.getRadixSymbol())) {
                        nOptn |= 4;
                    }
                    nOptn |= LcData.withPrecision(nPrec | 0x80);
                    int nWidth = sValue.length();
                    if (nWidth > 0) {
                        nOptn |= LcData.withWidth(nWidth);
                    }
                    String sPict = oData.getNumberFormat(1, nOptn);
                    PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanonical);
                } else if (poContentNode.isSameClass(XFA.DECIMALTAG)) {
                    LcData oData;
                    int nPrec;
                    Int oFrac = (Int)((Element)poContentNode).getAttribute(XFA.FRACDIGITSTAG);
                    String sLocale = this.getInstalledLocale();
                    int nOptn = 0;
                    if (oFrac.getValue() == -1) {
                        nOptn |= 2;
                    }
                    if ((nPrec = (oData = new LcData(sLocale)).getNumberPrecision(sValue)) == 0 && sValue.contains(oData.getRadixSymbol())) {
                        nOptn |= 4;
                    }
                    nOptn |= LcData.withPrecision(nPrec | 0x80);
                    int nWidth = sValue.length();
                    if (nWidth > 0) {
                        nOptn |= LcData.withWidth(nWidth);
                    }
                    String sPict = oData.getNumberFormat(1, nOptn);
                    PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanonical);
                }
            }
        }
        if (!StringUtils.isEmpty(sCanonical.value)) {
            this.setRawValue(sCanonical.value);
        } else {
            this.setRawValue(sValue);
        }
    }

    void setForeColor(String sString) {
        Element pFontNode = this.getElement(XFA.FONTTAG, false, 0, false, false);
        Element pFillNode = pFontNode.getElement(XFA.FILLTAG, false, 0, false, false);
        Element pColorNode = pFillNode.getElement(XFA.COLORTAG, false, 0, false, false);
        pColorNode.setAttribute(new StringAttr("value", sString), XFA.VALUETAG);
    }

    public void setFormattedValue(String sValue) {
        StringHolder sCanonical = new StringHolder();
        if (this.isPropertySpecified(XFA.FORMATTAG, true, 0)) {
            Picture pPictureNode;
            Element poFormatNode = this.getElement(XFA.FORMATTAG, true, 0, false, false);
            if (poFormatNode != null && (pPictureNode = (Picture)poFormatNode.getElement(XFA.PICTURETAG, true, 0, false, false)) != null) {
                String sLocale = this.getInstalledLocale();
                sCanonical.value = pPictureNode.unformatString(sValue, sLocale, null);
            }
        } else if (!StringUtils.isEmpty(sValue)) {
            Element poValueNode = this.getElement(XFA.VALUETAG, true, 0, true, false);
            Obj poContentNode = null;
            if (poValueNode != null) {
                poContentNode = (Element)poValueNode.getOneOfChild(false, true);
            }
            if (poContentNode != null) {
                if (poContentNode.isSameClass(XFA.DATETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getDateFormat(2);
                    PictureFmt.parseDate(sValue, sPict, sLocale, sCanonical, true);
                } else if (poContentNode.isSameClass(XFA.TIMETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getTimeFormat(2);
                    PictureFmt.parseTime(sValue, sPict, sLocale, sCanonical, true);
                } else if (poContentNode.isSameClass(XFA.DATETIMETAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getDateTimeFormat(2, 0);
                    String sDatePict = oData.getDateFormat(2);
                    String sTimePict = oData.getTimeFormat(2);
                    PictureFmt.parseDateTime(sValue, sPict, sDatePict, sTimePict, sLocale, sCanonical, true);
                } else if (poContentNode.isSameClass(XFA.INTEGERTAG)) {
                    String sLocale = this.getInstalledLocale();
                    LcData oData = new LcData(sLocale);
                    String sPict = oData.getNumberFormat(0, 1);
                    PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanonical);
                } else if (poContentNode.isSameClass(XFA.FLOATTAG)) {
                    String sLocale = this.getInstalledLocale();
                    int nOptn = 1;
                    LcData oData = new LcData(sLocale);
                    int nPrec = oData.getNumberPrecision(sValue);
                    nOptn |= LcData.withPrecision(nPrec | 0x80);
                    int nWidth = sValue.length();
                    if (nWidth > 0) {
                        nOptn |= LcData.withWidth(nWidth);
                    }
                    String sPict = oData.getNumberFormat(1, nOptn);
                    PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanonical);
                } else if (poContentNode.isSameClass(XFA.DECIMALTAG)) {
                    Int oFrac = (Int)((Element)poContentNode).getAttribute(XFA.FRACDIGITSTAG);
                    String sLocale = this.getInstalledLocale();
                    int nOptn = 1;
                    if (oFrac.getValue() == -1) {
                        nOptn |= 2;
                    }
                    LcData oData = new LcData(sLocale);
                    int nPrec = oData.getNumberPrecision(sValue);
                    nOptn |= LcData.withPrecision(nPrec | 0x80);
                    int nWidth = sValue.length();
                    if (nWidth > 0) {
                        nOptn |= LcData.withWidth(nWidth);
                    }
                    String sPict = oData.getNumberFormat(1, nOptn);
                    PictureFmt.parseNumeric(sValue, sPict, sLocale, sCanonical);
                }
            }
        }
        if (!StringUtils.isEmpty(sCanonical.value)) {
            this.setRawValue(sCanonical.value);
        } else {
            this.setRawValue(sValue);
        }
    }

    public void setIsNull(boolean bNull, boolean bNotify) {
        if (bNull && !this.hasProto() && !this.isPropertySpecified(XFA.VALUETAG, true, 0)) {
            return;
        }
        Element poValue = this.getElement(XFA.VALUETAG, false, 0, false, false);
        Node poNullCheck = poValue.getOneOfChild(true, false);
        if (bNull && poNullCheck == null) {
            return;
        }
        Content poValueContent = (Content)poValue.getOneOfChild();
        poValueContent.setIsNull(bNull, bNotify, false);
    }

    void setItemState(int nIndex, boolean bSelected) {
        String sBoundItem = this.getBoundItem(nIndex);
        if (StringUtils.isEmpty(sBoundItem)) {
            return;
        }
        Element pValueNode = this.getElement(XFA.VALUETAG, true, 0, false, false);
        if (pValueNode != null) {
            Content pContentNode = (Content)pValueNode.getOneOfChild(true, false);
            if (pContentNode == null) {
                return;
            }
            if (pContentNode.isSameClass(XFA.TEXTTAG)) {
                String sValue = ((TextValue)pContentNode).getValue();
                if (bSelected) {
                    if (!sBoundItem.equals(sValue)) {
                        ((TextValue)pContentNode).setValue(sBoundItem);
                    }
                } else if (sBoundItem.equals(sValue)) {
                    ((TextValue)pContentNode).setIsNull(true, true, false);
                }
            } else if (pContentNode.isSameClass(XFA.EXDATATAG)) {
                boolean bAddItem = bSelected;
                ArrayList<String> oValues = new ArrayList<String>();
                ExDataValue oExData = (ExDataValue)pContentNode;
                oExData.getValues(oValues);
                for (int i = oValues.size(); i > 0; --i) {
                    if (!sBoundItem.equals(oValues.get(i - 1))) continue;
                    if (bSelected) {
                        bAddItem = false;
                        break;
                    }
                    oValues.remove(i - 1);
                    oExData.setValue(oValues);
                    break;
                }
                if (bAddItem) {
                    oValues.add(sBoundItem);
                    oExData.setValue(oValues);
                }
            }
        }
    }

    void setMandatory(String sString) {
        Element pValidateNode = this.getElement(XFA.VALIDATETAG, false, 0, false, false);
        pValidateNode.setAttribute(new StringAttr("nullTest", sString), XFA.NULLTESTTAG);
    }

    void setMessage(String sMessage, String aType) {
        Element pValidateNode = this.getElement(XFA.VALIDATETAG, false, 0, false, false);
        TemplateModel.setValidationMessage(pValidateNode, sMessage, aType);
    }

    public void setOn(boolean bOn) {
        String sValue = this.getOnValue();
        if (bOn && sValue != null) {
            this.setRawValue(sValue);
        }
        if (!bOn) {
            sValue = this.getOffValue();
            if (sValue != null) {
                this.setRawValue(sValue);
            } else {
                this.setIsNull(true, true);
            }
        }
    }

    public void setRawValue(String sString) {
        Node pContentNode = null;
        Element pValueNode = this.getElement(XFA.VALUETAG, false, 0, false, false);
        if (pValueNode != null) {
            pContentNode = pValueNode.getOneOfChild();
        }
        if (pContentNode != null) {
            if (pContentNode.isSameClass(XFA.TEXTTAG)) {
                ((TextValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.EXDATATAG)) {
                ((ExDataValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.DATETAG)) {
                ((DateValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.DATETIMETAG)) {
                ((DateTimeValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.TIMETAG)) {
                ((TimeValue)pContentNode).setValue(sString);
            } else if (pContentNode.isSameClass(XFA.INTEGERTAG)) {
                ((IntegerValue)pContentNode).setValue(sString, false);
            } else if (pContentNode.isSameClass(XFA.FLOATTAG)) {
                ((FloatValue)pContentNode).setValue(sString, false, true, false);
            } else if (pContentNode.isSameClass(XFA.DECIMALTAG)) {
                ((DecimalValue)pContentNode).setValue(sString, false, true, false);
            } else if (pContentNode.isSameClass(XFA.IMAGETAG)) {
                ((ImageValue)pContentNode).setValue(sString, "");
            } else {
                MsgFormatPos oMessage = new MsgFormatPos(ResId.UnsupportedOperationException);
                oMessage.format("setRawValue");
                oMessage.format(pContentNode.getClassAtom());
                throw new ExFull(oMessage);
            }
        }
    }

    void setSelectedIndex(int nIndex) {
        if (nIndex == -1) {
            this.setIsNull(true, true);
        } else {
            String sBoundItem = this.getBoundItem(nIndex);
            if (!StringUtils.isEmpty(sBoundItem)) {
                this.setRawValue(sBoundItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyResolveItemsArrays(boolean bCreateDefaults) {
        ProtoableNode poNode = (ProtoableNode)this.getElement(XFA.ITEMSTAG, true, 0, bCreateDefaults, false);
        if (poNode != null) {
            boolean previousWillDirty = this.getWillDirty();
            this.setWillDirty(false);
            try {
                if (poNode.getXFAParent() != this) {
                    poNode.createProto(this, false);
                }
                if ((poNode = (ProtoableNode)this.getElement(XFA.ITEMSTAG, true, 1, bCreateDefaults, false)) != null && poNode.getXFAParent() != this) {
                    poNode.createProto(this, false);
                }
            }
            finally {
                this.setWillDirty(previousWillDirty);
            }
        }
    }

    public static class ItemPair {
        public Items mDisplayItems;
        public Items mSaveItems;
    }
}

