/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.template.containers;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.template.automation.EventTag;
import com.adobe.xfa.template.containers.ContainerScript;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.UnitSpan;
import org.xml.sax.Attributes;

public class Container
extends ProtoableNode {
    FormInfo mFormInfo;
    private static final int CHILD_INDEX_CACHE_SIZE = 5;
    private final Node[] mChildIndexCache = new Node[5];
    private String msErrorText = "";
    private ValidationState meValidationState = ValidationState.VALIDATIONSTATE_VALID;
    private boolean mbDelayCacheRefresh;

    public Container() {
    }

    protected Container(Element parent, Node prevSibling, String uri, String localName, String qName, Attributes attributes, int classTag, String className) {
        super(parent, prevSibling, uri, localName, qName, attributes, classTag, className);
    }

    boolean checkProto(int eTag) {
        return !(eTag == XFA.HTAG ? (this.isSpecified(XFA.MINTAG, 1, false, 0) || this.isSpecified(XFA.MAXHTAG, 1, false, 0)) && this.isHeightGrowSupported() : (eTag == XFA.MINHTAG || eTag == XFA.MAXHTAG ? this.isSpecified(XFA.HTAG, 1, false, 0) && this.isHeightGrowSupported() : (eTag == XFA.WTAG ? (this.isSpecified(XFA.MINWTAG, 1, false, 0) || this.isSpecified(XFA.MAXWTAG, 1, false, 0)) && this.isWidthGrowSupported() : (eTag == XFA.MINWTAG || eTag == XFA.MAXWTAG) && this.isSpecified(XFA.WTAG, 1, false, 0) && this.isWidthGrowSupported())));
    }

    @Override
    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        if (this.checkProto(eTag)) {
            return super.getAttribute(eTag, bPeek, bValidate);
        }
        return this.elementGetAttribute(eTag, bPeek, false);
    }

    EventTag getEvent(String sActivity, String sRef) {
        boolean bIsPseudoEvent = sActivity.equals("calculate") || sActivity.equals("validate");
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            EventTag event;
            if (bIsPseudoEvent) {
                if (!child.getClassAtom().equals(sActivity)) continue;
                return (EventTag)child;
            }
            if (!child.getClassAtom().equals("event") || !(event = (EventTag)child).getActivity().equals(sActivity)) continue;
            String sDefaultedRef = sRef;
            if (StringUtils.isEmpty(sDefaultedRef)) {
                sDefaultedRef = "$";
            }
            if (!event.getRef().equals(sDefaultedRef)) continue;
            return event;
        }
        return null;
    }

    public FormInfo getFormInfo() {
        return this.mFormInfo;
    }

    public int getRuntimePresence(int eParentPresence) {
        if (this.isSameClass(XFA.SUBFORMTAG) || this.isSameClass(XFA.FIELDTAG) || this.isSameClass(XFA.EXCLGROUPTAG) || this.isSameClass(XFA.DRAWTAG)) {
            Element oParent;
            int nScore = 0;
            int nParentScore = 0;
            int ePresence = this.getEnum(XFA.PRESENCETAG);
            if (ePresence == 1076494337) {
                nScore = 1;
            } else if (ePresence == 1076494338 || ePresence == 1076494339) {
                nScore = 2;
            }
            if (eParentPresence == 0 && (oParent = this.getXFAParent()) instanceof Container) {
                eParentPresence = ((Container)oParent).getRuntimePresence(0);
            }
            if (eParentPresence == 1076494337) {
                nParentScore = 1;
            } else if (eParentPresence == 1076494338 || eParentPresence == 1076494339) {
                nParentScore = 2;
            }
            if (nParentScore > nScore) {
                return eParentPresence;
            }
            return ePresence;
        }
        if (this.isSameClass(XFA.AREATAG) || this.isSameClass(XFA.SUBFORMSETTAG)) {
            if (eParentPresence != 0) {
                return eParentPresence;
            }
            Container oParent = (Container)this.getXFAParent();
            return oParent.getRuntimePresence(0);
        }
        if (this.isValidAttr(XFA.PRESENCETAG, false, null)) {
            return this.getEnum(XFA.PRESENCETAG);
        }
        return 1076494336;
    }

    public int getRuntimeAccess(int eParentAccess) {
        Element oParent;
        int nScore = 0;
        int nParentScore = 0;
        int eAccess = 65537;
        if (this.isValidAttr(XFA.ACCESSTAG, false, null)) {
            eAccess = this.getEnum(XFA.ACCESSTAG);
            if (eAccess == 65539) {
                nScore = 3;
            } else if (eAccess == 65536) {
                nScore = 2;
            } else if (eAccess == 65538) {
                nScore = 1;
            }
        }
        if (eParentAccess == 0 && (oParent = this.getXFAParent()) instanceof Container) {
            eParentAccess = ((Container)oParent).getRuntimeAccess(0);
        }
        if (eParentAccess == 65539) {
            nParentScore = 3;
        } else if (eParentAccess == 65536) {
            nParentScore = 2;
        } else if (eParentAccess == 65538) {
            nParentScore = 1;
        }
        if (nParentScore > nScore) {
            return eParentAccess;
        }
        return eAccess;
    }

    @Override
    public ScriptTable getScriptTable() {
        return ContainerScript.getScriptTable();
    }

    public String getErrorText() {
        return this.msErrorText;
    }

    public void setErrorText(String sErrorText) {
        this.msErrorText = sErrorText;
    }

    public ValidationState getValidationState() {
        return this.meValidationState;
    }

    public void setValidationState(ValidationState eValidationState) {
        this.meValidationState = eValidationState;
    }

    public void getInvalidObjects(NodeList invalidObjects) {
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (!(child instanceof Container)) continue;
            Container container = (Container)child;
            assert (StringUtils.isEmpty(container.getErrorText()) == (container.getValidationState() == ValidationState.VALIDATIONSTATE_VALID));
            if ((container instanceof Field || container instanceof Subform || container instanceof FormExclGroup) && container.getValidationState() != ValidationState.VALIDATIONSTATE_VALID) {
                invalidObjects.append(container);
            }
            container.getInvalidObjects(invalidObjects);
        }
    }

    public boolean isConnectSupported() {
        return false;
    }

    public Element getConnectNode(String sConnectionName, int eUsage, boolean bCreate) {
        if (!this.isConnectSupported()) {
            return null;
        }
        if (StringUtils.isEmpty(sConnectionName)) {
            return null;
        }
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int usage;
            String connectionName;
            Attribute attr;
            if (!child.isSameClass(XFA.CONNECTTAG) || (attr = ((Element)child).getAttribute(XFA.CONNECTIONTAG, true, false)) == null || !(connectionName = attr.toString()).equals(sConnectionName) || eUsage != (usage = ((Element)child).getEnum(XFA.USAGETAG))) continue;
            return (Element)child;
        }
        if (bCreate) {
            Element ret = this.getModel().createElement(this, this.getLastXMLChild(), "", "connect");
            ret.setAttribute(new StringAttr("connection", sConnectionName), XFA.CONNECTIONTAG);
            ret.setAttribute(eUsage, XFA.USAGETAG);
            return ret;
        }
        return null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    boolean isEventSpecified(String sActivity, String sRef) {
        EventTag event = this.getEvent(sActivity, sRef);
        return event != null && !StringUtils.isEmpty(event.getScriptText());
    }

    public boolean isHeightGrowable() {
        UnitSpan oMinHVal;
        UnitSpan oMaxHVal;
        Measurement oMinH;
        if (!this.isHeightGrowSupported()) {
            return false;
        }
        Measurement oH = (Measurement)this.getAttribute(XFA.HTAG, true, false);
        if (oH != null && !oH.isEmpty()) {
            return false;
        }
        Measurement oMaxH = (Measurement)this.getAttribute(XFA.MAXHTAG, true, false);
        return oMaxH == null || oMaxH.isEmpty() || (oMinH = (Measurement)this.getAttribute(XFA.MINHTAG, true, false)) == null || oMinH.isEmpty() || !(oMaxHVal = oMaxH.getUnitSpan()).lte(oMinHVal = oMinH.getUnitSpan());
    }

    public boolean isHeightGrowSupported() {
        return false;
    }

    public boolean isWidthGrowable() {
        UnitSpan oMinWVal;
        UnitSpan oMaxWVal;
        Measurement oMinW;
        if (!this.isWidthGrowSupported()) {
            return false;
        }
        Measurement oW = (Measurement)this.getAttribute(XFA.WTAG, true, false);
        if (oW != null && !oW.isEmpty()) {
            return false;
        }
        Measurement oMaxW = (Measurement)this.getAttribute(XFA.MAXWTAG, true, false);
        return oMaxW == null || oMaxW.isEmpty() || (oMinW = (Measurement)this.getAttribute(XFA.MINWTAG, true, false)) == null || oMinW.isEmpty() || !(oMaxWVal = oMaxW.getUnitSpan()).lte(oMinWVal = oMinW.getUnitSpan());
    }

    public boolean isWidthGrowSupported() {
        return false;
    }

    int measurementCompare(String sFirst, String sSecond) {
        UnitSpan firstm = new UnitSpan(sFirst);
        UnitSpan secondm = new UnitSpan(sSecond);
        if (firstm.equals(secondm)) {
            return 0;
        }
        if (firstm.gt(secondm)) {
            return 1;
        }
        return -1;
    }

    String measurementValidate(String sValue) {
        return UnitSpan.measurementValidate(sValue, false);
    }

    @Override
    public void setAttribute(Attribute attr, int eTag) {
        if (attr != null) {
            if ((eTag == XFA.HTAG || eTag == XFA.MINHTAG || eTag == XFA.MAXHTAG) && this.isHeightGrowSupported()) {
                if (eTag == XFA.HTAG) {
                    this.removeAttr(null, "minH");
                    this.removeAttr(null, "maxH");
                } else if (eTag == XFA.MINHTAG) {
                    String sMaxH;
                    Attribute oMinHAttr;
                    String sMinH;
                    Attribute oMaxHAttr = this.getAttribute(XFA.MAXHTAG, true, false);
                    if (oMaxHAttr != null && 0 < this.measurementCompare(sMinH = this.measurementValidate((oMinHAttr = attr).toString()), sMaxH = this.measurementValidate(oMaxHAttr.toString()))) {
                        this.setAttribute(oMinHAttr, XFA.MAXHTAG);
                    }
                    this.removeAttr(null, "h");
                } else if (eTag == XFA.MAXHTAG) {
                    Attribute oMinHAttr = this.getAttribute(XFA.MINHTAG, true, false);
                    if (oMinHAttr != null) {
                        Attribute oMaxHAttr = attr;
                        String sMaxH = this.measurementValidate(oMaxHAttr.toString());
                        String sMinH = this.measurementValidate(oMinHAttr.toString());
                        if (0 < this.measurementCompare(sMinH, sMaxH)) {
                            this.setAttribute(oMaxHAttr, XFA.MINHTAG);
                        }
                    }
                    this.removeAttr(null, "h");
                }
            }
            if ((eTag == XFA.WTAG || eTag == XFA.MINWTAG || eTag == XFA.MAXWTAG) && this.isWidthGrowSupported()) {
                if (eTag == XFA.WTAG) {
                    this.removeAttr(null, "minW");
                    this.removeAttr(null, "maxW");
                } else if (eTag == XFA.MINWTAG) {
                    String sMaxW;
                    Attribute oMinWAttr;
                    String sMinW;
                    Attribute oMaxWAttr = this.getAttribute(XFA.MAXWTAG, true, false);
                    if (oMaxWAttr != null && 0 < this.measurementCompare(sMinW = this.measurementValidate((oMinWAttr = attr).toString()), sMaxW = this.measurementValidate(oMaxWAttr.toString()))) {
                        this.setAttribute(oMinWAttr, XFA.MAXWTAG);
                    }
                    this.removeAttr(null, "w");
                } else if (eTag == XFA.MAXWTAG) {
                    Attribute oMinWAttr = this.getAttribute(XFA.MINWTAG, true, false);
                    if (oMinWAttr != null) {
                        Attribute oMaxWAttr = attr;
                        String sMaxW = this.measurementValidate(oMaxWAttr.toString());
                        String sMinW = this.measurementValidate(oMinWAttr.toString());
                        if (0 < this.measurementCompare(sMinW, sMaxW)) {
                            this.setAttribute(oMaxWAttr, XFA.MINWTAG);
                        }
                    }
                    this.removeAttr(null, "w");
                }
            }
        }
        super.setAttribute(attr, eTag);
    }

    public void setFormInfo(FormInfo formInfo) {
        this.mFormInfo = formInfo;
    }

    private void refreshChildIndexCache() {
        for (int i = 0; i < 5; ++i) {
            this.mChildIndexCache[i] = null;
        }
        for (Node child = this.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            int nSlot;
            int eChildTag = child.getClassTag();
            if (eChildTag == XFA.SUBFORMTAG || eChildTag == XFA.FIELDTAG || (nSlot = this.eTagToCacheSlot(eChildTag)) < 0 || this.mChildIndexCache[nSlot] != null) continue;
            this.mChildIndexCache[nSlot] = child;
        }
    }

    private void setCacheDelayFlag(boolean bDelay) {
        this.setChildListModified(false);
        this.setDelayCacheRefreshFlag(bDelay);
    }

    private boolean getDelayCacheRefreshFlag() {
        return this.mbDelayCacheRefresh;
    }

    private final void setDelayCacheRefreshFlag(boolean bFlagValue) {
        this.mbDelayCacheRefresh = bFlagValue;
    }

    @Override
    public Node locateChildByClass(int eChildTag, int nIndex) {
        int nSlot;
        if (nIndex == 0 && !this.getModel().isLoading() && (nSlot = this.eTagToCacheSlot(eChildTag)) >= 0) {
            if (this.isChildListModified()) {
                this.setCacheDelayFlag(true);
            } else {
                if (this.getDelayCacheRefreshFlag()) {
                    this.refreshChildIndexCache();
                    this.setCacheDelayFlag(false);
                }
                Node child = this.mChildIndexCache[nSlot];
                return child;
            }
        }
        return super.locateChildByClass(eChildTag, nIndex);
    }

    private int eTagToCacheSlot(int eChildTag) {
        if (eChildTag == XFA.BORDERTAG) {
            return 0;
        }
        if (eChildTag == XFA.BINDTAG) {
            return 1;
        }
        if (eChildTag == XFA.MARGINTAG) {
            return 2;
        }
        if (eChildTag == XFA.VALIDATETAG) {
            return 3;
        }
        if (eChildTag == XFA.CALCULATETAG) {
            return 4;
        }
        return -1;
    }

    public static interface ChangeLogger {
        public void logPropChange(Node var1, String var2, String var3, Object var4);

        public void logValueChange(Node var1, String var2, Object var3);

        public void logChildChange(Node var1, Node var2, Object var3);
    }

    public static enum ValidationState {
        VALIDATIONSTATE_VALID,
        VALIDATIONSTATE_BARCODETEST,
        VALIDATIONSTATE_NULLTEST,
        VALIDATIONSTATE_SCRIPTTEST,
        VALIDATIONSTATE_FORMATTEST;

    }

    public static class FormInfo {
        public final Container templateContainerNode;
        public Element dataParent;
        public Element connectionDataParent;
        public Node scopeData;
        public NodeList dataNodes;
        public boolean bAssociation;
        public boolean bConnectDataRef;
        public boolean bRemoveAfterUse;
        public final int eMergeType;
        public final Element connectionDataNode;
        public NodeList altDataNodes;

        public FormInfo(Container templateContainerNode, int eMergeType) {
            this.templateContainerNode = templateContainerNode;
            this.eMergeType = eMergeType;
            this.connectionDataNode = null;
        }

        public FormInfo(Element connectionDataNode) {
            this.templateContainerNode = null;
            this.eMergeType = 0;
            this.connectionDataNode = connectionDataNode;
        }
    }
}

