/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.form.FormSubform;

public class FormDependencyTracker
extends DependencyTracker {
    private final AppModel mAppModel;
    private final FormModel mFormModel;
    private final Element mNode;
    private final boolean mbIsCalculate;

    public FormDependencyTracker(Element node, boolean bIsCalculate) {
        assert (node instanceof FormField || node instanceof FormSubform || node instanceof FormExclGroup);
        this.mNode = node;
        this.mbIsCalculate = bIsCalculate;
        this.mFormModel = (FormModel)this.mNode.getModel();
        this.mAppModel = this.mFormModel.getAppModel();
        this.mAppModel.dependencyTracker(this);
    }

    void dispose() {
        this.mAppModel.dependencyTracker(null);
    }

    @Override
    public void addDependency(Obj dependsOn) {
        if (this.mNode == dependsOn && this.mbIsCalculate) {
            return;
        }
        this.mFormModel.addScriptDependency(this.mNode, dependsOn, this.mbIsCalculate);
    }

    @Override
    public void addVirtualDependency(Obj context, String sPropertyName) {
        if (context.isSameClass("subformSet") || context.isSameClass("subform")) {
            Element node = (Element)context;
            if (node.getModel() != this.mFormModel) {
                return;
            }
            String sNodeName = "_" + sPropertyName;
            String aNodeName = sNodeName.intern();
            for (Node child = node.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                if (!child.isSameClass(XFA.INSTANCEMANAGERTAG) || child.getName() != "_" && child.getName() != aNodeName) continue;
                this.addDependency(child);
            }
        }
    }
}

