/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.NodeListImpl;
import com.adobe.xfa.ut.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class NamedNodeMapImpl
extends NodeListImpl
implements NamedNodeMap {
    private final Map<NodeKey, NodeImpl> mNameMap = new HashMap<NodeKey, NodeImpl>();
    private final Map<NodeKey, NodeImpl> mNSMap = new HashMap<NodeKey, NodeImpl>();

    NamedNodeMapImpl(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Node getNamedItem(String name) {
        return this.mNameMap.get(new NodeKey(name));
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return this.mNSMap.get(new NodeKey(namespaceURI, localName));
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    void addNode(NodeImpl node) {
        String ns;
        super.addNode(node);
        String name = node.getNodeName();
        if (name != null) {
            this.mNameMap.put(new NodeKey(name), node);
        }
        if ((ns = node.getNamespaceURI()) != null) {
            this.mNSMap.put(new NodeKey(ns, node.getLocalName()), node);
        }
    }

    private static final class NodeKey {
        final String mFirst;
        final String mSecond;

        NodeKey(String first, String second) {
            this.mFirst = first;
            this.mSecond = second;
        }

        NodeKey(String first) {
            this.mFirst = first;
            this.mSecond = null;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() != NodeKey.class) {
                return false;
            }
            NodeKey otherKey = (NodeKey)other;
            return StringUtils.equalsWithNull(this.mFirst, otherKey.mFirst) && StringUtils.equalsWithNull(this.mSecond, otherKey.mSecond);
        }

        public int hashCode() {
            int result = this.mFirst.hashCode();
            if (this.mSecond != null) {
                result ^= this.mSecond.hashCode();
            }
            return result;
        }
    }
}

