/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.ut.Resolver;
import com.adobe.xfa.ut.StringUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UriPath {
    private URL msRefFileLocation;

    public URL getFile(String sFileName) {
        if (StringUtils.isEmpty(sFileName)) {
            return null;
        }
        File file = new File(sFileName);
        if (file.isAbsolute()) {
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (this.msRefFileLocation != null) {
            Protocol protocol = Resolver.getProtocol(this.msRefFileLocation.getProtocol());
            try {
                return new URL(this.msRefFileLocation, sFileName, protocol != null ? protocol.getURLStreamHandler() : null);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        File cwd = new File(System.getProperty("user.dir"));
        file = new File(cwd, sFileName);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getRefFileLocation() {
        return this.msRefFileLocation;
    }

    public void setRefFileLocation(URL location) {
        this.msRefFileLocation = location;
    }
}

