/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.Comment;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Element;
import com.adobe.xfa.Generator;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.SaveNameSpaceChecker;
import com.adobe.xfa.SaxHandler;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.protocol.ProtocolUtils;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.IntegerHolder;
import com.adobe.xfa.ut.Key;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Document
extends Element {
    private final AppModel mAppModel;
    private SaveNameSpaceChecker mChecker;
    private URL mParseFile;
    private String msParseFileName;
    private Model mStartingModel;
    private Element mStartingParent;
    private boolean mbIgnoreAggregating;
    private boolean mbWillDirty = true;
    private final Document mRealDocument;
    private boolean mbIsDefaultDocument;
    private boolean mbAutoUniquifyIDs = true;
    private boolean mbUniquifyIDsOnParse;
    private boolean mbAllDataRootsEmpty;
    private Element mAddedRootData;
    private final QNameCache mQNameCache = new QNameCache();
    private final IdentityHashMap<QName, String> mElementToIdAttrNameMap = new IdentityHashMap();
    private final IdentityHashMap<String, String> mNameSpaceToIdAttrNameMap = new IdentityHashMap();
    private final List<QName> mGlobalXMLIdAttrList = new ArrayList<QName>();
    private final IdentityHashMap<QName, KeySpec> mElementToPKeySpecMap = new IdentityHashMap();
    private final Map<String, Element> mXMLIdIndex = new HashMap<String, Element>();
    private final IdentityHashMap<String, Map<String, Element>> mXFAIdIndexes = new IdentityHashMap();
    private final Map<Key, Element> mPKeyIndex = new HashMap<Key, Element>();
    private final IdentityHashMap<String, String> mSimpleNameSpaceMap = new IdentityHashMap();
    public static final String Encoding = "UTF-8";
    public static final byte[] MarkupAttrMiddle = new byte[]{61, 34};
    public static final byte[] MarkupAttrMiddleQuote = new byte[]{61, 39};
    static final byte[] MarkupColon = new byte[]{58};
    public static final byte[] MarkupDQuoteString = new byte[]{34};
    public static final byte[] MarkupQuoteString = new byte[]{39};
    public static final byte[] MarkupCDATAStart = new byte[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    public static final byte[] MarkupCDATAEnd = new byte[]{93, 93, 62};
    static final byte[] MarkupCommentStart = new byte[]{60, 33, 45, 45};
    static final byte[] MarkupCommentEnd = new byte[]{45, 45, 62};
    public static final byte[] MarkupCloseTag = new byte[]{60, 47};
    public static final byte[] MarkupDocType = new byte[]{60, 33, 68, 79, 67, 60, 84, 89, 80, 69};
    public static final byte[] MarkupEndEntity = new byte[]{34, 62};
    public static final byte[] MarkupEndParen2 = new byte[]{93, 62};
    public static final byte[] MarkupEndTag = new byte[]{62};
    static final byte[] MarkupEndTag2 = new byte[]{47, 62};
    public static final byte[] MarkupEntity = new byte[]{60, 33, 69, 78, 84, 73, 84, 89};
    public static final byte[] MarkupPIStart = new byte[]{60, 63};
    public static final byte[] MarkupPIEnd = new byte[]{63, 62};
    static final byte[] MarkupPrefix = new byte[]{60, 63, 120, 109, 108, 32, 118, 101, 114, 115, 105, 111, 110, 61, 34, 49, 46, 48, 34, 32, 101, 110, 99, 111, 100, 105, 110, 103, 61, 34};
    public static final byte[] MarkupReturn = new byte[]{10};
    public static final byte[] MarkupSpace = new byte[]{32};
    public static final byte[] MarkupStartParen = new byte[]{91};
    public static final byte[] MarkupStartTag = new byte[]{60};
    public static final byte[] MarkupSystem = new byte[]{83, 89, 83, 84, 69, 77};
    static final byte[] MarkupXMLns = new byte[]{120, 109, 108, 110, 115};
    private static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;

    private Document(AppModel appModel, boolean aliasExistingAppModelDocument) {
        super(null, null, "", "");
        if (appModel == null) {
            throw new NullPointerException("appModel");
        }
        this.mAppModel = appModel;
        if (this.mAppModel.getDocument() == null) {
            this.mRealDocument = this;
            this.mAppModel.setDocument(this);
        } else {
            this.mRealDocument = aliasExistingAppModelDocument ? this.mAppModel.getDocument() : this;
        }
        this.setDocument(this);
        this.setModel(this.mAppModel);
        this.mbIsDefaultDocument = true;
        this.declareGlobalXMLId("http://www.w3.org/XML/1998/namespace", "id");
    }

    public Document(AppModel appModel) {
        this(appModel, true);
    }

    public static Document createDocument(AppModel appModel) {
        return new Document(appModel, false);
    }

    @Override
    public void appendChild(Node child) {
        if (child instanceof Element && this.getDocumentElement() != null) {
            throw new ExFull(ResId.HierarchyRequestException);
        }
        super.appendChild(child);
    }

    public final boolean autoUniquifyIDs() {
        return this.mbAutoUniquifyIDs;
    }

    public final void autoUniquifyIDs(boolean bAutoUniquifyIDs) {
        this.mbAutoUniquifyIDs = bAutoUniquifyIDs;
    }

    public final boolean uniquifyIDsOnParse() {
        return this.mbUniquifyIDsOnParse;
    }

    public final void uniquifyIDsOnParse(boolean bUniquifyIDsOnParse) {
        this.mbUniquifyIDsOnParse = bUniquifyIDsOnParse;
    }

    public final void clearIdMap() {
        this.mXMLIdIndex.clear();
        for (Map<String, Element> index : this.mXFAIdIndexes.values()) {
            index.clear();
        }
        this.mPKeyIndex.clear();
    }

    private String stripVersionFromNameSpace(String aNameSpaceURI) {
        String aSimpleNameSpace = this.mSimpleNameSpaceMap.get(aNameSpaceURI);
        if (aSimpleNameSpace == null) {
            String sNameSpaceURI = aNameSpaceURI == null ? "" : aNameSpaceURI;
            int len = sNameSpaceURI.length();
            aSimpleNameSpace = sNameSpaceURI.length() >= 4 && sNameSpaceURI.charAt(len - 1) == '/' && Character.isDigit(sNameSpaceURI.charAt(len - 2)) && sNameSpaceURI.charAt(len - 3) == '.' && Character.isDigit(sNameSpaceURI.charAt(len - 4)) ? sNameSpaceURI.substring(0, len - 4).intern() : aNameSpaceURI;
            this.mSimpleNameSpaceMap.put(aNameSpaceURI, aSimpleNameSpace);
        }
        return aSimpleNameSpace;
    }

    public final Element getElementByXMLId(String idValue) {
        return this.mXMLIdIndex.get(idValue);
    }

    public final Element getElementByXFAId(String aNameSpaceURI, String aIdValue) {
        if (aNameSpaceURI == "") {
            for (Map<String, Element> index : this.mXFAIdIndexes.values()) {
                Element element = index.get(aIdValue);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        String aSimpleNameSpaceURI = this.stripVersionFromNameSpace(aNameSpaceURI);
        Map<String, Element> index = this.mXFAIdIndexes.get(aSimpleNameSpaceURI);
        return index != null ? index.get(aIdValue) : null;
    }

    public final Element getElementByPKey(Key key) {
        return this.mPKeyIndex.get(key);
    }

    private static boolean referencedByHostDocument(Element element) {
        Element parent;
        while ((parent = Element.getXMLParent(element)) != null) {
            element = parent;
        }
        return element instanceof Document || element.getIsDataWindowRoot();
    }

    private static void indexHelper(Map<String, Element> index, Attribute attr, Element element) {
        assert (index != null);
        Element existing = index.get(attr.getAttrValue());
        if (existing == null) {
            index.put(attr.getAttrValue(), element);
        } else if (existing != element) {
            String sOriginalValue = attr.getAttrValue();
            int i = 1;
            while (true) {
                String sTest;
                if (!index.containsKey(sTest = sOriginalValue + "_copy" + i)) {
                    Attribute newValue = attr.newAttribute(attr.getNS(), attr.getLocalName(), attr.getQName(), sTest, false);
                    element.updateAttributeInternal(newValue);
                    index.put(sTest, element);
                    break;
                }
                ++i;
            }
        }
    }

    public final void declareXMLId(String aElementNameSpaceURI, String aElementName, String aIdAttributeName) {
        QName elementQName = this.mQNameCache.getQName(aElementNameSpaceURI, aElementName);
        String aExisting = this.mElementToIdAttrNameMap.get(elementQName);
        if (aExisting == null) {
            this.mElementToIdAttrNameMap.put(elementQName, aIdAttributeName);
        } else assert (aExisting == aIdAttributeName);
    }

    public final void declareGlobalXMLId(String aIdAttrNameSpaceURI, String aIdAttrName) {
        for (int i = 0; i < this.mGlobalXMLIdAttrList.size(); ++i) {
            QName test = this.mGlobalXMLIdAttrList.get(i);
            if (test.maNameSpaceURI != aIdAttrNameSpaceURI || test.maLocalName != aIdAttrName) continue;
            return;
        }
        QName newQName = this.mQNameCache.getQName(aIdAttrNameSpaceURI, aIdAttrName);
        this.mGlobalXMLIdAttrList.add(newQName);
    }

    public final void declareXFAId(String aNameSpaceURI, String aIdAttributeName) {
        String aSimpleNameSpaceURI = this.stripVersionFromNameSpace(aNameSpaceURI);
        String aExisting = this.mNameSpaceToIdAttrNameMap.get(aSimpleNameSpaceURI);
        if (aExisting == null) {
            this.mNameSpaceToIdAttrNameMap.put(aSimpleNameSpaceURI, aIdAttributeName);
            assert (this.mXFAIdIndexes.get(aSimpleNameSpaceURI) == null);
            this.mXFAIdIndexes.put(aSimpleNameSpaceURI, new HashMap());
        } else assert (aExisting == aIdAttributeName);
    }

    public final void declarePKey(String aElementNameSpaceURI, String aElementName, String aPKeyNodeAddressList, Element namespaceContextNode) {
        QName elementQName = this.mQNameCache.getQName(aElementNameSpaceURI, aElementName);
        KeySpec keySpec = this.mElementToPKeySpecMap.get(elementQName);
        if (keySpec == null) {
            keySpec = new KeySpec(namespaceContextNode);
            StringTokenizer tokenizer = new StringTokenizer(aPKeyNodeAddressList, ",");
            while (tokenizer.hasMoreTokens()) {
                keySpec.mNodeAddresses.add(tokenizer.nextToken().trim());
            }
            this.mElementToPKeySpecMap.put(elementQName, keySpec);
        }
    }

    public final boolean isId(String aElementNameSpaceURI, String aElementName, String aAttrNameSpaceURI, String aAttrLocalName) {
        String aSimpleNameSpaceURI = this.stripVersionFromNameSpace(aElementNameSpaceURI);
        if (this.mNameSpaceToIdAttrNameMap.get(aSimpleNameSpaceURI) == aAttrLocalName) {
            return true;
        }
        if (this.mElementToIdAttrNameMap.size() > 0) {
            QName elementQName = this.mQNameCache.getExistingQName(aElementNameSpaceURI, aElementName);
            if (elementQName != null && this.mElementToIdAttrNameMap.get(elementQName) == aAttrLocalName) {
                return true;
            }
            elementQName = this.mQNameCache.getExistingQName("", aElementName);
            if (elementQName != null && this.mElementToIdAttrNameMap.get(elementQName) == aAttrLocalName) {
                return true;
            }
        }
        for (int i = 0; i < this.mGlobalXMLIdAttrList.size(); ++i) {
            QName qName = this.mGlobalXMLIdAttrList.get(i);
            if (qName.maNameSpaceURI != aAttrNameSpaceURI || qName.maLocalName != aAttrLocalName) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Node clone(Element parent) {
        MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidMethodException, this.getClassAtom());
        oMessage.format("clone");
        throw new ExFull(oMessage);
    }

    public final Node cloneNode(boolean bDeep) {
        Document newDoc = new Document(this.mAppModel, false);
        if (bDeep) {
            for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                newDoc.appendChild(newDoc.importNode(child, true, null, null));
            }
        }
        return newDoc;
    }

    public final Element createElementNS(String sNameSpaceURI, String sQualifiedName, Element parent) {
        Node.doQualifyNodeName(sQualifiedName, false);
        Element newElement = new Element(parent, null, sNameSpaceURI, sQualifiedName);
        newElement.setDocument(this);
        if (parent != null) {
            parent.appendChild(newElement, true);
        }
        Document.checkValidNameSpace(newElement, sQualifiedName);
        return newElement;
    }

    private static String findEncoding(InputStream is) {
        assert (is.markSupported() || is instanceof MarkableInputStream);
        try {
            String sCharset;
            byte[] buf = new byte[64];
            is.mark(buf.length);
            int nBuf = is.read(buf, 0, buf.length);
            is.reset();
            int offset = 0;
            if (nBuf < 3) {
                return null;
            }
            if (buf[0] == -17 && buf[1] == -69 && buf[2] == -65) {
                offset = 3;
            } else if (buf[0] != 60 || buf[1] != 63) {
                return null;
            }
            int end = -1;
            for (int i = offset; i < nBuf; ++i) {
                if (buf[i] != 62) continue;
                end = i;
                break;
            }
            if (end == -1) {
                return null;
            }
            String sXMLDecl = new String(buf, offset, end, Encoding);
            if ((offset = sXMLDecl.indexOf("encoding")) == -1) {
                return null;
            }
            offset += "encoding".length();
            while (offset < sXMLDecl.length() && Document.isXMLSpace(sXMLDecl.charAt(offset))) {
                ++offset;
            }
            if (offset == sXMLDecl.length()) {
                return null;
            }
            if (sXMLDecl.charAt(offset) != '=') {
                return null;
            }
            ++offset;
            while (offset < sXMLDecl.length() && Document.isXMLSpace(sXMLDecl.charAt(offset))) {
                ++offset;
            }
            if (offset == sXMLDecl.length()) {
                return null;
            }
            char quote = sXMLDecl.charAt(offset);
            if (quote != '\'' && quote != '\"') {
                return null;
            }
            if ((sCharset = sXMLDecl.substring(++offset, end = sXMLDecl.indexOf(quote, offset))).equalsIgnoreCase("SHIFT-JIS")) {
                return "SHIFT_JIS";
            }
        }
        catch (IOException e) {
            throw new ExFull(e);
        }
        return null;
    }

    private static boolean isXMLSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    @Override
    public Node getFirstXMLChild() {
        return this.mRealDocument.mFirstXMLChild;
    }

    @Override
    public AppModel getAppModel() {
        return this.mAppModel;
    }

    public final Element getDocumentElement() {
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public Generator getGenerator() {
        return null;
    }

    @Override
    public String getName() {
        return "#document";
    }

    public URL getParseFile() {
        return this.mRealDocument.mParseFile;
    }

    public String getParseFileName() {
        return this.mRealDocument.msParseFileName;
    }

    @Override
    public boolean getWillDirty() {
        return this.mRealDocument.mbWillDirty;
    }

    public final SaveNameSpaceChecker getSaveChecker() {
        return this.mRealDocument.mChecker;
    }

    public final boolean isDefaultDocument() {
        return this.mRealDocument.mbIsDefaultDocument;
    }

    public final void isDefaultDocument(boolean bIsDefault) {
        this.mRealDocument.mbIsDefaultDocument = bIsDefault;
    }

    public boolean isAllDataRootsEmpty() {
        return this.mbAllDataRootsEmpty;
    }

    public void setAllDataRootsEmpty(boolean AllDataRootsEmpty) {
        this.mbAllDataRootsEmpty = AllDataRootsEmpty;
    }

    public Element getAddedRootData() {
        return this.mAddedRootData;
    }

    public void setAddedRootData(Element AddedRootData) {
        this.mAddedRootData = AddedRootData;
    }

    public final Node importNode(Node source, boolean bDeep) {
        return this.importNode(source, bDeep, null, null);
    }

    private final Node importNode(Node source, boolean bDeep, Element parent, Node previousSibling) {
        if (source == null) {
            return null;
        }
        if (source instanceof Element.DualDomNode) {
            source = ((Element.DualDomNode)((Object)source)).getXmlPeer();
        }
        if (source instanceof Document) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Document#importNode - document child");
        }
        if (source instanceof Element) {
            Element elementSource = (Element)source;
            Element newElement = new Element(parent, previousSibling, elementSource.getNS(), elementSource.getLocalName(), elementSource.getXMLName(), null, XFA.INVALID_ELEMENT, "");
            newElement.setDocument(this);
            newElement.setModel(this.mAppModel);
            int n = elementSource.getNumAttrs();
            for (int i = 0; i < n; ++i) {
                Attribute attr = elementSource.getAttr(i);
                newElement.setAttribute(attr.getNS(), attr.getQName(), attr.getLocalName(), attr.getAttrValue(), false);
            }
            if (source instanceof ModelPeer && !(source instanceof Model.DualDomModel)) {
                source = ((ModelPeer)source).getXfaPeer();
            }
            if (bDeep) {
                Node prevSibling = null;
                for (Node child = source.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                    prevSibling = this.importNode(child, true, newElement, prevSibling);
                }
            }
            return newElement;
        }
        if (source instanceof TextNode) {
            return new TextNode(parent, previousSibling, ((TextNode)source).getText());
        }
        if (source instanceof Chars) {
            return new Chars(parent, previousSibling, ((Chars)source).getText());
        }
        if (source instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)source;
            return new ProcessingInstruction(parent, previousSibling, pi.getName(), pi.getData());
        }
        if (source instanceof Comment) {
            return new Comment(parent, previousSibling, ((Comment)source).getData());
        }
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Document.importNode - unknown type");
    }

    public final boolean hasChanged() {
        return this.mRealDocument.isDirty();
    }

    final void indexNode(Element element, boolean bInDocumentCheckCompleted) {
        Key primaryKey;
        int index;
        QName elementLocalName;
        int index2;
        if (element instanceof Element.DualDomNode) {
            Node node = ((Element.DualDomNode)((Object)element)).getXmlPeer();
            if (node instanceof TextNode) {
                return;
            }
            element = (Element)node;
        }
        if (!bInDocumentCheckCompleted && !Document.referencedByHostDocument(element)) {
            return;
        }
        Attribute attr = null;
        String aElementNameSpaceURI = this.stripVersionFromNameSpace(element.getNS());
        String aXFAIdAttrName = this.mNameSpaceToIdAttrNameMap.get(aElementNameSpaceURI);
        if (aXFAIdAttrName != null && (index2 = element.findAttr("", aXFAIdAttrName)) != -1) {
            attr = element.getAttr(index2);
        }
        if (attr != null) {
            Document.indexHelper(this.mXFAIdIndexes.get(aElementNameSpaceURI), attr, element);
        }
        attr = null;
        String aXMLIdAttrName = null;
        QName elementQName = this.mQNameCache.getExistingQName(aElementNameSpaceURI, element.getLocalName());
        if (elementQName != null) {
            aXMLIdAttrName = this.mElementToIdAttrNameMap.get(elementQName);
        }
        if (aXMLIdAttrName == null && (elementLocalName = this.mQNameCache.getExistingQName("", element.getLocalName())) != null) {
            aXMLIdAttrName = this.mElementToIdAttrNameMap.get(elementLocalName);
        }
        if (aXMLIdAttrName != null && (index = element.findAttr("", aXMLIdAttrName)) != -1) {
            attr = element.getAttr(index);
        }
        if (attr != null) {
            Document.indexHelper(this.mXMLIdIndex, attr, element);
        }
        for (int i = 0; i < this.mGlobalXMLIdAttrList.size(); ++i) {
            QName xmlIdAttrQName = this.mGlobalXMLIdAttrList.get(i);
            int index3 = element.findAttr(xmlIdAttrQName.maNameSpaceURI, xmlIdAttrQName.maLocalName);
            if (index3 != -1) {
                attr = element.getAttr(index3);
            }
            if (attr == null) continue;
            Document.indexHelper(this.mXMLIdIndex, attr, element);
        }
        KeySpec primaryKeySpec = this.mElementToPKeySpecMap.get(elementQName);
        if (primaryKeySpec != null && (primaryKey = element.constructKey(primaryKeySpec.mNodeAddresses, primaryKeySpec.mNamespaceContextNode)).numValues() > 0) {
            Element existing = this.mPKeyIndex.get(primaryKey);
            if (existing == null) {
                this.mPKeyIndex.put(primaryKey, element);
            } else assert (existing == element);
        }
    }

    public final void indexSubtree(Element source, boolean bInDocumentCheckCompleted) {
        if (!bInDocumentCheckCompleted && !Document.referencedByHostDocument(source)) {
            return;
        }
        this.indexNode(source, true);
        for (Node child = source.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            this.indexSubtree((Element)child, true);
        }
    }

    final void deindexNode(Element element, boolean bInDocumentCheckCompleted) {
        Key primaryKey;
        int index;
        QName elementLocalName;
        int index2;
        if (element instanceof Element.DualDomNode) {
            Node node = ((Element.DualDomNode)((Object)element)).getXmlPeer();
            if (node instanceof TextNode) {
                return;
            }
            element = (Element)node;
        }
        if (!bInDocumentCheckCompleted && !Document.referencedByHostDocument(element)) {
            return;
        }
        Attribute attr = null;
        String aElementNameSpaceURI = this.stripVersionFromNameSpace(element.getNSInternal());
        String aXFAIdAttrName = this.mNameSpaceToIdAttrNameMap.get(aElementNameSpaceURI);
        if (aXFAIdAttrName != null && (index2 = element.findAttr("", aXFAIdAttrName)) != -1) {
            attr = element.getAttr(index2);
        }
        if (attr != null) {
            this.mXFAIdIndexes.get(aElementNameSpaceURI).remove(attr.getAttrValue());
        }
        attr = null;
        String aXMLIdAttrName = null;
        QName elementQName = this.mQNameCache.getExistingQName(aElementNameSpaceURI, element.getLocalName());
        if (elementQName != null) {
            aXMLIdAttrName = this.mElementToIdAttrNameMap.get(elementQName);
        }
        if (aXMLIdAttrName == null && (elementLocalName = this.mQNameCache.getExistingQName("", element.getLocalName())) != null) {
            aXMLIdAttrName = this.mElementToIdAttrNameMap.get(elementLocalName);
        }
        if (aXMLIdAttrName != null && (index = element.findAttr("", aXMLIdAttrName)) != -1) {
            attr = element.getAttr(index);
        }
        if (attr != null) {
            this.mXMLIdIndex.remove(attr.getAttrValue());
        }
        for (int i = 0; i < this.mGlobalXMLIdAttrList.size(); ++i) {
            QName xmlIdAttrQName = this.mGlobalXMLIdAttrList.get(i);
            int index3 = element.findAttr(xmlIdAttrQName.maNameSpaceURI, xmlIdAttrQName.maLocalName);
            if (index3 != -1) {
                attr = element.getAttr(index3);
            }
            if (attr == null) continue;
            this.mXMLIdIndex.remove(attr.getAttrValue());
        }
        KeySpec primaryKeySpec = this.mElementToPKeySpecMap.get(elementQName);
        if (primaryKeySpec != null && (primaryKey = element.constructKey(primaryKeySpec.mNodeAddresses, primaryKeySpec.mNamespaceContextNode)).numValues() > 0) {
            this.mPKeyIndex.remove(primaryKey);
        }
    }

    public final void deindexSubtree(Element source, boolean bInDocumentCheckCompleted) {
        if (!bInDocumentCheckCompleted && !Document.referencedByHostDocument(source)) {
            return;
        }
        this.deindexNode(source, true);
        for (Node child = source.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (!(child instanceof Element)) continue;
            this.deindexSubtree((Element)child, true);
        }
    }

    public final boolean idValueInUse(String idValue) {
        if (this.mXMLIdIndex.get(idValue) != null) {
            return true;
        }
        for (Map<String, Element> index : this.mXFAIdIndexes.values()) {
            if (index == null || !index.containsKey(idValue)) continue;
            return true;
        }
        return false;
    }

    public final boolean isIncrementalLoad() {
        return false;
    }

    public final void load(InputStream is, String encoding, boolean parseExternalDTD) {
        this.load(is, null, encoding, parseExternalDTD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(File file) {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(is);
            this.load(in, file.toString(), null, false);
        }
        catch (IOException e) {
            throw new ExFull(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(InputStream is, String source, String encoding, boolean parseExternalDTD) {
        this.mRealDocument.setParseFileName(source);
        this.setWillDirty(false);
        try {
            SaxHandler handler = new SaxHandler(this.mRealDocument);
            if (this.mStartingModel != null) {
                handler.setContext(this.mRealDocument.mStartingModel, this.mRealDocument.mStartingParent, this.mRealDocument.mbIgnoreAggregating);
            }
            if (encoding == null) {
                is = Document.makeInputStreamSupportMark(is);
                encoding = Document.findEncoding(is);
            }
            this.launchSAX(handler, is, encoding, parseExternalDTD);
        }
        finally {
            this.setWillDirty(true);
        }
        this.isDefaultDocument(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element loadIntoDocument(InputStream is) {
        this.setWillDirty(false);
        try {
            Element root = this.createElementNS("", "dummy", null);
            SaxHandler handler = new SaxHandler(this.mRealDocument);
            handler.setContext(null, root, false);
            is = Document.makeInputStreamSupportMark(is);
            String encoding = Document.findEncoding(is);
            this.launchSAX(handler, is, encoding, false);
            Element element = root;
            return element;
        }
        finally {
            this.setWillDirty(true);
        }
    }

    public final Element loadToNextElement(IntegerHolder depth) {
        return null;
    }

    private void launchSAX(SaxHandler h, InputStream is, String encoding, boolean parseExtrnlDTD) {
        try {
            SAXParser p = SAXParserFactory.newInstance().newSAXParser();
            XMLReader r = p.getXMLReader();
            r.setFeature("http://xml.org/sax/features/namespaces", true);
            r.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", parseExtrnlDTD);
            if (!parseExtrnlDTD) {
                r.setFeature("http://xml.org/sax/features/validation", false);
            }
            r.setContentHandler(h);
            r.setErrorHandler(h);
            r.setProperty("http://xml.org/sax/properties/lexical-handler", h);
            InputSource in = new InputSource(is);
            if (encoding != null) {
                in.setEncoding(encoding);
            }
            r.parse(in);
        }
        catch (SAXException s) {
            MsgFormatPos msg = new MsgFormatPos(ResId.EXPAT_ERROR);
            msg.format(s.getMessage());
            throw new ExFull(msg);
        }
        catch (ParserConfigurationException p) {
            throw new ExFull(p);
        }
        catch (IOException e) {
            throw new ExFull(e);
        }
    }

    public final void savePreamble(OutputStream os, DOMSaveOptions options) {
        try {
            if (!options.getExcludePreamble()) {
                os.write(MarkupPrefix);
                os.write(Encoding.getBytes(Encoding));
                os.write(MarkupDQuoteString);
                os.write(MarkupPIEnd);
                if (options.getDisplayFormat() != 0 || options.getFormatOutside()) {
                    os.write(MarkupReturn);
                }
                options.setExcludePreamble(true);
            }
        }
        catch (IOException e) {
            throw new ExFull(e);
        }
    }

    public void preSave() {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Document#preSave");
    }

    @Override
    @Deprecated
    public final void saveXML(OutputStream os, DOMSaveOptions options) {
        boolean bClearChecker = false;
        if (this.mRealDocument.mChecker == null) {
            this.mRealDocument.mChecker = new SaveNameSpaceChecker(this);
            bClearChecker = true;
        }
        try {
            this.mRealDocument.saveXMLInternal(os, options);
        }
        catch (IOException ex) {
            throw new ExFull(ex);
        }
        finally {
            if (bClearChecker) {
                this.mRealDocument.mChecker = null;
            }
        }
    }

    private void saveXMLInternal(OutputStream os, DOMSaveOptions options) throws IOException {
        Node prevChild = null;
        for (Node child = this.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            child.serialize(os, options, 0, prevChild);
            prevChild = child;
        }
    }

    public final void saveAs(OutputStream os, Node startNode, DOMSaveOptions options) {
        assert (startNode == null || startNode.getXMLParent() == null || startNode.getOwnerDocument().mRealDocument == this.mRealDocument);
        options = this.prepareSaveOptions(os, startNode, options);
        try {
            assert (this.mRealDocument.mChecker == null);
            this.mRealDocument.mChecker = new SaveNameSpaceChecker(startNode != null ? startNode : this);
            if (startNode != null && startNode != this) {
                Node xmlDomStartNode = startNode instanceof Element.DualDomNode ? ((Element.DualDomNode)((Object)startNode)).getXmlPeer() : startNode;
                Node previousSibling = xmlDomStartNode.getPreviousXMLSibling();
                startNode.serialize(os, options, 0, previousSibling);
            } else {
                this.mRealDocument.saveXMLInternal(os, options);
            }
        }
        catch (IOException ex) {
            throw new ExFull(ex);
        }
        finally {
            this.mRealDocument.mChecker = null;
        }
    }

    private DOMSaveOptions prepareSaveOptions(OutputStream os, Node startNode, DOMSaveOptions options) {
        DOMSaveOptions tweakedOptions = options == null ? new DOMSaveOptions() : new DOMSaveOptions(options);
        this.savePreamble(os, tweakedOptions);
        if (tweakedOptions.getIncludeDTD()) {
            Node node = startNode != null && startNode != this ? startNode : this.getFirstXMLChild();
            boolean bEmitCR = tweakedOptions.getDisplayFormat() != 0;
            this.saveDTD(os, node, bEmitCR);
        }
        return tweakedOptions;
    }

    private void saveDTD(OutputStream os, Node oNode, boolean bEmitCr) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Document#saveDTD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream outFile, DOMSaveOptions options, int level, Node prevSibling) throws IOException {
        boolean bClearChecker = false;
        if (this.mRealDocument.mChecker == null) {
            this.mRealDocument.mChecker = new SaveNameSpaceChecker(this);
            bClearChecker = true;
        }
        try {
            options = this.prepareSaveOptions(outFile, this, options);
            this.mRealDocument.saveXMLInternal(outFile, options);
        }
        finally {
            if (bClearChecker) {
                this.mRealDocument.mChecker = null;
            }
        }
    }

    public final void setContext(Model model, Element parent, boolean bIgnoreAggregating) {
        this.mRealDocument.mStartingModel = model;
        this.mRealDocument.mStartingParent = parent;
        this.mRealDocument.mbIgnoreAggregating = bIgnoreAggregating;
    }

    public final void setParseFileName(String source) {
        URL url = null;
        if (source != null) {
            try {
                File file = new File(source);
                if (file.exists()) {
                    url = file.toURI().toURL();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (url == null) {
                try {
                    url = new URL(source);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (url == null) {
                throw new IllegalArgumentException("source");
            }
        }
        this.mRealDocument.msParseFileName = source;
        this.mRealDocument.mParseFile = url;
    }

    @Override
    public void setWillDirty(boolean bWillDirty) {
        this.mRealDocument.mbWillDirty = bWillDirty;
    }

    private static InputStream makeInputStreamSupportMark(InputStream is) {
        return is.markSupported() ? is : new MarkableInputStream(is);
    }

    private static final class MarkableInputStream
    extends InputStream {
        private final InputStream mInputStream;
        private byte[] mBuffer;
        private int mOffset;
        private int mLength;

        public MarkableInputStream(InputStream is) {
            this.mInputStream = is;
        }

        @Override
        public int read() throws IOException {
            this.preLoadBuffer();
            if (this.mBuffer != null) {
                if (this.mOffset == this.mLength) {
                    this.disposeBuffer();
                } else {
                    return this.mBuffer[this.mOffset++] & 0xFF;
                }
            }
            return this.mInputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.preLoadBuffer();
            if (this.mBuffer != null) {
                if (this.mOffset == this.mLength) {
                    this.disposeBuffer();
                } else {
                    int bytesRead = Math.min(this.mLength - this.mOffset, len);
                    System.arraycopy(this.mBuffer, this.mOffset, b, off, bytesRead);
                    this.mOffset += bytesRead;
                    return bytesRead;
                }
            }
            return this.mInputStream.read(b, off, len);
        }

        private void preLoadBuffer() throws IOException {
            if (this.mOffset == 0 && this.mBuffer == null) {
                this.mBuffer = new byte[64];
                int nRead = ProtocolUtils.read(this.mInputStream, this.mBuffer);
                this.mLength = nRead < 0 ? 0 : nRead;
            }
        }

        private void disposeBuffer() {
            this.mBuffer = null;
            this.mLength = -1;
            this.mOffset = -1;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            this.preLoadBuffer();
            if (this.mBuffer != null) {
                int bytesLeft = this.mLength - this.mOffset;
                if (n >= (long)bytesLeft) {
                    this.disposeBuffer();
                    return (long)bytesLeft + this.mInputStream.skip(n - (long)bytesLeft);
                }
                this.mOffset = (int)((long)this.mOffset + n);
                return n;
            }
            return this.mInputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            this.preLoadBuffer();
            if (this.mBuffer != null) {
                int bytesLeft = this.mLength - this.mOffset;
                return bytesLeft == 0 ? this.mInputStream.available() : bytesLeft;
            }
            return this.mInputStream.available();
        }

        @Override
        public void mark(int howMuch) {
            assert (this.mOffset == 0);
            assert (howMuch == 64);
        }

        @Override
        public void reset() {
            assert (this.mBuffer != null);
            this.mOffset = 0;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() throws IOException {
            this.mInputStream.close();
        }
    }

    private static class KeySpec {
        final List<String> mNodeAddresses = new ArrayList<String>();
        final Element mNamespaceContextNode;

        KeySpec(Element namespaceContextNode) {
            this.mNamespaceContextNode = namespaceContextNode;
        }
    }

    private static class QNameCache {
        private static final List<QName> mCache = new ArrayList<QName>();

        private QNameCache() {
        }

        public final QName getQName(String aNameSpaceURI, String aLocalName) {
            QName qName = this.getExistingQName(aNameSpaceURI, aLocalName);
            if (qName == null) {
                qName = new QName(aNameSpaceURI, aLocalName);
                mCache.add(qName);
            }
            return qName;
        }

        public final QName getExistingQName(String aNameSpaceURI, String aLocalName) {
            for (int i = 0; i < mCache.size(); ++i) {
                QName qName = mCache.get(i);
                if (aNameSpaceURI != qName.maNameSpaceURI || aLocalName != qName.maLocalName) continue;
                return qName;
            }
            return null;
        }
    }

    private static class QName {
        final String maNameSpaceURI;
        final String maLocalName;

        QName(String aNameSpaceURI, String aLocalName) {
            this.maNameSpaceURI = aNameSpaceURI;
            this.maLocalName = aLocalName;
        }
    }
}

