/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.navigation;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageFit;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.navigation.XPDFDestination;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XPDFDestinationExplicit
extends XPDFDestination {
    private PDFDestinationExplicit pdfDestinationExplicit;
    private boolean internal;

    public XPDFDestinationExplicit(PDFDestinationExplicit pdfDestinationExplicit) {
        this.pdfDestinationExplicit = pdfDestinationExplicit;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws SAXException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ch.startElement(parentName);
        String childElt = null;
        AttributesImpl childAtt = new AttributesImpl();
        if (this.pdfDestinationExplicit.hasPageNumber()) {
            childAtt.addAttribute("", "PageNum", "PageNum", "CDATA", String.valueOf(this.pdfDestinationExplicit.getPageNumber()));
        } else {
            PDFPage page = this.pdfDestinationExplicit.getPage();
            if (page != null) {
                childAtt.addAttribute("", "PageNum", "PageNum", "CDATA", String.valueOf(page.getIndex()));
            }
        }
        PDFPageFit fit = this.pdfDestinationExplicit.getPageFit();
        Number[] coords = this.pdfDestinationExplicit.getCoordinates();
        if (PDFPageFit.XYZ == fit) {
            childElt = "XYZ";
            this.outCoord(coords, 0, childAtt, "Left");
            this.outCoord(coords, 1, childAtt, "Top");
            this.outCoord(coords, 2, childAtt, "Zoom");
        } else if (PDFPageFit.Fit == fit) {
            childElt = "Fit";
        } else if (PDFPageFit.FitH == fit) {
            childElt = "FitH";
            this.outCoord(coords, 0, childAtt, "Top");
        } else if (PDFPageFit.FitV == fit) {
            childElt = "FitV";
            this.outCoord(coords, 0, childAtt, "Left");
        } else if (PDFPageFit.FitR == fit) {
            childElt = "FitR";
            this.outCoord(coords, 0, childAtt, "Left");
            this.outCoord(coords, 1, childAtt, "Bottom");
            this.outCoord(coords, 2, childAtt, "Right");
            this.outCoord(coords, 3, childAtt, "Top");
        } else if (PDFPageFit.FitB == fit) {
            childElt = "FitB";
        } else if (PDFPageFit.FitBH == fit) {
            childElt = "FitBH";
            this.outCoord(coords, 0, childAtt, "Top");
        } else if (PDFPageFit.FitBV == fit) {
            childElt = "FitBV";
            this.outCoord(coords, 0, childAtt, "Left");
        }
        if (childElt != null) {
            ch.element(childElt, childAtt);
        }
        ch.endElement(parentName);
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        Number[] coords;
        String page = att.getValue("PageNum");
        if (page != null) {
            if (this.isInternal()) {
                this.pdfDestinationExplicit.setPage(this.pdfDestinationExplicit.getPDFDocument().requirePages().getPage(Integer.parseInt(page)));
            } else {
                this.pdfDestinationExplicit.setPageNumber(Integer.parseInt(page));
            }
        } else {
            this.pdfDestinationExplicit.setPage(null);
        }
        if ("XYZ".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.XYZ);
            coords = new Number[3];
            this.inCoord(att, "Left", coords, 0);
            this.inCoord(att, "Top", coords, 1);
            this.inCoord(att, "Zoom", coords, 2);
            this.pdfDestinationExplicit.setCoordinates(coords);
            return null;
        }
        if ("Fit".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.Fit);
            return null;
        }
        if ("FitH".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.FitH);
            coords = new Number[1];
            this.inCoord(att, "Top", coords, 0);
            this.pdfDestinationExplicit.setCoordinates(coords);
            return null;
        }
        if ("FitV".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.FitV);
            coords = new Number[1];
            this.inCoord(att, "Left", coords, 0);
            this.pdfDestinationExplicit.setCoordinates(coords);
            return null;
        }
        if ("FitR".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.FitR);
            coords = new Number[4];
            this.inCoord(att, "Left", coords, 0);
            this.inCoord(att, "Bottom", coords, 1);
            this.inCoord(att, "Right", coords, 2);
            this.inCoord(att, "Top", coords, 3);
            this.pdfDestinationExplicit.setCoordinates(coords);
            return null;
        }
        if ("FitB".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.FitB);
            return null;
        }
        if ("FitBH".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.FitBH);
            coords = new Number[1];
            this.inCoord(att, "Top", coords, 0);
            this.pdfDestinationExplicit.setCoordinates(coords);
            return null;
        }
        if ("FitBV".equals(lName)) {
            this.pdfDestinationExplicit.setPageFit(PDFPageFit.FitBV);
            coords = new Number[1];
            this.inCoord(att, "Left", coords, 0);
            this.pdfDestinationExplicit.setCoordinates(coords);
            return null;
        }
        return eh.XPDFInvalidElement(lName);
    }

    void outCoord(Number[] coords, int index, AttributesImpl att, String name) {
        if (coords[index] != null) {
            att.addAttribute("", name, name, "CDATA", String.valueOf(coords[index].doubleValue()));
        }
    }

    private void inCoord(XPDFAttributes att, String name, Number[] coords, int index) {
        String v = att.getValue(name);
        coords[index] = v == null ? null : new Double(Double.parseDouble(v));
    }

    public void setIsInternalDestination(boolean internal) {
        this.internal = internal;
    }

    public boolean isInternal() {
        return this.internal;
    }
}

