/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xpdf.model.action;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.xpdf.XPDFHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFAttributes;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFContentHandler;
import com.adobe.internal.pdftoolkit.xpdf.impl.XPDFErrorHandler;
import com.adobe.internal.pdftoolkit.xpdf.model.XPDFCosObject;
import com.adobe.internal.pdftoolkit.xpdf.model.action.XPDFActionFactory;
import org.xml.sax.SAXException;

public class XPDFAction
extends XPDFCosObject {
    private PDFAction pdfAction;
    protected boolean processingNextActions = false;

    public XPDFAction(PDFAction pdfAction) {
        this.pdfAction = pdfAction;
    }

    @Override
    public void toXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
    }

    protected void exportNextToXPDF(XPDFContentHandler ch, String parentName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        PDFAction.ArrayIterator iter = this.pdfAction.nextArrayIterator();
        if (iter != null && iter.hasNext()) {
            ch.startElement("Next");
            while (iter.hasNext()) {
                PDFAction action = iter.next();
                XPDFAction xpdfAction = XPDFActionFactory.newXPDFActionInstance(action);
                if (xpdfAction == null) continue;
                xpdfAction.toXPDF(ch, null);
            }
            ch.endElement("Next");
        }
    }

    @Override
    public XPDFHandler fromXPDFStartElement(String lName, XPDFAttributes att, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Next".equals(lName)) {
            this.processingNextActions = true;
            return null;
        }
        if (this.processingNextActions) {
            PDFAction action = XPDFActionFactory.newSkeletonInstance(lName, this.pdfAction.getPDFDocument());
            if (action == null) {
                return eh.XPDFInvalidElement(lName);
            }
            PDFAction.addNextAction(this.pdfAction, action);
            return XPDFActionFactory.newXPDFActionInstance(action);
        }
        return eh.XPDFInvalidElement(lName);
    }

    @Override
    public void fromXPDFEndElement(String name, XPDFErrorHandler eh) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, SAXException {
        if ("Next".equals(name)) {
            this.processingNextActions = false;
        }
        super.fromXPDFEndElement(name, eh);
    }
}

