/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFileInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRichMedia;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaActivation;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaConfiguration;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaConfigurationList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaContent;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaInstance;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaInstanceList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaSettings;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextBodyAttributes;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDF2CosWriter;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFActions;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationInk;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationLine;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationLink;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationProjection;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationSound;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationStrikeOut;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationText;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFExData;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFUtil;
import com.adobe.internal.pdftoolkit.xml.CopyBlobProcessElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class XFDF2PDFAnnotationReader
extends DefaultHandler {
    private int skipElement = 0;
    private int inValue = 0;
    private int countXDP = 0;
    private int countXFDF = 0;
    private boolean inXFDF = false;
    private boolean inAnnot = false;
    private int countAnnots = 0;
    private int curPage = -1;
    private PDFDocument pdfDoc = null;
    private PDFAnnotation curAnnot = null;
    private XFDFAnnotation xfdfAnnot = null;
    private StringBuilder valuesBuff = null;
    private boolean inDataStream = false;
    private OutputByteStream dataStream;
    private boolean rawMode = false;
    private char leftOverHexDigit;
    private boolean haveLeftOverHexDigit = false;
    private ArrayList inReplyToList = null;
    private HashMap processedAnnotName2ObjMap = null;
    private Map<PDFAnnotation, String> annot2Md5ChecksumMap;
    private XMLUtils.CopyBlob2String richTextBlob = null;
    private boolean has3DInfo = false;
    private XFDFExData exdata;
    private ASName exdataSubType = null;
    private static final String ANNOTS_NAME = "annots";
    private static final String XFDF_NAME = "xfdf";
    private static final String XFDF_NAME_SPACE = "http://ns.adobe.com/xfdf/";
    private static final String XDP_NAME = "xdp";
    private boolean hasXFDFElement = false;
    private PDFAnnotationRotationEnum rotationEnum = PDFAnnotationRotationEnum.NoRotate;
    private DefaultHandler handler;

    public XFDF2PDFAnnotationReader(PDFDocument doc, PDFAnnotationRotationEnum rotationEnum) {
        this.pdfDoc = doc;
        this.rotationEnum = rotationEnum;
    }

    public XFDF2PDFAnnotationReader(PDFDocument doc) {
        this.pdfDoc = doc;
    }

    private void markInReplyToEntry(PDFAnnotation textAnnot, String name) {
        if (name == null || textAnnot == null || !(textAnnot instanceof PDFAnnotationText)) {
            return;
        }
        if (this.inReplyToList == null) {
            this.inReplyToList = new ArrayList();
        }
        this.inReplyToList.add(new InReplyTo((PDFAnnotationText)textAnnot, name));
    }

    private int findReferencingAnnotation(String name, int start) {
        for (int refInd = start; refInd < this.inReplyToList.size(); ++refInd) {
            if (!name.equals(((InReplyTo)this.inReplyToList.get(refInd)).annotName)) continue;
            return refInd;
        }
        return -1;
    }

    private void createDefaultStyle(String style) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.curAnnot instanceof PDFAnnotationFreeText) {
            ((PDFAnnotationFreeText)this.curAnnot).setDefaultStyle(style);
        }
    }

    private void createDefaultAppearance(String appearance) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (this.curAnnot instanceof PDFAnnotationFreeText) {
            ((PDFAnnotationFreeText)this.curAnnot).setDefaultAppearance(appearance);
        } else if (this.curAnnot instanceof PDFAnnotationRedaction) {
            ((PDFAnnotationRedaction)this.curAnnot).setDA(appearance);
        }
    }

    static String getElementType(String sName, String qName) {
        String elemType = sName;
        if (elemType == null || elemType.length() == 0) {
            elemType = qName;
        }
        return elemType;
    }

    @Override
    public void setDocumentLocator(Locator l) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.skipElement = 0;
        this.inValue = 0;
        this.countXFDF = 0;
        this.countXDP = 0;
        this.inXFDF = false;
        this.inAnnot = false;
        this.countAnnots = 0;
        this.inReplyToList = null;
        this.valuesBuff = new StringBuilder("");
        this.processedAnnotName2ObjMap = new HashMap();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.annot2Md5ChecksumMap != null) {
            this.annot2Md5ChecksumMap.clear();
        }
        if (this.inReplyToList == null) {
            return;
        }
        try {
            PDFPage curPage;
            PDFPageTree pages = this.pdfDoc.requirePages();
            int pageIndex = 0;
            while ((curPage = pages.getPage(pageIndex++)) != null) {
                PDFAnnotationList annotations = curPage.getAnnotationList();
                if (annotations == null) continue;
                for (int annotInd = 0; annotInd < annotations.size(); ++annotInd) {
                    PDFAnnotation pdfAnnot = annotations.get(annotInd);
                    if (pdfAnnot == null) continue;
                    int refInd = 0;
                    String name = pdfAnnot.getName();
                    if (name == null) continue;
                    while ((refInd = this.findReferencingAnnotation(name, refInd)) != -1) {
                        PDFAnnotationText textAnnot = ((InReplyTo)this.inReplyToList.get(refInd++)).textAnnot;
                        textAnnot.setInReplyTo(pdfAnnot);
                    }
                }
                this.fixAnnotsWithNewInReplyTo(curPage);
            }
        }
        catch (PDFException e) {
            throw new SAXException("Annotations parsing error", e);
        }
        this.inReplyToList = null;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
        try {
            String elemType = XFDF2PDFAnnotationReader.getElementType(sName, qName);
            if (elemType == null || elemType.length() == 0) {
                throw new SAXException("Wrong XFDF structure");
            }
            if (elemType.equals(XDP_NAME)) {
                ++this.countXDP;
                if (this.countXDP > 1) {
                    ++this.skipElement;
                }
                return;
            }
            if (elemType.equals(XFDF_NAME)) {
                if (namespaceURI.equals(XFDF_NAME_SPACE)) {
                    this.hasXFDFElement = true;
                }
                ++this.countXFDF;
                this.inXFDF = true;
            }
            if (elemType.equals(ANNOTS_NAME)) {
                ++this.countAnnots;
                this.inAnnot = true;
            }
            if (this.skipElement > 0 || this.countXFDF != 1 || !this.inXFDF && this.countAnnots != 1) {
                ++this.skipElement;
            } else if (this.xfdfAnnot == null) {
                if (elemType.equals("text")) {
                    this.xfdfAnnot = new XFDFAnnotationText(this.pdfDoc);
                } else if (elemType.equals("circle")) {
                    this.xfdfAnnot = new XFDFAnnotationCircle(this.pdfDoc);
                } else if (elemType.equals("freetext")) {
                    this.xfdfAnnot = new XFDFAnnotationFreeText(this.pdfDoc);
                } else if (elemType.equals("highlight")) {
                    this.xfdfAnnot = new XFDFAnnotationHighlight(this.pdfDoc);
                } else if (elemType.equals("square")) {
                    this.xfdfAnnot = new XFDFAnnotationSquare(this.pdfDoc);
                } else if (elemType.equals("strikeout")) {
                    this.xfdfAnnot = new XFDFAnnotationStrikeOut(this.pdfDoc);
                } else if (elemType.equals("underline")) {
                    this.xfdfAnnot = new XFDFAnnotationUnderline(this.pdfDoc);
                } else if (elemType.equals("ink")) {
                    this.xfdfAnnot = new XFDFAnnotationInk(this.pdfDoc);
                } else if (elemType.equals("line")) {
                    this.xfdfAnnot = new XFDFAnnotationLine(this.pdfDoc);
                } else if (elemType.equals("polygon")) {
                    this.xfdfAnnot = new XFDFAnnotationPolygon(this.pdfDoc);
                } else if (elemType.equals("polyline")) {
                    this.xfdfAnnot = new XFDFAnnotationPolyline(this.pdfDoc);
                } else if (elemType.equals("projection")) {
                    this.xfdfAnnot = new XFDFAnnotationProjection(this.pdfDoc);
                } else if (elemType.equals("link")) {
                    this.xfdfAnnot = new XFDFAnnotationLink(this.pdfDoc);
                } else if (elemType.equals("sound")) {
                    this.xfdfAnnot = new XFDFAnnotationSound(this.pdfDoc);
                } else if (elemType.equals("fileattachment")) {
                    this.xfdfAnnot = new XFDFAnnotationFileAttachment(this.pdfDoc);
                } else if (elemType.equals("squiggly")) {
                    this.xfdfAnnot = new XFDFAnnotationSquiggly(this.pdfDoc);
                } else if (elemType.equals("caret")) {
                    this.xfdfAnnot = new XFDFAnnotationCaret(this.pdfDoc);
                } else if (elemType.equals("redact")) {
                    this.xfdfAnnot = new XFDFAnnotationRedaction(this.pdfDoc);
                } else if (elemType.equals("stamp")) {
                    this.xfdfAnnot = new XFDFAnnotationStamp(this.pdfDoc);
                }
                if (this.xfdfAnnot == null) {
                    if (!this.inXFDF && !this.inAnnot) {
                        ++this.skipElement;
                    }
                } else {
                    this.xfdfAnnot.setRotationType(this.rotationEnum);
                    this.curAnnot = this.xfdfAnnot.createPDFAnnotation(elemAttrs);
                    if (this.curAnnot == null) {
                        this.xfdfAnnot = null;
                        ++this.skipElement;
                    } else {
                        this.curPage = this.xfdfAnnot.getCurPage();
                        this.markInReplyToEntry(this.curAnnot, this.xfdfAnnot.getInReplyTo(elemAttrs));
                    }
                }
            } else {
                if (elemType.equals("contents-richtext")) {
                    this.richTextBlob = new XMLUtils.CopyBlob2String(new RichTextBodyAttributes());
                    ++this.inValue;
                } else {
                    if (this.richTextBlob != null) {
                        this.richTextBlob.startElement(namespaceURI, sName, qName, elemAttrs);
                        return;
                    }
                    if (elemType.equals("data")) {
                        if (this.curAnnot == null || this.inValue > 0) {
                            ++this.skipElement;
                        } else {
                            this.inDataStream = true;
                            this.dataStream = this.pdfDoc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                            this.rawMode = this.xfdfAnnot.startDataStream(elemAttrs);
                        }
                        ++this.inValue;
                    } else if (!elemType.equals("inklist")) {
                        if (elemType.equals("appearance")) {
                            if (!((this.xfdfAnnot instanceof XFDFAnnotationStamp || this.xfdfAnnot instanceof XFDFAnnotationCaret || this.xfdfAnnot instanceof XFDFAnnotationCircle || this.xfdfAnnot instanceof XFDFAnnotationFreeText || this.xfdfAnnot instanceof XFDFAnnotationHighlight || this.xfdfAnnot instanceof XFDFAnnotationLine || this.xfdfAnnot instanceof XFDFAnnotationPolygon || this.xfdfAnnot instanceof XFDFAnnotationPolyline || this.xfdfAnnot instanceof XFDFAnnotationProjection || this.xfdfAnnot instanceof XFDFAnnotationRedaction || this.xfdfAnnot instanceof XFDFAnnotationSound || this.xfdfAnnot instanceof XFDFAnnotationStrikeOut || this.xfdfAnnot instanceof XFDFAnnotationSquare || this.xfdfAnnot instanceof XFDFAnnotationSquiggly || this.xfdfAnnot instanceof XFDFAnnotationText || this.xfdfAnnot instanceof XFDFAnnotationUnderline) && this.inValue <= 0)) {
                                ++this.skipElement;
                            } else {
                                ++this.inValue;
                            }
                        } else if (elemType.equals("contents") || elemType.equals("gesture") || elemType.equals("vertices") || elemType.equals("defaultstyle") || elemType.equals("defaultappearance")) {
                            if (this.curAnnot == null || this.inValue > 0) {
                                ++this.skipElement;
                            }
                            ++this.inValue;
                        } else if (elemType.equals("OnActivation")) {
                            if (this.curAnnot == null || !(this.curAnnot instanceof PDFAnnotationLink)) {
                                ++this.skipElement;
                            } else if (this.curAnnot != null) {
                                PDFAnnotationLink linkAnnot = (PDFAnnotationLink)this.curAnnot;
                                linkAnnot.removeDestination();
                                XFDFActions actions = XFDFActions.create(linkAnnot.getPDFDocument());
                                linkAnnot.setDictionaryValue(ASName.k_A, actions);
                            }
                        } else if (elemType.equals("Action")) {
                            if (!(this.curAnnot instanceof PDFAnnotationLink)) {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("URI") || elemType.equals("Launch") || elemType.equals("GoTo") || elemType.equals("GoToR")) {
                            if (!(this.curAnnot instanceof PDFAnnotationLink) || !((XFDFAnnotationLink)this.xfdfAnnot).createAction(elemType, elemAttrs, (PDFAnnotationLink)this.curAnnot)) {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("Dest")) {
                            if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                                ++this.skipElement;
                            } else {
                                ((XFDFAnnotationLink)this.xfdfAnnot).setInDestination(true);
                            }
                        } else if (elemType.equals("XYZ") || elemType.equals("Fit") || elemType.equals("FitH") || elemType.equals("FitV") || elemType.equals("FitR") || elemType.equals("FitB") || elemType.equals("FitBH") || elemType.equals("FitBV")) {
                            if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink) || !((XFDFAnnotationLink)this.xfdfAnnot).createDestination(elemType, elemAttrs)) {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("Named")) {
                            if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                                ++this.skipElement;
                            } else if (!(!((XFDFAnnotationLink)this.xfdfAnnot).getInDestination() ? ((XFDFAnnotationLink)this.xfdfAnnot).createAction(elemType, elemAttrs, (PDFAnnotationLink)this.curAnnot) : ((XFDFAnnotationLink)this.xfdfAnnot).createDestination(elemType, elemAttrs))) {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("File")) {
                            if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                                ++this.skipElement;
                            } else {
                                ((XFDFAnnotationLink)this.xfdfAnnot).createFileSpec(elemAttrs);
                            }
                        } else if (elemType.equals("BorderStyleAlt")) {
                            if (this.xfdfAnnot == null || !(this.xfdfAnnot instanceof XFDFAnnotationLink)) {
                                ++this.skipElement;
                            } else if (!((XFDFAnnotationLink)this.xfdfAnnot).createAltBorder(elemAttrs)) {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("popup")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                                XFDFAnnotationPopup popupAnnot = new XFDFAnnotationPopup(this.xfdfAnnot);
                                popupAnnot.createPDFAnnotation(elemAttrs);
                            } else {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("ex_data")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                                if (this.curAnnot instanceof PDFAnnotationMarkup) {
                                    this.exdataSubType = XFDFAnnotation.createPDFExDataObject(this.curAnnot, elemAttrs);
                                }
                            } else {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("exdata3d")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                                this.has3DInfo = true;
                            } else {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("md5checksum")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                                ++this.inValue;
                                if (this.annot2Md5ChecksumMap == null) {
                                    this.annot2Md5ChecksumMap = new HashMap<PDFAnnotation, String>();
                                }
                            } else {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("anno3dname")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                                ++this.inValue;
                            } else {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("view3d")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null) {
                                this.has3DInfo = true;
                                ++this.inValue;
                            } else {
                                ++this.skipElement;
                            }
                        } else if (elemType.equals("measurementcomment")) {
                            if (this.curPage != -1 && this.xfdfAnnot != null && this.curAnnot != null && this.exdata != null) {
                                ++this.inValue;
                            } else {
                                ++this.skipElement;
                            }
                        } else if (this.curAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.curAnnot).hasExData() && this.has3DInfo) {
                            if (this.exdata != null) {
                                this.exdata.createPDFExData(elemType, null, elemAttrs, true);
                            }
                        } else if (!this.inXFDF && !this.inAnnot) {
                            ++this.skipElement;
                        }
                    }
                }
                if (this.curAnnot != null && this.curAnnot.getName() != null) {
                    this.processedAnnotName2ObjMap.put(this.curAnnot.getName(), this.curAnnot);
                }
            }
        }
        catch (IOException e) {
            throw new SAXException("IO error when setting annotations in the PDF Document", e);
        }
        catch (PDFException e) {
            throw new SAXException("Unable to set created XFDF annotations in the PDF document", e);
        }
        this.inXFDF = false;
        this.inAnnot = false;
    }

    private List get3DandRichMediaAnnotations(PDFPage curPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList annotations = curPage.getAnnotationList();
        ArrayList<PDFAnnotation> annots3D = new ArrayList<PDFAnnotation>();
        if (annotations != null) {
            for (int annotInd = 0; annotInd < annotations.size(); ++annotInd) {
                PDFAnnotation pdfAnnot = annotations.get(annotInd);
                if (!(pdfAnnot instanceof PDFAnnotation3D) && !(pdfAnnot instanceof PDFAnnotationRichMedia)) continue;
                annots3D.add(pdfAnnot);
            }
        }
        return annots3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        block83: {
            String elemType = XFDF2PDFAnnotationReader.getElementType(sName, qName);
            if (elemType == null || elemType.length() == 0) {
                throw new SAXException("Wrong XFDF structure");
            }
            try {
                if (this.skipElement > 0) {
                    --this.skipElement;
                    break block83;
                }
                if (elemType.equals("contents-richtext")) {
                    if (this.richTextBlob != null && this.inValue == 1) {
                        RichTextHandler reprocessRichText;
                        String newRichText;
                        CopyBlobProcessElement processElement = this.richTextBlob.getProcessElement();
                        String richText = this.richTextBlob.getBlob();
                        String contents = this.richTextBlob.getRawContent();
                        if (processElement != null && !processElement.wasProcessed() && (newRichText = (reprocessRichText = new RichTextHandler()).getRichText(contents)) != null) {
                            richText = newRichText;
                            contents = reprocessRichText.getRawContent();
                        }
                        if (richText != null && this.curAnnot != null) {
                            ((PDFAnnotationMarkup)this.curAnnot).setRichContents(richText);
                        }
                        if (contents != null && this.curAnnot != null) {
                            this.curAnnot.setContents(contents);
                        }
                        this.richTextBlob = null;
                        --this.inValue;
                    }
                    break block83;
                }
                if (this.richTextBlob != null) {
                    this.richTextBlob.endElement(namespaceURI, sName, qName);
                    return;
                }
                if (elemType.equals("text") || elemType.equals("circle") || elemType.equals("fileattachment") || elemType.equals("freetext") || elemType.equals("highlight") || elemType.equals("square") || elemType.equals("strikeout") || elemType.equals("underline") || elemType.equals("sound") || elemType.equals("stamp") || elemType.equals("ink") || elemType.equals("line") || elemType.equals("polygon") || elemType.equals("polyline") || elemType.equals("projection") && !this.has3DInfo || elemType.equals("caret") || elemType.equals("squiggly") || elemType.equals("link") || elemType.equals("redact")) {
                    block84: {
                        if (elemType.equals("redact")) {
                            PDFAnnotationRedaction redactionAnnot = (PDFAnnotationRedaction)this.curAnnot;
                            double[] quadPoints = redactionAnnot.getQuadPoints();
                            ASMatrix matrix = ContentUtil.computeMatrixFromBox(redactionAnnot.getPage());
                            matrix = matrix == null ? ASMatrix.createIdentityMatrix() : matrix.getInverse();
                            ContentWriter writer = ContentWriter.newInstance(this.pdfDoc);
                            InputByteStream ibs = null;
                            boolean noFill = redactionAnnot.getInteriorColor() == null;
                            try {
                                try {
                                    ASRectangle bbox = new ASRectangle(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
                                    ASQuad quad = null;
                                    if (quadPoints != null && quadPoints.length > 0) {
                                        for (int i = 0; i < quadPoints.length; i += 8) {
                                            quad = new ASQuad(new ASCoordinate(quadPoints[0], quadPoints[1]), new ASCoordinate(quadPoints[2], quadPoints[3]), new ASCoordinate(quadPoints[4], quadPoints[5]), new ASCoordinate(quadPoints[6], quadPoints[7]));
                                            quad = quad.transform(matrix);
                                            bbox = XFDF2PDFAnnotationReader.handleQuad(writer, quad, bbox, noFill);
                                        }
                                    } else {
                                        PDFRectangle rect = redactionAnnot.getRect();
                                        if (rect != null) {
                                            quad = new ASQuad(new ASCoordinate(rect.left(), rect.top()), new ASCoordinate(rect.right(), rect.top()), new ASCoordinate(rect.left(), rect.bottom()), new ASCoordinate(rect.right(), rect.bottom()));
                                            quad = quad.transform(matrix);
                                            bbox = XFDF2PDFAnnotationReader.handleQuad(writer, quad, bbox, noFill);
                                        }
                                    }
                                    ibs = writer.close().getContentStream();
                                    writer = null;
                                    PDFXObjectForm xobjForm = PDFXObjectForm.newInstance(this.pdfDoc, PDFRectangle.newInstance(this.pdfDoc, bbox), null, ibs);
                                    xobjForm.setMatrix(new double[]{1.0, 0.0, 0.0, 1.0, -bbox.left(), -bbox.bottom()});
                                    redactionAnnot.setRO(xobjForm);
                                    break block84;
                                }
                                finally {
                                    if (writer != null) {
                                        writer.close();
                                    }
                                    if (ibs != null) {
                                        ibs.close();
                                    }
                                }
                            }
                            catch (IOException e) {
                                throw new PDFIOException(e);
                            }
                        }
                        if (elemType.equals("freetext")) {
                            if (((PDFAnnotationFreeText)this.curAnnot).getDefaultStyle() == null) {
                                this.createDefaultStyle("font: Helvetica,sans-serif 12.0pt; text-align:left; color:#000000 ");
                            }
                            if (((PDFAnnotationFreeText)this.curAnnot).getDefaultAppearance() == null) {
                                this.createDefaultAppearance("/Helv 12 Tf 0 g");
                            }
                        }
                    }
                    this.curAnnot = null;
                    this.xfdfAnnot = null;
                    this.curPage = -1;
                    break block83;
                }
                if (elemType.equals("contents")) {
                    --this.inValue;
                    if (this.inValue == 0 && this.curAnnot != null) {
                        this.curAnnot.setContents(this.valuesBuff.toString());
                        this.valuesBuff.setLength(0);
                    }
                } else if (elemType.equals("appearance")) {
                    --this.inValue;
                    if (this.inValue == 0 && (this.xfdfAnnot instanceof XFDFAnnotationStamp || this.xfdfAnnot instanceof XFDFAnnotationCaret || this.xfdfAnnot instanceof XFDFAnnotationCircle || this.xfdfAnnot instanceof XFDFAnnotationFreeText || this.xfdfAnnot instanceof XFDFAnnotationHighlight || this.xfdfAnnot instanceof XFDFAnnotationLine || this.xfdfAnnot instanceof XFDFAnnotationPolygon || this.xfdfAnnot instanceof XFDFAnnotationPolyline || this.xfdfAnnot instanceof XFDFAnnotationProjection || this.xfdfAnnot instanceof XFDFAnnotationRedaction || this.xfdfAnnot instanceof XFDFAnnotationSound || this.xfdfAnnot instanceof XFDFAnnotationStrikeOut || this.xfdfAnnot instanceof XFDFAnnotationSquare || this.xfdfAnnot instanceof XFDFAnnotationSquiggly || this.xfdfAnnot instanceof XFDFAnnotationText || this.xfdfAnnot instanceof XFDFAnnotationUnderline)) {
                        if (this.handler == null) {
                            this.handler = new XFDF2CosWriter(this.xfdfAnnot);
                        }
                        this.xfdfAnnot.createAppearance(this.valuesBuff.toString(), this.handler);
                        this.valuesBuff.setLength(0);
                    }
                } else if (elemType.equals("gesture")) {
                    --this.inValue;
                    if (this.inValue == 0 && this.curAnnot != null) {
                        if (this.xfdfAnnot instanceof XFDFAnnotationInk) {
                            ((XFDFAnnotationInk)this.xfdfAnnot).createInk(this.valuesBuff.toString());
                        }
                        this.valuesBuff.setLength(0);
                    }
                } else if (elemType.equals("vertices")) {
                    --this.inValue;
                    if (this.inValue == 0 && this.curAnnot != null) {
                        if (this.xfdfAnnot instanceof XFDFAnnotationPolygon) {
                            ((XFDFAnnotationPolygon)this.xfdfAnnot).addPDFVertices(this.valuesBuff.toString());
                        }
                        if (this.xfdfAnnot instanceof XFDFAnnotationPolyline) {
                            ((XFDFAnnotationPolyline)this.xfdfAnnot).addPDFVertices(this.valuesBuff.toString());
                        }
                        this.valuesBuff.setLength(0);
                    }
                } else if (elemType.equals("defaultstyle")) {
                    --this.inValue;
                    if (this.inValue == 0 && this.curAnnot != null) {
                        this.createDefaultStyle(this.valuesBuff.toString());
                        this.valuesBuff.setLength(0);
                    }
                } else if (elemType.equals("defaultappearance")) {
                    --this.inValue;
                    if (this.inValue == 0 && this.curAnnot != null) {
                        this.createDefaultAppearance(this.valuesBuff.toString());
                        this.valuesBuff.setLength(0);
                    }
                } else if (elemType.equals("data")) {
                    --this.inValue;
                    if (this.inValue == 0 && this.curAnnot != null) {
                        this.xfdfAnnot.endDataStream(this.dataStream, this.rawMode);
                    }
                    this.dataStream = null;
                    this.inDataStream = false;
                } else if (elemType.equals(XFDF_NAME)) {
                    if (this.countXFDF > 1) {
                        --this.countXFDF;
                    }
                } else if (elemType.equals(XDP_NAME)) {
                    if (this.countXDP > 1) {
                        --this.countXDP;
                    }
                } else if (elemType.equals(ANNOTS_NAME) && this.countAnnots > 1) {
                    --this.countAnnots;
                } else if (elemType.equals("exdata3d")) {
                    this.has3DInfo = false;
                } else if (elemType.equals("md5checksum")) {
                    --this.inValue;
                    String md5ChecksumImported = this.valuesBuff.toString().trim();
                    this.valuesBuff.setLength(0);
                    List annots = this.get3DandRichMediaAnnotations(this.curAnnot.getPage());
                    String md5ChecksumCalculated = "";
                    byte[] checksum = null;
                    for (int i3D = 0; i3D < annots.size(); ++i3D) {
                        PDFAnnotation annot = (PDFAnnotation)annots.get(i3D);
                        if (this.annot2Md5ChecksumMap.containsKey(annot)) {
                            md5ChecksumCalculated = this.annot2Md5ChecksumMap.get(annot);
                        } else {
                            PDFAnnotation3D annot3D;
                            if (this.exdataSubType == PDFExData.k_RichMedia && annot instanceof PDFAnnotationRichMedia) {
                                PDFEmbeddedFile embeddedFile;
                                PDFFileSpecification asset;
                                PDFRichMediaInstance rmInstance;
                                PDFRichMediaConfigurationList rmConfigList;
                                PDFRichMediaContent rmContent;
                                PDFRichMediaActivation rmActivation;
                                PDFAnnotationRichMedia annotRM = (PDFAnnotationRichMedia)annot;
                                PDFRichMediaConfiguration rmConfig = null;
                                PDFRichMediaSettings rmSettings = (PDFRichMediaSettings)annotRM.getRichMediaSettings();
                                if (rmSettings != null && (rmActivation = rmSettings.getActivation()) != null && (rmConfig = rmActivation.getConfiguration()) == null && (rmContent = (PDFRichMediaContent)annotRM.getRichMediaContent()) != null && (rmConfigList = rmContent.getConfigurations()) != null) {
                                    rmConfig = (PDFRichMediaConfiguration)rmConfigList.get(0);
                                }
                                if (rmConfig == null) continue;
                                PDFRichMediaInstanceList rmInstanceList = rmConfig.getInstances();
                                if (rmInstanceList != null && (rmInstance = (PDFRichMediaInstance)rmInstanceList.get(0)) != null && (asset = rmInstance.getAsset()) != null && (embeddedFile = asset.getEmbeddedFile()) != null) {
                                    PDFEmbeddedFileInfo fileInfo = embeddedFile.getFileInfo();
                                    ASString md5 = fileInfo.getCheckSum();
                                    if (md5 != null) {
                                        checksum = md5.getBytes();
                                    }
                                    md5ChecksumCalculated = XFDFUtil.getMD5ChecksumString(checksum);
                                }
                            } else if ((this.exdataSubType == PDFExData.k_Markup3D || this.exdataSubType == PDFExData.k_3DM) && annot instanceof PDFAnnotation3D && (annot3D = (PDFAnnotation3D)annot).has3DDictOrStream()) {
                                checksum = XFDFUtil.calculateMD5Checksum(annot3D);
                                md5ChecksumCalculated = XFDFUtil.getMD5ChecksumString(checksum);
                            }
                            if (md5ChecksumCalculated == null) continue;
                            this.annot2Md5ChecksumMap.put(annot, md5ChecksumCalculated);
                        }
                        if (!md5ChecksumCalculated.equalsIgnoreCase(md5ChecksumImported)) continue;
                        this.exdata = new XFDFExData(this.xfdfAnnot, annot, checksum);
                    }
                } else if (elemType.equals("anno3dname")) {
                    --this.inValue;
                    String annot3DName = this.valuesBuff.toString().trim();
                    this.valuesBuff.setLength(0);
                    List annots3D = this.get3DandRichMediaAnnotations(this.curAnnot.getPage());
                    for (int i3D = 0; i3D < annots3D.size(); ++i3D) {
                        PDFAnnotation annot3D = (PDFAnnotation)annots3D.get(i3D);
                        if (annot3D.getName() == null || !annot3D.getName().equalsIgnoreCase(annot3DName)) continue;
                        this.exdata = new XFDFExData(this.xfdfAnnot, annot3D, null);
                    }
                } else if (elemType.equals("view3d")) {
                    --this.inValue;
                    System.out.println("done with the import" + this.curAnnot.getName());
                    if (this.curAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.curAnnot).hasExData() && this.has3DInfo && this.exdata != null) {
                        this.exdata.import3DMarkup();
                    }
                } else if (elemType.equals("measurementcomment")) {
                    --this.inValue;
                    String measurementcomment = this.valuesBuff.toString().trim();
                    this.valuesBuff.setLength(0);
                    this.exdata.setMeasurementcomment(measurementcomment);
                    if (this.curAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.curAnnot).hasExData() && this.has3DInfo) {
                        this.exdata.import3DMarkup();
                    }
                } else if (this.curAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.curAnnot).hasExData() && this.has3DInfo) {
                    if (this.exdata != null) {
                        this.exdata.createPDFExData(elemType, this.valuesBuff.toString(), null, false);
                    }
                    this.valuesBuff.setLength(0);
                }
            }
            catch (PDFException e) {
                throw new SAXException("Unable to set parsed annotations in the PDF document", e);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        throw new SAXException(" ERROR: SAX Exception: Doctype is disallowed!!");
    }

    private static ASRectangle handleQuad(ContentWriter writer, ASQuad quad, ASRectangle bbox, boolean noFill) throws PDFIOException, PDFInvalidParameterException {
        if (!noFill) {
            writer.write(InstructionFactory.newMoveTo(quad.p3().x(), quad.p3().y()));
            writer.write(InstructionFactory.newLineTo(quad.p4().x(), quad.p4().y()));
            writer.write(InstructionFactory.newLineTo(quad.p2().x(), quad.p2().y()));
            writer.write(InstructionFactory.newLineTo(quad.p1().x(), quad.p1().y()));
            writer.write(InstructionFactory.newLineTo(quad.p3().x(), quad.p3().y()));
            writer.write(InstructionFactory.newFillPath());
        }
        bbox = XFDF2PDFAnnotationReader.updateBBox(quad.p3().x(), quad.p3().y(), bbox, noFill);
        bbox = XFDF2PDFAnnotationReader.updateBBox(quad.p4().x(), quad.p4().y(), bbox, noFill);
        bbox = XFDF2PDFAnnotationReader.updateBBox(quad.p2().x(), quad.p2().y(), bbox, noFill);
        bbox = XFDF2PDFAnnotationReader.updateBBox(quad.p1().x(), quad.p1().y(), bbox, noFill);
        return bbox;
    }

    private static ASRectangle updateBBox(double x, double y, ASRectangle rect, boolean noFill) throws PDFInvalidParameterException {
        double borderWidth = 0.5;
        if (noFill) {
            borderWidth = 0.0;
        }
        double[] updatedRect = new double[]{x - borderWidth < rect.left() ? x - borderWidth : rect.left(), y - borderWidth < rect.bottom() ? y - borderWidth : rect.bottom(), x + borderWidth > rect.right() ? x + borderWidth : rect.right(), y + borderWidth > rect.top() ? y + borderWidth : rect.top()};
        return new ASRectangle(updatedRect);
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.skipElement > 0 || this.inValue != 1) {
            return;
        }
        if (this.richTextBlob != null) {
            this.richTextBlob.copyCharacters(buf, offset, len);
        } else if (this.inDataStream) {
            try {
                if (this.rawMode) {
                    if (XFDF2PDFAnnotationReader.copyHexString(this.haveLeftOverHexDigit, this.leftOverHexDigit, buf, offset, len, this.dataStream)) {
                        this.leftOverHexDigit = buf[offset + len - 1];
                        this.haveLeftOverHexDigit = true;
                    }
                    this.haveLeftOverHexDigit = false;
                }
                XFDF2PDFAnnotationReader.copyLowBytes(buf, offset, len, this.dataStream);
            }
            catch (PDFIOException e) {
                throw new SAXException("Unable to write to annotation data buffer.", e);
            }
        } else {
            String content = new String(buf, offset, len);
            if (this.valuesBuff == null) {
                this.valuesBuff = new StringBuilder(content);
            } else {
                this.valuesBuff.append(content);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException err) throws SAXParseException {
        throw err;
    }

    static final boolean copyHexString(boolean useLeadingDigit, char leadingDigit, char[] hex, int offset, int len, OutputByteStream obs) throws PDFIOException {
        try {
            for (int pos = 0; pos < len; ++pos) {
                char rawByte;
                while (pos < len && hex[pos + offset] < ' ') {
                    ++pos;
                }
                if (pos >= len) {
                    return false;
                }
                if (useLeadingDigit) {
                    rawByte = leadingDigit;
                    useLeadingDigit = false;
                } else {
                    rawByte = hex[pos + offset];
                    ++pos;
                }
                byte b1 = (byte)(Character.digit(rawByte, 16) << 4);
                if (pos >= len) {
                    return true;
                }
                byte b2 = (byte)Character.digit(hex[pos + offset], 16);
                obs.write(b1 | b2);
            }
            return false;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    static final void copyLowBytes(char[] bytes, int offset, int len, OutputByteStream obs) throws PDFIOException {
        try {
            for (int i = offset; i < offset + len; ++i) {
                byte b = (byte)(Character.getNumericValue(bytes[i]) & 0xFF);
                obs.write(b);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void fixAnnotsWithNewInReplyTo(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationIterator iter = page.getAnnotationsIterator();
        PDFAnnotation annot = null;
        while (iter.hasNext()) {
            PDFAnnotation inReplyToAnnot;
            annot = iter.next();
            if (!(annot instanceof PDFAnnotationMarkup) || (inReplyToAnnot = ((PDFAnnotationMarkup)annot).getInReplyTo()) == null || !this.processedAnnotName2ObjMap.containsKey(inReplyToAnnot.getName()) || inReplyToAnnot == (PDFAnnotation)this.processedAnnotName2ObjMap.get(inReplyToAnnot.getName()) || ((PDFAnnotation)this.processedAnnotName2ObjMap.get(inReplyToAnnot.getName())).getPage() != page) continue;
            inReplyToAnnot = (PDFAnnotation)this.processedAnnotName2ObjMap.get(inReplyToAnnot.getName());
            ((PDFAnnotationMarkup)annot).setInReplyTo(inReplyToAnnot);
        }
    }

    boolean hasXFDFElement() {
        return this.hasXFDFElement;
    }

    private static class InReplyTo {
        private PDFAnnotationText textAnnot;
        private String annotName;

        InReplyTo(PDFAnnotationText text, String name) {
            this.textAnnot = text;
            this.annotName = name;
        }
    }
}

