/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralTraverser;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.Cos2XMLReaderDispatcher;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.Cos2XMLReferencesDispatcher;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.util.ArrayListStack;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Cos2XMLReader
implements XMLReader {
    private ContentHandler mHandler;
    private PDFCosDictionary mRoot;
    private ASName mParentKey;
    private XFDFAnnotation mParentAnnot;

    public Cos2XMLReader(PDFCosDictionary rootObject, ASName parentKey, XFDFAnnotation parentAnnot) {
        this.mRoot = rootObject;
        this.mParentKey = parentKey;
        this.mParentAnnot = parentAnnot;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.mHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        boolean dbgCnt = false;
        try {
            CosObject root = this.mRoot.getDictionaryValue(this.mParentKey);
            if (!(root instanceof CosContainer)) {
                return;
            }
            this.mHandler.startDocument();
            Cos2XMLReferencesDispatcher refDispath = new Cos2XMLReferencesDispatcher();
            GeneralTraverser refTaverser = new GeneralTraverser(refDispath);
            refTaverser.traverseCosGraph((CosContainer)root, null);
            Cos2XMLReaderDispatcher cos2XMLDispatch = new Cos2XMLReaderDispatcher(this.mHandler, refDispath.getReferences(), this.mParentAnnot);
            GeneralTraverser cos2XMLTraverser = new GeneralTraverser(cos2XMLDispatch);
            ArrayListStack rootStack = new ArrayListStack();
            CosContainerValuesIterator.Entry rootEntry = this.mParentAnnot.pdfAnnot.getCosDictionary().getValuesIterator().createEntry(this.mParentKey, 0, root);
            cos2XMLDispatch.startDispatch(rootEntry, rootStack, false);
            cos2XMLTraverser.traverseCosGraph((CosContainer)root, null);
            cos2XMLDispatch.finishDispatch(rootEntry, rootStack);
            this.mHandler.endDocument();
            if (!dbgCnt) {
                dbgCnt = true;
            }
        }
        catch (PDFException e) {
            throw new SAXException("Cannot parse Cos to XML", e);
        }
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.mHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

