/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.template;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFAElement;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormManifest;
import com.adobe.xfa.template.containers.Field;
import java.util.ArrayList;
import java.util.List;

public class XFAManifest
extends XFAElement {
    public static final Action ACTION_INCLUDE = Action.INCLUDE;
    public static final Action ACTION_EXCLUDE = Action.EXCLUDE;
    public static final Action ACTION_ALL = Action.ALL;
    private static final int HASH_PRIME = 1000003;
    Action action;
    List refElements;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public List getRefElements() {
        return this.refElements;
    }

    public void setRefElements(List refElements) {
        this.refElements = refElements;
    }

    public XFAManifest(Action action, List refElements) {
        this.action = action;
        this.refElements = refElements;
    }

    public XFAManifest(Element element) throws PDFInvalidParameterException {
        super(element);
        this.createXFAManifest(element);
    }

    private void createXFAManifest(Element manifestElement) throws PDFInvalidParameterException {
        String action = manifestElement.getAttribute(XFA.ACTIONTAG).getAttrValue();
        ArrayList<String> referenceList = new ArrayList<String>(manifestElement.getXMLChildCount());
        for (Node child = manifestElement.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
            if (child.getClassTag() != XFA.REFTAG) continue;
            TextNode childNode = ((Element)child).getText(true, false, false);
            if (childNode == null) {
                throw new PDFInvalidParameterException("Empty ref elements in the manifest. This is invalid.");
            }
            if (childNode == null) continue;
            referenceList.add(SOMExpressionUtils.trimSomExpression(childNode.getValue()));
        }
        this.setAction(Action.getInstance(action));
        this.setRefElements(referenceList);
    }

    public static Element getManifestNode(Field signatureField) {
        Element uiNode = signatureField.peekElement(XFA.UITAG, false, 0);
        if (uiNode == null) {
            return null;
        }
        Element signatureNode = (Element)uiNode.getOneOfChild(true, false);
        if (signatureNode == null) {
            return null;
        }
        if (!signatureNode.getAttribute(XFA.TYPETAG).getAttrValue().equals("PDF1.6") && !signatureNode.getAttribute(XFA.TYPETAG).getAttrValue().equals("PDF1.7")) {
            return null;
        }
        Element manifestNode = signatureNode.peekElement(XFA.MANIFESTTAG, false, 0);
        if (manifestNode == null) {
            return null;
        }
        if (manifestNode instanceof FormManifest) {
            FormManifest oFormManifest = (FormManifest)manifestNode;
            manifestNode = oFormManifest.getProto();
        }
        return manifestNode;
    }

    public static final class Action {
        private final String action;
        public static final Action INCLUDE = new Action("include");
        public static final Action EXCLUDE = new Action("exclude");
        public static final Action ALL = new Action("all");
        private static final Action[] values = new Action[]{INCLUDE, EXCLUDE, ALL};

        private Action(String action) {
            this.action = action;
        }

        public static Action getInstance(String s) {
            if (s == null) {
                return INCLUDE;
            }
            for (int i = 0; i < values.length; ++i) {
                if (!s.equalsIgnoreCase(Action.values[i].action)) continue;
                return values[i];
            }
            return null;
        }

        public String toString() {
            return this.action;
        }

        public boolean isEmpty() {
            return this.action.trim().length() == 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Action)) {
                return false;
            }
            Action otherElement = (Action)obj;
            return otherElement.action.equals(this.action);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 1000003 + (this.action == null ? 0 : this.action.hashCode());
            return hash;
        }
    }
}

