/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.AdjacencyInfo;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.Wordafier;

class VerticalAdjacencyInfo
extends AdjacencyInfo {
    private double deltaXAbs;
    private double fontHeight;

    public VerticalAdjacencyInfo(PDFCharacter currentChar, PDFCharacter nextChar, Wordafier wordafier) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getVerticalAdjacencyInfo(currentChar, nextChar, wordafier);
    }

    void getVerticalAdjacencyInfo(PDFCharacter currentChar, PDFCharacter nextChar, Wordafier wordafier) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        VerticalAdjacencyInfo adjacencyInfo = this;
        double xAdjacencyFactor = 0.2;
        double yAdjacencyFactor = 0.5;
        double spaceHeight = 0.0;
        double fontHeight = 0.0;
        double xThreshold = 0.0;
        double yThreshold = 0.0;
        if (currentChar.getTextRun() == nextChar.getTextRun()) {
            spaceHeight = Math.abs(currentChar.getSpaceCharHeight());
            fontHeight = currentChar.getVerticalFontSize();
        } else {
            double nextCharSpaceHeight;
            double currentCharSpaceHeight = currentChar.getSpaceCharHeight();
            spaceHeight = currentCharSpaceHeight < (nextCharSpaceHeight = nextChar.getSpaceCharHeight()) ? currentCharSpaceHeight : nextCharSpaceHeight;
            double currentCharFontHeight = currentChar.getVerticalFontSize();
            double nextCharFontHeight = nextChar.getVerticalFontSize();
            fontHeight = currentCharFontHeight < nextCharFontHeight ? currentCharFontHeight : nextCharFontHeight;
        }
        spaceHeight = Math.abs(spaceHeight);
        yThreshold = 0.5 * spaceHeight;
        xThreshold = 0.2 * fontHeight;
        double deltaY = currentChar.getYDistanceTo(nextChar);
        double deltaX = currentChar.getXDistanceTo(nextChar);
        double deltaXAbs = Math.abs(deltaX);
        adjacencyInfo.setDeltaXAbs(deltaXAbs);
        adjacencyInfo.setFontHeight(fontHeight);
        adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.None);
        if (deltaY >= 0.0) {
            if (deltaY <= yThreshold) {
                adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Bottom);
            }
        } else if (Math.abs(deltaY) <= currentChar.getSpaceCharHeight()) {
            adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Top);
        } else if (Math.abs(deltaY) < currentChar.getSpaceCharHeight() + yThreshold) {
            adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Bottom);
        } else {
            deltaY = nextChar.getYDistanceTo(currentChar);
            if (deltaY > 0.0) {
                if (deltaY <= yThreshold) {
                    adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Top);
                }
            } else if (Math.abs(deltaY) <= nextChar.getSpaceCharHeight()) {
                adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Top);
            } else if (Math.abs(deltaY) <= nextChar.getSpaceCharHeight() + yThreshold) {
                adjacencyInfo.setYAdjacency(AdjacencyInfo.YAdjacency.Next_Char_To_Bottom);
            }
        }
        adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.None);
        if (deltaX >= 0.0) {
            if (deltaX <= xThreshold) {
                adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Right);
            }
        } else if (Math.abs(deltaX) <= currentChar.getWidth()) {
            adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Right);
        } else if (Math.abs(deltaX) < currentChar.getWidth() + xThreshold) {
            adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Left);
        } else {
            deltaX = nextChar.getXDistanceTo(currentChar);
            if (deltaX > 0.0) {
                if (deltaX <= xThreshold) {
                    adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Left);
                }
            } else if (Math.abs(deltaX) <= nextChar.getWidth()) {
                adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Left);
            } else if (Math.abs(deltaX) <= nextChar.getWidth() + xThreshold) {
                adjacencyInfo.setXAdjacency(AdjacencyInfo.XAdjacency.Next_Char_To_Right);
            }
        }
        boolean nextCharIsAdjacent = adjacencyInfo.getYAdjacency() != AdjacencyInfo.YAdjacency.None && adjacencyInfo.getXAdjacency() != AdjacencyInfo.XAdjacency.None;
        adjacencyInfo.setAdjacent(nextCharIsAdjacent);
    }

    public void setDeltaXAbs(double deltaXAbs) {
        this.deltaXAbs = deltaXAbs;
    }

    public double getDeltaXAbs() {
        return this.deltaXAbs;
    }

    public void setFontHeight(double fontHeight) {
        this.fontHeight = fontHeight;
    }

    public double getFontHeight() {
        return this.fontHeight;
    }
}

